/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.cycloids_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.cycloids_pkg.cycloidsSimulation;
import users.ntnu.fkh.cycloids_pkg.cycloidsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cycloids
extends AbstractModel {
    public cycloidsSimulation _simulation = null;
    public cycloidsView _view = null;
    public cycloids _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 200.0;
    public double xmin = -this.range;
    public double xmax = this.range * 1.8;
    public double ymin = -this.range;
    public double ymax = this.range;
    public double dt = 0.02;
    public double size = this.range / 25.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public int npt = 100;
    public int psize = 5;
    public double g = 1000.0;
    public double r = this.xmax / 3.7;
    public double r2 = 2.0 * this.r;
    public double xc = -this.r * this.pi;
    public double yc = this.r;
    public double T = 2.0;
    public double omega = 2.0 * this.pi / this.T;
    public double t = -this.T / 2.0;
    public double c = this.omega * this.t;
    public double x = this.r * (this.c + Math.sin(this.c));
    public double y = this.r * (1.0 - Math.cos(this.c));
    public double vx = 0.0;
    public double vy = 0.0;
    public double ac = this.r * this.omega * this.omega;
    public int n = 5;
    public double[] xp;
    public double[] yp;
    public double[] yps;
    public double[] vxp;
    public double[] vyp;
    public double[] ratio;
    public double dx = this.size * 10.0;
    public double[] xcp;
    public boolean gravity = false;
    public boolean show = true;
    public double vscale = 0.2;
    public int stage = 0;
    public double c2 = 0.0;
    public String msg = "test";
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/cycloids.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        cycloids cycloids2 = new cycloids(stringArray);
    }

    public cycloids() {
        this(null, null, null, null, null, false);
    }

    public cycloids(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public cycloids(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new cycloidsSimulation(this, string, frame, uRL, bl);
        this._view = (cycloidsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = -this.T / 2.0;
        this.c = this.omega * this.t;
        this.x = this.r * (this.c + Math.sin(this.c));
        this.y = this.r * (1.0 - Math.cos(this.c));
        this.vy = 0.0;
        this.vx = 0.0;
        if (this.stage == 0) {
            this.gravity = false;
        }
        if (this.stage == 0) {
            this.msg = "A cycloid is the curve defined by the path of a point on the edge of circular wheel as the wheel rolls along a straight line.";
        } else if (this.stage == 1) {
            this.msg = "There are five cycloidal curves. Cycloidal curves is the curve of fastest descent under gravity";
        } else if (this.stage == 2) {
            this.msg = "Five particles starts at different height, which one will arrive bottom first? Why?";
        }
    }

    public void _constraints1() {
        int n;
        if (this._isPlaying()) {
            if (this.x > this.xmax || this.y < this.ymin) {
                this._pause();
            }
            if (this.t > 0.0) {
                ++this.stage;
                this._initialize();
                if (this.stage < 3) {
                    this._pause();
                } else if (!this.gravity) {
                    this.gravity = true;
                    for (n = 0; n < this.n; ++n) {
                        this.t = 0.0;
                        this.vxp[n] = Math.sqrt(2.0 * this.g * this.yps[n]);
                        this.vyp[n] = 0.0;
                        this.xp[n] = (double)n * this.dx;
                        this.yp[n] = 0.0;
                        this.msg = "";
                    }
                }
            }
        }
        if (this.stage == 1) {
            for (n = 0; n < this.n; ++n) {
                this.xp[n] = this.x + (double)n * this.dx;
                this.yp[n] = this.y;
                this.xcp[n] = this.r * this.c + (double)n * this.dx;
            }
        } else if (this.stage == 2 && this.t < 0.0) {
            for (n = 0; n < this.n; ++n) {
                this.c2 = this.ratio[n] * this.c;
                this.xp[n] = this.r * (this.c2 + Math.sin(this.c2)) + (double)n * this.dx;
                this.yp[n] = this.r * (1.0 - Math.cos(this.c2));
                if (this.t != -this.T / 2.0) continue;
                this.yps[n] = this.yp[n];
            }
        }
        if (this.yp[0] < this.ymin + 2.0 * this.size) {
            this._pause();
            this.msg = "Do you know why it is not depends on the ball's starting position? They all arrive at the same time!";
        }
    }

    public double _method_for_shapecircle_x() {
        return this.r * this.c;
    }

    public double _method_for_shapecircle_transformation() {
        return this.omega * this.t;
    }

    public boolean _method_for_shapecircle_visible() {
        return this.stage < 2;
    }

    public double _method_for_analyticCurve_min() {
        return -this.pi;
    }

    public boolean _method_for_analyticCurve_visible() {
        return this.stage > 0;
    }

    public boolean _method_for_shape_visible() {
        return this.stage < 2;
    }

    public boolean _method_for_trace_active() {
        return this.stage == 0;
    }

    public boolean _method_for_arrow_visible() {
        return this.stage < 2;
    }

    public boolean _method_for_traceSet_active() {
        return this.stage == 1 && this.t < 0.0;
    }

    public boolean _method_for_shapeSet_visible() {
        return this.stage == 1;
    }

    public boolean _method_for_traceSet2_active() {
        return this.stage > 1;
    }

    public boolean _method_for_shapeSet2_visible() {
        return this.stage > 0;
    }

    public double _method_for_segment_x() {
        return -this.r * this.pi;
    }

    public double _method_for_segment_sizeX() {
        return this.xmax - this.xmin;
    }

    public double _method_for_text_x() {
        return this.xmin * 1.52;
    }

    public double _method_for_text_y() {
        return this.ymin / 2.0;
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public boolean _method_for_step_enabled() {
        return this._isPaused();
    }

    public void _method_for_step_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.range = 200.0;
        this.xmin = -this.range;
        this.xmax = this.range * 1.8;
        this.ymin = -this.range;
        this.ymax = this.range;
        this.dt = 0.02;
        this.size = this.range / 25.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.npt = 100;
        this.psize = 5;
        this.g = 1000.0;
        this.r = this.xmax / 3.7;
        this.r2 = 2.0 * this.r;
        this.xc = -this.r * this.pi;
        this.yc = this.r;
        this.T = 2.0;
        this.omega = 2.0 * this.pi / this.T;
        this.t = -this.T / 2.0;
        this.c = this.omega * this.t;
        this.x = this.r * (this.c + Math.sin(this.c));
        this.y = this.r * (1.0 - Math.cos(this.c));
        this.vx = 0.0;
        this.vy = 0.0;
        this.ac = this.r * this.omega * this.omega;
        this.n = 5;
        this.xp = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.xp[n] = this.x;
        }
        this.yp = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.yp[n] = this.y;
        }
        this.yps = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.yps[n] = this.y;
        }
        this.vxp = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.vxp[n] = 0.0;
        }
        this.vyp = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.vyp[n] = 0.0;
        }
        this.ratio = new double[]{1.0, 0.8, 0.6, 0.4, 0.2};
        this.dx = this.size * 10.0;
        this.xcp = new double[]{this.x, this.x + this.dx, this.x + 2.0 * this.dx, this.x + 3.0 * this.dx, this.x + 4.0 * this.dx};
        this.gravity = false;
        this.show = true;
        this.vscale = 0.2;
        this.stage = 0;
        this.c2 = 0.0;
        this.msg = "test";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.xp = null;
        this.yp = null;
        this.yps = null;
        this.vxp = null;
        this.vyp = null;
        this.ratio = null;
        this.xcp = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    private class _ODE_evolution1
    implements ODE {
        private RK4 __solver = null;
        private double[] __state = null;
        private double[] _xp;
        private double[] _yp;
        private double[] _vyp;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[6 + cycloids.this.xp.length + cycloids.this.yp.length + cycloids.this.vyp.length];
            this._xp = new double[cycloids.this.xp.length];
            this._yp = new double[cycloids.this.yp.length];
            this._vyp = new double[cycloids.this.vyp.length];
        }

        private boolean arraysChanged() {
            if (cycloids.this.xp.length != this._xp.length) {
                return true;
            }
            if (cycloids.this.yp.length != this._yp.length) {
                return true;
            }
            return cycloids.this.vyp.length != this._vyp.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            this.__state[n++] = cycloids.this.c;
            this.__state[n++] = cycloids.this.x;
            this.__state[n++] = cycloids.this.y;
            this.__state[n++] = cycloids.this.vx;
            this.__state[n++] = cycloids.this.vy;
            System.arraycopy(cycloids.this.xp, 0, this.__state, n, cycloids.this.xp.length);
            System.arraycopy(cycloids.this.yp, 0, this.__state, n += cycloids.this.xp.length, cycloids.this.yp.length);
            System.arraycopy(cycloids.this.vyp, 0, this.__state, n += cycloids.this.yp.length, cycloids.this.vyp.length);
            n += cycloids.this.vyp.length;
            this.__state[n++] = cycloids.this.t;
            this.__solver = new RK4(this);
            this.__solver.initialize(cycloids.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (cycloids.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(cycloids.this.dt);
            }
            int n = 0;
            this.__state[n++] = cycloids.this.c;
            this.__state[n++] = cycloids.this.x;
            this.__state[n++] = cycloids.this.y;
            this.__state[n++] = cycloids.this.vx;
            this.__state[n++] = cycloids.this.vy;
            System.arraycopy(cycloids.this.xp, 0, this.__state, n, cycloids.this.xp.length);
            System.arraycopy(cycloids.this.yp, 0, this.__state, n += cycloids.this.xp.length, cycloids.this.yp.length);
            System.arraycopy(cycloids.this.vyp, 0, this.__state, n += cycloids.this.yp.length, cycloids.this.vyp.length);
            n += cycloids.this.vyp.length;
            this.__state[n++] = cycloids.this.t;
            this.__solver.step();
            n = 0;
            cycloids.this.c = this.__state[n++];
            cycloids.this.x = this.__state[n++];
            cycloids.this.y = this.__state[n++];
            cycloids.this.vx = this.__state[n++];
            cycloids.this.vy = this.__state[n++];
            System.arraycopy(this.__state, n, cycloids.this.xp, 0, cycloids.this.xp.length);
            System.arraycopy(this.__state, n += cycloids.this.xp.length, cycloids.this.yp, 0, cycloids.this.yp.length);
            System.arraycopy(this.__state, n += cycloids.this.yp.length, cycloids.this.vyp, 0, cycloids.this.vyp.length);
            n += cycloids.this.vyp.length;
            cycloids.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            double d5 = dArray[n2++];
            double[] dArray3 = this._xp;
            System.arraycopy(dArray, n2, this._xp, 0, this._xp.length);
            double[] dArray4 = this._yp;
            System.arraycopy(dArray, n2 += this._xp.length, this._yp, 0, this._yp.length);
            double[] dArray5 = this._vyp;
            System.arraycopy(dArray, n2 += this._yp.length, this._vyp, 0, this._vyp.length);
            n2 += this._vyp.length;
            double d6 = dArray[n2++];
            n2 = 0;
            dArray2[n2++] = cycloids.this.omega;
            dArray2[n2++] = d4;
            dArray2[n2++] = d5;
            dArray2[n2++] = d6 < 0.0 ? -cycloids.this.ac * Math.sin(d) : 0.0;
            dArray2[n2++] = d6 < 0.0 ? cycloids.this.ac * Math.cos(d) : -cycloids.this.g;
            int n3 = this._xp.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = cycloids.this.vxp[n];
            }
            n3 = this._yp.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = dArray5[n];
            }
            n3 = this._vyp.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = cycloids.this.gravity ? -cycloids.this.g : 0.0;
            }
            dArray2[n2++] = 1.0;
        }
    }
}

