/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.cycloidalpendulum_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.cycloidalpendulum_pkg.cycloidalpendulumSimulation;
import users.ntnu.fkh.cycloidalpendulum_pkg.cycloidalpendulumView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cycloidalpendulum
extends AbstractModel {
    public cycloidalpendulumSimulation _simulation = null;
    public cycloidalpendulumView _view = null;
    public cycloidalpendulum _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 20.0;
    public double scale = 1.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double dt = 0.05;
    public double size = this.range / 25.0;
    public double size2 = this.size / 2.0;
    public double size3 = this.size / 3.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public int npt = 200;
    public double T = 5.0;
    public double T2 = this.T / 2.0;
    public double omega = 2.0 * this.pi / this.T;
    public double r = this.xmax / 4.5;
    public double y1 = this.ymax;
    public double y2 = this.y1 - 4.0 * this.r;
    public double t = -this.T2;
    public double x;
    public double y;
    public double x0;
    public double y0;
    public boolean view = false;
    public double g = this.pi * this.pi / this.T2 / this.T2 * this.r;
    public double ratio = 0.6;
    public double cta = this.omega * this.t;
    public double cta2 = this.cta * this.ratio;
    public double t2 = -this.T2 * 0.8;
    public double dt2 = this.ratio * this.dt;
    public double xd = this.r * (this.omega * this.t2 - Math.cos(this.omega * (this.t2 + this.T2 / 2.0)));
    public double yd = this.y2 + this.r * (1.0 - Math.sin(this.omega * (this.t2 + this.T2 / 2.0)));
    public double xd0;
    public double yd0;
    public double xx;
    public double yy;
    public double vx = 0.0;
    public double vy = 0.0;
    public double vxd = 0.0;
    public double vyd = 0.0;
    public int PN = 0;
    public boolean show2 = true;
    public double sign = 1.0;
    public double ys = 0.0;
    private _ODE_evolution2 _ODEi_evolution2;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/cycloidalpendulum.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        cycloidalpendulum cycloidalpendulum2 = new cycloidalpendulum(stringArray);
    }

    public cycloidalpendulum() {
        this(null, null, null, null, null, false);
    }

    public cycloidalpendulum(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public cycloidalpendulum(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new cycloidalpendulumSimulation(this, string, frame, uRL, bl);
        this._view = (cycloidalpendulumView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution2.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = -this.T2;
        this.t2 = this.ratio * this.t;
        this.dt2 = this.ratio * this.dt;
        this.x = this.r * (this.omega * this.t + Math.sin(this.omega * this.t));
        this.y = this.y2 + this.r * (1.0 - Math.cos(this.omega * this.t));
        this.xd = this.r * (this.omega * this.t2 + Math.sin(this.omega * this.t2));
        this.ys = this.yd = this.y2 + this.r * (1.0 - Math.cos(this.omega * this.t2));
        this.vy = 0.0;
        this.vx = 0.0;
        this.vyd = 0.0;
        this.vxd = 0.0;
        this._view.trace.clear();
    }

    public void _evolution1() {
        this.t2 += this.dt2;
    }

    public void _constraints1() {
        this.cta = this.omega * this.t;
        this.cta2 = this.cta * this.ratio;
        this.x0 = this.r * (this.omega * this.t - Math.sin(this.cta));
        this.y0 = this.y1 - this.r * (1.0 - Math.cos(this.cta));
        this.sign = this.dt > 0.0 ? 1.0 : -1.0;
        this.xd0 = this.r * (this.cta * this.ratio - Math.sin(this.cta2));
        this.yd0 = this.y1 - this.r * (1.0 - Math.cos(this.cta2));
        this.xd = this.r * (this.cta * this.ratio + Math.sin(this.cta2));
        this.yd = this.y2 + this.r * (1.0 - Math.cos(this.cta2));
        this.vxd = this.g * (this.ys - this.yd) / (this.r * this.omega) * this.sign;
        this.vyd = this.vxd * Math.sin(this.cta2) / (1.0 + Math.cos(this.cta2));
    }

    public double _method_for_drawingPanel_minimumX() {
        return this.xmin * this.scale;
    }

    public double _method_for_drawingPanel_maximumX() {
        return this.xmax * this.scale;
    }

    public double _method_for_analyticCurve_min() {
        return -this.T2;
    }

    public double _method_for_segment_sizeX() {
        return this.x - this.x0;
    }

    public double _method_for_segment_sizeY() {
        return this.y - this.y0;
    }

    public double _method_for_shapecircle_x() {
        return this.r * this.omega * this.t;
    }

    public double _method_for_shapecircle_y() {
        return this.y1 - this.r;
    }

    public double _method_for_shapecircle_sizeX() {
        return 2.0 * this.r;
    }

    public double _method_for_shapecircle_sizeY() {
        return 2.0 * this.r;
    }

    public double _method_for_shapecircle_transformation() {
        return this.omega * this.t;
    }

    public boolean _method_for_shapetop_visible() {
        return this.view || this.show2;
    }

    public double _method_for_segment2_sizeX() {
        return this.xd - this.xd0;
    }

    public double _method_for_segment2_sizeY() {
        return this.yd - this.yd0;
    }

    public double _method_for_shapecircle2_x() {
        return this.r * this.omega * this.t;
    }

    public double _method_for_shapecircle2_y() {
        return this.y2 + this.r;
    }

    public double _method_for_shapecircle2_sizeX() {
        return 2.0 * this.r;
    }

    public double _method_for_shapecircle2_sizeY() {
        return 2.0 * this.r;
    }

    public double _method_for_shapecircle2_transformation() {
        return this.omega * this.t;
    }

    public boolean _method_for_trace_active() {
        return this._isPlaying();
    }

    public boolean _method_for_trace_connected() {
        return this._isPlaying();
    }

    public double _method_for_arrowt_sizeX() {
        return (this.vx - this.r * this.omega) * this.sign;
    }

    public double _method_for_arrowt_sizeY() {
        return this.vy * this.sign;
    }

    public double _method_for_arrow_sizeX() {
        return this.vx * this.sign;
    }

    public double _method_for_arrow_sizeY() {
        return this.vy * this.sign;
    }

    public boolean _method_for_arrow_visible() {
        return this.vx != 0.0;
    }

    public double _method_for_arrowt2_x() {
        return this.x + (this.vx - this.r * this.omega) * this.sign;
    }

    public double _method_for_arrowt2_y() {
        return this.y + this.vy * this.sign;
    }

    public double _method_for_arrowt2_sizeX() {
        return this.r * this.omega * this.sign;
    }

    public double _method_for_text_x() {
        return this.xmax / 10.0;
    }

    public double _method_for_text_y() {
        return this.ymax - this.size;
    }

    public double _method_for_text2_x() {
        return this.xmax / 10.0;
    }

    public double _method_for_text2_y() {
        return this.ymin + this.size;
    }

    public double _method_for_analyticCurve2_min() {
        return -this.T2;
    }

    public double _method_for_shapecbigircle_sizeX() {
        return 8.0 * this.r;
    }

    public double _method_for_shapecbigircle_sizeY() {
        return 8.0 * this.r;
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_buttonstep_enabled() {
        return this._isPaused();
    }

    public void _method_for_buttonstep_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public boolean _method_for_checkBox2_enabled() {
        return this._isPaused();
    }

    public boolean _method_for_slider_enabled() {
        return this._isPaused() && this.show2;
    }

    public void _method_for_slider_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.range = 20.0;
        this.scale = 1.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.dt = 0.05;
        this.size = this.range / 25.0;
        this.size2 = this.size / 2.0;
        this.size3 = this.size / 3.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.npt = 200;
        this.T = 5.0;
        this.T2 = this.T / 2.0;
        this.omega = 2.0 * this.pi / this.T;
        this.r = this.xmax / 4.5;
        this.y1 = this.ymax;
        this.y2 = this.y1 - 4.0 * this.r;
        this.t = -this.T2;
        this.view = false;
        this.g = this.pi * this.pi / this.T2 / this.T2 * this.r;
        this.ratio = 0.6;
        this.cta = this.omega * this.t;
        this.cta2 = this.cta * this.ratio;
        this.t2 = -this.T2 * 0.8;
        this.dt2 = this.ratio * this.dt;
        this.xd = this.r * (this.omega * this.t2 - Math.cos(this.omega * (this.t2 + this.T2 / 2.0)));
        this.yd = this.y2 + this.r * (1.0 - Math.sin(this.omega * (this.t2 + this.T2 / 2.0)));
        this.vx = 0.0;
        this.vy = 0.0;
        this.vxd = 0.0;
        this.vyd = 0.0;
        this.PN = 0;
        this.show2 = true;
        this.sign = 1.0;
        this.ys = 0.0;
        this._ODEi_evolution2 = new _ODE_evolution2();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
        this._ODEi_evolution2.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution2 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    private class _ODE_evolution2
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;

        _ODE_evolution2() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = cycloidalpendulum.this.x;
            this.__state[n++] = cycloidalpendulum.this.vx;
            this.__state[n++] = cycloidalpendulum.this.y;
            this.__state[n++] = cycloidalpendulum.this.vy;
            this.__state[n++] = cycloidalpendulum.this.t;
            this.__solver = new ODEBisectionEventSolver(this, RK4.class);
            this.__solver.addEvent(new _ODE_evolution2_Event1());
            this.__solver.addEvent(new _ODE_evolution2_Event2());
            this.__solver.initialize(cycloidalpendulum.this.dt);
        }

        void step() {
            if (cycloidalpendulum.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(cycloidalpendulum.this.dt);
            }
            int n = 0;
            this.__state[n++] = cycloidalpendulum.this.x;
            this.__state[n++] = cycloidalpendulum.this.vx;
            this.__state[n++] = cycloidalpendulum.this.y;
            this.__state[n++] = cycloidalpendulum.this.vy;
            this.__state[n++] = cycloidalpendulum.this.t;
            this.__solver.step();
            n = 0;
            cycloidalpendulum.this.x = this.__state[n++];
            cycloidalpendulum.this.vx = this.__state[n++];
            cycloidalpendulum.this.y = this.__state[n++];
            cycloidalpendulum.this.vy = this.__state[n++];
            cycloidalpendulum.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            n = 0;
            dArray2[n++] = d2;
            dArray2[n++] = -cycloidalpendulum.this.r * cycloidalpendulum.this.omega * cycloidalpendulum.this.omega * Math.sin(cycloidalpendulum.this.omega * d5);
            dArray2[n++] = d4;
            dArray2[n++] = cycloidalpendulum.this.r * cycloidalpendulum.this.omega * cycloidalpendulum.this.omega * Math.cos(cycloidalpendulum.this.omega * d5);
            dArray2[n++] = 1.0;
        }

        private class _ODE_evolution2_Event2
        implements StateEvent {
            private _ODE_evolution2_Event2() {
            }

            public String toString() {
                return "Event 2";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                double d5 = dArray[n++];
                return d5 + cycloidalpendulum.this.T2;
            }

            public boolean action() {
                int n = 0;
                cycloidalpendulum.this.x = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.vx = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.y = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.vy = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.t = _ODE_evolution2.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.x;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.vx;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.y;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.vy;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                cycloidalpendulum.this.dt = 0.05;
                cycloidalpendulum.this.t = -cycloidalpendulum.this.T - cycloidalpendulum.this.t;
                return true;
            }
        }

        private class _ODE_evolution2_Event1
        implements StateEvent {
            private _ODE_evolution2_Event1() {
            }

            public String toString() {
                return "Event";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                double d5 = dArray[n++];
                return cycloidalpendulum.this.T2 - d5;
            }

            public boolean action() {
                int n = 0;
                cycloidalpendulum.this.x = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.vx = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.y = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.vy = _ODE_evolution2.this.__state[n++];
                cycloidalpendulum.this.t = _ODE_evolution2.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.x;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.vx;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.y;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.vy;
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n++] = cycloidalpendulum.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                cycloidalpendulum.this.dt = -0.05;
                cycloidalpendulum.this.t = cycloidalpendulum.this.T - cycloidalpendulum.this.t;
                return true;
            }
        }
    }
}

