/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.basic.p10gravity_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.basic.p10gravity_pkg.p10gravitySimulation;
import users.ntnu.fkh.basic.p10gravity_pkg.p10gravityView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class p10gravity
extends AbstractModel {
    public p10gravitySimulation _simulation = null;
    public p10gravityView _view = null;
    public p10gravity _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 20.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = 0.0;
    public double ymax = this.range;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 40.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public int psize = 5;
    public int npt = 50;
    public boolean show = false;
    public int n = 10;
    public double[] x;
    public double[] y;
    public double[] vx;
    public double[] vy;
    public double[] m;
    public double[] d;
    public String[] msg;
    public int[] cnt;
    public double dx = (this.xmax - this.xmin) / (double)this.n;
    public double v0 = 2.0;
    public int id = 0;
    public double g = 10.0;
    public boolean samemass = true;
    private _ODE_evolution1 _ODEi_evolution1;
    double dv;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/basic/p10gravity.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/basic/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/basic/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        p10gravity p10gravity2 = new p10gravity(stringArray);
    }

    public p10gravity() {
        this(null, null, null, null, null, false);
    }

    public p10gravity(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public p10gravity(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new p10gravitySimulation(this, string, frame, uRL, bl);
        this._view = (p10gravityView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.x[0] = this.xmin + 0.5 * this.dx;
        for (int i = 0; i < this.n; ++i) {
            this.vx[i] = 0.0;
            this.vy[i] = (double)(i + 1) * this.v0;
            if (this.samemass) {
                this.x[i] = this.xmin + ((double)i + 0.5) * this.dx;
                this.d[i] = this.size2;
            } else {
                this.d[i] = Math.sqrt((double)(i + 1) * this.size);
                if (i > 0) {
                    this.x[i] = this.x[i - 1] + this.d[i] * 1.1;
                }
            }
            this.y[i] = this.ymin + this.d[i] / 2.0;
            this.cnt[i] = 0;
        }
    }

    public void _constraints1() {
        for (int i = 0; i < this.n; ++i) {
            this.msg[i] = this.cnt[i] + "";
        }
    }

    public double dvalue(double d) {
        this.dv = d > 0.0 ? 0.5 : (d < 0.0 ? -0.5 : 0.0);
        return (double)((int)(d * 100.0 + this.dv)) / 100.0;
    }

    public double _method_for_textSet_y() {
        return this.ymax / 4.0;
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_init_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_checkBox_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.range = 20.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = 0.0;
        this.ymax = this.range;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 40.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.psize = 5;
        this.npt = 50;
        this.show = false;
        this.n = 10;
        this.x = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.y[n] = this.ymin + this.size2;
        }
        this.vx = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.vx[n] = 0.0;
        }
        this.vy = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.vy[n] = 0.0;
        }
        this.m = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.m[n] = 1.0;
        }
        this.d = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.size;
        }
        this.msg = new String[this.n];
        this.cnt = new int[this.n];
        this.dx = (this.xmax - this.xmin) / (double)this.n;
        this.v0 = 2.0;
        this.id = 0;
        this.g = 10.0;
        this.samemass = true;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.vx = null;
        this.vy = null;
        this.m = null;
        this.d = null;
        this.msg = null;
        this.cnt = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double[] _y;
        private double[] _vy;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + p10gravity.this.y.length + p10gravity.this.vy.length];
            this._y = new double[p10gravity.this.y.length];
            this._vy = new double[p10gravity.this.vy.length];
        }

        private boolean arraysChanged() {
            if (p10gravity.this.y.length != this._y.length) {
                return true;
            }
            return p10gravity.this.vy.length != this._vy.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            System.arraycopy(p10gravity.this.y, 0, this.__state, n, p10gravity.this.y.length);
            System.arraycopy(p10gravity.this.vy, 0, this.__state, n += p10gravity.this.y.length, p10gravity.this.vy.length);
            n += p10gravity.this.vy.length;
            this.__state[n++] = p10gravity.this.t;
            this.__solver = new ODEBisectionEventSolver(this, EulerRichardson.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(p10gravity.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (p10gravity.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(p10gravity.this.dt);
            }
            int n = 0;
            System.arraycopy(p10gravity.this.y, 0, this.__state, n, p10gravity.this.y.length);
            System.arraycopy(p10gravity.this.vy, 0, this.__state, n += p10gravity.this.y.length, p10gravity.this.vy.length);
            n += p10gravity.this.vy.length;
            this.__state[n++] = p10gravity.this.t;
            this.__solver.step();
            n = 0;
            System.arraycopy(this.__state, n, p10gravity.this.y, 0, p10gravity.this.y.length);
            System.arraycopy(this.__state, n += p10gravity.this.y.length, p10gravity.this.vy, 0, p10gravity.this.vy.length);
            n += p10gravity.this.vy.length;
            p10gravity.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            double[] dArray3 = this._y;
            System.arraycopy(dArray, n2, this._y, 0, this._y.length);
            double[] dArray4 = this._vy;
            System.arraycopy(dArray, n2 += this._y.length, this._vy, 0, this._vy.length);
            n2 += this._vy.length;
            double d = dArray[n2++];
            n2 = 0;
            int n3 = this._y.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = dArray4[n];
            }
            n3 = this._vy.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = -p10gravity.this.g;
            }
            dArray2[n2++] = 1.0;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "\u4e8b\u4ef6";
            }

            public double getTolerance() {
                return 0.01;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double[] dArray2 = _ODE_evolution1.this._y;
                System.arraycopy(dArray, n, _ODE_evolution1.this._y, 0, _ODE_evolution1.this._y.length);
                double[] dArray3 = _ODE_evolution1.this._vy;
                System.arraycopy(dArray, n += _ODE_evolution1.this._y.length, _ODE_evolution1.this._vy, 0, _ODE_evolution1.this._vy.length);
                n += _ODE_evolution1.this._vy.length;
                double d = dArray[n++];
                for (int i = 0; i < p10gravity.this.n; ++i) {
                    if (!(dArray3[i] < 0.0) || !(dArray2[i] < p10gravity.this.ymin + p10gravity.this.d[i] / 2.0)) continue;
                    p10gravity.this.id = i;
                    return dArray2[i] - (p10gravity.this.ymin + p10gravity.this.d[i] / 2.0);
                }
                return 1.0;
            }

            public boolean action() {
                int n = 0;
                System.arraycopy(_ODE_evolution1.this.__state, n, p10gravity.this.y, 0, p10gravity.this.y.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += p10gravity.this.y.length, p10gravity.this.vy, 0, p10gravity.this.vy.length);
                n += p10gravity.this.vy.length;
                p10gravity.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                System.arraycopy(p10gravity.this.y, 0, _ODE_evolution1.this.__state, n, p10gravity.this.y.length);
                System.arraycopy(p10gravity.this.vy, 0, _ODE_evolution1.this.__state, n += p10gravity.this.y.length, p10gravity.this.vy.length);
                n += p10gravity.this.vy.length;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = p10gravity.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                p10gravity.this.vy[p10gravity.this.id] = -p10gravity.this.vy[p10gravity.this.id];
                int n = p10gravity.this.id;
                p10gravity.this.cnt[n] = p10gravity.this.cnt[n] + 1;
                return true;
            }
        }
    }
}

