/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.StepperClipControl;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoClipControl;

public abstract class ClipControl {
    protected int stepNumber = 0;
    protected final VideoClip clip;
    protected Video video;
    protected double rate = 1.0;
    protected boolean looping = false;
    protected PropertyChangeSupport support;
    protected double timeStretch = 1.0;

    public static ClipControl getControl(VideoClip videoClip) {
        Video video = videoClip.getVideo();
        if (videoClip.playAllSteps || video == null || video instanceof ImageVideo) {
            return new StepperClipControl(videoClip);
        }
        return new VideoClipControl(videoClip);
    }

    protected ClipControl(VideoClip videoClip) {
        this.clip = videoClip;
        this.video = this.clip.getVideo();
        this.support = new SwingPropertyChangeSupport(this);
    }

    public VideoClip getVideoClip() {
        return this.clip;
    }

    public void play() {
    }

    public void stop() {
    }

    public void step() {
    }

    public void back() {
    }

    public void setStepNumber(int n) {
        this.stepNumber = n;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setRate(double d) {
        this.rate = d;
    }

    public double getRate() {
        return this.rate;
    }

    public void setLooping(boolean bl) {
        this.looping = bl;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public int getFrameNumber() {
        return this.clip.stepToFrame(this.stepNumber);
    }

    public abstract boolean isPlaying();

    public abstract double getTime();

    public abstract double getStepTime(int var1);

    public abstract void setFrameDuration(double var1);

    public abstract double getMeanFrameDuration();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void dispose() {
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            ClipControl clipControl = (ClipControl)object;
            xMLControl.setValue("rate", clipControl.getRate());
            xMLControl.setValue("delta_t", clipControl.getMeanFrameDuration());
            if (clipControl.isLooping()) {
                xMLControl.setValue("looping", true);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            double d;
            ClipControl clipControl = (ClipControl)object;
            double d2 = xMLControl.getDouble("rate");
            if (d2 != Double.NaN) {
                clipControl.setRate(d2);
            }
            if ((d = xMLControl.getDouble("delta_t")) != Double.NaN) {
                clipControl.setFrameDuration(d);
            }
            clipControl.setLooping(xMLControl.getBoolean("looping"));
            return object;
        }
    }
}

