/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public abstract class AbstractTile
extends Element {
    protected int numberOfTiles = 0;
    protected double[][][] corners = null;
    private boolean drawQuickInterior = false;
    private int interiorTransparency = 128;
    private double displacementFactor = 1.0;
    private boolean levelBelowWhenEqual = true;
    private double levelx = 0.0;
    private double levely = 0.0;
    private double levelz = 0.0;
    private double leveldx = 0.0;
    private double leveldy = 0.0;
    private double leveldz = 1.0;
    private double[] levelZ = null;
    private Color[] levelColors = null;
    private int[][] a = null;
    private int[][] b = null;
    private double[] pixel = new double[3];
    private double[] center = new double[3];
    private double[] pixelOrigin = new double[3];
    private Object3D[] objects = null;

    public void setDisplacementFactor(double d) {
        this.displacementFactor = d;
    }

    public double getDisplacementFactor() {
        return this.displacementFactor;
    }

    public void setDrawQuickInterior(boolean bl, int n) {
        this.drawQuickInterior = bl;
        this.interiorTransparency = Math.max(0, Math.min(n, 255));
    }

    public void setColorBelowWhenEqual(boolean bl) {
        this.levelBelowWhenEqual = bl;
    }

    public void setColorOriginAndDirection(double[] dArray, double[] dArray2) {
        this.levelx = dArray[0];
        this.levely = dArray[1];
        this.levelz = dArray[2];
        this.leveldx = dArray2[0];
        this.leveldy = dArray2[1];
        this.leveldz = dArray2[2];
    }

    public void setColorRegions(double[] dArray, Color[] colorArray) {
        if (dArray == null || colorArray == null) {
            this.levelZ = null;
            this.levelColors = null;
            return;
        }
        this.levelZ = new double[dArray.length];
        this.levelColors = new Color[dArray.length + 1];
        int n = 0;
        while (n < dArray.length) {
            this.levelZ[n] = dArray[n];
            ++n;
        }
        n = 0;
        while (n < dArray.length + 1) {
            this.levelColors[n] = n < colorArray.length ? colorArray[n] : colorArray[colorArray.length - 1];
            ++n;
        }
        this.setElementChanged(true);
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        if (this.levelZ != null) {
            this.drawColorCoded(graphics2D, n);
            return;
        }
        int n2 = this.corners[n].length;
        if (this.getRealStyle().isDrawingFill()) {
            graphics2D.setPaint(this.getDrawingPanel3D().projectColor(this.getRealStyle().getFillColor(), this.objects[n].getDistance()));
            graphics2D.fillPolygon(this.a[n], this.b[n], n2);
        }
        if (this.getRealStyle().isDrawingLines()) {
            graphics2D.setStroke(this.getRealStyle().getLineStroke());
            graphics2D.setColor(this.getDrawingPanel3D().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance()));
            graphics2D.drawPolygon(this.a[n], this.b[n], n2);
        }
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        if (this.drawQuickInterior) {
            Color color = this.getRealStyle().getFillColor();
            if (color.getAlpha() > this.interiorTransparency) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            graphics2D.setPaint(color);
            int n = 0;
            while (n < this.numberOfTiles) {
                graphics2D.fillPolygon(this.a[n], this.b[n], this.corners[n].length);
                ++n;
            }
        }
        graphics2D.setColor(this.getRealStyle().getLineColor());
        int n = 0;
        while (n < this.numberOfTiles) {
            graphics2D.drawPolygon(this.a[n], this.b[n], this.corners[n].length);
            ++n;
        }
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixelOrigin[0] - (double)n) < 5.0 && Math.abs(this.pixelOrigin[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    protected abstract void computeCorners();

    protected void setCorners(double[][][] dArray) {
        this.corners = dArray;
        if (this.corners == null) {
            this.numberOfTiles = 0;
            this.a = null;
            this.b = null;
            return;
        }
        this.numberOfTiles = this.corners.length;
        this.a = new int[this.numberOfTiles][];
        this.b = new int[this.numberOfTiles][];
        this.objects = new Object3D[this.numberOfTiles];
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.corners[n].length;
            this.a[n] = new int[n2];
            this.b[n] = new int[n2];
            this.objects[n] = new Object3D(this, n);
            ++n;
        }
    }

    protected void projectPoints() {
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.corners[n].length;
            int n3 = 0;
            while (n3 < 3) {
                this.center[n3] = 0.0;
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                this.getDrawingPanel3D().project(this.corners[n][n3], this.pixel);
                this.a[n][n3] = (int)this.pixel[0];
                this.b[n][n3] = (int)this.pixel[1];
                int n4 = 0;
                while (n4 < 3) {
                    int n5 = n4;
                    this.center[n5] = this.center[n5] + this.corners[n][n3][n4];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < 3) {
                int n6 = n3++;
                this.center[n6] = this.center[n6] / (double)n2;
            }
            this.getDrawingPanel3D().project(this.center, this.pixel);
            this.objects[n].setDistance(this.pixel[2] * this.displacementFactor);
            ++n;
        }
        this.getDrawingPanel3D().project(this.getHotSpot(this.targetPosition), this.pixelOrigin);
        this.setNeedToProject(false);
    }

    private double levelScalarProduct(double[] dArray) {
        return (dArray[0] - this.levelx) * this.leveldx + (dArray[1] - this.levely) * this.leveldy + (dArray[2] - this.levelz) * this.leveldz;
    }

    private void drawColorCoded(Graphics2D graphics2D, int n) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = this.corners[n].length;
        int[] nArray = new int[n5];
        if (this.levelBelowWhenEqual) {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = 0;
                d = this.levelScalarProduct(this.corners[n][n4]);
                n3 = this.levelZ.length - 1;
                while (n3 >= 0) {
                    if (d > this.levelZ[n3]) {
                        nArray[n4] = n3 + 1;
                        break;
                    }
                    --n3;
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = this.levelZ.length;
                d = this.levelScalarProduct(this.corners[n][n4]);
                n3 = 0;
                n2 = this.levelZ.length;
                while (n3 < n2) {
                    if (d < this.levelZ[n3]) {
                        nArray[n4] = n3;
                        break;
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        int[] nArray2 = new int[n5 * 2];
        int[] nArray3 = new int[n5 * 2];
        int n6 = 0;
        n3 = this.levelZ.length;
        while (n6 <= n3) {
            n2 = 0;
            int n7 = 0;
            while (n7 < n5) {
                double d2;
                int n8 = (n7 + 1) % n5;
                if (nArray[n7] <= n6 && nArray[n8] >= n6) {
                    if (nArray[n7] == n6) {
                        nArray2[n2] = this.a[n][n7];
                        nArray3[n2] = this.b[n][n7];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6 - 1] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                    if (nArray[n8] > n6) {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                } else if (nArray[n7] >= n6 && nArray[n8] <= n6) {
                    if (nArray[n7] == n6) {
                        nArray2[n2] = this.a[n][n7];
                        nArray3[n2] = this.b[n][n7];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                    if (nArray[n8] < n6) {
                        d2 = this.levelScalarProduct(this.corners[n][n7]);
                        d2 = (this.levelZ[n6 - 1] - d2) / (this.levelScalarProduct(this.corners[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                }
                ++n7;
            }
            if (n2 > 0) {
                Color color = this.levelColors[n6];
                graphics2D.setPaint(color);
                graphics2D.fillPolygon(nArray2, nArray3, n2);
            }
            ++n6;
        }
        graphics2D.setColor(this.getDrawingPanel3D().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance()));
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.drawPolygon(this.a[n], this.b[n], n5);
    }
}

