/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail {
    public static final int NO_MAXIMUM = -1;
    private TrailPoint first;
    private TrailPoint last;
    private int maximumPoints = -1;
    private int length = 0;
    private boolean connected = true;
    private String[] inputLabels = new String[]{"x", "y", "z"};
    protected int datasetID = this.hashCode();

    public ElementTrail() {
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
    }

    @Override
    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible() || this.first == null) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glDisable(2896);
        GLTools.setColor(gL, this.getStyle().getLineColor());
        gL.glLineWidth(this.getStyle().getLineWidth());
        gL.glPushMatrix();
        this.transform(gL);
        this.preLinesGL(gLAutoDrawable);
        gL.glBegin(1);
        TrailPoint trailPoint = this.first;
        while (trailPoint.nextPoint != null) {
            if (trailPoint.pointConnected) {
                gL.glVertex3d(trailPoint.x, trailPoint.y, trailPoint.z);
                gL.glVertex3d(trailPoint.nextPoint.x, trailPoint.nextPoint.y, trailPoint.nextPoint.z);
            } else if (trailPoint.nextPoint.nextPoint == null || !trailPoint.nextPoint.pointConnected) {
                gL.glEnd();
                gL.glBegin(0);
                gL.glVertex3d(trailPoint.nextPoint.x, trailPoint.nextPoint.y, trailPoint.nextPoint.z);
                gL.glEnd();
                gL.glBegin(1);
            }
            trailPoint = trailPoint.nextPoint;
        }
        gL.glEnd();
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    @Override
    public void addPoint(double d, double d2, double d3) {
        if (this.first == null) {
            this.last = this.first = new TrailPoint(d, d2, d3, this.connected);
            this.length = 1;
        } else {
            this.last = this.last.nextPoint = new TrailPoint(d, d2, d3, this.connected);
            ++this.length;
            if (this.maximumPoints != -1 && this.length > this.maximumPoints) {
                this.first = this.first.nextPoint;
            }
        }
    }

    @Override
    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2]);
    }

    @Override
    public void setMaximumPoints(int n) {
        this.maximumPoints = n;
    }

    @Override
    public int getMaximumPoints() {
        return this.maximumPoints;
    }

    @Override
    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void moveToPoint(double d, double d2, double d3) {
        boolean bl = this.connected;
        this.connected = false;
        this.addPoint(d, d2, d3);
        this.connected = bl;
    }

    @Override
    public void clear() {
        this.last = null;
        this.first = null;
    }

    @Override
    public void setXLabel(String string) {
        this.inputLabels[0] = string;
    }

    @Override
    public void setYLabel(String string) {
        this.inputLabels[1] = string;
    }

    @Override
    public void setZLabel(String string) {
        this.inputLabels[2] = string;
    }

    public int getNumberOfPoints() {
        return this.length;
    }

    @Override
    public void setGhostPoint(double[] dArray, boolean bl) {
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = new double[this.length][3];
        TrailPoint trailPoint = this.first;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            dArray[0][n] = trailPoint.x;
            dArray[1][n] = trailPoint.y;
            dArray[2][n] = trailPoint.z;
            trailPoint = trailPoint.nextPoint;
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.getStyle().getFillColor(), this.getStyle().getFillColor(), this.getStyle().getFillColor()};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public int getBlendPriority() {
        return 2;
    }

    private class TrailPoint {
        private double x;
        private double y;
        private double z;
        private boolean pointConnected;
        public TrailPoint nextPoint;

        public TrailPoint(double d, double d2, double d3, boolean bl) {
            this.x = d;
            this.y = d2;
            this.z = d3;
            this.pointConnected = bl;
        }
    }
}

