/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.display3d.ControlElement3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementText;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlElement3DText
extends ControlElement3D {
    private static final int TEXT_PROPERTIES_ADDED = 4;
    private ElementText text;
    private Font font;
    private Font defaultFont;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.display3d.core.ElementText";
    }

    @Override
    protected Element createElement() {
        this.text = OSP3DFactory.ElementText();
        this.font = this.defaultFont = this.text.getFont();
        return this.text;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 4;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("font");
            infoList.add("justification");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("font")) {
            return "Font|Object";
        }
        if (string.equals("justification")) {
            return "3DJustification";
        }
        if (string.equals("rotationAngle")) {
            return "int|double";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("3DJustification") >= 0) {
            if (string2.equals("left")) {
                return new IntegerValue(1);
            }
            if (string2.equals("center")) {
                return new IntegerValue(0);
            }
            if (string2.equals("right")) {
                return new IntegerValue(2);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getString() == this.text.getText()) break;
                this.text.setText(value.getString());
                break;
            }
            case 1: {
                Font font;
                if (!(value.getObject() instanceof Font) || (font = (Font)value.getObject()) == this.font) break;
                this.font = font;
                this.text.setFont(this.font);
                break;
            }
            case 2: {
                if (value.getInteger() == this.text.getJustification()) break;
                this.text.setJustification(value.getInteger());
                break;
            }
            case 3: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.text.getRotationAngle()) break;
                this.text.setRotationAngle(d);
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.text.setText("");
                break;
            }
            case 1: {
                this.text.setJustification(0);
                break;
            }
            case 2: {
                this.text.setFont(this.defaultFont);
                break;
            }
            case 3: {
                this.text.setRotationAngle(0.0);
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

