/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.HasEditor;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.RequiresInitializationUnderEjs;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.control.display3d.ControlElement3D;
import org.colos.ejs.library.control.display3d.ControlParentOfElement3D;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Camera;
import org.opensourcephysics.display3d.core.CameraInspector;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.VisualizationHints;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDrawingPanel3D
extends ControlSwingElement
implements NeedsUpdate,
ControlParentOfElement3D,
InteractionListener,
RequiresInitializationUnderEjs,
SpecialRender,
HasEditor {
    private static final int DP3D_ADDED = 40;
    private static final int PANEL_ENABLED = 43;
    public static final double TO_RAD = Math.PI / 180;
    protected static final int PROJECTION = 7;
    protected static final int[] POSITION_INDEXES = new int[]{24, 25, 26};
    protected static final int[] CAMERA_INDEXES = new int[]{8, 9, 10, 11, 12, 13, 36, 37, 38, 39};
    protected static final int[] CAMERA_PARTIAL_INDEXES = new int[]{8, 9, 10, 11, 12, 13, 36, 37, 38, 39};
    private static final int KEY_INDEX = 35;
    DrawingPanel3D drawingPanel3D;
    private VisualizationHints visHints;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private Camera camera;
    private JFrame cameraInspectorFrame = null;
    private CameraInspector cameraInspector = null;
    private boolean reportXYZMotion = false;
    private boolean reportCameraMotion = false;
    private boolean cameraLocationSet = false;
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(0.0)};
    private DoubleValue[] cameraValues;
    private Vector<NeedsPreUpdate> preupdateList = new Vector();
    private static List<String> infoList = null;
    private boolean settingExtrema = false;

    @Override
    public Object getObject() {
        return this.drawingPanel3D;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.display3d.core.DrawingPanel3D";
    }

    @Override
    protected Component createVisual() {
        this.drawingPanel3D = OSP3DFactory.DrawingPanel3D();
        this.minX = this.drawingPanel3D.getPreferredMinX();
        this.maxX = this.drawingPanel3D.getPreferredMaxX();
        this.minY = this.drawingPanel3D.getPreferredMinY();
        this.maxY = this.drawingPanel3D.getPreferredMaxY();
        this.minZ = this.drawingPanel3D.getPreferredMinZ();
        this.maxZ = this.drawingPanel3D.getPreferredMaxZ();
        this.visHints = this.drawingPanel3D.getVisualizationHints();
        this.camera = this.drawingPanel3D.getCamera();
        this.cameraValues = new DoubleValue[]{new DoubleValue(this.camera.getFocusX()), new DoubleValue(this.camera.getFocusY()), new DoubleValue(this.camera.getFocusZ()), new DoubleValue(this.camera.getDistanceToScreen()), new DoubleValue(this.camera.getAzimuth()), new DoubleValue(this.camera.getAltitude()), new DoubleValue(this.camera.getX()), new DoubleValue(this.camera.getY()), new DoubleValue(this.camera.getZ()), new DoubleValue(this.camera.getRotation())};
        this.drawingPanel3D.addInteractionListener(this);
        this.drawingPanel3D.render();
        Component component = this.drawingPanel3D.getComponent();
        component.setFocusable(true);
        component.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlDrawingPanel3D.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlDrawingPanel3D.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlDrawingPanel3D.this.printScreen();
                    }
                }
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = keyEvent.getKeyCode();
                ControlDrawingPanel3D.this.variableChanged(35, ControlDrawingPanel3D.this.keyPressedValue);
                ControlDrawingPanel3D.this.invokeActions(30);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = -1;
                ControlDrawingPanel3D.this.variableChanged(35, ControlDrawingPanel3D.this.keyPressedValue);
            }
        });
        this.drawingPanel3D.getComponent().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) && ControlDrawingPanel3D.this.getSimulation() != null) {
                    ControlDrawingPanel3D.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return component;
    }

    @Override
    public void addMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem("CameraInspector.Camera");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawingPanel3D.this.showCameraInspector();
            }
        });
        jMenuItem.setActionCommand("CameraInspector.Camera");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(jMenuItem);
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), arrayList);
    }

    @Override
    public boolean acceptsChild(ControlElement controlElement) {
        return controlElement instanceof ControlElement3D;
    }

    @Override
    public BufferedImage render(BufferedImage bufferedImage) {
        return this.drawingPanel3D.render(bufferedImage);
    }

    @Override
    public void showEditor(String string) {
        if ("camera".equalsIgnoreCase(string)) {
            this.camera.reset();
            this.reportCameraMotion();
        }
    }

    public void showCameraInspector() {
        if (this.cameraInspectorFrame == null) {
            this.createCameraInspector();
        }
        this.cameraInspectorFrame.setVisible(true);
    }

    private void createCameraInspector() {
        this.cameraInspector = new CameraInspector(this.drawingPanel3D);
        this.cameraInspector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ControlDrawingPanel3D.this.isUnderEjs) {
                    ControlDrawingPanel3D.this.updateCameraFields();
                }
            }
        });
        this.cameraInspectorFrame = CameraInspector.createFrame(this.cameraInspector);
        this.cameraInspectorFrame.setLocationRelativeTo(this.drawingPanel3D.getComponent());
    }

    @Override
    public void update() {
        Enumeration<NeedsPreUpdate> enumeration = this.preupdateList.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preupdate();
        }
        if (this.myGroup != null && this.myGroup.isCollectingData()) {
            return;
        }
        this.drawingPanel3D.render();
    }

    @Override
    public void addToPreupdateList(NeedsPreUpdate needsPreUpdate) {
        this.preupdateList.add(needsPreUpdate);
    }

    @Override
    public void removeFromPreupdateList(NeedsPreUpdate needsPreUpdate) {
        this.preupdateList.remove(needsPreUpdate);
    }

    @Override
    public void addElement(Element element) {
        this.drawingPanel3D.addElement(element);
    }

    @Override
    public void removeElement(Element element) {
        this.drawingPanel3D.removeElement(element);
    }

    @Override
    protected void getPopupMenu(int n, int n2) {
        if (this.cameraInspectorFrame == null) {
            this.createCameraInspector();
        }
        super.getPopupMenu(n, n2);
    }

    @Override
    public String initializationString() {
        if (this.getProperty("implementation") == null) {
            return "";
        }
        String string = this.getProperty("implementation");
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return "    org.opensourcephysics.display3d.factory.OSP3DFactory.setImplementation (org.opensourcephysics.display3d.factory.OSP3DFactory.IMPLEMENTATION_" + string + ");\n";
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("squareAspect");
            infoList.add("projectionMode");
            infoList.add("cameraFocusX");
            infoList.add("cameraFocusY");
            infoList.add("cameraFocusZ");
            infoList.add("cameraDistanceToScreen");
            infoList.add("cameraAzimuth");
            infoList.add("cameraAltitude");
            infoList.add("implementation");
            infoList.add("decorationType");
            infoList.add("cursorType");
            infoList.add("removeHiddenLines");
            infoList.add("allowQuickRedraw");
            infoList.add("useColorDepth");
            infoList.add("showCoordinates");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("zFormat");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("movedAction");
            infoList.add("pressAction");
            infoList.add("releaseAction");
            infoList.add("dragAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("axesLabels");
            infoList.add("cameraX");
            infoList.add("cameraY");
            infoList.add("cameraZ");
            infoList.add("cameraRotation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("minimumZ")) {
            return "int|double";
        }
        if (string.equals("maximumZ")) {
            return "int|double";
        }
        if (string.equals("squareAspect")) {
            return "boolean";
        }
        if (string.equals("projectionMode")) {
            return "int|3DCameraMode";
        }
        if (string.equals("cameraFocusX")) {
            return "int|double";
        }
        if (string.equals("cameraFocusY")) {
            return "int|double";
        }
        if (string.equals("cameraFocusZ")) {
            return "int|double";
        }
        if (string.equals("cameraDistanceToScreen")) {
            return "int|double";
        }
        if (string.equals("cameraAzimuth")) {
            return "int|double";
        }
        if (string.equals("cameraAltitude")) {
            return "int|double";
        }
        if (string.equals("implementation")) {
            return "String|3DImplementation CONSTANT";
        }
        if (string.equals("decorationType")) {
            return "int|3DDecorationType";
        }
        if (string.equals("cursorType")) {
            return "int|3DCursorType";
        }
        if (string.equals("removeHiddenLines")) {
            return "boolean";
        }
        if (string.equals("allowQuickRedraw")) {
            return "boolean";
        }
        if (string.equals("useColorDepth")) {
            return "boolean";
        }
        if (string.equals("showCoordinates")) {
            return "int|3DShowCoordinates";
        }
        if (string.equals("xFormat")) {
            return "Object|String TRANSLATABLE";
        }
        if (string.equals("yFormat")) {
            return "Object|String TRANSLATABLE";
        }
        if (string.equals("zFormat")) {
            return "Object|String TRANSLATABLE";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("z")) {
            return "int|double";
        }
        if (string.equals("movedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("keyPressed")) {
            return "int";
        }
        if (string.equals("axesLabels")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("cameraX")) {
            return "int|double";
        }
        if (string.equals("cameraY")) {
            return "int|double";
        }
        if (string.equals("cameraZ")) {
            return "int|double";
        }
        if (string.equals("cameraRotation")) {
            return "int|double";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("x") || string.equals("y") || string.equals("z")) {
            if (string2 != null) {
                Value value = Value.parseConstant(string2, true);
                if (!this.reportXYZMotion) {
                    this.reportXYZMotion = value == null;
                }
            }
        } else if (string.startsWith("camera")) {
            if (string.equals("cameraX") || string.equals("cameraY") || string.equals("cameraZ")) {
                this.cameraLocationSet = true;
            }
            if (string2 != null) {
                Value value = Value.parseConstant(string2, true);
                if (!this.reportCameraMotion) {
                    this.reportCameraMotion = value == null;
                }
            }
        }
        return super.setProperty(string, string2);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("3DCameraMode") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).indexOf("no_perspective") >= 0) {
                return new IntegerValue(10);
            }
            if (string2.indexOf("perspective") >= 0) {
                return new IntegerValue(11);
            }
            if (string2.indexOf("planar_xy") >= 0) {
                return new IntegerValue(0);
            }
            if (string2.indexOf("planar_xz") >= 0) {
                return new IntegerValue(1);
            }
            if (string2.indexOf("planar_yz") >= 0) {
                return new IntegerValue(2);
            }
        }
        if (string.indexOf("3DDecorationType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cube")) {
                return new IntegerValue(2);
            }
            if (string2.equals("axes")) {
                return new IntegerValue(1);
            }
        }
        if (string.indexOf("3DCursorType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cube")) {
                return new IntegerValue(2);
            }
            if (string2.equals("crosshair")) {
                return new IntegerValue(3);
            }
            if (string2.equals("xyz")) {
                return new IntegerValue(1);
            }
        }
        if (string.indexOf("3DShowCoordinates") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(-1);
            }
            if (string2.equals("bottom_left")) {
                return new IntegerValue(0);
            }
            if (string2.equals("bottom_right")) {
                return new IntegerValue(1);
            }
            if (string2.equals("top_left")) {
                return new IntegerValue(3);
            }
            if (string2.equals("top_right")) {
                return new IntegerValue(2);
            }
        }
        return super.parseConstant(string, string2);
    }

    private void setAxesLabels(String string) {
        String[] stringArray = new String[]{"X", "Y", "Z"};
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[0] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[1] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[2] = stringTokenizer.nextToken();
            }
        }
        this.drawingPanel3D.getVisualizationHints().setAxesLabels(stringArray);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.resetExtrema();
                break;
            }
            case 1: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.resetExtrema();
                break;
            }
            case 2: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.resetExtrema();
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.resetExtrema();
                break;
            }
            case 4: {
                if (value.getDouble() == this.minZ) break;
                this.minZ = value.getDouble();
                this.resetExtrema();
                break;
            }
            case 5: {
                if (value.getDouble() == this.maxZ) break;
                this.maxZ = value.getDouble();
                this.resetExtrema();
                break;
            }
            case 6: {
                if (value.getBoolean() == this.drawingPanel3D.isSquareAspect()) break;
                this.drawingPanel3D.setSquareAspect(value.getBoolean());
                break;
            }
            case 7: {
                if (value.getInteger() == this.camera.getProjectionMode()) break;
                this.camera.setProjectionMode(value.getInteger());
                break;
            }
            case 8: {
                if (value.getDouble() == this.cameraValues[0].value) break;
                this.cameraValues[0].value = value.getDouble();
                this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
                break;
            }
            case 9: {
                if (value.getDouble() == this.cameraValues[1].value) break;
                this.cameraValues[1].value = value.getDouble();
                this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
                break;
            }
            case 10: {
                if (value.getDouble() == this.cameraValues[2].value) break;
                this.cameraValues[2].value = value.getDouble();
                this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
                break;
            }
            case 11: {
                if (value.getDouble() == this.cameraValues[3].value) break;
                this.cameraValues[3].value = value.getDouble();
                this.camera.setDistanceToScreen(this.cameraValues[3].value);
                break;
            }
            case 12: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.cameraValues[4].value) break;
                this.cameraValues[4].value = value.getDouble();
                this.camera.setAzimuth(this.cameraValues[4].value);
                break;
            }
            case 13: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.cameraValues[5].value) break;
                this.cameraValues[5].value = value.getDouble();
                this.camera.setAltitude(this.cameraValues[5].value);
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                if (value.getInteger() == this.visHints.getDecorationType()) break;
                this.visHints.setDecorationType(value.getInteger());
                break;
            }
            case 16: {
                if (value.getInteger() == this.visHints.getCursorType()) break;
                this.visHints.setCursorType(value.getInteger());
                break;
            }
            case 17: {
                if (value.getBoolean() == this.visHints.isRemoveHiddenLines()) break;
                this.visHints.setRemoveHiddenLines(value.getBoolean());
                break;
            }
            case 18: {
                if (value.getBoolean() == this.visHints.isAllowQuickRedraw()) break;
                this.visHints.setAllowQuickRedraw(value.getBoolean());
                break;
            }
            case 19: {
                if (value.getBoolean() == this.visHints.isUseColorDepth()) break;
                this.visHints.setUseColorDepth(value.getBoolean());
                break;
            }
            case 20: {
                if (value.getInteger() == this.visHints.getShowCoordinates()) break;
                this.visHints.setShowCoordinates(value.getInteger());
                break;
            }
            case 21: {
                String string = value.getString();
                if (string == null) {
                    this.visHints.setXFormat(null);
                    break;
                }
                if (string.equals(this.visHints.getXFormat())) break;
                this.visHints.setXFormat(string);
                break;
            }
            case 22: {
                String string = value.getString();
                if (string == null) {
                    this.visHints.setYFormat(null);
                    break;
                }
                if (string.equals(this.visHints.getYFormat())) break;
                this.visHints.setYFormat(string);
                break;
            }
            case 23: {
                String string = value.getString();
                if (string == null) {
                    this.visHints.setZFormat(null);
                    break;
                }
                if (string.equals(this.visHints.getZFormat())) break;
                this.visHints.setZFormat(string);
                break;
            }
            case 24: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 25: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 26: {
                this.posValues[2].value = value.getDouble();
                break;
            }
            case 27: {
                this.removeAction(33, this.getProperty("movedAction"));
                this.addAction(33, value.getString());
                break;
            }
            case 28: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, value.getString());
                break;
            }
            case 29: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, value.getString());
                break;
            }
            case 30: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, value.getString());
                break;
            }
            case 31: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 32: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 33: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, value.getString());
                break;
            }
            case 34: {
                this.keyPressedValue.value = value.getInteger();
                break;
            }
            case 35: {
                this.setAxesLabels(value.toString());
                break;
            }
            case 36: {
                if (value.getDouble() == this.cameraValues[6].value) break;
                this.cameraValues[6].value = value.getDouble();
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
                break;
            }
            case 37: {
                if (value.getDouble() == this.cameraValues[7].value) break;
                this.cameraValues[7].value = value.getDouble();
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
                break;
            }
            case 38: {
                if (value.getDouble() == this.cameraValues[8].value) break;
                this.cameraValues[8].value = value.getDouble();
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
                break;
            }
            case 39: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.cameraValues[9].value) break;
                this.cameraValues[9].value = d;
                this.camera.setRotation(this.cameraValues[9].value);
                break;
            }
            default: {
                super.setValue(n - 40, value);
                break;
            }
            case 43: {
                this.drawingPanel3D.getInteractionTarget(0).setEnabled(value.getBoolean());
            }
        }
        if (this.isUnderEjs && this.cameraInspector != null) {
            if (n == 7) {
                this.cameraInspector.updateFields();
            } else {
                int n2 = 0;
                while (n2 < CAMERA_INDEXES.length) {
                    if (CAMERA_INDEXES[n2] == n) {
                        this.cameraInspector.updateFields();
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.minX = -1.0;
                this.resetExtrema();
                break;
            }
            case 1: {
                this.maxX = 1.0;
                this.resetExtrema();
                break;
            }
            case 2: {
                this.minY = -1.0;
                this.resetExtrema();
                break;
            }
            case 3: {
                this.maxY = 1.0;
                this.resetExtrema();
                break;
            }
            case 4: {
                this.minZ = -1.0;
                this.resetExtrema();
                break;
            }
            case 5: {
                this.maxZ = 1.0;
                this.resetExtrema();
                break;
            }
            case 6: {
                this.drawingPanel3D.setSquareAspect(true);
                break;
            }
            case 7: {
                this.camera.setProjectionMode(11);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 39: {
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.visHints.setDecorationType(2);
                break;
            }
            case 16: {
                this.visHints.setCursorType(1);
                break;
            }
            case 17: {
                this.visHints.setRemoveHiddenLines(true);
                break;
            }
            case 18: {
                this.visHints.setAllowQuickRedraw(true);
                break;
            }
            case 19: {
                this.visHints.setUseColorDepth(true);
                break;
            }
            case 20: {
                this.visHints.setShowCoordinates(0);
                break;
            }
            case 21: {
                this.visHints.setXFormat("x = 0.00;x = -0.00");
                break;
            }
            case 22: {
                this.visHints.setYFormat("y = 0.00;y = -0.00");
                break;
            }
            case 23: {
                this.visHints.setZFormat("z = 0.00;z = -0.00");
                break;
            }
            case 24: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 25: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 26: {
                this.posValues[2].value = (this.minZ + this.maxZ) / 2.0;
                break;
            }
            case 27: {
                this.removeAction(33, this.getProperty("movedAction"));
                break;
            }
            case 28: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 29: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 30: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 31: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 32: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 33: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 34: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 35: {
                this.setAxesLabels(null);
                break;
            }
            default: {
                super.setDefaultValue(n - 40);
                break;
            }
            case 43: {
                this.drawingPanel3D.getInteractionTarget(0).setEnabled(true);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
            case 8: {
                return this.cameraValues[0];
            }
            case 9: {
                return this.cameraValues[1];
            }
            case 10: {
                return this.cameraValues[2];
            }
            case 11: {
                return this.cameraValues[3];
            }
            case 12: {
                return this.cameraValues[4];
            }
            case 13: {
                return this.cameraValues[5];
            }
            case 36: {
                return this.cameraValues[6];
            }
            case 37: {
                return this.cameraValues[7];
            }
            case 38: {
                return this.cameraValues[8];
            }
            case 39: {
                return this.cameraValues[9];
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return null;
            }
            case 24: {
                return this.posValues[0];
            }
            case 25: {
                return this.posValues[1];
            }
            case 26: {
                return this.posValues[2];
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return null;
            }
            case 34: {
                return this.keyPressedValue;
            }
            case 35: {
                return null;
            }
            default: {
                return super.getValue(n - 40);
            }
            case 43: 
        }
        return null;
    }

    private void resetExtrema() {
        this.settingExtrema = true;
        this.drawingPanel3D.setPreferredMinMax(this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
        this.reportCameraMotion();
    }

    private void reportCameraMotion() {
        if (this.settingExtrema) {
            this.camera.setDistanceToScreen(this.cameraValues[3].value);
            if (this.cameraLocationSet) {
                this.camera.setXYZ(this.cameraValues[6].value, this.cameraValues[7].value, this.cameraValues[8].value);
            } else {
                this.camera.setAzimuthAndAltitude(this.cameraValues[4].value, this.cameraValues[5].value);
            }
            this.camera.setRotation(this.cameraValues[9].value);
            this.camera.setFocusXYZ(this.cameraValues[0].value, this.cameraValues[1].value, this.cameraValues[2].value);
        } else {
            this.cameraValues[0].value = this.camera.getFocusX();
            this.cameraValues[1].value = this.camera.getFocusY();
            this.cameraValues[2].value = this.camera.getFocusZ();
            this.cameraValues[3].value = this.camera.getDistanceToScreen();
            this.cameraValues[4].value = this.camera.getAzimuth();
            this.cameraValues[5].value = this.camera.getAltitude();
            this.cameraValues[6].value = this.camera.getX();
            this.cameraValues[7].value = this.camera.getY();
            this.cameraValues[8].value = this.camera.getZ();
            this.cameraValues[9].value = this.camera.getRotation();
        }
        if (this.reportCameraMotion) {
            this.variablesChanged(CAMERA_INDEXES, this.cameraValues);
        }
        if (this.isUnderEjs) {
            if (!this.editorIsReading()) {
                if (this.cameraLocationSet) {
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[4] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[5] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[6] = 36;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[7] = 37;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[8] = 38;
                } else {
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[4] = 12;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[5] = 13;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[6] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[7] = -1;
                    ControlDrawingPanel3D.CAMERA_PARTIAL_INDEXES[8] = -1;
                }
                this.setFieldListValues(CAMERA_PARTIAL_INDEXES, this.cameraValues);
            }
            this.drawingPanel3D.render();
        }
        this.settingExtrema = false;
    }

    private void updateCameraFields() {
        this.reportCameraMotion();
        switch (this.camera.getProjectionMode()) {
            case 0: {
                this.setFieldListValue(7, new StringValue("PLANAR_XY"));
                break;
            }
            case 1: {
                this.setFieldListValue(7, new StringValue("PLANAR_XZ"));
                break;
            }
            case 2: {
                this.setFieldListValue(7, new StringValue("PLANAR_YZ"));
                break;
            }
            case 10: {
                this.setFieldListValue(7, new StringValue("NO_PERSPECTIVE"));
                break;
            }
            default: {
                this.setFieldListValue(7, new StringValue("PERSPECTIVE"));
            }
        }
    }

    private void reportMouseMotion(Object object) {
        if (object == null || !(object instanceof double[])) {
            return;
        }
        double[] dArray = (double[])object;
        this.posValues[0].value = dArray[0];
        this.posValues[1].value = dArray[1];
        this.posValues[2].value = dArray[2];
        if (this.reportXYZMotion) {
            this.variablesChanged(POSITION_INDEXES, this.posValues);
        }
        if (this.isUnderEjs) {
            this.setFieldListValues(POSITION_INDEXES, this.posValues);
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                break;
            }
            case 2005: {
                this.reportMouseMotion(interactionEvent.getInfo());
                this.invokeActions(33);
                break;
            }
            case 2000: {
                this.drawingPanel3D.getComponent().requestFocus();
                this.reportMouseMotion(interactionEvent.getInfo());
                this.invokeActions(10);
                break;
            }
            case 2001: {
                if (interactionEvent.getInfo() == null) {
                    this.reportCameraMotion();
                    break;
                }
                this.reportMouseMotion(interactionEvent.getInfo());
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }
}

