/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.opensourcephysics.drawing2d.DrawingPanel;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.tools.ResourceLoader;

public class Style {
    public static final int DEFAULT_SENSITIVITY = 5;
    public static final int CHANGED_LINE_COLOR = 0;
    public static final int CHANGED_LINE_WIDTH = 1;
    public static final int CHANGED_FILL_COLOR = 2;
    public static final int CHANGED_DRAWING_FILL = 3;
    public static final int CHANGED_DRAWING_LINES = 4;
    public static final int CHANGED_RELATIVE_POSITION = 5;
    public static final int CHANGED_SENSITIVITY = 6;
    public static final int CHANGED_EXTRA_COLOR = 7;
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.black;
    private float lineWidth = 1.0f;
    private Paint fillColor = Color.blue;
    private Color extraColor = Color.black;
    private int sensitivity = 5;
    int position = 0;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    Style(Element element) {
        this.element = element;
    }

    public Style clone() {
        Style style = new Style(this.element);
        style.drawsFill = this.drawsFill;
        style.drawsLines = this.drawsLines;
        style.fillColor = this.fillColor;
        style.lineColor = this.lineColor;
        style.lineStroke = this.lineStroke;
        style.lineWidth = this.lineWidth;
        style.position = this.position;
        style.sensitivity = this.sensitivity;
        style.extraColor = this.extraColor;
        return style;
    }

    public void copyTo(Element element) {
        Style style = element.getStyle();
        style.setDrawingFill(this.drawsFill);
        style.setDrawingLines(this.drawsLines);
        style.setFillColor(this.fillColor);
        style.setLineColor(this.lineColor);
        style.setLineWidth(this.lineWidth);
        style.setRelativePosition(this.position);
        style.setSensitivity(this.sensitivity);
        style.setExtraColor(this.extraColor);
    }

    public final void setLineColor(Color color) {
        if (color == null) {
            return;
        }
        this.lineColor = color;
        if (this.element != null) {
            this.element.styleChanged(0);
        }
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineWidth(float f) {
        if (this.lineWidth == f) {
            return;
        }
        this.lineWidth = f;
        this.lineStroke = new BasicStroke(this.lineWidth);
        if (this.element != null) {
            this.element.styleChanged(1);
        }
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public final void setFillColor(Paint paint) {
        if (paint == null) {
            return;
        }
        this.fillColor = paint;
        if (this.element != null) {
            this.element.styleChanged(2);
        }
    }

    public final Paint getFillColor() {
        return this.fillColor;
    }

    public final void setExtraColor(Color color) {
        if (color == null) {
            return;
        }
        this.extraColor = color;
        if (this.element != null) {
            this.element.styleChanged(7);
        }
    }

    public final Color getExtraColor() {
        return this.extraColor;
    }

    public final boolean isDrawingFill() {
        return this.drawsFill;
    }

    public final void setDrawingFill(boolean bl) {
        this.drawsFill = bl;
        if (this.element != null) {
            this.element.styleChanged(3);
        }
    }

    public final boolean isDrawingLines() {
        return this.drawsLines;
    }

    public final void setDrawingLines(boolean bl) {
        this.drawsLines = bl;
        if (this.element != null) {
            this.element.styleChanged(4);
        }
    }

    public final void setRelativePosition(int n) {
        this.position = n;
        this.element.styleChanged(5);
    }

    public final int getRelativePosition() {
        return this.position;
    }

    public final void setSensitivity(int n) {
        this.sensitivity = n;
    }

    public final int getSensitivity() {
        return this.sensitivity;
    }

    public final void setPaint(String string) {
        this.setPaint(string, 0.0, 0.0);
    }

    public final void setPaint(String string, double d, double d2) {
        DrawingPanel drawingPanel;
        if (string == null) {
            return;
        }
        BufferedImage bufferedImage = ResourceLoader.getBufferedImage(string);
        if (bufferedImage != null && (drawingPanel = this.element.getPanel()) != null) {
            Toolkit.getDefaultToolkit().prepareImage(bufferedImage, -1, -1, drawingPanel.getComponent());
            if (d <= 0.0) {
                d = bufferedImage.getWidth();
            }
            if (d2 <= 0.0) {
                d2 = bufferedImage.getHeight();
            }
            this.fillColor = new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, d, d2));
        }
    }
}

