/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class Style {
    public static final int DEFAULT_SENSITIVITY = 5;
    public static final int CHANGED_LINE_COLOR = 0;
    public static final int CHANGED_LINE_WIDTH = 1;
    public static final int CHANGED_FILL_COLOR = 2;
    public static final int CHANGED_DRAWING_FILL = 3;
    public static final int CHANGED_DRAWING_LINES = 4;
    public static final int CHANGED_RELATIVE_POSITION = 5;
    public static final int CHANGED_SENSITIVITY = 6;
    public static final int CHANGED_EXTRA_COLOR = 7;
    public static final int CHANGED_DEPTH_FACTOR = 8;
    public static final int CHANGED_RESOLUTION = 9;
    public static final int CHANGED_TEXTURES = 10;
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.BLACK;
    private float lineWidth = 1.0f;
    private Paint fillColor = Color.BLUE;
    private Color extraColor = Color.black;
    private int sensitivity = 5;
    private Resolution resolution = null;
    private double depthFactor = 1.0;
    private int position = 0;
    private String textureFile1 = null;
    private String textureFile2 = null;
    private double transpTexture = Double.NaN;
    private boolean combineTexture = false;
    private double ambientFactor = 0.4;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    public Style(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public Style clone() {
        Style style = new Style(this.element);
        this.copyTo(style);
        return style;
    }

    public void copyTo(Style style) {
        style.setDrawingFill(this.drawsFill);
        style.setDrawingLines(this.drawsLines);
        style.setLineColor(this.lineColor);
        style.setLineWidth(this.lineWidth);
        style.setFillColor(this.fillColor);
        style.setExtraColor(this.extraColor);
        style.setSensitivity(this.sensitivity);
        style.setResolution(this.resolution);
        style.setDepthFactor(this.depthFactor);
        style.setRelativePosition(this.position);
        style.setTexture(this.textureFile1, this.textureFile2, this.transpTexture, this.combineTexture);
    }

    private void notifyChange(int n) {
        if (this.element == null) {
            return;
        }
        this.element.styleChanged(n);
    }

    void setElement(Element element) {
        this.element = element;
    }

    public void setLineColor(Color color) {
        if (color == null || color.equals(this.lineColor)) {
            return;
        }
        this.lineColor = color;
        this.notifyChange(0);
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(float f) {
        if (this.lineWidth == f) {
            return;
        }
        this.lineWidth = f;
        this.lineStroke = new BasicStroke(this.lineWidth);
        this.notifyChange(1);
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setFillColor(Paint paint) {
        if (paint == null || paint.equals(this.fillColor)) {
            return;
        }
        this.fillColor = paint;
        this.notifyChange(2);
    }

    public final Paint getFillColor() {
        return this.fillColor;
    }

    public final void setExtraColor(Color color) {
        if (color == null || color.equals(this.extraColor)) {
            return;
        }
        this.extraColor = color;
        this.notifyChange(7);
    }

    public final Color getExtraColor() {
        return this.extraColor;
    }

    public void setResolution(Resolution resolution) {
        if (this.resolution != null && this.resolution.equals(resolution)) {
            return;
        }
        this.resolution = resolution;
        this.notifyChange(9);
    }

    public final Resolution getResolution() {
        return this.resolution;
    }

    public boolean isDrawingFill() {
        return this.drawsFill;
    }

    public void setDrawingFill(boolean bl) {
        if (this.drawsFill == bl) {
            return;
        }
        this.drawsFill = bl;
        this.notifyChange(3);
    }

    public boolean isDrawingLines() {
        return this.drawsLines;
    }

    public void setDrawingLines(boolean bl) {
        if (this.drawsLines == bl) {
            return;
        }
        this.drawsLines = bl;
        this.notifyChange(4);
    }

    public void setDepthFactor(double d) {
        if (this.depthFactor == d) {
            return;
        }
        this.depthFactor = d;
        this.notifyChange(8);
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setTexture(String string, String string2, double d, boolean bl) {
        this.textureFile1 = string;
        this.textureFile2 = string2;
        this.transpTexture = d;
        this.combineTexture = bl;
        this.notifyChange(10);
    }

    public String[] getTextures() {
        return new String[]{this.textureFile1, this.textureFile2};
    }

    public double getTransparency() {
        return this.transpTexture;
    }

    public boolean getCombine() {
        return this.combineTexture;
    }

    public void setAmbientFactor(double d) {
        if (this.ambientFactor == d) {
            return;
        }
        this.ambientFactor = d;
        this.notifyChange(2);
    }

    public double getAmbientFactor() {
        return this.ambientFactor;
    }

    public final void setRelativePosition(int n) {
        if (this.position == n) {
            return;
        }
        this.position = n;
        this.notifyChange(5);
    }

    public final int getRelativePosition() {
        return this.position;
    }

    public final void setSensitivity(int n) {
        if (this.sensitivity == n) {
            return;
        }
        this.sensitivity = n;
        this.notifyChange(6);
    }

    public final int getSensitivity() {
        return this.sensitivity;
    }
}

