/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.Paint;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector4f;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementCone;
import org.opensourcephysics.drawing3d.ElementCylinder;
import org.opensourcephysics.drawing3d.ElementEllipsoid;
import org.opensourcephysics.drawing3d.ElementObject;
import org.opensourcephysics.drawing3d.ElementSphere;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Style;
import org.opensourcephysics.tools.ResourceLoader;

public class Java3dStyle {
    private Style style;
    private float shininess = 50.0f;
    private Appearance appearance;
    private TransparencyAttributes transparency;

    Java3dStyle(Style style) {
        this.style = style;
        this.appearance = new Appearance();
        this.appearance.setCapability(8);
        this.appearance.setCapability(9);
        this.appearance.setCapability(15);
        this.appearance.setCapability(14);
        this.appearance.setCapability(1);
        this.appearance.setCapability(0);
        this.appearance.setCapability(3);
        this.appearance.setCapability(13);
        this.appearance.setCapability(12);
        this.appearance.setCapability(7);
        this.appearance.setCapability(17);
        this.appearance.setCapability(16);
        this.appearance.setCapability(5);
        this.appearance.setCapability(11);
        this.appearance.setCapability(21);
        this.appearance.setCapability(19);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(1);
        polygonAttributes.setCapability(3);
        polygonAttributes.setCapability(5);
        this.appearance.setPolygonAttributes(polygonAttributes);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineAntialiasingEnable(true);
        lineAttributes.setLineWidth(this.style.getLineWidth());
        lineAttributes.setCapability(1);
        this.appearance.setLineAttributes(lineAttributes);
        PointAttributes pointAttributes = new PointAttributes();
        pointAttributes.setCapability(1);
        pointAttributes.setCapability(3);
        this.appearance.setPointAttributes(pointAttributes);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        renderingAttributes.setCapability(10);
        this.appearance.setRenderingAttributes(renderingAttributes);
        this.transparency = new TransparencyAttributes();
        this.transparency.setCapability(3);
        this.transparency.setCapability(1);
        this.appearance.setTransparencyAttributes(this.transparency);
        Material material = new Material();
        material.setCapability(1);
        this.appearance.setMaterial(material);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setCapability(1);
        this.appearance.setColoringAttributes(coloringAttributes);
        this.applyStyleChange(0);
        this.applyStyleChange(2);
        this.applyStyleChange(1);
        this.applyStyleChange(3);
        this.applyStyleChange(4);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void applyStyleChange(int n) {
        switch (n) {
            case 0: {
                Color color = this.style.getLineColor();
                float[] fArray = color.getRGBComponents(null);
                this.appearance.getRenderingAttributes().setIgnoreVertexColors(true);
                this.appearance.getColoringAttributes().setColor(fArray[0], fArray[1], fArray[2]);
                this.transparency.setTransparency(1.0f - fArray[3]);
                if (fArray[3] != 1.0f) {
                    this.appearance.getPolygonAttributes().setCullFace(0);
                    this.transparency.setTransparencyMode(1);
                } else {
                    this.appearance.getPolygonAttributes().setCullFace(1);
                    this.transparency.setTransparencyMode(4);
                }
                this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
                this.appearance.getMaterial().setShininess(this.shininess);
                break;
            }
            case 1: {
                this.appearance.getLineAttributes().setLineWidth(this.style.getLineWidth());
                break;
            }
            case 2: {
                Paint paint = this.style.getFillColor();
                if (!(paint instanceof Color)) break;
                Color color = (Color)paint;
                float[] fArray = color.getRGBComponents(null);
                this.appearance.getMaterial().setAmbientColor((float)((double)fArray[0] * this.style.getAmbientFactor()), (float)((double)fArray[1] * this.style.getAmbientFactor()), (float)((double)fArray[2] * this.style.getAmbientFactor()));
                this.appearance.getMaterial().setDiffuseColor(fArray[0], fArray[1], fArray[2]);
                if (fArray[3] != 1.0f) {
                    this.transparency.setTransparencyMode(2);
                } else {
                    this.appearance.getPolygonAttributes().setCullFace(1);
                    this.transparency.setTransparencyMode(4);
                }
                this.transparency.setTransparency(1.0f - fArray[3]);
                this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
                this.appearance.getMaterial().setShininess(this.shininess);
                break;
            }
            case 3: {
                if (this.style.isDrawingFill()) {
                    this.turnFillOn();
                    break;
                }
                if (!this.style.isDrawingLines()) break;
                this.turnLinesOn();
                break;
            }
            case 4: {
                if (!this.style.isDrawingLines() || this.style.isDrawingFill()) break;
                this.turnLinesOn();
                break;
            }
            case 10: {
                this.setTexture(this.style.getTextures(), this.style.getTransparency(), this.style.getCombine());
                break;
            }
            case 8: {
                this.appearance.getPolygonAttributes().setPolygonOffset(0.1f);
                this.appearance.getPolygonAttributes().setPolygonOffsetFactor((float)this.style.getDepthFactor());
            }
        }
    }

    private void setTexture(String[] stringArray, double d, boolean bl) {
        URL uRL;
        TransparencyAttributes transparencyAttributes = null;
        Texture texture = null;
        Texture texture2 = null;
        TextureUnitState[] textureUnitStateArray = new TextureUnitState[2];
        boolean bl2 = false;
        boolean bl3 = false;
        if (d <= 0.0 || d >= 1.0) {
            d = Double.NaN;
        }
        if (stringArray[0] == null && stringArray[1] == null) {
            this.appearance.setTexture(null);
            return;
        }
        if (stringArray[0] != null) {
            uRL = ResourceLoader.getResource(stringArray[0]).getURL();
            texture = new TextureLoader(uRL, 5, null).getTexture();
            texture.setBoundaryModeT(3);
            texture.setBoundaryModeS(3);
        }
        if (stringArray[1] != null) {
            uRL = ResourceLoader.getResource(stringArray[1]).getURL();
            texture2 = new TextureLoader(uRL, 5, null).getTexture();
            texture2.setBoundaryModeT(3);
            texture2.setBoundaryModeS(3);
        }
        if (!Double.isNaN(d)) {
            transparencyAttributes = new TransparencyAttributes();
            transparencyAttributes.setTransparencyMode(2);
            transparencyAttributes.setTransparency((float)d);
        }
        uRL = new TextureAttributes();
        if (bl) {
            uRL.setTextureMode(3);
        } else {
            uRL.setTextureMode(5);
        }
        TextureAttributes textureAttributes = new TextureAttributes();
        if (bl) {
            textureAttributes.setTextureMode(2);
        } else {
            textureAttributes.setTextureMode(5);
        }
        if (stringArray[0] != null && stringArray[1] != null) {
            textureUnitStateArray[0] = new TextureUnitState(texture, (TextureAttributes)uRL, null);
            textureUnitStateArray[0].setCapability(1);
            textureUnitStateArray[1] = new TextureUnitState(texture2, textureAttributes, null);
            textureUnitStateArray[1].setCapability(1);
            bl3 = true;
            bl2 = true;
        } else if (stringArray[0] == null && stringArray[1] != null) {
            bl2 = false;
            bl3 = true;
        } else {
            bl2 = true;
            bl3 = false;
        }
        Element element = this.style.getElement();
        Java3dElement java3dElement = (Java3dElement)element.getImplementingObject();
        if (!java3dElement.isPrimitive()) {
            if (texture != null) {
                texture.setMinFilter(5);
            }
            if (texture2 != null) {
                texture2.setMinFilter(5);
            }
            int n = 0;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            if (element instanceof ElementSphere || element instanceof ElementEllipsoid || element instanceof ElementObject) {
                fArray[0] = 1.0f;
                fArray2[2] = 1.0f;
            }
            if (element instanceof ElementCylinder) {
                fArray[0] = 1.0f;
                fArray2[2] = 1.0f;
            }
            if (element instanceof ElementCone) {
                fArray[0] = 1.0f;
                fArray2[1] = 1.0f;
            }
            TexCoordGeneration texCoordGeneration = new TexCoordGeneration(n, 1, new Vector4f(fArray), new Vector4f(fArray2), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            texCoordGeneration.setCapability(1);
            texCoordGeneration.setEnable(true);
            this.appearance.setTexCoordGeneration(texCoordGeneration);
        } else {
            this.appearance.setTexCoordGeneration(null);
        }
        if (bl2 && !bl3 && java3dElement.isPrimitive()) {
            this.appearance.setTextureUnitState(null);
            this.appearance.setTexture(texture);
        } else if (bl2 && !bl3 && !java3dElement.isPrimitive()) {
            this.appearance.setTexture(texture);
        } else if (!bl2 && bl3 && java3dElement.isPrimitive()) {
            this.appearance.setTextureUnitState(null);
            this.appearance.setTexture(texture2);
        } else if (!bl2 && bl3 && !java3dElement.isPrimitive()) {
            this.appearance.setTexture(texture2);
        } else {
            this.appearance.setTextureUnitState(textureUnitStateArray);
        }
        this.appearance.setTransparencyAttributes(transparencyAttributes);
        element.addChange(128);
    }

    private void turnFillOn() {
        Paint paint = this.style.getFillColor();
        this.appearance.getPolygonAttributes().setPolygonMode(2);
        this.appearance.getPolygonAttributes().setCullFace(1);
        if (paint instanceof Color) {
            this.appearance.getMaterial().setDiffuseColor(new Color3f((Color)paint));
        }
        this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
    }

    private void turnLinesOn() {
        this.appearance.getPolygonAttributes().setPolygonMode(1);
        this.appearance.getPolygonAttributes().setCullFace(0);
        this.appearance.getMaterial().setDiffuseColor(new Color3f(this.style.getLineColor()));
        this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
    }
}

