/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Style;

public class Java3dElementText
extends Java3dElement {
    private static final int FORCE_UPDATE = 136;
    private OrientedShape3D textOS = new OrientedShape3D();
    private TransformGroup textTG = null;
    private BranchGroup localbg = null;
    private Shape3D shape = null;
    private double scale;
    private static final double nearDistance = 3.0;
    private static final double factorDistance = 4.0;
    private static final int preferredFrameSize = 300;
    private static GeneralPath gp = new GeneralPath();

    static {
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(1.0f, 1.0f);
    }

    public Java3dElementText(ElementText elementText) {
        super(elementText);
        this.textOS.setCapability(27);
        this.textOS.setCapability(13);
        this.textOS.setCapability(19);
        this.textOS.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.textOS.setAlignmentMode(1);
        this.textOS.setConstantScaleEnable(true);
        this.textTG = new TransformGroup();
        this.textTG.setCapability(12);
        this.textTG.setCapability(13);
        this.textTG.setCapability(17);
        this.textTG.setCapability(18);
        this.textTG.setCapability(14);
        if (((ElementText)this.element).getText() != null) {
            this.element.addChange(8);
        }
        this.addNode((Node)this.textTG);
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 4) != 0) {
            this.setOSScale();
        }
        if ((n & 0x88) != 0) {
            this.recreateNode();
        }
    }

    public boolean isPrimitive() {
        return false;
    }

    private void setOSScale() {
        if (!((ElementText)this.element).isTrueSize()) {
            return;
        }
        Vector3d vector3d = this.getSizeVector();
        vector3d.x = 0.4;
        vector3d.y = 0.4;
        vector3d.z = 0.4;
        double d = Math.max(vector3d.x, Math.max(vector3d.y, vector3d.z));
        this.textOS.setScale(d * 20.0);
    }

    private void recreateNode() {
        Font3D font3D;
        Text2D text2D = null;
        Text3D text3D = null;
        ElementText elementText = (ElementText)this.element;
        Style style = this.element.getStyle();
        if (style.getLineColor() == null) {
            return;
        }
        String string = elementText.getText();
        Font font = elementText.getFont();
        if (font == null || string == null) {
            return;
        }
        if (this.textTG != null) {
            this.textTG.removeAllChildren();
        }
        if (((ElementText)this.element).isTrueSize()) {
            text2D = new Text2D(string, new Color3f(style.getLineColor()), font.getName(), font.getSize() * 2, font.getStyle());
            this.getAppearance().setTexture(text2D.getAppearance().getTexture());
            this.getAppearance().getTransparencyAttributes().setTransparencyMode(1);
            if (this.textOS.getGeometry() != null) {
                this.textOS.removeAllGeometries();
            }
            this.textOS = new OrientedShape3D();
            this.textOS.setCapability(27);
            this.textOS.setCapability(13);
            this.textOS.setCapability(19);
            this.textOS.setRotationPoint(0.0f, 0.0f, 0.0f);
            this.textOS.setAlignmentMode(1);
            this.textOS.setConstantScaleEnable(true);
            this.textOS.setGeometry(text2D.getGeometry());
            this.textOS.setAppearance(this.getAppearance());
            this.setOSScale();
        } else {
            font3D = new Font3D(font, new FontExtrusion((Shape)gp));
            text3D = new Text3D(font3D, elementText.getText(), new Point3f(0.0f, 0.0f, 0.0f));
            text3D.setAlignment(elementText.getStyle().getRelativePosition());
            this.shape = new Shape3D();
            this.shape.setGeometry((Geometry)text3D);
            this.shape.setAppearance(this.getAppearance());
        }
        if (this.localbg != null) {
            this.localbg.removeChild(0);
        }
        this.localbg = new BranchGroup();
        this.localbg.setCapability(17);
        if (((ElementText)this.element).isTrueSize()) {
            this.localbg.addChild((Node)this.textOS);
        } else {
            this.localbg.addChild((Node)this.shape);
            font3D = new Transform3D();
            Transform3D transform3D = new Transform3D();
            font3D.rotX(1.5707963267948966);
            transform3D.rotY(1.5707963267948966);
            font3D.mul(transform3D);
            font3D.setScale(0.05);
            this.textTG.setTransform((Transform3D)font3D);
        }
        this.textTG.addChild((Node)this.localbg);
    }

    protected void updateText(double d) {
        double d2 = d;
        this.scale = d2 < 3.0 ? (double)((float)(4.0 * d2 * 300.0 / (double)this.element.getPanel().getComponent().getWidth())) : (double)((float)(4.0 * d2 * 300.0 / (double)this.element.getPanel().getComponent().getWidth()));
        double d3 = Math.max(this.element.getSizeX(), Math.max(this.element.getSizeY(), this.element.getSizeZ()));
        if (this.textOS != null) {
            this.textOS.setScale(this.scale * d3);
        }
    }
}

