/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import org.opensourcephysics.drawing3d.ElementCone;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementCone
extends Java3dElement {
    private Cone cone;
    private TransformGroup tg;
    private BranchGroup bg;
    double[][][] standardCone;
    private int nr;
    private int nu;
    private int nv;

    public Java3dElementCone(ElementCone elementCone) {
        super(elementCone);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(transform3D);
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 0x10) != 0) {
            int n3;
            int n4;
            if (this.element.getStyle().getResolution() == null) {
                return;
            }
            if (this.element.getStyle().getResolution().getType() == 0) {
                n4 = Math.max(this.element.getStyle().getResolution().getN2(), 1);
                n3 = Math.max(this.element.getStyle().getResolution().getN1(), 1);
            } else {
                double d = Math.abs(this.element.getSizeX()) / 2.0;
                double d2 = Math.abs(this.element.getSizeY()) / 2.0;
                n3 = Math.max((int)Math.round(0.49 + Math.max(d, d2) / this.element.getStyle().getResolution().getMaxLength()), 1);
                n4 = Math.max((int)Math.round(0.49 + Math.PI * 2 * (d + d2) / this.element.getStyle().getResolution().getMaxLength()), 3);
            }
            this.nr = this.nv = n3;
            this.nu = n4;
            if (((ElementCone)this.element).checkStandarCone()) {
                this.primitive = true;
                this.createPrimitiveCone();
            } else {
                this.primitive = false;
                this.createTileCone();
            }
            this.styleChanged(10);
        }
        if ((n & 8) != 0) {
            if (((ElementCone)this.element).checkStandarCone()) {
                if (this.primitive) {
                    return;
                }
                this.primitive = true;
                this.createPrimitiveCone();
            } else {
                this.primitive = false;
                this.createTileCone();
            }
            this.styleChanged(10);
        }
    }

    private void createPrimitiveCone() {
        if (this.cone != null || this.standardCone != null) {
            this.tg.removeChild((Node)this.bg);
        }
        this.cone = new Cone(0.5f, 1.0f, 3, this.nu, this.nr, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.cone);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    private void createTileCone() {
        double d = ((ElementCone)this.element).getTruncationHeight() / this.element.getSizeZ();
        if (!Double.isNaN(d)) {
            d = Math.min(d, 1.0);
        }
        this.standardCone = ElementCone.createStandardCone(this.nr, this.nu, this.nv, ((ElementCone)this.element).getMinimumAngle(), ((ElementCone)this.element).getMaximumAngle(), ((ElementCone)this.element).isClosedTop(), ((ElementCone)this.element).isClosedBottom(), ((ElementCone)this.element).isClosedLeft(), ((ElementCone)this.element).isClosedRight(), d);
        int n = this.standardCone.length;
        int n2 = this.standardCone[0].length;
        Point3d[] point3dArray = new Point3d[n * n2 * 2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                point3dArray[n3 * n2 + n4 + n * n2] = new Point3d(this.standardCone[n3][n4][0], this.standardCone[n3][n4][1], this.standardCone[n3][n4][2]);
                if (n4 == 0) {
                    point3dArray[n3 * n2 + n4 + 3] = new Point3d(this.standardCone[n3][n4][0], this.standardCone[n3][n4][1], this.standardCone[n3][n4][2]);
                } else if (n4 == 1) {
                    point3dArray[n3 * n2 + n4 + 1] = new Point3d(this.standardCone[n3][n4][0], this.standardCone[n3][n4][1], this.standardCone[n3][n4][2]);
                } else if (n4 == 2) {
                    point3dArray[n3 * n2 + n4 - 1] = new Point3d(this.standardCone[n3][n4][0], this.standardCone[n3][n4][1], this.standardCone[n3][n4][2]);
                } else {
                    point3dArray[n3 * n2 + n4 - 3] = new Point3d(this.standardCone[n3][n4][0], this.standardCone[n3][n4][1], this.standardCone[n3][n4][2]);
                }
                ++n4;
            }
            ++n3;
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3dArray);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.setCreaseAngle((double)((float)Math.toRadians(40.0)));
        normalGenerator.generateNormals(geometryInfo);
        GeometryArray geometryArray = geometryInfo.getGeometryArray();
        Shape3D shape3D = new Shape3D((Geometry)geometryArray, this.getAppearance());
        this.addNode((Node)shape3D);
    }

    public boolean isPrimitive() {
        return this.primitive;
    }
}

