/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.Set;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.interaction.InteractionSource;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Style;
import org.opensourcephysics.numerics.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
implements InteractionSource {
    public static final double[] STD_ORIGIN = new double[]{0.0, 0.0, 0.0};
    public static final double[] STD_END = new double[]{1.0, 1.0, 1.0};
    public static final double[] STD_CENTERED_ORIGIN = new double[]{-0.5, -0.5, -0.5};
    public static final double[] STD_CENTERED_END = new double[]{0.5, 0.5, 0.5};
    public static final double TO_RADIANS = Math.PI / 180;
    public static final double[] X_UNIT_VECTOR = new double[]{1.0, 0.0, 0.0};
    public static final double[] Y_UNIT_VECTOR = new double[]{0.0, 1.0, 0.0};
    public static final double[] Z_UNIT_VECTOR = new double[]{0.0, 0.0, 1.0};
    public static final int TARGET_POSITION = 0;
    public static final int TARGET_SIZE = 1;
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_VISIBILITY = 1;
    public static final int CHANGE_POSITION = 2;
    public static final int CHANGE_SIZE = 4;
    public static final int CHANGE_SHAPE = 8;
    public static final int CHANGE_RESOLUTION = 16;
    public static final int CHANGE_GROUP = 32;
    public static final int CHANGE_PROJECTION = 64;
    public static final int CHANGE_COLOR = 128;
    public static final int CHANGE_TRANSFORMATION = 256;
    public static final int CHANGE_POSITION_AND_SIZE = 38;
    public static final int CHANGE_INTERACTION_POINTS = 102;
    private String name = "unnamed";
    private boolean visible = true;
    private boolean canBeMeasured = true;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private double sizeZ = 1.0;
    private Transformation transformation = null;
    private Style style = new Style(this);
    private Group group = null;
    private Object dataObject = null;
    protected int changeType = 0;
    private int implementation = -1;
    private DrawingPanel3D panel;
    private ImplementingObject implementingObject;
    private ImplementingObject previousImplementingObject;
    protected double[] center = new double[3];
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);
    private ArrayList<InteractionListener> listeners = new ArrayList();
    private ArrayList<Transformation> additionalTransformations = new ArrayList();

    protected abstract ImplementingObject createImplementingObject(int var1);

    public final ImplementingObject getImplementingObject() {
        return this.implementingObject;
    }

    public final ImplementingObject getPreviousImplementingObject() {
        return this.previousImplementingObject;
    }

    protected void setImplementation(int n) {
        if (n == this.implementation && this.implementingObject != null) {
            return;
        }
        this.implementation = n;
        this.previousImplementingObject = this.implementingObject;
        this.implementingObject = this.createImplementingObject(this.implementation);
    }

    protected final int getImplementation() {
        return this.implementation;
    }

    public void setPanel(DrawingPanel3D drawingPanel3D) {
        if (this.implementingObject != null) {
            this.implementingObject.removeFromScene();
        }
        this.panel = drawingPanel3D;
        this.setImplementation(this.panel.getImplementation());
        this.implementingObject.addToScene();
    }

    public void removePanel() {
        if (this.implementingObject != null) {
            this.implementingObject.removeFromScene();
            this.panel = null;
            this.implementingObject = null;
        }
    }

    public final DrawingPanel3D getPanel() {
        Element element = this;
        while (element.group != null) {
            element = element.group;
        }
        return element.panel;
    }

    void setGroup(Group group) {
        if (this.implementingObject != null) {
            this.implementingObject.removeFromScene();
        }
        this.group = group;
        if (this.group != null) {
            this.panel = group.getPanel();
            if (this instanceof Set || this instanceof Group) {
                for (Element element : ((Group)this).elementList) {
                    element.panel = group.getPanel();
                }
            }
            this.setImplementation(group.getImplementation());
            if (this.implementingObject != null) {
                this.implementingObject.addToScene();
            }
        }
        this.changeType |= 0x20;
    }

    public final Group getGroup() {
        return this.group;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.changeType |= 1;
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setX(double d) {
        this.x = d;
        this.changeType |= 2;
    }

    public final double getX() {
        return this.x;
    }

    public void setY(double d) {
        this.y = d;
        this.changeType |= 2;
    }

    public final double getY() {
        return this.y;
    }

    public void setZ(double d) {
        this.z = d;
        this.changeType |= 2;
    }

    public final double getZ() {
        return this.z;
    }

    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.changeType |= 2;
    }

    public void setPosition(double[] dArray) {
        this.setXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public final double[] getPosition() {
        return new double[]{this.x, this.y, this.z};
    }

    public final double[] getScaledPosition() {
        return this.panel.scalePosition(this.getPosition());
    }

    public void setSizeX(double d) {
        this.sizeX = d;
        this.changeType |= 4;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double d) {
        this.sizeY = d;
        this.changeType |= 4;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeZ(double d) {
        this.sizeZ = d;
        this.changeType |= 4;
    }

    public final double getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        this.sizeX = d;
        this.sizeY = d2;
        this.sizeZ = d3;
        this.changeType |= 4;
    }

    public void setSize(double[] dArray) {
        this.setSizeXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public final double[] getSize() {
        return new double[]{this.sizeX, this.sizeY, this.sizeZ};
    }

    public final double[] getScaledSize() {
        return this.panel.scaleSize(this.getSize());
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation == null ? null : (Transformation)transformation.clone();
        this.changeType |= 0x100;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return null;
        }
        return (Transformation)this.transformation.clone();
    }

    public void addSecondaryTransformation(Transformation transformation) {
        this.addSecondaryTransformation(transformation, -1);
    }

    public void addSecondaryTransformation(Transformation transformation, int n) {
        if (n < 0 || n > this.additionalTransformations.size()) {
            this.additionalTransformations.add(transformation);
        } else {
            this.additionalTransformations.add(n, transformation);
        }
        this.changeType |= 0x100;
    }

    public void addSecondaryTransformations(List<Transformation> list) {
        if (this.additionalTransformations.addAll(list)) {
            this.changeType |= 0x100;
        }
    }

    public List<Transformation> getSecondaryTransformations() {
        ArrayList<Transformation> arrayList = new ArrayList<Transformation>();
        for (Transformation transformation : this.additionalTransformations) {
            arrayList.add((Transformation)transformation.clone());
        }
        return arrayList;
    }

    public void removeSecondaryTransformation(Transformation transformation) {
        if (this.additionalTransformations.remove(transformation)) {
            this.changeType |= 0x100;
        }
    }

    public void removeAllSecondaryTransformations() {
        if (!this.additionalTransformations.isEmpty()) {
            this.additionalTransformations.clear();
            this.changeType |= 0x100;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double[] toSpaceFrame(double[] dArray) {
        void var2_7;
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        for (Transformation transformation : this.additionalTransformations) {
            transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        dArray[2] = dArray[2] + this.z;
        Group group = this.group;
        while (var2_7 != null) {
            dArray[0] = dArray[0] * var2_7.sizeX;
            dArray[1] = dArray[1] * var2_7.sizeY;
            dArray[2] = dArray[2] * var2_7.sizeZ;
            if (var2_7.transformation != null) {
                var2_7.transformation.direct(dArray);
            }
            for (Transformation transformation : var2_7.additionalTransformations) {
                transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + var2_7.x;
            dArray[1] = dArray[1] + var2_7.y;
            dArray[2] = dArray[2] + var2_7.z;
            Group group2 = var2_7.group;
        }
        return dArray;
    }

    public double[] toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            dArray[2] = dArray[2] - element.z;
            int n2 = element.additionalTransformations.size() - 1;
            while (n2 >= 0) {
                element.additionalTransformations.get(n2).inverse(dArray);
                --n2;
            }
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element != this) {
                if (element.sizeX != 0.0) {
                    dArray[0] = dArray[0] / element.sizeX;
                }
                if (element.sizeY != 0.0) {
                    dArray[1] = dArray[1] / element.sizeY;
                }
                if (element.sizeZ != 0.0) {
                    dArray[2] = dArray[2] / element.sizeZ;
                }
            }
            --n;
        }
        return dArray;
    }

    public final double[] sizeAndToSpaceFrame(double[] dArray) {
        dArray[0] = dArray[0] * this.sizeX;
        dArray[1] = dArray[1] * this.sizeY;
        dArray[2] = dArray[2] * this.sizeZ;
        return this.toSpaceFrame(dArray);
    }

    public Style getStyle() {
        return this.style;
    }

    public void styleChanged(int n) {
        if (this.implementingObject != null) {
            this.implementingObject.styleChanged(n);
        }
    }

    public void setCanBeMeasured(boolean bl) {
        this.canBeMeasured = bl;
    }

    public boolean getCanBeMeasured() {
        return this.canBeMeasured;
    }

    public double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY + this.sizeZ * this.sizeZ);
    }

    protected void getExtrema(double[] dArray, double[] dArray2) {
        switch (this.getStyle().getRelativePosition()) {
            case 5: {
                System.arraycopy(STD_ORIGIN, 0, dArray, 0, 3);
                System.arraycopy(STD_END, 0, dArray2, 0, 3);
                break;
            }
            default: {
                System.arraycopy(STD_CENTERED_ORIGIN, 0, dArray, 0, 3);
                System.arraycopy(STD_CENTERED_END, 0, dArray2, 0, 3);
                break;
            }
            case 8: {
                System.arraycopy(STD_END, 0, dArray, 0, 3);
                System.arraycopy(STD_ORIGIN, 0, dArray2, 0, 3);
            }
        }
        this.sizeAndToSpaceFrame(dArray);
        this.sizeAndToSpaceFrame(dArray2);
    }

    public final void setDataObject(Object object) {
        this.dataObject = object;
    }

    public final Object getDataObject() {
        return this.dataObject;
    }

    public void setEnabled(boolean bl) {
        this.targetPosition.setEnabled(bl);
        this.targetSize.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.targetPosition.isEnabled() || this.targetSize.isEnabled();
    }

    @Override
    public InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    @Override
    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    @Override
    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    final void invokeActions(InteractionEvent interactionEvent) {
        for (InteractionListener interactionListener : this.listeners) {
            interactionListener.interactionPerformed(interactionEvent);
        }
    }

    public final void addChange(int n) {
        this.changeType |= n;
    }

    public boolean hasChanged() {
        return this.changeType != 0;
    }

    protected int getChange() {
        return this.changeType;
    }

    public void processChanges(int n) {
        this.implementingObject.processChanges(this.changeType, n |= this.changeType);
        if ((n & 0x66) != 0) {
            this.projectInteractionPoints();
        }
        this.changeType = 0;
    }

    protected void projectInteractionPoints() {
        System.arraycopy(STD_ORIGIN, 0, this.center, 0, 3);
        this.sizeAndToSpaceFrame(this.center);
        this.getPanel().projectPosition(this.center);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        int n3 = this.getStyle().getSensitivity();
        if (Math.abs(this.center[0] - (double)n) < (double)n3 && Math.abs(this.center[1] - (double)n2) < (double)n3) {
            return this.targetPosition;
        }
        return null;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        switch (this.getStyle().getRelativePosition()) {
            default: {
                if (interactionTarget == this.targetPosition) {
                    return new double[]{0.0, 0.0, 0.0};
                }
                if (interactionTarget != this.targetSize) break;
                return new double[]{this.getSizeX() != 0.0 ? 1 : 0, this.getSizeY() != 0.0 ? 1 : 0, this.getSizeZ() != 0.0 ? 1 : 0};
            }
            case 0: {
                if (interactionTarget == this.targetPosition) {
                    return new double[]{0.0, 0.0, 0.0};
                }
                if (interactionTarget != this.targetSize) break;
                return new double[]{this.getSizeX() == 0.0 ? 0.0 : 0.5, this.getSizeY() == 0.0 ? 0.0 : 0.5, this.getSizeZ() == 0.0 ? 0.0 : 0.5};
            }
        }
        return null;
    }

    public final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.sizeAndToSpaceFrame(dArray);
        }
        return dArray;
    }

    final void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.group;
        block2 : switch (interactionTarget.getType()) {
            case 0: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    switch (interactionTarget.getEnabled()) {
                        case 2: {
                            group.setX(group.x + dArray[0] - dArray2[0]);
                            break block2;
                        }
                        case 3: {
                            group.setY(group.y + dArray[1] - dArray2[1]);
                            break block2;
                        }
                        case 4: {
                            group.setZ(group.z + dArray[2] - dArray2[2]);
                            break block2;
                        }
                        case 5: {
                            group.setX(group.x + dArray[0] - dArray2[0]);
                            group.setY(group.y + dArray[1] - dArray2[1]);
                            break block2;
                        }
                        case 6: {
                            group.setX(group.x + dArray[0] - dArray2[0]);
                            group.setZ(group.z + dArray[2] - dArray2[2]);
                            break block2;
                        }
                        case 7: {
                            group.setY(group.y + dArray[1] - dArray2[1]);
                            group.setZ(group.z + dArray[2] - dArray2[2]);
                            break block2;
                        }
                    }
                    group.setXYZ(group.x + dArray[0] - dArray2[0], group.y + dArray[1] - dArray2[1], group.z + dArray[2] - dArray2[2]);
                    break;
                }
                double[] dArray3 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.sizeX;
                dArray4[1] = dArray4[1] * this.sizeY;
                dArray4[2] = dArray4[2] * this.sizeZ;
                if (this.transformation != null) {
                    this.transformation.direct(dArray4);
                }
                for (Transformation transformation : this.additionalTransformations) {
                    transformation.direct(dArray4);
                }
                switch (interactionTarget.getEnabled()) {
                    case 2: {
                        this.setX(dArray3[0] - dArray4[0]);
                        break block2;
                    }
                    case 3: {
                        this.setY(dArray3[1] - dArray4[1]);
                        break block2;
                    }
                    case 4: {
                        this.setZ(dArray3[2] - dArray4[2]);
                        break block2;
                    }
                    case 5: {
                        this.setX(dArray3[0] - dArray4[0]);
                        this.setY(dArray3[1] - dArray4[1]);
                        break block2;
                    }
                    case 6: {
                        this.setX(dArray3[0] - dArray4[0]);
                        this.setZ(dArray3[2] - dArray4[2]);
                        break block2;
                    }
                    case 7: {
                        this.setY(dArray3[1] - dArray4[1]);
                        this.setZ(dArray3[2] - dArray4[2]);
                        break block2;
                    }
                }
                this.setXYZ(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1], dArray3[2] - dArray4[2]);
                break;
            }
            case 1: {
                double[] dArray5;
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray6 = (double[])dArray.clone();
                    dArray6[0] = dArray6[0] - group.x;
                    dArray6[1] = dArray6[1] - group.y;
                    dArray6[2] = dArray6[2] - group.z;
                    try {
                        int n = group.additionalTransformations.size() - 1;
                        while (n >= 0) {
                            group.additionalTransformations.get(n).inverse(dArray6);
                            --n;
                        }
                        if (group.transformation != null) {
                            group.transformation.inverse(dArray6);
                        }
                    }
                    catch (Exception exception) {}
                    double[] dArray7 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray7);
                    dArray6[0] = dArray7[0] != 0.0 ? dArray6[0] / dArray7[0] : group.sizeX;
                    dArray6[1] = dArray7[1] != 0.0 ? dArray6[1] / dArray7[1] : group.sizeY;
                    dArray6[2] = dArray7[2] != 0.0 ? dArray6[2] / dArray7[2] : group.sizeZ;
                    switch (interactionTarget.getEnabled()) {
                        case 2: {
                            group.setSizeX(dArray6[0]);
                            break block2;
                        }
                        case 3: {
                            group.setSizeY(dArray6[1]);
                            break block2;
                        }
                        case 4: {
                            group.setSizeZ(dArray6[2]);
                            break block2;
                        }
                        case 5: {
                            group.setSizeX(dArray6[0]);
                            group.setSizeY(dArray6[1]);
                            break block2;
                        }
                        case 6: {
                            group.setSizeX(dArray6[0]);
                            group.setSizeZ(dArray6[2]);
                            break block2;
                        }
                        case 7: {
                            group.setSizeY(dArray6[1]);
                            group.setSizeZ(dArray6[2]);
                            break block2;
                        }
                    }
                    group.setSize(dArray6);
                    break;
                }
                double[] dArray8 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray8);
                dArray8[0] = dArray8[0] - this.x;
                dArray8[1] = dArray8[1] - this.y;
                dArray8[2] = dArray8[2] - this.z;
                try {
                    int n = this.additionalTransformations.size() - 1;
                    while (n >= 0) {
                        this.additionalTransformations.get(n).inverse(dArray8);
                        --n;
                    }
                    if (this.transformation != null) {
                        this.transformation.inverse(dArray8);
                    }
                }
                catch (Exception exception) {}
                if ((dArray5 = this.getHotSpotBodyCoordinates(interactionTarget))[0] != 0.0) {
                    dArray8[0] = dArray8[0] / dArray5[0];
                }
                if (dArray5[1] != 0.0) {
                    dArray8[1] = dArray8[1] / dArray5[1];
                }
                if (dArray5[2] != 0.0) {
                    dArray8[2] = dArray8[2] / dArray5[2];
                }
                switch (interactionTarget.getEnabled()) {
                    case 2: {
                        this.setSizeX(dArray8[0]);
                        break block2;
                    }
                    case 3: {
                        this.setSizeY(dArray8[1]);
                        break block2;
                    }
                    case 4: {
                        this.setSizeZ(dArray8[2]);
                        break block2;
                    }
                    case 5: {
                        this.setSizeX(dArray8[0]);
                        this.setSizeY(dArray8[1]);
                        break block2;
                    }
                    case 6: {
                        this.setSizeX(dArray8[0]);
                        this.setSizeZ(dArray8[2]);
                        break block2;
                    }
                    case 7: {
                        this.setSizeY(dArray8[1]);
                        this.setSizeZ(dArray8[2]);
                        break block2;
                    }
                }
                this.setSize(dArray8);
            }
        }
    }

    private final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            dArray[2] = dArray[2] - element.z;
            try {
                int n2 = element.additionalTransformations.size() - 1;
                while (n2 >= 0) {
                    element.additionalTransformations.get(n2).inverse(dArray);
                    --n2;
                }
                if (element.transformation != null) {
                    element.transformation.inverse(dArray);
                }
            }
            catch (Exception exception) {}
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] / element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] / element.sizeY;
            }
            if (element.sizeZ != 0.0) {
                dArray[2] = dArray[2] / element.sizeZ;
            }
            --n;
        }
    }

    private final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] * element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] * element.sizeY;
            }
            if (element.sizeZ != 0.0) {
                dArray[2] = dArray[2] * element.sizeZ;
            }
            if (element.transformation != null) {
                element.transformation.direct(dArray);
            }
            for (Transformation transformation : element.additionalTransformations) {
                transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + element.x;
            dArray[1] = dArray[1] + element.y;
            dArray[2] = dArray[2] + element.z;
        } while ((element = element.group) != null && element.group != null);
    }
}

