/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.MyCoordinateStringBuilder;
import org.colos.ejs.library.control.swing.UpdateHotSpot2DDelayedAction;
import org.colos.ejs.library.control.swing.UpdateHotSpotDelayedAction;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.AxisFactory;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.axes.CartesianType2;
import org.opensourcephysics.display.axes.CartesianType3;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.display.axes.PolarAxes;
import org.opensourcephysics.display.axes.PolarType1;
import org.opensourcephysics.display.axes.PolarType2;
import org.opensourcephysics.displayejs.HasDataObjectInterface;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.PlottingPanel2D;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPlottingPanel
extends ControlDrawablesParent
implements InteractiveMouseHandler {
    protected static final int ADDEDBYPLOTTINGPANEL = 46;
    static final int PANEL_FONT = 54;
    private static final int[] posIndex = new int[]{18, 19};
    private static final int KEY_INDEX = 31;
    private static final int ALIASING = 44;
    private static final int MENU = 45;
    protected PlottingPanel2D plottingPanel;
    private String title;
    private String titleFontname;
    protected boolean reportDrag = false;
    protected boolean reportKey = false;
    private Rectangle myGutters;
    private int[] defaultGutters;
    private DrawableAxes axes;
    private boolean axisGridX;
    private boolean axisGridY;
    private boolean xaxisLog;
    private boolean yaxisLog;
    private int axesType;
    private double xaxisPos;
    private double yaxisPos;
    private double deltaR;
    private double deltaTheta;
    private String xLabel;
    private String yLabel;
    private String labelFontname;
    protected MyCoordinateStringBuilder strBuilder;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0)};
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    private static List<String> infoList = null;
    private org.opensourcephysics.displayejs.InteractionTarget targetHit = null;
    private InteractionSource sourceLingered = null;
    private InteractionTarget target2D = null;
    private InteractionTarget target2DEntered = null;

    @Override
    protected Component createVisual() {
        this.plottingPanel = new PlottingPanel2D("", "", "");
        this.plottingPanel.enableInspector(false);
        this.plottingPanel.setSquareAspect(false);
        this.plottingPanel.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0);
        this.plottingPanel.setAutoscaleX(true);
        this.plottingPanel.setAutoscaleY(true);
        this.plottingPanel.setBuffered(true);
        this.plottingPanel.removeOptionController();
        this.axes = this.plottingPanel.getAxes();
        this.axes.setVisible(true);
        this.axisGridX = true;
        this.axes.setShowMajorXGrid(true);
        this.axisGridY = true;
        this.axes.setShowMajorYGrid(true);
        this.yaxisLog = false;
        this.xaxisLog = false;
        this.deltaR = 1.0;
        this.deltaTheta = 0.39269908169872414;
        if (this.axes instanceof CartesianAxes) {
            this.xaxisLog = ((CartesianAxes)this.axes).isXLog();
            this.yaxisLog = ((CartesianAxes)this.axes).isYLog();
            if (this.axes instanceof CartesianType1) {
                this.axesType = 1;
            } else if (this.axes instanceof CartesianType2) {
                this.axesType = 2;
            } else if (this.axes instanceof CartesianType3) {
                this.axesType = 3;
                ((CartesianType3)this.axes).setEnabled(false);
            } else {
                this.axesType = 1;
            }
        } else if (this.axes instanceof PolarAxes) {
            this.deltaR = ((PolarAxes)this.axes).getDeltaR();
            this.deltaTheta = ((PolarAxes)this.axes).getDeltaTheta();
            this.axesType = this.axes instanceof PolarType1 ? 4 : (this.axes instanceof PolarType2 ? 5 : 4);
        } else {
            this.axesType = 0;
        }
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.autoX = this.plottingPanel.isAutoscaleX();
        this.autoY = this.plottingPanel.isAutoscaleY();
        this.plottingPanel.setInteractiveMouseHandler(this);
        this.strBuilder = new MyCoordinateStringBuilder();
        this.plottingPanel.setCoordinateStringBuilder(this.strBuilder);
        this.plottingPanel.setFocusable(true);
        this.defaultGutters = this.plottingPanel.getGutters();
        this.plottingPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ((ControlPlottingPanel)ControlPlottingPanel.this).keyPressedValue.value = keyEvent.getKeyCode();
                if (ControlPlottingPanel.this.reportKey) {
                    ControlPlottingPanel.this.variableChanged(31, ControlPlottingPanel.this.keyPressedValue);
                    ControlPlottingPanel.this.invokeActions(30);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (ControlPlottingPanel.this.reportKey) {
                    ControlPlottingPanel.this.variableChanged(31, ControlPlottingPanel.this.keyPressedValue);
                }
            }
        });
        return this.plottingPanel;
    }

    protected int[] getPosIndex() {
        return posIndex;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("title");
            infoList.add("titleFont");
            infoList.add("axesType");
            infoList.add("titleX");
            infoList.add("titleY");
            infoList.add("xaxisType");
            infoList.add("yaxisType");
            infoList.add("deltaR");
            infoList.add("deltaTheta");
            infoList.add("interiorBackground");
            infoList.add("majorTicksX");
            infoList.add("majorTicksY");
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("square");
            infoList.add("showCoordinates");
            infoList.add("gutters");
            infoList.add("xaxisPos");
            infoList.add("yaxisPos");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("xyExpression");
            infoList.add("xyFormat");
            infoList.add("xMarginPercentage");
            infoList.add("yMarginPercentage");
            infoList.add("TLmessage");
            infoList.add("TRmessage");
            infoList.add("BLmessage");
            infoList.add("BRmessage");
            infoList.add("showAxes");
            infoList.add("fixedGutters");
            infoList.add("aliasing");
            infoList.add("menu");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        if (string.equals("square")) {
            return "squareAspect";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("titleFont")) {
            return "Font|Object";
        }
        if (string.equals("axesType")) {
            return "int|AxesType";
        }
        if (string.equals("titleX")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("titleY")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("xaxisType")) {
            return "int|CartesianAxisType";
        }
        if (string.equals("yaxisType")) {
            return "int|CartesianAxisType";
        }
        if (string.equals("deltaR")) {
            return "int|double";
        }
        if (string.equals("deltaTheta")) {
            return "int|double";
        }
        if (string.equals("interiorBackground")) {
            return "Color|Object";
        }
        if (string.equals("majorTicksX")) {
            return "boolean";
        }
        if (string.equals("majorTicksY")) {
            return "boolean";
        }
        if (string.equals("autoscaleX")) {
            return "boolean";
        }
        if (string.equals("autoscaleY")) {
            return "boolean";
        }
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("square")) {
            return "boolean";
        }
        if (string.equals("showCoordinates")) {
            return "boolean";
        }
        if (string.equals("gutters")) {
            return "Margins|Object";
        }
        if (string.equals("xaxisPos")) {
            return "int|double";
        }
        if (string.equals("yaxisPos")) {
            return "int|double";
        }
        if (string.equals("xFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("yFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("keyPressed")) {
            return "int";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("xyExpression")) {
            return "Object|String";
        }
        if (string.equals("xyFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("xMarginPercentage")) {
            return "int|double";
        }
        if (string.equals("yMarginPercentage")) {
            return "int|double";
        }
        if (string.equals("TLmessage")) {
            return "String";
        }
        if (string.equals("TRmessage")) {
            return "String";
        }
        if (string.equals("BLmessage")) {
            return "String";
        }
        if (string.equals("BRmessage")) {
            return "String";
        }
        if (string.equals("showAxes")) {
            return "boolean";
        }
        if (string.equals("fixedGutters")) {
            return "boolean";
        }
        if (string.equals("aliasing")) {
            return "boolean";
        }
        if (string.equals("menu")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("CartesianAxisType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("linear")) {
                return new IntegerValue(0);
            }
            if (string2.equals("log10")) {
                return new IntegerValue(1);
            }
        }
        if (string.indexOf("AxesType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("null") || string2.equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cartesian1")) {
                return new IntegerValue(1);
            }
            if (string2.equals("cartesian2")) {
                return new IntegerValue(2);
            }
            if (string2.equals("cartesian3")) {
                return new IntegerValue(3);
            }
            if (string2.equals("polar1")) {
                return new IntegerValue(4);
            }
            if (string2.equals("polar2")) {
                return new IntegerValue(5);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("x") || string.equals("y") || string.equals("dragaction")) {
            if (string2 != null) {
                Value value = Value.parseConstant(string2, true);
                this.reportDrag = value == null;
            }
        } else if (string.equals("keyAction") || string.equals("keyPressed")) {
            if (string2 != null) {
                Value value = Value.parseConstant(string2, true);
                if (!this.reportKey) {
                    this.reportKey = value == null;
                }
            }
        } else {
            if (string.equals("xaxis")) {
                return super.setProperty("xaxisPos", string2);
            }
            if (string.equals("yaxis")) {
                return super.setProperty("yaxisPos", string2);
            }
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.title = value.getString();
                this.plottingPanel.setTitle(this.title, this.titleFontname);
                break;
            }
            case 1: {
                if (!(value.getObject() instanceof Font)) break;
                Font font = (Font)value.getObject();
                this.titleFontname = font.getFamily();
                if (font.isPlain()) {
                    this.titleFontname = String.valueOf(this.titleFontname) + "-PLAIN";
                } else if (font.isItalic()) {
                    this.titleFontname = font.isBold() ? String.valueOf(this.titleFontname) + "-BOLDITALIC" : String.valueOf(this.titleFontname) + "-ITALIC";
                } else if (font.isBold()) {
                    this.titleFontname = String.valueOf(this.titleFontname) + "-BOLD";
                }
                this.titleFontname = String.valueOf(this.titleFontname) + "-" + font.getSize();
                if (this.title == null) break;
                this.axes.setTitle(this.title, this.titleFontname);
                break;
            }
            case 2: {
                if (this.axesType == value.getInteger()) break;
                this.axesType = value.getInteger();
                switch (this.axesType) {
                    default: {
                        this.axes = AxisFactory.createAxesType1(this.plottingPanel);
                        ((CartesianType1)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType1)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 2: {
                        this.axes = AxisFactory.createAxesType2(this.plottingPanel);
                        ((CartesianType2)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType2)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 3: {
                        this.axes = AxisFactory.createAxesType3(this.plottingPanel);
                        ((CartesianType3)this.axes).setEnabled(false);
                        ((CartesianType3)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType3)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 4: {
                        this.axes = new PolarType1(this.plottingPanel);
                        ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                        ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                        break;
                    }
                    case 5: {
                        this.axes = new PolarType2(this.plottingPanel);
                        ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                        ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                    }
                }
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                if (this.title != null) {
                    this.axes.setTitle(this.title, this.titleFontname);
                }
                this.axes.setShowMajorXGrid(this.axisGridX);
                this.axes.setShowMajorYGrid(this.axisGridY);
                if (this.axes instanceof CartesianAxes) {
                    ((CartesianAxes)this.axes).setX(this.xaxisPos);
                    ((CartesianAxes)this.axes).setY(this.yaxisPos);
                }
                if (this.axesType == 0) {
                    this.plottingPanel.setAxes(null);
                } else {
                    this.plottingPanel.setAxes(this.axes);
                }
                this.plottingPanel.setPreferredMinMax(this.minX, this.maxX, this.minY, this.maxY);
                this.plottingPanel.setCoordinateStringBuilder(this.strBuilder);
                break;
            }
            case 3: {
                this.xLabel = value.getString();
                this.plottingPanel.setXLabel(this.xLabel, this.labelFontname);
                break;
            }
            case 4: {
                this.yLabel = value.getString();
                this.plottingPanel.setYLabel(this.yLabel, this.labelFontname);
                break;
            }
            case 5: {
                if (this.xaxisLog && value.getInteger() != 1) {
                    this.xaxisLog = false;
                    this.plottingPanel.setLogScale(false, this.yaxisLog);
                    break;
                }
                if (this.xaxisLog || value.getInteger() != 1) break;
                this.xaxisLog = true;
                this.plottingPanel.setLogScale(true, this.yaxisLog);
                break;
            }
            case 6: {
                if (this.yaxisLog && value.getInteger() != 1) {
                    this.yaxisLog = false;
                    this.plottingPanel.setLogScale(this.xaxisLog, false);
                    break;
                }
                if (this.yaxisLog || value.getInteger() != 1) break;
                this.yaxisLog = true;
                this.plottingPanel.setLogScale(this.xaxisLog, true);
                break;
            }
            case 7: {
                if (value.getDouble() == this.deltaR) break;
                this.deltaR = value.getDouble();
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                break;
            }
            case 8: {
                if (value.getDouble() == this.deltaTheta) break;
                this.deltaTheta = value.getDouble();
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                break;
            }
            case 9: {
                if (!(value.getObject() instanceof Color)) break;
                this.axes.setInteriorBackground((Color)value.getObject());
                break;
            }
            case 10: {
                this.axes.setShowMajorXGrid(value.getBoolean());
                break;
            }
            case 11: {
                this.axes.setShowMajorYGrid(value.getBoolean());
                break;
            }
            case 12: {
                this.autoX = value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 13: {
                this.autoY = value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 14: {
                if (value.getDouble() == this.minX && this.xminSet) break;
                this.minX = value.getDouble();
                this.xminSet = true;
                this.updateExtrema();
                break;
            }
            case 15: {
                if (value.getDouble() == this.maxX && this.xmaxSet) break;
                this.maxX = value.getDouble();
                this.xmaxSet = true;
                this.updateExtrema();
                break;
            }
            case 16: {
                if (value.getDouble() == this.minY && this.yminSet) break;
                this.minY = value.getDouble();
                this.yminSet = true;
                this.updateExtrema();
                break;
            }
            case 17: {
                if (value.getDouble() == this.maxY && this.ymaxSet) break;
                this.maxY = value.getDouble();
                this.ymaxSet = true;
                this.updateExtrema();
                break;
            }
            case 18: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 19: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 23: {
                this.plottingPanel.setSquareAspect(value.getBoolean());
                break;
            }
            case 24: {
                this.plottingPanel.setShowCoordinates(value.getBoolean());
                break;
            }
            case 25: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myGutters) break;
                this.plottingPanel.setPreferredGutters(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.myGutters = rectangle;
                break;
            }
            case 26: {
                if (this.xaxisPos == value.getDouble() || !(this.axes instanceof CartesianAxes)) break;
                this.xaxisPos = value.getDouble();
                ((CartesianAxes)this.axes).setX(this.xaxisPos);
                break;
            }
            case 27: {
                if (this.yaxisPos == value.getDouble() || !(this.axes instanceof CartesianAxes)) break;
                this.yaxisPos = value.getDouble();
                ((CartesianAxes)this.axes).setY(this.yaxisPos);
                break;
            }
            case 28: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setXFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.strBuilder.setXFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 29: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setYFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.strBuilder.setYFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, value.getString());
                break;
            }
            case 31: {
                this.keyPressedValue.value = value.getInteger();
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 34: {
                this.strBuilder.setExpression(value.getString());
                break;
            }
            case 35: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setExpressionFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.strBuilder.setExpressionFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 36: {
                this.plottingPanel.setXMarginPercentage(value.getDouble());
                break;
            }
            case 37: {
                this.plottingPanel.setYMarginPercentage(value.getDouble());
                break;
            }
            case 38: {
                this.plottingPanel.setMessage(value.getString(), 3);
                break;
            }
            case 39: {
                this.plottingPanel.setMessage(value.getString(), 2);
                break;
            }
            case 40: {
                this.plottingPanel.setMessage(value.getString(), 0);
                break;
            }
            case 41: {
                this.plottingPanel.setMessage(value.getString(), 1);
                break;
            }
            case 42: {
                boolean bl = value.getBoolean();
                this.plottingPanel.setClipAtGutter(bl);
                this.plottingPanel.setAxesVisible(bl);
                break;
            }
            case 43: {
                this.plottingPanel.setAdjustableGutter(!value.getBoolean());
                break;
            }
            case 44: {
                boolean bl = value.getBoolean();
                this.plottingPanel.setAntialiasTextOn(bl);
                this.plottingPanel.setAntialiasShapeOn(bl);
                break;
            }
            case 45: {
                this.enableMenu = value.getBoolean();
                break;
            }
            default: {
                super.setValue(n - 46, value);
                break;
            }
            case 54: {
                if (value.getObject() instanceof Font) {
                    Font font = (Font)value.getObject();
                    this.labelFontname = font.getFamily();
                    if (font.isPlain()) {
                        this.labelFontname = String.valueOf(this.labelFontname) + "-PLAIN";
                    } else if (font.isItalic()) {
                        this.labelFontname = font.isBold() ? String.valueOf(this.labelFontname) + "-BOLDITALIC" : String.valueOf(this.labelFontname) + "-ITALIC";
                    } else if (font.isBold()) {
                        this.labelFontname = String.valueOf(this.labelFontname) + "-BOLD";
                    }
                    this.labelFontname = String.valueOf(this.labelFontname) + "-" + font.getSize();
                    if (this.xLabel != null) {
                        this.axes.setXLabel(this.xLabel, this.labelFontname);
                    }
                    if (this.yLabel != null) {
                        this.axes.setYLabel(this.yLabel, this.labelFontname);
                    }
                }
                super.setValue(8, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.title = "";
                this.plottingPanel.setTitle("", this.titleFontname);
                break;
            }
            case 1: {
                this.titleFontname = "Helvetica-BOLD-14";
                if (this.title == null) break;
                this.axes.setTitle(this.title, this.titleFontname);
                break;
            }
            case 2: {
                this.axesType = 1;
                this.axes = AxisFactory.createAxesType1(this.plottingPanel);
                ((CartesianType1)this.axes).setXLog(this.xaxisLog);
                ((CartesianType1)this.axes).setYLog(this.yaxisLog);
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                if (this.title != null) {
                    this.axes.setTitle(this.title, this.titleFontname);
                }
                this.axes.setShowMajorXGrid(this.axisGridX);
                this.axes.setShowMajorYGrid(this.axisGridY);
                break;
            }
            case 3: {
                this.xLabel = "";
                this.plottingPanel.setXLabel("", this.labelFontname);
                break;
            }
            case 4: {
                this.yLabel = "";
                this.plottingPanel.setYLabel("", this.labelFontname);
                break;
            }
            case 5: {
                this.xaxisLog = false;
                this.plottingPanel.setLogScale(false, this.yaxisLog);
                break;
            }
            case 6: {
                this.yaxisLog = false;
                this.plottingPanel.setLogScale(this.xaxisLog, false);
                break;
            }
            case 7: {
                this.deltaR = 1.0;
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                break;
            }
            case 8: {
                this.deltaTheta = 0.39269908169872414;
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                break;
            }
            case 9: {
                this.axes.setInteriorBackground(Color.white);
                break;
            }
            case 10: {
                this.axes.setShowMajorXGrid(true);
                break;
            }
            case 11: {
                this.axes.setShowMajorYGrid(true);
                break;
            }
            case 12: {
                this.autoX = false;
                this.updateAutoscale();
                break;
            }
            case 13: {
                this.autoY = false;
                this.updateAutoscale();
                break;
            }
            case 14: {
                this.minX = Double.NaN;
                break;
            }
            case 15: {
                this.maxX = Double.NaN;
                break;
            }
            case 16: {
                this.minY = Double.NaN;
                break;
            }
            case 17: {
                this.maxY = Double.NaN;
                break;
            }
            case 18: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 19: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 23: {
                this.plottingPanel.setSquareAspect(false);
                break;
            }
            case 24: {
                this.plottingPanel.setShowCoordinates(true);
                break;
            }
            case 25: {
                this.plottingPanel.setPreferredGutters(this.defaultGutters[0], this.defaultGutters[1], this.defaultGutters[2], this.defaultGutters[3]);
                this.myGutters = null;
                break;
            }
            case 26: {
                if (!(this.axes instanceof CartesianAxes)) break;
                this.xaxisPos = Double.NaN;
                ((CartesianAxes)this.axes).setX(Double.NaN);
                break;
            }
            case 27: {
                if (!(this.axes instanceof CartesianAxes)) break;
                this.yaxisPos = Double.NaN;
                ((CartesianAxes)this.axes).setY(Double.NaN);
                break;
            }
            case 28: {
                this.strBuilder.setXFormat(new DecimalFormat("x=0.000;x=-0.000"));
                break;
            }
            case 29: {
                this.strBuilder.setYFormat(new DecimalFormat("y=0.000;y=-0.000"));
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 31: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 34: {
                this.strBuilder.setExpression(null);
                break;
            }
            case 35: {
                this.strBuilder.setXFormat(new DecimalFormat("0.000;-0.000"));
                break;
            }
            case 36: {
                this.plottingPanel.setXMarginPercentage(0.0);
                break;
            }
            case 37: {
                this.plottingPanel.setYMarginPercentage(0.0);
                break;
            }
            case 38: {
                this.plottingPanel.setMessage("", 3);
                break;
            }
            case 39: {
                this.plottingPanel.setMessage("", 2);
                break;
            }
            case 40: {
                this.plottingPanel.setMessage("", 0);
                break;
            }
            case 41: {
                this.plottingPanel.setMessage("", 1);
                break;
            }
            case 42: {
                this.plottingPanel.setClipAtGutter(true);
                this.plottingPanel.setAxesVisible(true);
                break;
            }
            case 43: {
                this.plottingPanel.setAdjustableGutter(false);
                break;
            }
            case 44: {
                this.plottingPanel.setAntialiasTextOn(false);
                this.plottingPanel.setAntialiasShapeOn(false);
                break;
            }
            case 45: {
                this.enableMenu = true;
                break;
            }
            default: {
                super.setDefaultValue(n - 46);
                break;
            }
            case 54: {
                this.labelFontname = "Helvetica-PLAIN-12";
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                super.setDefaultValue(8);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "Helvetica-BOLD-14";
            }
            case 2: {
                return "CARTESIAN1";
            }
            case 3: 
            case 4: {
                return "<none>";
            }
            case 5: 
            case 6: {
                return "LINEAR";
            }
            case 7: {
                return "1";
            }
            case 8: {
                return "PI/8";
            }
            case 9: {
                return "WHITE";
            }
            case 10: 
            case 11: {
                return "true";
            }
            case 12: 
            case 13: {
                return "false";
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return "<none>";
            }
            case 20: 
            case 21: 
            case 22: {
                return "<no_action>";
            }
            case 23: {
                return "false";
            }
            case 24: {
                return "true";
            }
            case 25: {
                return this.defaultGutters[0] + "," + this.defaultGutters[1] + "," + this.defaultGutters[2] + "," + this.defaultGutters[3];
            }
            case 26: 
            case 27: {
                return "<none>";
            }
            case 28: {
                return "x=0.000;x=-0.000";
            }
            case 29: {
                return "y=0.000;y=-0.000";
            }
            case 30: 
            case 32: 
            case 33: {
                return "<no_action>";
            }
            case 31: {
                return "<none>";
            }
            case 34: {
                return "<none>";
            }
            case 35: {
                return "0.000;-0.000";
            }
            case 36: 
            case 37: {
                return "0.0";
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return "<none>";
            }
            case 42: {
                return "true";
            }
            case 43: {
                return "false";
            }
            case 44: {
                return "false";
            }
            case 45: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 46);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return null;
            }
            case 18: {
                return this.posValues[0];
            }
            case 19: {
                return this.posValues[1];
            }
            case 31: {
                return this.keyPressedValue;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return null;
            }
        }
        return super.getValue(n - 46);
    }

    @Override
    public ControlDrawable getSelectedDrawable() {
        Object object;
        if (this.targetHit != null && this.targetHit.getSource() instanceof HasDataObjectInterface) {
            Object object2 = ((HasDataObjectInterface)((Object)this.targetHit.getSource())).getDataObject();
            if (object2 instanceof ControlDrawable) {
                return (ControlDrawable)object2;
            }
        } else if (this.target2D != null && (object = this.target2D.getElement().getDataObject()) instanceof ControlDrawable) {
            return (ControlDrawable)object;
        }
        return null;
    }

    private final void invokeTheAction(InteractionTarget interactionTarget, int n, MouseEvent mouseEvent) {
        Element element = interactionTarget.getElement();
        element.invokeActions(new org.opensourcephysics.drawing2d.interaction.InteractionEvent((Object)element, n, interactionTarget.getActionCommand(), interactionTarget, mouseEvent));
    }

    @Override
    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        switch (interactivePanel.getMouseAction()) {
            case 1: {
                Interactive interactive = interactivePanel.getInteractive();
                if (interactive instanceof org.opensourcephysics.displayejs.InteractionTarget) {
                    this.targetHit = (org.opensourcephysics.displayejs.InteractionTarget)interactive;
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    break;
                }
                if (interactive instanceof InteractionTarget) {
                    this.target2D = (InteractionTarget)interactive;
                    this.invokeTheAction(this.target2D, 2000, mouseEvent);
                    break;
                }
                this.targetHit = null;
                this.target2D = null;
                this.mousePressed(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 3: {
                if (this.targetHit != null) {
                    Point3D point3D = new Point3D(interactivePanel.getMouseX(), interactivePanel.getMouseY(), 0.0);
                    Simulation simulation = this.getSimulation();
                    if (simulation != null) {
                        simulation.invokeMethodWhenIdle(new UpdateHotSpotDelayedAction(this.targetHit, interactivePanel, point3D));
                        if (!simulation.isPaused()) break;
                        interactivePanel.render();
                        break;
                    }
                    this.targetHit.updateHotspot(interactivePanel, point3D);
                    interactivePanel.render();
                    break;
                }
                if (this.target2D != null) {
                    double[] dArray = new double[]{interactivePanel.getMouseX(), interactivePanel.getMouseY(), 0.0};
                    Simulation simulation = this.getSimulation();
                    if (simulation != null) {
                        simulation.invokeMethodWhenIdle(new UpdateHotSpot2DDelayedAction(this.target2D, (double[])dArray.clone(), mouseEvent));
                        if (!simulation.isPaused()) break;
                        interactivePanel.render();
                        break;
                    }
                    this.target2D.getElement().updateHotSpot(this.target2D, dArray);
                    this.invokeTheAction(this.target2D, 2001, mouseEvent);
                    interactivePanel.render();
                    break;
                }
                this.mouseDragged(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 2: {
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                    Simulation simulation = this.getSimulation();
                    if (simulation == null || simulation.isPaused()) {
                        interactivePanel.invalidateImage();
                        interactivePanel.repaint();
                    }
                } else if (this.target2D != null) {
                    this.invokeTheAction(this.target2D, 2002, mouseEvent);
                    Simulation simulation = this.getSimulation();
                    if (simulation == null || simulation.isPaused()) {
                        interactivePanel.invalidateImage();
                        interactivePanel.repaint();
                    }
                } else {
                    this.mouseReleased(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                }
                this.targetHit = null;
                this.target2D = null;
                break;
            }
            case 5: {
                this.invokeActions(31);
                break;
            }
            case 6: {
                this.invokeActions(32);
                this.targetHit = null;
                this.target2D = null;
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                } else if (this.target2DEntered != null) {
                    this.invokeTheAction(this.target2DEntered, 2004, mouseEvent);
                }
                this.sourceLingered = null;
                this.target2DEntered = null;
                break;
            }
            case 7: {
                Interactive interactive = interactivePanel.getInteractive();
                if (interactive != null) {
                    interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    if (interactive instanceof org.opensourcephysics.displayejs.InteractionTarget) {
                        if (this.sourceLingered == ((org.opensourcephysics.displayejs.InteractionTarget)interactive).getSource()) break;
                        if (this.sourceLingered != null) {
                            this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                        }
                        this.sourceLingered = ((org.opensourcephysics.displayejs.InteractionTarget)interactive).getSource();
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2003, null, interactive));
                        break;
                    }
                    if (!(interactive instanceof InteractionTarget) || this.target2DEntered != null && this.target2DEntered == interactive) break;
                    if (this.target2DEntered != null) {
                        this.invokeTheAction(this.target2DEntered, 2004, mouseEvent);
                    }
                    this.target2DEntered = (InteractionTarget)interactive;
                    this.invokeTheAction(this.target2DEntered, 2003, mouseEvent);
                    break;
                }
                interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(1));
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                } else if (this.target2DEntered != null) {
                    this.invokeTheAction(this.target2DEntered, 2004, mouseEvent);
                }
                this.sourceLingered = null;
                this.target2DEntered = null;
            }
        }
    }

    public void mousePressed(double d, double d2) {
        this.plottingPanel.requestFocus();
        this.invokeActions(10);
        this.mouseDragged(d, d2);
    }

    public void mouseDragged(double d, double d2) {
        this.posValues[0].value = d;
        this.posValues[1].value = d2;
        if (this.reportDrag) {
            this.variablesChanged(this.getPosIndex(), this.posValues);
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosIndex(), this.posValues);
            }
        }
    }

    public void mouseReleased(double d, double d2) {
        this.invokeActions(0);
    }
}

