/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.drawing3d.ControlGroup3D;
import org.colos.ejs.library.control.drawing3d.ControlParentOfElement3D;
import org.colos.ejs.library.control.drawing3d.ControlTransformation3D;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.utils.Resolution;
import org.opensourcephysics.drawing3d.utils.Style;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlElement3D
extends ControlElement
implements InteractionListener {
    public static final int EL3D_NAME = 0;
    public static final int PARENT = 1;
    protected static final int POSITION_X = 2;
    protected static final int POSITION_Y = 3;
    protected static final int POSITION_Z = 4;
    protected static final int SIZE_X = 5;
    protected static final int SIZE_Y = 6;
    protected static final int SIZE_Z = 7;
    protected static final int TRANSFORMATION = 8;
    protected static final int VISIBLE = 9;
    protected static final int LINE_COLOR = 10;
    protected static final int LINE_WIDTH = 11;
    protected static final int FILL_COLOR = 12;
    protected static final int RESOLUTION = 13;
    protected static final int DRAWING_FILL = 14;
    protected static final int DRAWING_LINES = 15;
    protected static final int ENABLED_POSITION = 16;
    protected static final int MOVES_GROUP = 17;
    protected static final int ENABLED_SIZE = 18;
    protected static final int RESIZES_GROUP = 19;
    protected static final int SENSITIVITY = 20;
    protected static final int PRESS_ACTION = 21;
    protected static final int DRAG_ACTION = 22;
    protected static final int RELEASE_ACTION = 23;
    protected static final int ENTERED_ACTION = 24;
    protected static final int EXITED_ACTION = 25;
    protected static final int POSITION = 26;
    protected static final int SIZE = 27;
    protected static final int MENU_NAME = 28;
    protected static final int OFFSET = 29;
    protected static final int DEPTH_FACTOR = 30;
    protected static final int MEASURED = 31;
    protected static final int EXTRA_COLOR = 32;
    protected static final int TEXTURE = 33;
    protected static final int SECOND_TEXTURE = 34;
    protected static final int TEXTURE_TRANSPARENCY = 35;
    protected static final int TEXTURE_COMBINE = 36;
    public static final Color NULL_COLOR = ConstantParserUtil.NULL_COLOR;
    public static final double TO_RADIANS = Math.PI / 180;
    protected String menuNameEntry = null;
    protected DoubleValue[] posValues;
    protected DoubleValue[] sizeValues;
    protected double defaultX;
    protected double defaultY;
    protected double defaultZ;
    protected double defaultSizeX;
    protected double defaultSizeY;
    protected double defaultSizeZ;
    protected Color defLines;
    protected Color defExtraColor;
    protected Paint defFill;
    protected Resolution defaultRes;
    protected int defaultOffset;
    protected double[] thePos;
    protected double[] theSize;
    protected ControlParentOfElement3D myParent;
    private Element myElement = this.createElement();
    private int[] posSpot;
    private int[] sizeSpot;
    private int fullPosition;
    private int fullSize;
    private static List<String> infoList = null;

    public ControlElement3D() {
        Style style = this.myElement.getStyle();
        DoubleValue[] doubleValueArray = new DoubleValue[3];
        this.defaultX = this.myElement.getX();
        doubleValueArray[0] = new DoubleValue(this.defaultX);
        this.defaultY = this.myElement.getY();
        doubleValueArray[1] = new DoubleValue(this.defaultY);
        this.defaultZ = this.myElement.getZ();
        doubleValueArray[2] = new DoubleValue(this.defaultZ);
        this.posValues = doubleValueArray;
        DoubleValue[] doubleValueArray2 = new DoubleValue[3];
        this.defaultSizeX = this.myElement.getSizeX();
        doubleValueArray2[0] = new DoubleValue(this.defaultSizeX);
        this.defaultSizeY = this.myElement.getSizeY();
        doubleValueArray2[1] = new DoubleValue(this.defaultSizeY);
        this.defaultSizeZ = this.myElement.getSizeZ();
        doubleValueArray2[2] = new DoubleValue(this.defaultSizeZ);
        this.sizeValues = doubleValueArray2;
        this.defLines = style.getLineColor();
        this.defFill = style.getFillColor();
        this.defExtraColor = style.getExtraColor();
        this.defaultRes = style.getResolution();
        this.defaultOffset = style.getRelativePosition();
        int n = this.getPropertiesDisplacement();
        this.posSpot = new int[]{2 + n, 3 + n, 4 + n};
        this.sizeSpot = new int[]{5 + n, 6 + n, 7 + n};
        this.fullPosition = 26 + n;
        this.fullSize = 27 + n;
        this.myElement.addInteractionListener(this);
        this.myElement.setDataObject(this);
    }

    protected abstract int getPropertiesDisplacement();

    protected abstract Element createElement();

    @Override
    public Object getObject() {
        return this.myElement;
    }

    @Override
    public abstract String getObjectClassname();

    public Element getElement() {
        return this.myElement;
    }

    /*
     * Unable to fully structure code
     */
    protected Window getTopWindow() {
        if (this.myParent == null) {
            return null;
        }
        var1_1 = this.getEjsControl();
        var2_2 = var1_1.getElement(this.getProperty("parent"));
        if (var2_2 != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.getElement(var2_2.getProperty("parent"));
lbl8:
            // 2 sources

            ** while (!(var2_2 instanceof ControlSwingElement))
        }
lbl9:
        // 1 sources

        return ((ControlSwingElement)var2_2).getTopWindow();
    }

    public final int[] getPosSpot() {
        return this.posSpot;
    }

    public final int[] getSizeSpot() {
        return this.sizeSpot;
    }

    public final int getFullPositionSpot() {
        return this.fullPosition;
    }

    public final int getFullSizeSpot() {
        return this.fullSize;
    }

    protected void setName(String string) {
        this.myElement.setName(string);
    }

    public final void setParent(ControlParentOfElement3D controlParentOfElement3D) {
        Element element = this.myElement;
        if (this.myParent != null) {
            if (this instanceof NeedsPreUpdate) {
                this.myParent.removeFromPreupdateList((NeedsPreUpdate)((Object)this));
            }
            this.myParent.removeElement(element);
        }
        if (controlParentOfElement3D != null) {
            if (this instanceof NeedsPreUpdate) {
                controlParentOfElement3D.addToPreupdateList((NeedsPreUpdate)((Object)this));
            }
            controlParentOfElement3D.addElement(element);
            if (controlParentOfElement3D instanceof NeedsUpdate) {
                ((NeedsUpdate)((Object)controlParentOfElement3D)).update();
            }
            if (controlParentOfElement3D instanceof NeedsFinalUpdate) {
                ((NeedsFinalUpdate)((Object)controlParentOfElement3D)).finalUpdate();
            }
            this.myParent = controlParentOfElement3D;
        }
    }

    public final ControlParentOfElement3D getParent() {
        return this.myParent;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.myParent instanceof NeedsUpdate) {
            ((NeedsUpdate)((Object)this.myParent)).update();
        }
        if (this.myParent instanceof NeedsFinalUpdate) {
            ((NeedsFinalUpdate)((Object)this.myParent)).finalUpdate();
        }
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    @Override
    public boolean acceptsChild(ControlElement controlElement) {
        if (controlElement instanceof ControlTransformation3D) {
            return true;
        }
        return super.acceptsChild(controlElement);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizeX");
            infoList.add("sizeY");
            infoList.add("sizeZ");
            infoList.add("transformation");
            infoList.add("visible");
            infoList.add("lineColor");
            infoList.add("lineWidth");
            infoList.add("fillColor");
            infoList.add("resolution");
            infoList.add("drawingFill");
            infoList.add("drawingLines");
            infoList.add("enabledPosition");
            infoList.add("movesGroup");
            infoList.add("enabledSize");
            infoList.add("resizesGroup");
            infoList.add("sensitivity");
            infoList.add("pressAction");
            infoList.add("dragAction");
            infoList.add("releaseAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("position");
            infoList.add("size");
            infoList.add("menuName");
            infoList.add("elementposition");
            infoList.add("depthFactor");
            infoList.add("measured");
            infoList.add("extraColor");
            infoList.add("texture");
            infoList.add("textureSecond");
            infoList.add("textureTransparency");
            infoList.add("textureCombine");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("z")) {
            return "int|double";
        }
        if (string.equals("sizeX")) {
            return "int|double";
        }
        if (string.equals("sizeY")) {
            return "int|double";
        }
        if (string.equals("sizeZ")) {
            return "int|double";
        }
        if (string.equals("transformation")) {
            return "3DTransformation|double[]|String|Object";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("lineColor")) {
            return "int|Color|Object";
        }
        if (string.equals("lineWidth")) {
            return "int|double";
        }
        if (string.equals("fillColor")) {
            return "int|Color|Object";
        }
        if (string.equals("resolution")) {
            return "3DResolution|String|Object";
        }
        if (string.equals("drawingFill")) {
            return "boolean";
        }
        if (string.equals("drawingLines")) {
            return "boolean";
        }
        if (string.equals("enabledPosition")) {
            return "Interaction3D|int|boolean";
        }
        if (string.equals("movesGroup")) {
            return "boolean";
        }
        if (string.equals("enabledSize")) {
            return "Interaction3D|int|boolean";
        }
        if (string.equals("resizesGroup")) {
            return "boolean";
        }
        if (string.equals("sensitivity")) {
            return "int";
        }
        if (string.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("position")) {
            return "double[]";
        }
        if (string.equals("size")) {
            return "double[]";
        }
        if (string.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int";
        }
        if (string.equals("depthFactor")) {
            return "double";
        }
        if (string.equals("measured")) {
            return "boolean";
        }
        if (string.equals("extraColor")) {
            return "int|Color|Object";
        }
        if (string.equals("texture")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("textureSecond")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("textureTransparency")) {
            return "double";
        }
        if (string.equals("textureCombine")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(string);
    }

    protected void updatePanel() {
        DrawingPanel3D drawingPanel3D = this.myElement.getPanel();
        if (drawingPanel3D != null) {
            drawingPanel3D.update();
        }
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setName(value.getString());
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlParentOfElement3D) {
                    this.setParent((ControlParentOfElement3D)((Object)controlElement));
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlElements3DParent");
                break;
            }
            case 2: {
                this.thePos = null;
                this.posValues[0].value = value.getDouble();
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 3: {
                this.thePos = null;
                this.posValues[1].value = value.getDouble();
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 4: {
                this.thePos = null;
                this.posValues[2].value = value.getDouble();
                this.myElement.setZ(this.posValues[2].value);
                break;
            }
            case 26: {
                if (!(value.getObject() instanceof double[])) break;
                this.thePos = (double[])value.getObject();
                this.posValues[0].value = this.thePos[0];
                this.posValues[1].value = this.thePos[1];
                this.posValues[2].value = this.thePos[2];
                this.myElement.setXYZ(this.posValues[0].value, this.posValues[1].value, this.posValues[2].value);
                break;
            }
            case 5: {
                this.theSize = null;
                this.sizeValues[0].value = value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 6: {
                this.theSize = null;
                this.sizeValues[1].value = value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 7: {
                this.theSize = null;
                this.sizeValues[2].value = value.getDouble();
                this.myElement.setSizeZ(this.sizeValues[2].value);
                break;
            }
            case 27: {
                if (!(value.getObject() instanceof double[])) break;
                this.theSize = (double[])value.getObject();
                this.sizeValues[0].value = this.theSize[0];
                this.sizeValues[1].value = this.theSize[1];
                this.sizeValues[2].value = this.theSize[2];
                this.myElement.setSizeXYZ(this.sizeValues[0].value, this.sizeValues[1].value, this.sizeValues[2].value);
                break;
            }
            case 8: {
                if (value == null) {
                    System.err.println("Trans is null");
                    return;
                }
                if (value.getObject() instanceof Transformation) {
                    this.myElement.setTransformation((Transformation)value.getObject());
                    break;
                }
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (dArray.length == 6) {
                        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
                        double[] dArray3 = new double[]{dArray[3], dArray[4], dArray[5]};
                        this.myElement.setTransformation(Matrix3DTransformation.createAlignmentTransformation(dArray2, dArray3));
                        break;
                    }
                    if (dArray.length != 4) break;
                    double[] dArray4 = new double[]{dArray[1], dArray[2], dArray[3]};
                    this.myElement.setTransformation(Matrix3DTransformation.rotation(dArray[0], dArray4));
                    break;
                }
                this.myElement.setTransformation(ControlElement3D.createTransformation(this, value.getString()));
                break;
            }
            case 9: {
                this.myElement.setVisible(value.getBoolean());
                break;
            }
            case 10: {
                if (value.getObject() instanceof Color) {
                    this.myElement.getStyle().setLineColor((Color)value.getObject());
                    break;
                }
                this.myElement.getStyle().setLineColor(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth((float)value.getDouble());
                break;
            }
            case 12: {
                if (value.getObject() instanceof Paint) {
                    this.myElement.getStyle().setFillColor((Paint)value.getObject());
                    break;
                }
                this.myElement.getStyle().setFillColor(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 13: {
                if (value.getObject() instanceof Resolution) {
                    this.myElement.getStyle().setResolution((Resolution)value.getObject());
                    break;
                }
                Resolution resolution = ControlElement3D.decodeResolution(value.toString());
                if (resolution == null) break;
                this.myElement.getStyle().setResolution(resolution);
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingFill(value.getBoolean());
                break;
            }
            case 15: {
                this.myElement.getStyle().setDrawingLines(value.getBoolean());
                break;
            }
            case 16: {
                if (value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(0).setEnabled(value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(0).setEnabled(value.getInteger());
                break;
            }
            case 17: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(value.getBoolean());
                break;
            }
            case 18: {
                if (value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(1).setEnabled(value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(1).setEnabled(value.getInteger());
                break;
            }
            case 19: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(value.getBoolean());
                break;
            }
            case 20: {
                this.myElement.getStyle().setSensitivity(value.getInteger());
                break;
            }
            case 21: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, value.getString());
                break;
            }
            case 22: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, value.getString());
                break;
            }
            case 23: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, value.getString());
                break;
            }
            case 24: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 25: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 28: {
                this.menuNameEntry = value.getString();
                this.setName(this.menuNameEntry);
                break;
            }
            case 29: {
                if (value.getInteger() == this.myElement.getStyle().getRelativePosition()) break;
                this.myElement.getStyle().setRelativePosition(value.getInteger());
                break;
            }
            case 30: {
                if (value.getDouble() == this.myElement.getStyle().getDepthFactor()) break;
                this.myElement.getStyle().setDepthFactor(value.getDouble());
                break;
            }
            case 31: {
                this.myElement.setCanBeMeasured(value.getBoolean());
                break;
            }
            case 32: {
                if (value.getObject() instanceof Color) {
                    this.myElement.getStyle().setExtraColor((Color)value.getObject());
                    break;
                }
                this.myElement.getStyle().setExtraColor(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 33: {
                this.myElement.getStyle().setTexture(value.getString(), this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 34: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], value.getString(), this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 35: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], value.getDouble(), this.myElement.getStyle().getCombine());
                break;
            }
            case 36: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), value.getBoolean());
                break;
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                super.setDefaultValue(0);
                this.setName("");
                break;
            }
            case 1: {
                if (this.myGroup.getElement(this.getProperty("parent")) == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.posValues[0].value = this.defaultX;
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 3: {
                this.posValues[1].value = this.defaultY;
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 4: {
                this.posValues[2].value = this.defaultZ;
                this.myElement.setZ(this.posValues[2].value);
                break;
            }
            case 26: {
                this.thePos = null;
                break;
            }
            case 5: {
                this.sizeValues[0].value = this.defaultSizeX;
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 6: {
                this.sizeValues[1].value = this.defaultSizeY;
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 7: {
                this.sizeValues[2].value = this.defaultSizeZ;
                this.myElement.setSizeZ(this.sizeValues[2].value);
                break;
            }
            case 27: {
                this.theSize = null;
                break;
            }
            case 8: {
                this.myElement.setTransformation(new Matrix3DTransformation(null));
                break;
            }
            case 9: {
                this.myElement.setVisible(true);
                break;
            }
            case 10: {
                this.myElement.getStyle().setLineColor(this.defLines);
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth(1.0f);
                break;
            }
            case 12: {
                this.myElement.getStyle().setFillColor(this.defFill);
                break;
            }
            case 13: {
                this.myElement.getStyle().setResolution(this.defaultRes);
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingFill(true);
                break;
            }
            case 15: {
                this.myElement.getStyle().setDrawingLines(true);
                break;
            }
            case 16: {
                this.myElement.getInteractionTarget(0).setEnabled(false);
                break;
            }
            case 17: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(false);
                break;
            }
            case 18: {
                this.myElement.getInteractionTarget(1).setEnabled(false);
                break;
            }
            case 19: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(false);
                break;
            }
            case 20: {
                this.myElement.getStyle().setSensitivity(5);
                break;
            }
            case 21: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 22: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 23: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 24: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 25: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 28: {
                this.menuNameEntry = null;
                break;
            }
            case 29: {
                this.myElement.getStyle().setRelativePosition(5);
                break;
            }
            case 30: {
                this.myElement.getStyle().setDepthFactor(1.0);
                break;
            }
            case 31: {
                this.myElement.setCanBeMeasured(true);
                break;
            }
            case 32: {
                this.myElement.getStyle().setExtraColor(this.defExtraColor);
                break;
            }
            case 33: {
                this.myElement.getStyle().setTexture(null, this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 34: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], null, this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 35: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], Double.NaN, this.myElement.getStyle().getCombine());
                break;
            }
            case 36: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), false);
                break;
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 26: 
            case 27: {
                return "<none>";
            }
            case 2: {
                return "" + this.defaultX;
            }
            case 3: {
                return "" + this.defaultY;
            }
            case 4: {
                return "" + this.defaultZ;
            }
            case 5: {
                return "" + this.defaultSizeX;
            }
            case 6: {
                return "" + this.defaultSizeY;
            }
            case 7: {
                return "" + this.defaultSizeZ;
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "true";
            }
            case 10: {
                return "<none>";
            }
            case 11: {
                return "1";
            }
            case 12: {
                return "<none>";
            }
            case 13: {
                return "<none>";
            }
            case 14: 
            case 15: {
                return "true";
            }
            case 16: {
                return "ENABLED_NONE";
            }
            case 17: {
                return "false";
            }
            case 18: {
                return "ENABLED_NONE";
            }
            case 19: {
                return "false";
            }
            case 20: {
                return Integer.toString(5);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return "<no_action>";
            }
            case 28: {
                return "<none>";
            }
            case 29: {
                return "" + this.defaultOffset;
            }
            case 30: {
                return "1.0";
            }
            case 31: {
                return "true";
            }
            case 32: {
                return this.defExtraColor.toString();
            }
            case 33: 
            case 34: 
            case 35: {
                return "<none>";
            }
            case 36: {
                return "false";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 26: {
                return new ObjectValue(this.thePos);
            }
            case 2: {
                return this.posValues[0];
            }
            case 3: {
                return this.posValues[1];
            }
            case 4: {
                return this.posValues[2];
            }
            case 27: {
                return new ObjectValue(this.theSize);
            }
            case 5: {
                return this.sizeValues[0];
            }
            case 6: {
                return this.sizeValues[1];
            }
            case 7: {
                return this.sizeValues[2];
            }
        }
        return null;
    }

    final ControlGroup3D getControlGroup() {
        if (this.myParent instanceof ControlGroup3D) {
            return (ControlGroup3D)this.myParent;
        }
        return null;
    }

    protected void propagatePosition(ControlElement3D controlElement3D) {
        this.posValues[0].value = this.myElement.getX();
        this.posValues[1].value = this.myElement.getY();
        this.posValues[2].value = this.myElement.getZ();
        if (this.thePos != null) {
            this.thePos[0] = this.posValues[0].value;
            this.thePos[1] = this.posValues[1].value;
            this.thePos[2] = this.posValues[2].value;
            ObjectValue objectValue = new ObjectValue(this.thePos);
            this.variableChanged(this.getFullPositionSpot(), objectValue);
            if (controlElement3D != this) {
                controlElement3D.variableChanged(controlElement3D.getFullPositionSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.posValues);
            if (controlElement3D != this) {
                controlElement3D.variablesChanged(controlElement3D.getPosSpot(), this.posValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.posValues);
            }
        }
    }

    protected void propagateSize(ControlElement3D controlElement3D) {
        this.sizeValues[0].value = this.myElement.getSizeX();
        this.sizeValues[1].value = this.myElement.getSizeY();
        this.sizeValues[2].value = this.myElement.getSizeZ();
        if (this.theSize != null) {
            this.theSize[0] = this.sizeValues[0].value;
            this.theSize[1] = this.sizeValues[1].value;
            this.theSize[2] = this.sizeValues[2].value;
            ObjectValue objectValue = new ObjectValue(this.theSize);
            this.variableChanged(this.getFullSizeSpot(), objectValue);
            if (controlElement3D != this) {
                controlElement3D.variableChanged(controlElement3D.getFullSizeSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.sizeValues);
            if (controlElement3D != this) {
                controlElement3D.variablesChanged(controlElement3D.getSizeSpot(), this.sizeValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.sizeValues);
            }
        }
    }

    private void reportMouseMotion(Object object) {
        InteractionTarget interactionTarget = (InteractionTarget)object;
        ControlGroup3D controlGroup3D = this.getControlGroup();
        if (interactionTarget == this.myElement.getInteractionTarget(0)) {
            if (interactionTarget.getAffectsGroup() && controlGroup3D != null) {
                controlGroup3D.propagatePosition(this);
            } else {
                this.propagatePosition(this);
            }
        } else if (interactionTarget == this.myElement.getInteractionTarget(1)) {
            if (interactionTarget.getAffectsGroup() && controlGroup3D != null) {
                controlGroup3D.propagateSize(this);
            } else {
                this.propagateSize(this);
            }
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                break;
            }
            case 2000: {
                this.reportMouseMotion(interactionEvent.getInfo());
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(interactionEvent.getInfo());
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("3DResolution") >= 0) {
            Resolution resolution = ControlElement3D.decodeResolution(string2);
            if (resolution != null) {
                return new ObjectValue(resolution);
            }
        } else if (string.indexOf("ElementPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (string2.equals("north")) {
                return new IntegerValue(1);
            }
            if (string2.equals("south")) {
                return new IntegerValue(2);
            }
            if (string2.equals("east")) {
                return new IntegerValue(3);
            }
            if (string2.equals("west")) {
                return new IntegerValue(4);
            }
            if (string2.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (string2.equals("north_west")) {
                return new IntegerValue(6);
            }
            if (string2.equals("south_east")) {
                return new IntegerValue(7);
            }
            if (string2.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (string.indexOf("ArrowPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (string2.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (string2.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (string.indexOf("3DTransformation") >= 0) {
            Transformation transformation = ControlElement3D.decodeTransformation(this, string2);
            if (transformation != null) {
                return new ObjectValue(transformation);
            }
        } else if (string.indexOf("ArrowPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (string2.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (string2.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (string.indexOf("MarkerShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("ellipse")) {
                return new IntegerValue(1);
            }
            if (string2.equals("rectangle")) {
                return new IntegerValue(2);
            }
            if (string2.equals("round_rectangle")) {
                return new IntegerValue(3);
            }
            if (string2.equals("wheel")) {
                return new IntegerValue(4);
            }
            if (string2.equals("none")) {
                return new IntegerValue(0);
            }
        } else if (string.indexOf("Interaction3D") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("enabled_none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("enabled_any")) {
                return new IntegerValue(1);
            }
            if (string2.equals("enabled_x")) {
                return new IntegerValue(2);
            }
            if (string2.equals("enabled_y")) {
                return new IntegerValue(3);
            }
            if (string2.equals("enabled_z")) {
                return new IntegerValue(4);
            }
            if (string2.equals("enabled_xy")) {
                return new IntegerValue(5);
            }
            if (string2.equals("enabled_xz")) {
                return new IntegerValue(6);
            }
            if (string2.equals("enabled_yz")) {
                return new IntegerValue(7);
            }
        }
        return super.parseConstant(string, string2);
    }

    public static Resolution decodeResolution(String string) {
        if ((string = string.trim().toLowerCase()).indexOf(46) >= 0) {
            try {
                return new Resolution(Double.parseDouble(string));
            }
            catch (Exception exception) {
                System.out.println("Incorrect double value for resolution");
                exception.printStackTrace();
                return null;
            }
        }
        if (string.indexOf(44) < 0) {
            try {
                new Resolution(Integer.parseInt(string));
            }
            catch (Exception exception) {}
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) {
                return new Resolution(n, 1, 1);
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) {
                return new Resolution(n, n2, 1);
            }
            return new Resolution(n, n2, Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            System.out.println("Incorrect integer values for resolution");
            exception.printStackTrace();
            return null;
        }
    }

    private static Transformation createTransformation(ControlElement controlElement, String string) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        if (string == null || string.equals("null")) {
            return matrix3DTransformation;
        }
        if (string.indexOf(58) < 0 && string.indexOf(44) < 0) {
            return matrix3DTransformation;
        }
        if (controlElement.editorIsReading() && string.indexOf("void") >= 0) {
            return matrix3DTransformation;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = string2.toLowerCase();
            try {
                Matrix3DTransformation matrix3DTransformation2;
                String string4;
                if (string3.startsWith("x:") || string3.startsWith("y:") || string3.startsWith("z:")) {
                    string4 = string2.substring(2).trim();
                    boolean bl = false;
                    if (string4.endsWith("\u222b") || string4.endsWith("d")) {
                        string4 = string4.substring(0, string4.length() - 1).trim();
                        bl = true;
                    }
                    double d = Double.parseDouble(string4);
                    if (bl) {
                        d *= Math.PI / 180;
                    }
                    matrix3DTransformation2 = string3.startsWith("x") ? Matrix3DTransformation.rotationX(d) : (string3.startsWith("y") ? Matrix3DTransformation.rotationY(d) : Matrix3DTransformation.rotationZ(d));
                } else if (string3.startsWith("q:")) {
                    string4 = string2.substring(2).trim();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                    double d = Double.parseDouble(stringTokenizer2.nextToken());
                    double d2 = Double.parseDouble(stringTokenizer2.nextToken());
                    double d3 = Double.parseDouble(stringTokenizer2.nextToken());
                    double d4 = Double.parseDouble(stringTokenizer2.nextToken());
                    matrix3DTransformation2 = Matrix3DTransformation.Quaternion(d, d2, d3, d4);
                } else {
                    string4 = string2;
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ",");
                    String string5 = stringTokenizer3.nextToken();
                    double d = Double.parseDouble(stringTokenizer3.nextToken());
                    double d5 = Double.parseDouble(stringTokenizer3.nextToken());
                    double d6 = Double.parseDouble(stringTokenizer3.nextToken());
                    if (!stringTokenizer3.hasMoreTokens()) {
                        boolean bl = false;
                        if (string5.endsWith("\u222b") || string5.endsWith("d")) {
                            string5 = string5.substring(0, string5.length() - 1);
                            bl = true;
                        }
                        double d7 = Double.parseDouble(string5);
                        if (bl) {
                            d7 *= Math.PI / 180;
                        }
                        matrix3DTransformation2 = Matrix3DTransformation.rotation(d7, new double[]{d, d5, d6});
                    } else {
                        double d8 = Double.parseDouble(string5);
                        double d9 = Double.parseDouble(stringTokenizer3.nextToken());
                        double d10 = Double.parseDouble(stringTokenizer3.nextToken());
                        matrix3DTransformation2 = Matrix3DTransformation.createAlignmentTransformation(new double[]{d8, d, d5}, new double[]{d6, d9, d10});
                    }
                }
                matrix3DTransformation2.multiply(matrix3DTransformation);
                matrix3DTransformation = matrix3DTransformation2;
            }
            catch (Exception exception) {
                System.out.println("Incorrect value for transformation: " + string2);
                exception.printStackTrace();
            }
        }
        return matrix3DTransformation;
    }

    private static Transformation decodeTransformation(ControlElement controlElement, String string) {
        if (string.indexOf(34) >= 0) {
            return null;
        }
        if (string.indexOf(37) >= 0) {
            return null;
        }
        if (string.indexOf(123) >= 0 || string.indexOf(125) >= 0) {
            return null;
        }
        if (string.indexOf(58) < 0 && string.indexOf(44) < 0) {
            return null;
        }
        return ControlElement3D.createTransformation(controlElement, string.trim());
    }
}

