/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.numerics.Function;

public class FunctionDrawer
implements Drawable,
Measurable,
Function {
    private double[] xrange = new double[2];
    private double[] yrange = new double[2];
    private int numpts = 0;
    private GeneralPath generalPath = new GeneralPath();
    private Function function;
    private boolean filled = false;
    private boolean measured = false;
    public Color color = Color.black;
    public boolean functionChanged = false;

    public FunctionDrawer(Function function) {
        this.function = function;
    }

    public FunctionDrawer(Function function, double d, double d2, int n, boolean bl) {
        this(function);
        this.initialize(d, d2, n, bl);
    }

    public double evaluate(double d) {
        return this.function.evaluate(d);
    }

    public void initialize(double d, double d2, int n, boolean bl) {
        if (n < 1) {
            return;
        }
        this.filled = bl;
        this.xrange[0] = d;
        this.xrange[1] = d2;
        this.numpts = n;
        this.generalPath.reset();
        if (n < 1) {
            return;
        }
        this.yrange[0] = this.function.evaluate(d);
        this.yrange[1] = this.yrange[0];
        if (bl) {
            this.generalPath.moveTo((float)this.xrange[0], 0.0f);
            this.generalPath.lineTo((float)this.xrange[0], (float)this.yrange[0]);
        } else {
            this.generalPath.moveTo((float)this.xrange[0], (float)this.yrange[0]);
        }
        double d3 = this.xrange[0];
        double d4 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            double d5 = this.function.evaluate(d3 += d4);
            this.generalPath.lineTo((float)d3, (float)d5);
            if (d5 < this.yrange[0]) {
                this.yrange[0] = d5;
            }
            if (d5 > this.yrange[1]) {
                this.yrange[1] = d5;
            }
            ++n2;
        }
        if (bl) {
            this.generalPath.lineTo((float)d3, 0.0f);
            this.generalPath.closePath();
        }
        this.measured = true;
    }

    public GeneralPath getPath() {
        return (GeneralPath)this.generalPath.clone();
    }

    public double[] getXRange() {
        return this.xrange;
    }

    public double[] getYRange() {
        return this.yrange;
    }

    void checkRange(DrawingPanel drawingPanel) {
        if (this.xrange[0] == drawingPanel.getXMin() && this.xrange[1] == drawingPanel.getXMax() && this.numpts == drawingPanel.getWidth() && !this.functionChanged) {
            return;
        }
        this.functionChanged = false;
        this.xrange[0] = drawingPanel.getXMin();
        this.xrange[1] = drawingPanel.getXMax();
        this.numpts = drawingPanel.getWidth();
        this.generalPath.reset();
        if (this.numpts < 1) {
            return;
        }
        this.yrange[0] = this.function.evaluate(this.xrange[0]);
        this.yrange[1] = this.yrange[0];
        if (this.filled) {
            this.generalPath.moveTo((float)this.xrange[0], 0.0f);
            this.generalPath.lineTo((float)this.xrange[0], (float)this.yrange[0]);
        } else {
            this.generalPath.moveTo((float)this.xrange[0], (float)this.yrange[0]);
        }
        double d = this.xrange[0];
        double d2 = (this.xrange[1] - this.xrange[0]) / (double)this.numpts;
        int n = 0;
        while (n < this.numpts) {
            double d3 = this.function.evaluate(d += d2);
            if (!Double.isNaN(d) && !Double.isNaN(d3)) {
                d3 = Math.min(d3, 1.0E12);
                d3 = Math.max(d3, -1.0E12);
                this.generalPath.lineTo((float)d, (float)d3);
                if (d3 < this.yrange[0]) {
                    this.yrange[0] = d3;
                }
                if (d3 > this.yrange[1]) {
                    this.yrange[1] = d3;
                }
            }
            ++n;
        }
        if (this.filled) {
            this.generalPath.lineTo((float)d, 0.0f);
            this.generalPath.closePath();
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.measured) {
            this.checkRange(drawingPanel);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
        Shape shape = this.generalPath.createTransformedShape(drawingPanel.getPixelTransform());
        if (this.filled) {
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        } else {
            graphics2D.draw(shape);
        }
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isMeasured() {
        return this.measured;
    }

    public double getXMin() {
        return this.xrange[0];
    }

    public double getXMax() {
        return this.xrange[1];
    }

    public double getYMin() {
        return this.yrange[0];
    }

    public double getYMax() {
        return this.yrange[1];
    }
}

