/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Color;
import java.util.ArrayList;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractionTargetPoligonMovingPoint;
import org.opensourcephysics.displayejs.InteractionTargetPoligonPoint;
import org.opensourcephysics.displayejs.InteractivePoligon;

public class ControlPoligon
extends ControlInteractiveElement {
    protected static final int POLIGON_ADDED = 17;
    protected static final int INPUT_X = 17;
    protected static final int INPUT_Y = 18;
    protected static final int INPUT_Z = 19;
    protected static final int MY_SIZE_X = 20;
    protected static final int MY_SIZE_Y = 21;
    protected static final int MY_SIZE_Z = 22;
    protected static final int MY_LINE_COLOR = 36;
    protected static final int MY_FILL_COLOR = 35;
    protected static final int INDEX_SELECTED = 12;
    protected InteractivePoligon poligon;
    protected ObjectValue[] coordinatesValues;
    protected IntegerValue pointValue = new IntegerValue(-1);
    protected int insensitiveCorner = -1;
    private int[] myPosSpot;
    private int[] mySizeSpot;
    private int[] coordinatesSpot;
    private int myFullPosition;
    private int myFullSize;
    private static ArrayList infoList = null;

    public ControlPoligon() {
        int n = this.getPropertiesDisplacement();
        this.myPosSpot = new int[]{4 + n, 5 + n, 6 + n};
        this.mySizeSpot = new int[]{20 + n, 21 + n, 22 + n};
        this.coordinatesSpot = new int[]{17 + n, 18 + n, 19 + n};
        this.myFullPosition = 45 + n;
        this.myFullSize = 46 + n;
    }

    protected int getPropertiesDisplacement() {
        return 0;
    }

    public final int[] getMyPosSpot() {
        return this.myPosSpot;
    }

    public final int[] getMySizeSpot() {
        return this.mySizeSpot;
    }

    public final int getMyFullPositionSpot() {
        return this.myFullPosition;
    }

    public final int getMyFullSizeSpot() {
        return this.myFullSize;
    }

    private final int[] getCoordinatesSpot() {
        return this.coordinatesSpot;
    }

    protected void setName(String string) {
        this.poligon.setName(string);
    }

    protected Drawable createDrawable() {
        this.poligon = new InteractivePoligon();
        double[][] dArray = this.poligon.getData();
        this.coordinatesValues = new ObjectValue[3];
        if (dArray != null) {
            this.coordinatesValues[0] = new ObjectValue(dArray[0]);
            this.coordinatesValues[1] = new ObjectValue(dArray[1]);
            this.coordinatesValues[2] = new ObjectValue(dArray[2]);
        }
        this.poligon.setAllowTable(true);
        return this.poligon;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("maxpoints");
            infoList.add("connected");
            infoList.add("closed");
            infoList.add("fixed");
            infoList.add("positionx");
            infoList.add("positiony");
            infoList.add("positionz");
            infoList.add("startType");
            infoList.add("startSize");
            infoList.add("endType");
            infoList.add("endSize");
            infoList.add("neumatic");
            infoList.add("indexSelected");
            infoList.add("markershape");
            infoList.add("markersize");
            infoList.add("markerColor");
            infoList.add("markerFill");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("maxpoints")) {
            return "points";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("maxpoints")) {
            return "int PREVIOUS";
        }
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("z")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("connected")) {
            return "boolean[]";
        }
        if (string.equals("closed")) {
            return "boolean";
        }
        if (string.equals("startType")) {
            return "int|ExtremeType";
        }
        if (string.equals("startSize")) {
            return "int|double";
        }
        if (string.equals("endType")) {
            return "int|ExtremeType";
        }
        if (string.equals("endSize")) {
            return "int|double";
        }
        if (string.equals("neumatic")) {
            return "int|double";
        }
        if (string.equals("fixed")) {
            return "int|boolean[]";
        }
        if (string.equals("positionx")) {
            return "int|double";
        }
        if (string.equals("positiony")) {
            return "int|double";
        }
        if (string.equals("positionz")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("secondaryColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("indexSelected")) {
            return "int";
        }
        if (string.equals("markershape")) {
            return "MarkerShape|int|int[]";
        }
        if (string.equals("markersize")) {
            return "int|int[]";
        }
        if (string.equals("markerColor")) {
            return "Color|Object|Object[]";
        }
        if (string.equals("markerFill")) {
            return "Color|Object|Object[]";
        }
        return super.getPropertyInfo(string);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("linecolor")) {
            return super.setProperty("secondaryColor", string2);
        }
        return super.setProperty(string, string2);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("ExtremeType") >= 0 || string.indexOf("PoligonShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("plain")) {
                return new IntegerValue(0);
            }
            if (string2.equals("circle")) {
                return new IntegerValue(1);
            }
            if (string2.equals("diamond")) {
                return new IntegerValue(2);
            }
            if (string2.equals("square")) {
                return new IntegerValue(3);
            }
            if (string2.equals("line")) {
                return new IntegerValue(5);
            }
            if (string2.equals("arrow")) {
                return new IntegerValue(4);
            }
            if (string2.equals("filled_circle")) {
                return new IntegerValue(6);
            }
            if (string2.equals("filled_diamond")) {
                return new IntegerValue(7);
            }
            if (string2.equals("filled_square")) {
                return new IntegerValue(8);
            }
            if (string2.equals("filled_arrow")) {
                return new IntegerValue(9);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.poligon.getNumberOfPoints() == value.getInteger()) break;
                this.poligon.setNumberOfPoints(value.getInteger());
                double[][] dArray = this.poligon.getData();
                if (dArray != null) {
                    this.coordinatesValues[0] = new ObjectValue(dArray[0]);
                    this.coordinatesValues[1] = new ObjectValue(dArray[1]);
                    this.coordinatesValues[2] = new ObjectValue(dArray[2]);
                }
                if (this.insensitiveCorner > -1 && this.insensitiveCorner < this.poligon.getNumberOfPoints()) {
                    this.poligon.setPointSizeEnabled(this.insensitiveCorner, false);
                    break;
                }
                this.insensitiveCorner = -1;
                break;
            }
            case 1: {
                if (!(value.getObject() instanceof boolean[])) break;
                this.poligon.setConnections((boolean[])value.getObject());
                break;
            }
            case 2: {
                this.poligon.setClosed(value.getBoolean());
                break;
            }
            case 3: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(blArray.length, this.poligon.getNumberOfPoints());
                    while (n2 < n3) {
                        this.poligon.setPointSizeEnabled(n2, !blArray[n2]);
                        ++n2;
                    }
                    this.insensitiveCorner = -1;
                    break;
                }
                if (this.insensitiveCorner < 0) {
                    int n4 = 0;
                    int n5 = this.poligon.getNumberOfPoints();
                    while (n4 < n5) {
                        this.poligon.setPointSizeEnabled(n4, true);
                        ++n4;
                    }
                } else {
                    this.poligon.setPointSizeEnabled(this.insensitiveCorner, true);
                }
                this.insensitiveCorner = value.getInteger();
                this.poligon.setPointSizeEnabled(this.insensitiveCorner, false);
                break;
            }
            case 4: {
                super.setValue(0, value);
                break;
            }
            case 5: {
                super.setValue(1, value);
                break;
            }
            case 6: {
                super.setValue(2, value);
                break;
            }
            case 7: {
                this.poligon.setStartType(value.getInteger());
                break;
            }
            case 8: {
                this.poligon.setStartSize(value.getDouble());
                break;
            }
            case 9: {
                this.poligon.setEndType(value.getInteger());
                break;
            }
            case 10: {
                this.poligon.setEndSize(value.getDouble());
                break;
            }
            case 11: {
                this.poligon.setNeumatic(value.getDouble());
                break;
            }
            case 12: {
                this.pointValue.value = value.getInteger();
                break;
            }
            case 13: {
                if (value.getObject() instanceof int[]) {
                    this.poligon.setShapesType((int[])value.getObject());
                    break;
                }
                this.poligon.setShapesType(value.getInteger());
                break;
            }
            case 14: {
                if (value.getObject() instanceof int[]) {
                    this.poligon.setShapesSize((int[])value.getObject());
                    break;
                }
                this.poligon.setShapesSize(value.getInteger());
                break;
            }
            case 15: {
                if (value.getObject() instanceof Object[]) {
                    this.poligon.setShapesEdgeColor((Object[])value.getObject());
                    break;
                }
                if (!(value.getObject() instanceof Color)) break;
                this.poligon.setShapesEdgeColor((Color)value.getObject());
                break;
            }
            case 16: {
                if (value.getObject() instanceof Object[]) {
                    this.poligon.setShapesFillColor((Object[])value.getObject());
                    break;
                }
                if (!(value.getObject() instanceof Color)) break;
                this.poligon.setShapesFillColor((Color)value.getObject());
                break;
            }
            case 17: {
                if (value.getObject() instanceof double[]) {
                    this.poligon.setXs((double[])value.getObject());
                    break;
                }
                this.poligon.setXs(value.getDouble());
                break;
            }
            case 18: {
                if (value.getObject() instanceof double[]) {
                    this.poligon.setYs((double[])value.getObject());
                    break;
                }
                this.poligon.setYs(value.getDouble());
                break;
            }
            case 19: {
                if (value.getObject() instanceof double[]) {
                    this.poligon.setZs((double[])value.getObject());
                    break;
                }
                this.poligon.setZs(value.getDouble());
                break;
            }
            case 35: {
                super.setValue(19, value);
                break;
            }
            case 36: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n6 = nArray.length;
                    Color[] colorArray = new Color[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        colorArray[n7] = DisplayColors.getLineColor(nArray[n7]);
                        ++n7;
                    }
                    this.poligon.setColors(colorArray);
                    break;
                }
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n8 = objectArray.length;
                    Color[] colorArray = new Color[n8];
                    int n9 = 0;
                    while (n9 < n8) {
                        colorArray[n9] = (Color)objectArray[n9];
                        ++n9;
                    }
                    this.poligon.setColors(colorArray);
                    break;
                }
                super.setValue(18, value);
                this.poligon.setColors(null);
                break;
            }
            default: {
                super.setValue(n - 17, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.poligon.setNumberOfPoints(0);
                break;
            }
            case 1: {
                this.poligon.setConnections(null);
                break;
            }
            case 2: {
                this.poligon.setClosed(true);
                break;
            }
            case 3: {
                int n2 = 0;
                int n3 = this.poligon.getNumberOfPoints();
                while (n2 < n3) {
                    this.poligon.setPointSizeEnabled(n2, true);
                    ++n2;
                }
                this.insensitiveCorner = -1;
                break;
            }
            case 4: {
                super.setDefaultValue(0);
                break;
            }
            case 5: {
                super.setDefaultValue(1);
                break;
            }
            case 6: {
                super.setDefaultValue(2);
                break;
            }
            case 7: {
                this.poligon.setStartType(0);
                break;
            }
            case 8: {
                this.poligon.setStartSize(Double.NaN);
                break;
            }
            case 9: {
                this.poligon.setEndType(0);
                break;
            }
            case 10: {
                this.poligon.setEndSize(Double.NaN);
                break;
            }
            case 11: {
                this.poligon.setNeumatic(0.0);
                break;
            }
            case 12: {
                this.pointValue.value = -1;
                break;
            }
            case 13: {
                this.poligon.setShapesType(null);
                break;
            }
            case 14: {
                this.poligon.setShapesSize(null);
                break;
            }
            case 15: {
                this.poligon.setShapesEdgeColor((Object[])null);
                break;
            }
            case 16: {
                this.poligon.setShapesFillColor((Object[])null);
                break;
            }
            case 17: {
                this.poligon.setXs(0.0);
                break;
            }
            case 18: {
                this.poligon.setYs(0.0);
                break;
            }
            case 19: {
                this.poligon.setZs(0.0);
                break;
            }
            case 20: {
                this.sizeValues[0].value = 1.0;
                this.myElement.setSizeX(1.0 * this.scalex);
                break;
            }
            case 21: {
                this.sizeValues[1].value = 1.0;
                this.myElement.setSizeY(1.0 * this.scaley);
                break;
            }
            case 22: {
                this.sizeValues[2].value = 1.0;
                this.myElement.setSizeZ(1.0 * this.scalez);
                break;
            }
            case 35: {
                super.setDefaultValue(19);
                break;
            }
            case 36: {
                super.setDefaultValue(18);
                this.poligon.setColors(null);
                break;
            }
            default: {
                super.setDefaultValue(n - 17);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "<none>";
            }
            case 4: {
                return super.getDefaultValueString(0);
            }
            case 5: {
                return super.getDefaultValueString(1);
            }
            case 6: {
                return super.getDefaultValueString(2);
            }
            case 7: {
                return "PLAIN";
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "PLAIN";
            }
            case 10: {
                return "<none>";
            }
            case 11: {
                return "0";
            }
            case 12: {
                return "<none>";
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return "<none>";
            }
            case 17: 
            case 18: 
            case 19: {
                return "<none>";
            }
            case 20: 
            case 21: 
            case 22: {
                return "1";
            }
            case 35: {
                return super.getDefaultValueString(19);
            }
            case 36: {
                return super.getDefaultValueString(18);
            }
        }
        return super.getDefaultValueString(n - 17);
    }

    public Value getValue(int n) {
        switch (n) {
            case 17: {
                return this.coordinatesValues[0];
            }
            case 18: {
                return this.coordinatesValues[1];
            }
            case 19: {
                return this.coordinatesValues[2];
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return null;
            }
            case 4: {
                return super.getValue(0);
            }
            case 5: {
                return super.getValue(1);
            }
            case 6: {
                return super.getValue(2);
            }
            case 12: {
                return this.pointValue;
            }
        }
        return super.getValue(n - 17);
    }

    private int getIndex(Object object) {
        if (object instanceof InteractionTargetPoligonPoint) {
            return ((InteractionTargetPoligonPoint)object).getPointIndex();
        }
        if (object instanceof InteractionTargetPoligonMovingPoint) {
            return ((InteractionTargetPoligonMovingPoint)object).getPointIndex();
        }
        return -1;
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2004: {
                this.invokeActions(12);
                this.pointValue.value = -1;
                this.variableChanged(12, this.pointValue);
                break;
            }
            case 2003: {
                this.pointValue.value = this.getIndex(interactionEvent.getTarget());
                this.variableChanged(12, this.pointValue);
                this.invokeActions(11);
                break;
            }
            case 2000: {
                this.pointValue.value = this.getIndex(interactionEvent.getTarget());
                this.variableChanged(12, this.pointValue);
                this.invokeActions(10);
            }
            case 2001: {
                if (interactionEvent.getTarget().getClass() == InteractionTargetPoligonPoint.class) {
                    this.variablesChanged(this.getCoordinatesSpot(), this.coordinatesValues);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValues(this.getCoordinatesSpot(), this.coordinatesValues);
                    break;
                }
                if (interactionEvent.getTarget().getClass() == InteractionTargetElementSize.class) {
                    this.sizeValues[0].value = this.scalex != 0.0 ? this.myElement.getSizeX() / this.scalex : this.myElement.getSizeX();
                    this.sizeValues[1].value = this.scaley != 0.0 ? this.myElement.getSizeY() / this.scaley : this.myElement.getSizeY();
                    this.sizeValues[2].value = this.scalez != 0.0 ? this.myElement.getSizeZ() / this.scalez : this.myElement.getSizeZ();
                    if (this.theSize != null) {
                        this.theSize[0] = this.sizeValues[0].value;
                        this.theSize[1] = this.sizeValues[1].value;
                        if (this.theSize.length > 2) {
                            this.theSize[2] = this.sizeValues[2].value;
                        }
                        ObjectValue objectValue = new ObjectValue(this.theSize);
                        this.variableChanged(this.getMyFullSizeSpot(), objectValue);
                        if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                        this.setFieldListValue(this.getMyFullSizeSpot(), objectValue);
                        break;
                    }
                    this.variablesChanged(this.getMySizeSpot(), this.sizeValues);
                    if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                    this.setFieldListValues(this.getMySizeSpot(), this.sizeValues);
                    break;
                }
                this.posValues[0].value = this.myElement.getX();
                this.posValues[1].value = this.myElement.getY();
                this.posValues[2].value = this.myElement.getZ();
                if (this.thePos != null) {
                    this.thePos[0] = this.posValues[0].value;
                    this.thePos[1] = this.posValues[1].value;
                    if (this.thePos.length > 2) {
                        this.thePos[2] = this.posValues[2].value;
                    }
                    ObjectValue objectValue = new ObjectValue(this.thePos);
                    this.variableChanged(this.getMyFullPositionSpot(), objectValue);
                    if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                    this.setFieldListValue(this.getMyFullPositionSpot(), objectValue);
                    break;
                }
                this.variablesChanged(this.getMyPosSpot(), this.posValues);
                if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                this.setFieldListValues(this.getMyPosSpot(), this.posValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.pointValue.value = -1;
                this.variableChanged(12, this.pointValue);
            }
        }
    }
}

