/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public class ImageVideoType
implements VideoType {
    protected FileFilter jpgFilter;
    protected FileFilter pngFilter;

    public Video getVideo(File file) {
        try {
            return new ImageVideo(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Video getVideo(String string) {
        try {
            return new ImageVideo(string, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public VideoRecorder getRecorder() {
        return new ImageVideoRecorder();
    }

    public boolean canRecord() {
        return true;
    }

    public String getDescription() {
        return MediaRes.getString("ImageVideoType.Description");
    }

    public String getDefaultExtension() {
        return "jpg";
    }

    public FileFilter[] getFileFilters() {
        if (this.jpgFilter == null) {
            this.jpgFilter = new JPGFileFilter();
            this.pngFilter = new PNGFileFilter();
        }
        return new FileFilter[]{this.jpgFilter, this.pngFilter};
    }

    public boolean isType(Video video) {
        return video.getClass().equals(ImageVideo.class);
    }

    public class JPGFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = VideoIO.getExtension(file);
            return string != null && string.equals("jpg");
        }

        public String getDescription() {
            return MediaRes.getString("ImageVideoType.JPGFileFilter.Description");
        }
    }

    public class PNGFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = VideoIO.getExtension(file);
            return string != null && string.equals("png");
        }

        public String getDescription() {
            return MediaRes.getString("ImageVideoType.PNGFileFilter.Description");
        }
    }
}

