/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.displayejs.Comparator3D;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.displayejs.Measurable3D;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Resolution;

public class DrawingPanel3D
extends InteractivePanel
implements InteractionSource {
    public static final int TRANSPARENCY_LEVEL = 100;
    private static final int AXIS_DIVISIONS = 10;
    public static final int DISPLAY_PLANAR = 0;
    public static final int DISPLAY_PLANAR_XY = 0;
    public static final int DISPLAY_PLANAR_XZ = 1;
    public static final int DISPLAY_PLANAR_YZ = 2;
    public static final int DISPLAY_3D = 10;
    public static final int DISPLAY_PERSPECTIVE = 10;
    public static final int DISPLAY_NO_PERSPECTIVE = 12;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_XYZ = 1;
    public static final int CURSOR_CUBE = 2;
    public static final int CURSOR_CROSSHAIR = 3;
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_AXES = 1;
    public static final int DECORATION_CUBE = 2;
    protected boolean autoscaleZ = false;
    protected boolean removeHiddenLines = true;
    protected boolean respondToMouse = true;
    protected boolean showPosition = true;
    protected boolean useColorDepth = true;
    protected boolean allowQuickRedraw = true;
    protected int displayMode = 10;
    protected int cursorMode = 1;
    protected int decorationType = 2;
    protected int deltaa = 0;
    protected int deltab = 0;
    protected double alpha = 0.0;
    protected double beta = 0.0;
    protected double zoom = 1.0;
    protected double zmin = -1.0;
    protected double zmax = 1.0;
    protected double zminPreferred = -10.0;
    protected double zmaxPreferred = 10.0;
    protected double zfloor = Double.NaN;
    protected double zceil = Double.NaN;
    protected ArrayList listeners = new ArrayList();
    protected NumberFormat xFormat = new DecimalFormat("x=0.000;x=-0.000");
    protected NumberFormat yFormat = new DecimalFormat("y=0.000;y=-0.000");
    protected NumberFormat zFormat = new DecimalFormat("z=0.000;z=-0.000");
    private boolean quickRedrawOn = false;
    private double cosAlpha = Math.cos(this.alpha);
    private double sinAlpha = Math.sin(this.alpha);
    private double cosBeta = Math.cos(this.beta);
    private double sinBeta = Math.sin(this.beta);
    private double ratioToPlane = 2.5;
    private double ratioToCenter = 2.0;
    private double centerX;
    private double centerY;
    private double centerZ;
    private double aconstant;
    private double bconstant;
    private double viewToPlane;
    private double viewToCenter;
    private int acenter;
    private int bcenter;
    private int trackersVisible;
    private int keyPressed = -1;
    private Point3D trackerPoint = new Point3D(0.0, 0.0, 0.0);
    private ArrayList list3D = new ArrayList();
    private Comparator3D comparator = new Comparator3D();
    private InteractiveArrow xAxis;
    private InteractiveArrow yAxis;
    private InteractiveArrow zAxis;
    private InteractiveText xText;
    private InteractiveText yText;
    private InteractiveText zText;
    private InteractiveArrow[] boxSides = new InteractiveArrow[12];
    private InteractiveArrow[] trackerLines = null;
    private float[] crc = new float[4];
    private int lastX = 0;
    private int lastY = 0;
    private InteractionTarget targetHit = null;
    private Interactive iad = null;

    public DrawingPanel3D() {
        this(10);
    }

    public DrawingPanel3D(int n) {
        super.setSquareAspect(true);
        super.setShowCoordinates(false);
        super.enableInspector(false);
        super.removeOptionController();
        this.autoscaleZ = false;
        this.autoscaleY = false;
        this.autoscaleX = false;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DrawingPanel3D.this.computeConstants(1);
                if (!DrawingPanel3D.this.getIgnoreRepaint()) {
                    DrawingPanel3D.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DrawingPanel3D.this.keyPressed = keyEvent.getKeyCode();
            }

            public void keyReleased(KeyEvent keyEvent) {
                DrawingPanel3D.this.keyPressed = -1;
            }
        });
        Resolution resolution = new Resolution(10);
        int n2 = 0;
        int n3 = this.boxSides.length;
        while (n2 < n3) {
            this.boxSides[n2] = new InteractiveArrow(1);
            this.boxSides[n2].setResolution(resolution);
            this.boxSides[n2].setEnabled(false);
            this.boxSides[n2].canBeMeasured(false);
            ++n2;
        }
        this.xAxis = new InteractiveArrow(0);
        this.xAxis.setResolution(resolution);
        this.xAxis.setEnabled(false);
        this.xAxis.canBeMeasured(false);
        this.xText = new InteractiveText("X");
        this.xText.getStyle().setFont(new Font("Dialog", 0, 12));
        this.xText.setEnabled(false);
        this.xText.canBeMeasured(false);
        this.yAxis = new InteractiveArrow(0);
        this.yAxis.setResolution(resolution);
        this.yAxis.setEnabled(false);
        this.yAxis.canBeMeasured(false);
        this.yText = new InteractiveText("Y");
        this.yText.getStyle().setFont(new Font("Dialog", 0, 12));
        this.yText.setEnabled(false);
        this.yText.canBeMeasured(false);
        this.zAxis = new InteractiveArrow(0);
        this.zAxis.setResolution(resolution);
        this.zAxis.setEnabled(false);
        this.zAxis.canBeMeasured(false);
        this.zText = new InteractiveText("Z");
        this.zText.getStyle().setFont(new Font("Dialog", 0, 12));
        this.zText.setEnabled(false);
        this.zText.canBeMeasured(false);
        this.trackerLines = new InteractiveArrow[9];
        n2 = 0;
        n3 = this.trackerLines.length;
        while (n2 < n3) {
            this.trackerLines[n2] = new InteractiveArrow(1);
            this.trackerLines[n2].setResolution(resolution);
            this.trackerLines[n2].setEnabled(false);
            this.trackerLines[n2].setVisible(false);
            this.trackerLines[n2].canBeMeasured(false);
            ++n2;
        }
        this.setForeground(this.getForeground());
        this.clear();
        this.displayMode = n;
        if (this.displayMode < 10) {
            this.setDecorationType(0);
            this.setCursorMode(0);
            this.setUseColorDepth(false);
        } else {
            this.setDecorationType(2);
            this.setCursorMode(1);
            this.setUseColorDepth(true);
        }
        this.setPixelScale();
        this.computeConstants(2);
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    public void setSquareAspect(boolean bl) {
        if (this.squareAspect == bl) {
            return;
        }
        this.squareAspect = bl;
        this.computeConstants(3);
        this.invalidateImage();
        this.repaint();
    }

    public void setAutoscaleZ(boolean bl) {
        this.autoscaleZ = bl;
        this.invalidateImage();
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public void setRemoveHiddenLines(boolean bl) {
        this.removeHiddenLines = bl;
        this.invalidateImage();
    }

    public boolean isRemoveHiddenLines() {
        return this.removeHiddenLines;
    }

    public void setAllowQuickRedraw(boolean bl) {
        this.allowQuickRedraw = bl;
        this.invalidateImage();
    }

    public boolean isAllowQuickRedraw() {
        return this.allowQuickRedraw;
    }

    public void setShowCoordinates(boolean bl) {
        this.showPosition = bl;
    }

    public boolean isShowCoordinates() {
        return this.showPosition;
    }

    public void setXFormat(NumberFormat numberFormat) {
        this.xFormat = numberFormat;
    }

    public void setYFormat(NumberFormat numberFormat) {
        this.yFormat = numberFormat;
    }

    public void setZFormat(NumberFormat numberFormat) {
        this.zFormat = numberFormat;
    }

    public void setUseColorDepth(boolean bl) {
        this.useColorDepth = bl;
        this.invalidateImage();
    }

    public boolean isUseColorDepth() {
        return this.useColorDepth;
    }

    public void setDisplayMode(int n) {
        if (this.displayMode == n) {
            return;
        }
        this.displayMode = n;
        this.setDecorationType(this.decorationType);
        this.computeConstants(4);
        this.invalidateImage();
        if (!this.getIgnoreRepaint()) {
            this.repaint();
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setCursorMode(int n) {
        this.cursorMode = n;
        switch (n) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 1: {
                this.trackersVisible = 3;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
            }
        }
    }

    public int getCursorMode() {
        return this.cursorMode;
    }

    public void setDecorationType(int n) {
        this.decorationType = n;
        switch (n) {
            case 0: {
                this.xAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yAxis.setVisible(false);
                this.yText.setVisible(false);
                this.zAxis.setVisible(false);
                this.zText.setVisible(false);
                int n2 = 0;
                int n3 = this.boxSides.length;
                while (n2 < n3) {
                    this.boxSides[n2].setVisible(false);
                    ++n2;
                }
                break;
            }
            case 1: {
                boolean bl = this.displayMode == 0 || this.displayMode == 1 || this.displayMode >= 10;
                boolean bl2 = this.displayMode == 0 || this.displayMode == 2 || this.displayMode >= 10;
                boolean bl3 = this.displayMode == 2 || this.displayMode == 1 || this.displayMode >= 10;
                this.xAxis.setVisible(bl);
                this.xText.setVisible(bl);
                this.yAxis.setVisible(bl2);
                this.yText.setVisible(bl2);
                this.zAxis.setVisible(bl3);
                this.zText.setVisible(bl3);
                int n4 = 0;
                int n5 = this.boxSides.length;
                while (n4 < n5) {
                    this.boxSides[n4].setVisible(false);
                    ++n4;
                }
                break;
            }
            case 2: {
                this.xAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yAxis.setVisible(false);
                this.yText.setVisible(false);
                this.zAxis.setVisible(false);
                this.zText.setVisible(false);
                int n6 = 0;
                int n7 = this.boxSides.length;
                while (n6 < n7) {
                    this.boxSides[n6].setVisible(true);
                    ++n6;
                }
                break;
            }
        }
        this.invalidateImage();
        if (!this.getIgnoreRepaint()) {
            this.repaint();
        }
    }

    public int getDecorationType() {
        return this.decorationType;
    }

    public void setDecorationResolution(Resolution resolution) {
        int n = 0;
        int n2 = this.boxSides.length;
        while (n < n2) {
            this.boxSides[n].setResolution(resolution);
            ++n;
        }
        this.xAxis.setResolution(resolution);
        this.yAxis.setResolution(resolution);
        this.zAxis.setResolution(resolution);
        n = 0;
        n2 = this.trackerLines.length;
        while (n < n2) {
            this.trackerLines[n].setResolution(resolution);
            ++n;
        }
    }

    public void setAxesLabels(String[] stringArray) {
        this.xText.getStyle().setDisplayObject(stringArray[0]);
        this.yText.getStyle().setDisplayObject(stringArray[1]);
        this.zText.getStyle().setDisplayObject(stringArray[2]);
    }

    public void setPan(int n, int n2) {
        this.deltaa = n;
        this.deltab = n2;
        this.computeConstants(5);
    }

    public Point getPan() {
        return new Point(this.deltaa, this.deltab);
    }

    public void setAlpha(double d) {
        this.alpha = d;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.reportTheNeedToProject(1);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setBeta(double d) {
        this.beta = d;
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.reportTheNeedToProject(2);
    }

    public double getBeta() {
        return this.beta;
    }

    public void setAlphaAndBeta(double d, double d2) {
        this.alpha = d;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.beta = d2;
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.reportTheNeedToProject(3);
    }

    public void setZoom(double d) {
        this.zoom = d;
        this.computeConstants(6);
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setRatioToCenter(double d) {
        this.ratioToCenter = d;
        this.computeConstants(7);
    }

    public double getRatioToCenter() {
        return this.ratioToCenter;
    }

    public void setRatioToPlane(double d) {
        this.ratioToPlane = d;
        this.computeConstants(8);
    }

    public double getRatioToPlane() {
        return this.ratioToPlane;
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4, double d5, double d6) {
        super.setPreferredMinMax(d, d2, d3, d4);
        this.setPreferredMinMaxZ(d5, d6);
    }

    public void setPreferredMinMaxZ(double d, double d2) {
        if (this.zminPreferred == d && this.zmaxPreferred == d2) {
            return;
        }
        if (Double.isNaN(d)) {
            d = this.yminPreferred;
        }
        if (Double.isNaN(d2)) {
            d2 = this.ymaxPreferred;
        }
        this.autoscaleZ = false;
        if (d == d2) {
            d = 0.9 * d - 0.5;
            d2 = 1.1 * d2 + 0.5;
        }
        this.zminPreferred = d;
        this.zmaxPreferred = d2;
        this.invalidateImage();
    }

    public double getPreferredZMax() {
        return this.zmaxPreferred;
    }

    public double getPreferredZMin() {
        return this.zminPreferred;
    }

    public double getZMin() {
        return this.zmin;
    }

    public double getZMax() {
        return this.zmax;
    }

    public void limitAutoscaleZ(double d, double d2) {
        if (d2 - d < (double)1.4E-45f) {
            d = 0.9 * d - (double)1.4E-45f;
            d2 = 1.1 * d2 + (double)1.4E-45f;
        }
        this.zfloor = d;
        this.zceil = d2;
        this.invalidateImage();
    }

    protected void scale(ArrayList arrayList) {
        super.scale(arrayList);
        if (this.autoscaleZ) {
            this.scaleZ(arrayList);
        }
    }

    public void setEnabled(boolean bl) {
        this.respondToMouse = bl;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(int n, boolean bl) {
        this.respondToMouse = bl;
    }

    public boolean isEnabled(int n) {
        return true;
    }

    public void addListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public void removeListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    public void removeAllListeners() {
        this.listeners = new ArrayList();
    }

    public void invokeActions(InteractionEvent interactionEvent) {
        for (InteractionListener interactionListener : this.listeners) {
            interactionListener.interactionPerformed(interactionEvent);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.xAxis != null) {
            int n = 0;
            int n2 = this.boxSides.length;
            while (n < n2) {
                this.boxSides[n].getStyle().setEdgeColor(color);
                ++n;
            }
            this.xAxis.getStyle().setEdgeColor(color);
            this.xText.getStyle().setEdgeColor(color);
            this.yAxis.getStyle().setEdgeColor(color);
            this.yText.getStyle().setEdgeColor(color);
            this.zAxis.getStyle().setEdgeColor(color);
            this.zText.getStyle().setEdgeColor(color);
            n = 0;
            n2 = this.trackerLines.length;
            while (n < n2) {
                this.trackerLines[n].getStyle().setEdgeColor(color.brighter().brighter());
                ++n;
            }
        }
    }

    public void setPixelScale() {
        double d = this.xmin;
        double d2 = this.xmax;
        double d3 = this.ymin;
        double d4 = this.ymax;
        double d5 = this.zmin;
        double d6 = this.zmax;
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        this.zmin = this.zminPreferred;
        this.zmax = this.zmaxPreferred;
        if (d != this.xmin || d2 != this.xmax || d3 != this.ymin || d4 != this.ymax || d5 != this.zmin || d6 != this.zmax) {
            this.computeConstants(9);
        }
    }

    public void clear() {
        super.clear();
        int n = 0;
        int n2 = this.boxSides.length;
        while (n < n2) {
            this.addDrawable(this.boxSides[n]);
            ++n;
        }
        this.addDrawable(this.xAxis);
        this.addDrawable(this.xText);
        this.addDrawable(this.yAxis);
        this.addDrawable(this.yText);
        this.addDrawable(this.zAxis);
        this.addDrawable(this.zText);
        n = 0;
        n2 = this.trackerLines.length;
        while (n < n2) {
            this.addDrawable(this.trackerLines[n]);
            ++n;
        }
    }

    public void paintDrawableList(Graphics graphics, ArrayList arrayList) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Iterator iterator = arrayList.iterator();
        Shape shape = graphics2D.getClip();
        int n = this.getWidth() - this.leftGutter - this.rightGutter;
        int n2 = this.getHeight() - this.bottomGutter - this.topGutter;
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.clipAtGutter) {
            graphics2D.clipRect(this.leftGutter, this.topGutter, n, n2);
        }
        if (this.quickRedrawOn || !this.removeHiddenLines) {
            while (iterator.hasNext()) {
                if (this.isValidImage()) {
                    Drawable drawable = (Drawable)iterator.next();
                    if (drawable instanceof Drawable3D) {
                        ((Drawable3D)drawable).drawQuickly(this, graphics2D);
                        continue;
                    }
                    drawable.draw(this, graphics2D);
                    continue;
                }
                break;
            }
        } else {
            int n3;
            Object[] objectArray;
            this.list3D.clear();
            while (iterator.hasNext()) {
                if (!this.isValidImage()) break;
                objectArray = (Object[])iterator.next();
                if (objectArray instanceof Drawable3D) {
                    Object3D[] object3DArray = ((Drawable3D)objectArray).getObjects3D(this);
                    if (object3DArray == null) continue;
                    n3 = 0;
                    int n4 = object3DArray.length;
                    while (n3 < n4) {
                        if (object3DArray[n3] != null && !Double.isNaN(object3DArray[n3].distance)) {
                            this.list3D.add(object3DArray[n3]);
                        }
                        ++n3;
                    }
                    continue;
                }
                objectArray.draw(this, graphics2D);
            }
            if (this.list3D.size() > 0) {
                objectArray = this.list3D.toArray();
                Arrays.sort(objectArray, this.comparator);
                int n5 = 0;
                n3 = objectArray.length;
                while (n5 < n3) {
                    Object3D object3D = (Object3D)objectArray[n5];
                    object3D.drawable3D.draw(this, graphics2D, object3D.index);
                    ++n5;
                }
            }
        }
        graphics2D.setClip(shape);
    }

    public double[] project(double[] dArray, double[] dArray2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = dArray[0] - this.centerX;
        double d6 = dArray[1] - this.centerY;
        double d7 = 0.0;
        switch (dArray.length) {
            case 2: 
            case 4: {
                d7 = 0.0;
                break;
            }
            case 3: 
            case 6: {
                d7 = dArray[2] - this.centerZ;
                break;
            }
            default: {
                throw new IllegalArgumentException("Method project not supported for this length.");
            }
        }
        switch (this.displayMode) {
            case 0: {
                d4 = d7;
                d3 = d5;
                d2 = d6;
                d = 1.8;
                break;
            }
            case 1: {
                d4 = d6;
                d3 = d5;
                d2 = d7;
                d = 1.8;
                break;
            }
            case 2: {
                d4 = d5;
                d3 = d6;
                d2 = d7;
                d = 1.8;
                break;
            }
            case 12: {
                d4 = d5 * this.cosAlpha + d6 * this.sinAlpha;
                d3 = -d5 * this.sinAlpha + d6 * this.cosAlpha;
                d2 = -d4 * this.sinBeta + d7 * this.cosBeta;
                d4 = d4 * this.cosBeta + d7 * this.sinBeta;
                d = 1.3;
                break;
            }
            default: {
                d4 = d5 * this.cosAlpha + d6 * this.sinAlpha;
                d3 = -d5 * this.sinAlpha + d6 * this.cosAlpha;
                d2 = -d4 * this.sinBeta + d7 * this.cosBeta;
                d4 = d4 * this.cosBeta + d7 * this.sinBeta;
                double d8 = this.viewToCenter - d4;
                if (Math.abs(d8) < 0.01) {
                    d8 = 0.01;
                }
                d = this.viewToPlane / d8;
            }
        }
        dArray2[0] = (double)this.acenter + d3 * d * this.aconstant;
        dArray2[1] = (double)this.bcenter - d2 * d * this.bconstant;
        switch (dArray.length) {
            case 2: 
            case 3: {
                dArray2[2] = (this.viewToCenter - d4) / this.viewToCenter;
                break;
            }
            case 4: {
                dArray2[2] = dArray[2] * d * this.aconstant;
                dArray2[3] = dArray[3] * d * this.bconstant;
                dArray2[4] = (this.viewToCenter - d4) / this.viewToCenter;
                break;
            }
            case 6: {
                switch (this.displayMode) {
                    case 0: {
                        dArray2[2] = dArray[3] * d * this.aconstant;
                        dArray2[3] = dArray[4] * d * this.bconstant;
                        break;
                    }
                    case 1: {
                        dArray2[2] = dArray[3] * d * this.aconstant;
                        dArray2[3] = dArray[5] * d * this.bconstant;
                        break;
                    }
                    case 2: {
                        dArray2[2] = dArray[4] * d * this.aconstant;
                        dArray2[3] = dArray[5] * d * this.bconstant;
                        break;
                    }
                    default: {
                        dArray2[2] = Math.max(dArray[3], dArray[4]) * d * this.aconstant;
                        dArray2[3] = dArray[5] * d * this.bconstant;
                    }
                }
                dArray2[4] = (this.viewToCenter - d4) / this.viewToCenter;
            }
        }
        return dArray2;
    }

    public Color projectColor(Color color, double d) {
        if (!this.useColorDepth) {
            return color;
        }
        try {
            color.getRGBComponents(this.crc);
            int n = 0;
            while (n < 3) {
                int n2 = n;
                this.crc[n2] = (float)((double)this.crc[n2] / d);
                this.crc[n] = (float)Math.max(Math.min((double)this.crc[n], 1.0), 0.0);
                ++n;
            }
            return new Color(this.crc[0], this.crc[1], this.crc[2], this.crc[3]);
        }
        catch (Exception exception) {
            return color;
        }
    }

    private Point3D worldPoint(int n, int n2) {
        double d = 1.8;
        switch (this.displayMode) {
            case 0: {
                return new Point3D(this.centerX + (double)(n - this.acenter) / (d * this.aconstant), this.centerY + (double)(this.bcenter - n2) / (d * this.bconstant), this.zmax);
            }
            case 1: {
                return new Point3D(this.centerX + (double)(n - this.acenter) / (d * this.aconstant), this.ymax, this.centerZ + (double)(this.bcenter - n2) / (d * this.bconstant));
            }
            case 2: {
                return new Point3D(this.xmax, this.centerY + (double)(n - this.acenter) / (d * this.aconstant), this.centerZ + (double)(this.bcenter - n2) / (d * this.bconstant));
            }
        }
        return new Point3D((this.xmin + this.xmax) / 2.0, (this.ymin + this.ymax) / 2.0, (this.zmin + this.zmax) / 2.0);
    }

    private Point3D worldDistance(int n, int n2) {
        double d = 1.8;
        switch (this.displayMode) {
            case 0: {
                return new Point3D((double)n / (d * this.aconstant), (double)(-n2) / (d * this.bconstant), 0.0);
            }
            case 1: {
                return new Point3D((double)n / (d * this.aconstant), 0.0, (double)(-n2) / (d * this.bconstant));
            }
            case 2: {
                return new Point3D(0.0, (double)n / (d * this.aconstant), (double)(-n2) / (d * this.bconstant));
            }
        }
        return new Point3D((double)n / (1.3 * this.aconstant), (double)n2 / (1.3 * this.bconstant), 0.0);
    }

    public boolean isFocusable() {
        return true;
    }

    private boolean mouseDraggedComputations(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            this.setPan(this.deltaa + (mouseEvent.getX() - this.lastX), this.deltab + (mouseEvent.getY() - this.lastY));
            return false;
        }
        if (mouseEvent.isShiftDown()) {
            this.setZoom(this.zoom - (double)(mouseEvent.getY() - this.lastY) * 0.01);
            return false;
        }
        if (this.displayMode >= 10 && this.iad == null && !mouseEvent.isAltDown()) {
            this.setAlphaAndBeta(this.alpha - (double)(mouseEvent.getX() - this.lastX) * 0.01, this.beta + (double)(mouseEvent.getY() - this.lastY) * 0.01);
            return false;
        }
        Point3D point3D = this.worldDistance(mouseEvent.getX() - this.lastX, mouseEvent.getY() - this.lastY);
        if (this.displayMode < 10) {
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint.x += point3D.x;
                    break;
                }
                case 89: {
                    this.trackerPoint.y += point3D.y;
                    break;
                }
                case 90: {
                    this.trackerPoint.z += point3D.z;
                    break;
                }
                default: {
                    this.trackerPoint.x += point3D.x;
                    this.trackerPoint.y += point3D.y;
                    this.trackerPoint.z += point3D.z;
                    break;
                }
            }
        } else {
            int n = 1;
            if (this.cosBeta < 0.0) {
                n = -1;
            }
            switch (this.keyPressed) {
                case 88: {
                    if (this.cosAlpha >= 0.0 && Math.abs(this.sinAlpha) < this.cosAlpha) {
                        this.trackerPoint.x += point3D.y;
                        break;
                    }
                    if (this.sinAlpha >= 0.0 && Math.abs(this.cosAlpha) < this.sinAlpha) {
                        this.trackerPoint.x -= point3D.x;
                        break;
                    }
                    if (this.cosAlpha < 0.0 && Math.abs(this.sinAlpha) < -this.cosAlpha) {
                        this.trackerPoint.x -= point3D.y;
                        break;
                    }
                    this.trackerPoint.x += point3D.x;
                    break;
                }
                case 89: {
                    if (this.cosAlpha >= 0.0 && Math.abs(this.sinAlpha) < this.cosAlpha) {
                        this.trackerPoint.y += point3D.x;
                        break;
                    }
                    if (this.sinAlpha >= 0.0 && Math.abs(this.cosAlpha) < this.sinAlpha) {
                        this.trackerPoint.y += point3D.y;
                        break;
                    }
                    if (this.cosAlpha < 0.0 && Math.abs(this.sinAlpha) < -this.cosAlpha) {
                        this.trackerPoint.y -= point3D.x;
                        break;
                    }
                    this.trackerPoint.y -= point3D.y;
                    break;
                }
                case 90: {
                    if (this.cosBeta >= 0.0) {
                        this.trackerPoint.z -= point3D.y;
                        break;
                    }
                    this.trackerPoint.z += point3D.y;
                    break;
                }
                default: {
                    this.trackerPoint.z -= (double)n * point3D.y;
                    if (this.cosAlpha >= 0.0 && Math.abs(this.sinAlpha) < this.cosAlpha) {
                        this.trackerPoint.y += point3D.x;
                        break;
                    }
                    if (this.sinAlpha >= 0.0 && Math.abs(this.cosAlpha) < this.sinAlpha) {
                        this.trackerPoint.x -= point3D.x;
                        break;
                    }
                    if (this.cosAlpha < 0.0 && Math.abs(this.sinAlpha) < -this.cosAlpha) {
                        this.trackerPoint.y -= point3D.x;
                        break;
                    }
                    this.trackerPoint.x += point3D.x;
                }
            }
        }
        return true;
    }

    private void resetInteraction(InteractivePanel interactivePanel) {
        this.iad = null;
        this.targetHit = null;
        this.showTrackers(false);
        this.blMessageBox.setText(null);
        this.repaint();
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        switch (interactivePanel.getMouseAction()) {
            case 1: {
                this.requestFocus();
                if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                    return;
                }
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                this.targetHit = null;
                this.iad = interactivePanel.getInteractive();
                if (this.iad instanceof InteractionTarget) {
                    this.targetHit = (InteractionTarget)this.iad;
                    this.trackerPoint = this.targetHit.getHotspot(interactivePanel);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    this.trackerPoint = this.targetHit.getHotspot(interactivePanel);
                } else if (this.iad != null) {
                    if (!this.iad.isEnabled()) {
                        return;
                    }
                    switch (this.displayMode) {
                        default: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.y = this.iad.getY();
                            this.trackerPoint.z = this.zmax;
                            break;
                        }
                        case 1: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.y = this.ymax;
                            break;
                        }
                        case 2: {
                            this.trackerPoint.y = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.x = this.xmax;
                        }
                    }
                    this.invokeActions(new InteractionEvent((Object)this, 2000, null, this.iad));
                    switch (this.displayMode) {
                        default: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.y = this.iad.getY();
                            this.trackerPoint.z = this.zmax;
                            break;
                        }
                        case 1: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.y = this.ymax;
                            break;
                        }
                        case 2: {
                            this.trackerPoint.y = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.x = this.xmax;
                            break;
                        }
                    }
                } else if (this.displayMode < 10 || mouseEvent.isAltDown()) {
                    this.trackerPoint = this.worldPoint(mouseEvent.getX(), mouseEvent.getY());
                    this.invokeActions(new InteractionEvent((Object)this, 2000, null, this.trackerPoint));
                } else {
                    this.invokeActions(new InteractionEvent((Object)this, 2000, null, null));
                    this.resetInteraction(interactivePanel);
                    return;
                }
                if (this.showPosition) {
                    this.displayPosition(this.trackerPoint.x, this.trackerPoint.y, this.trackerPoint.z);
                }
                this.positionTrackers();
                this.showTrackers(true);
                interactivePanel.repaint();
                break;
            }
            case 3: {
                if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                    return;
                }
                if (this.iad != null && !this.iad.isEnabled()) {
                    return;
                }
                this.quickRedrawOn = this.allowQuickRedraw && this.keyPressed != 83;
                boolean bl = this.mouseDraggedComputations(mouseEvent);
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                if (!bl) {
                    this.invokeActions(new InteractionEvent((Object)this, 2001, null, null));
                    this.resetInteraction(interactivePanel);
                    return;
                }
                if (this.targetHit != null) {
                    this.targetHit.updateHotspot(interactivePanel, this.trackerPoint);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2001, null, this.targetHit));
                    this.trackerPoint = this.targetHit.getHotspot(interactivePanel);
                } else if (this.iad != null) {
                    this.invokeActions(new InteractionEvent((Object)this, 2001, null, this.iad));
                } else {
                    this.invokeActions(new InteractionEvent((Object)this, 2001, null, this.trackerPoint));
                }
                if (this.showPosition) {
                    this.displayPosition(this.trackerPoint.x, this.trackerPoint.y, this.trackerPoint.z);
                }
                this.positionTrackers();
                this.showTrackers(true);
                interactivePanel.repaint();
                break;
            }
            case 2: {
                if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                    return;
                }
                if (this.iad != null && !this.iad.isEnabled()) {
                    return;
                }
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                } else if (this.iad != null) {
                    this.invokeActions(new InteractionEvent((Object)this, 2002, null, this.iad));
                } else if (this.displayMode < 10 || mouseEvent.isAltDown()) {
                    this.invokeActions(new InteractionEvent((Object)this, 2002, null, this.trackerPoint));
                } else {
                    this.invokeActions(new InteractionEvent((Object)this, 2002, null, null));
                }
                this.quickRedrawOn = false;
                this.resetInteraction(interactivePanel);
                break;
            }
            case 6: {
                this.invokeActions(new InteractionEvent((Object)this, 2004, null, null));
                break;
            }
            case 5: {
                this.invokeActions(new InteractionEvent((Object)this, 2003, null, null));
                break;
            }
            case 7: {
                if (interactivePanel.getInteractive() != null) {
                    interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                } else {
                    interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
                this.invokeActions(new InteractionEvent((Object)this, 2005, null, null));
            }
        }
    }

    private void reportTheNeedToProject(int n) {
        ArrayList arrayList = (ArrayList)this.drawableList.clone();
        for (Object e : arrayList) {
            if (!(e instanceof Drawable3D)) continue;
            ((Drawable3D)e).needsToProject(this);
        }
    }

    private void computeConstants(int n) {
        double d;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        this.acenter = this.deltaa + n2 / 2;
        this.bcenter = this.deltab + n3 / 2;
        if (this.squareAspect) {
            n2 = n3 = Math.min(n2, n3);
        }
        double d2 = this.xmax - this.xmin;
        double d3 = this.ymax - this.ymin;
        double d4 = this.zmax - this.zmin;
        switch (this.displayMode) {
            case 0: {
                d = Math.max(d2, d3);
                break;
            }
            case 1: {
                d = Math.max(d2, d4);
                break;
            }
            case 2: {
                d = Math.max(d3, d4);
                break;
            }
            default: {
                d = Math.max(Math.max(d2, d3), d4);
            }
        }
        this.centerX = (this.xmax + this.xmin) / 2.0;
        this.centerY = (this.ymax + this.ymin) / 2.0;
        this.centerZ = (this.zmax + this.zmin) / 2.0;
        this.aconstant = 0.5 * this.zoom * (double)n2 / d;
        this.bconstant = 0.5 * this.zoom * (double)n3 / d;
        this.viewToPlane = this.ratioToPlane * d;
        this.viewToCenter = this.ratioToCenter * d;
        this.resetDecoration(d2, d3, d4);
        this.reportTheNeedToProject(3);
    }

    private void scaleZ(ArrayList arrayList) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        boolean bl = false;
        for (Object e : arrayList) {
            Measurable3D measurable3D;
            if (!(e instanceof Measurable3D) || !(measurable3D = (Measurable3D)e).isMeasured() || Double.isNaN(measurable3D.getZMax()) || Double.isNaN(measurable3D.getZMin())) continue;
            d = Math.min(d, measurable3D.getZMin());
            d = Math.min(d, measurable3D.getZMax());
            d2 = Math.max(d2, measurable3D.getZMax());
            d2 = Math.max(d2, measurable3D.getZMin());
            bl = true;
        }
        if (bl) {
            if (d == d2) {
                d = 0.9 * d - 0.5;
                d2 = 1.1 * d2 + 0.5;
            }
            double d3 = d2 - d;
            this.zminPreferred = d - this.autoscaleMargin * d3;
            this.zmaxPreferred = d2 + this.autoscaleMargin * d3;
        }
        if (!Double.isNaN(this.zfloor)) {
            this.zminPreferred = Math.min(this.zfloor, this.zminPreferred);
        }
        if (!Double.isNaN(this.zceil)) {
            this.zmaxPreferred = Math.max(this.zceil, this.zmaxPreferred);
        }
    }

    private void displayPosition(double d, double d2, double d3) {
        switch (this.displayMode) {
            case 0: {
                this.blMessageBox.setText(String.valueOf(this.xFormat.format(d)) + " " + this.yFormat.format(d2));
                break;
            }
            case 1: {
                this.blMessageBox.setText(String.valueOf(this.xFormat.format(d)) + " " + this.zFormat.format(d3));
                break;
            }
            case 2: {
                this.blMessageBox.setText(String.valueOf(this.yFormat.format(d2)) + " " + this.zFormat.format(d3));
                break;
            }
            default: {
                this.blMessageBox.setText(String.valueOf(this.xFormat.format(d)) + " " + this.yFormat.format(d2) + " " + this.zFormat.format(d3));
            }
        }
    }

    private void showTrackers(boolean bl) {
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            if (n < this.trackersVisible) {
                this.trackerLines[n].setVisible(bl);
            } else {
                this.trackerLines[n].setVisible(false);
            }
            ++n;
        }
    }

    private void positionTrackers() {
        switch (this.cursorMode) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(this.trackerPoint.x, this.ymin, this.zmin);
                this.trackerLines[0].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                this.trackerLines[1].setXYZ(this.xmin, this.trackerPoint.y, this.zmin);
                this.trackerLines[1].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint.x, this.trackerPoint.y, this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint.y, this.trackerPoint.z);
                this.trackerLines[0].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint.x, this.ymin, this.trackerPoint.z);
                this.trackerLines[1].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint.x, this.trackerPoint.y, this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                this.trackerLines[3].setXYZ(this.trackerPoint.x, this.ymin, this.zmin);
                this.trackerLines[3].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                this.trackerLines[4].setXYZ(this.xmin, this.trackerPoint.y, this.zmin);
                this.trackerLines[4].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[5].setXYZ(this.trackerPoint.x, this.ymin, this.zmin);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                this.trackerLines[6].setXYZ(this.xmin, this.ymin, this.trackerPoint.z);
                this.trackerLines[6].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[7].setXYZ(this.xmin, this.trackerPoint.y, this.zmin);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                this.trackerLines[8].setXYZ(this.xmin, this.ymin, this.trackerPoint.z);
                this.trackerLines[8].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint.y, this.trackerPoint.z);
                this.trackerLines[0].setSizeXYZ(this.xmax - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint.x, this.ymin, this.trackerPoint.z);
                this.trackerLines[1].setSizeXYZ(0.0, this.ymax - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint.x, this.trackerPoint.y, this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.zmax - this.zmin);
            }
        }
    }

    private void resetDecoration(double d, double d2, double d3) {
        if (this.boxSides == null || this.boxSides[0] == null) {
            return;
        }
        this.boxSides[0].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[0].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[1].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[1].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[2].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[2].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[3].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[3].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[4].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[4].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[5].setXYZ(this.xmax, this.ymin, this.zmax);
        this.boxSides[5].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[6].setXYZ(this.xmin, this.ymax, this.zmax);
        this.boxSides[6].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[7].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[7].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[8].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[8].setSizeXYZ(0.0, 0.0, d3);
        this.boxSides[9].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[9].setSizeXYZ(0.0, 0.0, d3);
        this.boxSides[10].setXYZ(this.xmax, this.ymax, this.zmin);
        this.boxSides[10].setSizeXYZ(0.0, 0.0, d3);
        this.boxSides[11].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[11].setSizeXYZ(0.0, 0.0, d3);
        this.xAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.xAxis.setSizeXYZ(d, 0.0, 0.0);
        this.xText.setXYZ(this.xmax + d * 0.02, this.ymin, this.zmin);
        this.yAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.yAxis.setSizeXYZ(0.0, d2, 0.0);
        this.yText.setXYZ(this.xmin, this.ymax + d * 0.02, this.zmin);
        this.zAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.zAxis.setSizeXYZ(0.0, 0.0, d3);
        this.zText.setXYZ(this.xmin, this.ymin, this.zmax + d * 0.02);
    }
}

