/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlFrame
extends ControlWindow {
    private static final int FRAME_ADDED = 6;
    private static final int FRAME_NAME = 11;
    protected JFrame frame;
    protected String iconImageFile = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        Image image;
        this.startingup = true;
        this.frame = new JFrame(EjsControl.getDefaultGraphicsConfiguration());
        this.frame.getContentPane().setLayout(new BorderLayout());
        String string = Simulation.getPathToLibrary();
        if (!string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        if ((image = ResourceLoader.getImage(String.valueOf(string) + "_ejs_library/images/EjsMainIcon.gif")) != null) {
            this.frame.setIconImage(image);
        }
        this.frame.setDefaultCloseOperation(1);
        this.internalValue = new BooleanValue(true);
        this.frame.getContentPane().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlFrame.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlFrame.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlFrame.this.printScreen();
                    }
                }
            }
        });
        this.frame.getContentPane().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ControlFrame.this.getSimulation() != null && OSPRuntime.isPopupTrigger(mouseEvent)) {
                    ControlFrame.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return this.frame.getContentPane();
    }

    @Override
    public String getObjectClassname() {
        return "java.awt.Component";
    }

    @Override
    public Object getObject() {
        return this.frame;
    }

    @Override
    protected JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.frame.getJMenuBar();
    }

    @Override
    protected void whenClosing() {
        super.whenClosing();
        if (this.frame.getDefaultCloseOperation() == 3 || this.frame.getDefaultCloseOperation() == 2) {
            this.invokeActions();
            if (this.getSimulation() != null) {
                this.getSimulation().onExit();
            }
        }
    }

    @Override
    protected int getVisibleIndex() {
        return 15;
    }

    @Override
    protected int getLocationIndex() {
        return 7;
    }

    @Override
    protected int getSizeIndex() {
        return 16;
    }

    @Override
    public Component getComponent() {
        return this.frame;
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    @Override
    public Container getContainer() {
        return this.frame.getContentPane();
    }

    @Override
    public void add(final ControlElement controlElement) {
        if (!(controlElement.getVisual() instanceof JMenuBar)) {
            super.add(controlElement);
            return;
        }
        this.children.add(controlElement);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlFrame.this.menubar = (JMenuBar)controlElement.getVisual();
                ControlFrame.this.frame.setJMenuBar(ControlFrame.this.menubar);
                ControlFrame.this.adjustSize();
            }
        });
        ((ControlSwingElement)controlElement).setControlWindow(this);
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement controlElement) {
        if (!(controlElement.getVisual() instanceof JMenuBar)) {
            super.remove(controlElement);
            return;
        }
        this.children.remove(controlElement);
        ((ControlSwingElement)controlElement).setControlWindow(null);
        this.menubar = null;
        this.frame.setJMenuBar(null);
        this.adjustSize();
        this.frame.validate();
        this.frame.repaint();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("exit");
            infoList.add("onExit");
            infoList.add("image");
            infoList.add("glasspane");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("resizable")) {
            return "boolean";
        }
        if (string.equals("exit")) {
            return "boolean CONSTANT";
        }
        if (string.equals("onExit")) {
            return "Action CONSTANT";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("glasspane")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.frame.setTitle(String.valueOf(TeXParser.parseTeX(value.getString())) + " " + string);
                    break;
                }
                this.frame.setTitle(TeXParser.parseTeX(value.getString()));
                break;
            }
            case 1: {
                this.frame.setResizable(value.getBoolean());
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                if (value.getBoolean()) {
                    this.frame.setDefaultCloseOperation(OSPRuntime.appletMode ? 2 : 3);
                    break;
                }
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                if (value.getString().equals(this.iconImageFile)) {
                    return;
                }
                this.iconImageFile = value.getString();
                this.frame.setIconImage(this.getIcon(this.iconImageFile).getImage());
                break;
            }
            case 5: {
                this.frame.getGlassPane().setVisible(value.getBoolean());
                break;
            }
            case 11: {
                super.setValue(5, value);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                String string = this.getGroup().getReplaceOwnerName();
                if (string != null && string.equals(value.getString())) {
                    this.getGroup().setOwnerFrame(this.getGroup().getReplaceOwnerFrame());
                    break;
                }
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.frame.setTitle(string);
                    break;
                }
                this.frame.setTitle("");
                break;
            }
            case 1: {
                this.frame.setResizable(true);
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                break;
            }
            case 4: {
                this.iconImageFile = null;
                this.frame.setIconImage(null);
                break;
            }
            case 5: {
                this.frame.getGlassPane().setVisible(false);
                break;
            }
            case 11: {
                super.setDefaultValue(5);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "<none>";
            }
            case 3: {
                return "<no_action>";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "false";
            }
        }
        return super.getDefaultValueString(n - 6);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }
}

