/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import ch.epfl.cockpit.communication.DatasFile;
import ch.epfl.cockpit.communication.GraphicsFile;
import ch.epfl.cockpit.communication.HashTableMessage;
import ch.epfl.cockpit.communication.Message;
import ch.epfl.cockpit.communication.ParamsFileXML;
import ch.epfl.cockpit.communication.Request;
import ch.epfl.cockpit.communication.ServletMessenger;
import ch.epfl.cockpit.communication.TextFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.colos.ejs.library.EmersionLink;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.SwingWorker;

public class EmersionConnection
implements EmersionLink {
    private URL eMersionURL = null;
    private String eMersionSessionID = null;
    private Component parentComponent = null;
    private Simulation simulation = null;
    private SavePanel savePanel = new SavePanel();
    private ReadPanel readPanel = new ReadPanel();
    private ProgressDialog progressMonitor;
    private LongTask task;
    private Timer timer;
    private int previous;

    public EmersionConnection(JApplet jApplet, Simulation simulation) {
        this.simulation = simulation;
        String string = jApplet.getParameter("eMersionURL");
        try {
            this.eMersionURL = new URL(string);
            this.eMersionSessionID = jApplet.getParameter("eMersionSessionID");
        }
        catch (MalformedURLException malformedURLException) {
            if (string != null) {
                System.out.println("Malformed URL exception for URL = <" + string + ">");
            }
            this.eMersionURL = null;
            this.eMersionSessionID = null;
        }
    }

    public boolean isConnected() {
        return this.eMersionURL != null && this.eMersionSessionID != null;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setNameLabel(String string) {
        this.savePanel.nameLabel.setText(string);
    }

    public void setAnnotationLabel(String string) {
        this.savePanel.annotationLabel.setText(string);
    }

    private void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Delay interrupted!");
        }
    }

    public String saveBinary(String string, String string2, byte[] byArray) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        this.task = new LongTask(string, string2, byArray);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public String saveImage(String string, String string2, Image image) {
        if (!this.isConnected()) {
            return null;
        }
        if (!string.toLowerCase().endsWith(".gif")) {
            string = String.valueOf(string) + ".gif";
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        if (string.toLowerCase().endsWith(".gif")) {
            string = string.substring(0, string.length() - 4);
        }
        this.task = new LongTask(string, string2, image);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public String saveText(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        this.task = new LongTask(string, string2, string3, true);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public String saveXML(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        this.task = new LongTask(string, string2, string3, false);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    public byte[] readBinary(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_binary_set");
        if (string2 == null) {
            return null;
        }
        ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_binary_set");
        request.setFragID(string2);
        try {
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            System.out.println("Response:" + message.toString());
            System.out.println("Response feedback:" + message.getStatus());
            DatasFile datasFile = (DatasFile)message;
            return datasFile.getContent();
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    public String readText(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_text_set");
        if (string2 == null) {
            return null;
        }
        ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_text_set");
        request.setFragID(string2);
        try {
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            System.out.println("Response:" + message.toString());
            System.out.println("Response feedback:" + message.getStatus());
            TextFile textFile = (TextFile)message;
            String string3 = textFile.getText();
            return string3;
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    public String readXML(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_params_set");
        if (string2 == null) {
            return null;
        }
        ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_params_set");
        request.setFragID(string2);
        try {
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            System.out.println("Response:" + message.toString());
            System.out.println("Response feedback:" + message.getStatus());
            ParamsFileXML paramsFileXML = (ParamsFileXML)message;
            String string3 = paramsFileXML.getParamsXML();
            return string3;
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    public Image readImage(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_binary_set");
        System.out.println("File for reading image from eMersion is " + string2);
        return null;
    }

    private Component getParentComponent() {
        if (this.simulation != null) {
            return this.simulation.getParentComponent();
        }
        return this.parentComponent;
    }

    private void showException(Exception exception) {
        exception.printStackTrace();
        System.out.println("A dialog should appear now");
        JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
    }

    static /* synthetic */ void access$4(EmersionConnection emersionConnection, int n) {
        emersionConnection.delay(n);
    }

    private class LongTask {
        private int lengthOfTask;
        private int current = 0;
        private String statMessage;
        private String filename;
        private String annotation;
        private Image image;
        private String txt;
        private byte[] data;
        private boolean isText;
        private String kindFragment;
        private boolean isOk = false;

        LongTask(String string, String string2, Image image) {
            this.kindFragment = "image";
            this.filename = string;
            this.annotation = string2;
            this.image = image;
            this.lengthOfTask = 100;
        }

        LongTask(String string, String string2, String string3, boolean bl) {
            this.kindFragment = "text";
            this.filename = string;
            this.annotation = string2;
            this.txt = string3;
            this.isText = bl;
            this.lengthOfTask = 100;
        }

        LongTask(String string, String string2, byte[] byArray) {
            this.kindFragment = "data";
            this.filename = string;
            this.annotation = string2;
            this.data = byArray;
            this.lengthOfTask = 100;
        }

        void go() {
            this.current = 0;
            new SwingWorker(){

                public Object construct() {
                    if (LongTask.this.kindFragment.equals("image")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.image);
                    }
                    if (LongTask.this.kindFragment.equals("text")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.txt, LongTask.this.isText);
                    }
                    return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.data);
                }
            };
        }

        int getCurrent() {
            return this.current;
        }

        void stop() {
            this.current = this.lengthOfTask;
        }

        boolean getStatus() {
            return this.isOk;
        }

        boolean done() {
            return this.current >= this.lengthOfTask;
        }

        String getMessage() {
            return this.statMessage;
        }

        static /* synthetic */ void access$0(LongTask longTask, int n) {
            longTask.current = n;
        }

        static /* synthetic */ int access$1(LongTask longTask) {
            return longTask.current;
        }

        static /* synthetic */ void access$2(LongTask longTask, String string) {
            longTask.statMessage = string;
        }

        static /* synthetic */ int access$3(LongTask longTask) {
            return longTask.lengthOfTask;
        }

        static /* synthetic */ void access$4(LongTask longTask, boolean bl) {
            longTask.isOk = bl;
        }

        static /* synthetic */ EmersionConnection access$12(LongTask longTask) {
            return longTask.EmersionConnection.this;
        }

        /*
         * Exception performing whole class analysis.
         */
        class ActualTask {
            final /* synthetic */ LongTask this$1;

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, Image var4_4) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var5_5 = 0;
                        while (var5_5 < 50) {
                            LongTask.access$0(var1_1, var5_5);
                            EmersionConnection.access$4(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + 100 + "%.");
                            ++var5_5;
                        }
                        var5_6 = new ServletMessenger(EmersionConnection.access$1(LongTask.access$12(var1_1)));
                        var6_8 = new GraphicsFile(EmersionConnection.access$2(LongTask.access$12(var1_1)), var2_2, var4_4);
                        var6_8.setAnnotation(var3_3);
                        var5_6.send(var6_8);
                        var7_10 = 50;
                        while (var7_10 < 101) {
                            LongTask.access$0(var1_1, var7_10);
                            EmersionConnection.access$4(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var7_10;
                        }
                        break block5;
                    }
                    catch (Exception var5_7) {
                        EmersionConnection.access$3(LongTask.access$12(var1_1), var5_7);
                        var6_9 = 50;
                        ** while (var6_9 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var6_9);
                        EmersionConnection.access$4(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var6_9;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, String var4_4, boolean var5_5) {
                block7: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var6_6 = 0;
                        while (var6_6 < 50) {
                            LongTask.access$0(var1_1, var6_6);
                            EmersionConnection.access$4(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++var6_6;
                        }
                        if (LongTask.access$5(var1_1)) {
                            var6_7 = new ServletMessenger(EmersionConnection.access$1(LongTask.access$12(var1_1)));
                            var7_10 /* !! */  = new TextFile(EmersionConnection.access$2(LongTask.access$12(var1_1)), var2_2, var3_3, var4_4);
                            var6_7.send(var7_10 /* !! */ );
                        } else {
                            var6_7 = new ServletMessenger(EmersionConnection.access$1(LongTask.access$12(var1_1)));
                            var7_10 /* !! */  = new ParamsFileXML(EmersionConnection.access$2(LongTask.access$12(var1_1)), var2_2, var3_3, var4_4);
                            var6_7.send(var7_10 /* !! */ );
                        }
                        var6_8 = 50;
                        while (var6_8 < 101) {
                            LongTask.access$0(var1_1, var6_8);
                            EmersionConnection.access$4(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var6_8;
                        }
                        break block7;
                    }
                    catch (Exception var6_9) {
                        EmersionConnection.access$3(LongTask.access$12(var1_1), var6_9);
                        var7_11 = 50;
                        ** while (var7_11 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var7_11);
                        EmersionConnection.access$4(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var7_11;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, byte[] var4_4) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var5_5 = 0;
                        while (var5_5 < 50) {
                            LongTask.access$0(var1_1, var5_5);
                            EmersionConnection.access$4(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++var5_5;
                        }
                        var5_6 = new ServletMessenger(EmersionConnection.access$1(LongTask.access$12(var1_1)));
                        var6_8 = new DatasFile(EmersionConnection.access$2(LongTask.access$12(var1_1)), var2_2, var3_3, var4_4);
                        var5_6.send(var6_8);
                        var7_10 = 50;
                        while (var7_10 < 101) {
                            LongTask.access$0(var1_1, var7_10);
                            EmersionConnection.access$4(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var7_10;
                        }
                        break block5;
                    }
                    catch (Exception var5_7) {
                        EmersionConnection.access$3(LongTask.access$12(var1_1), var5_7);
                        var6_9 = 50;
                        ** while (var6_9 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var6_9);
                        EmersionConnection.access$4(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var6_9;
                        continue;
                    }
                }
            }
        }
    }

    class ProgressDialog
    extends JDialog {
        private JProgressBar progressBar;
        private JLabel msg;
        private JLabel note;

        public ProgressDialog() {
            super(JOptionPane.getFrameForComponent(EmersionConnection.this.getParentComponent()), "Progress");
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.msg = new JLabel("Monitoring the Delivery");
            this.note = new JLabel("Initializing progress...");
            JPanel jPanel = new JPanel(new GridLayout(3, 0));
            jPanel.add(this.msg);
            jPanel.add(this.note);
            jPanel.add(this.progressBar);
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setContentPane(jPanel);
            this.setSize(380, 120);
            this.setLocation(300, 300);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressDialog.this.dispose();
                    EmersionConnection.this.progressMonitor.dispose();
                    EmersionConnection.this.progressMonitor = null;
                }
            });
        }

        public void setProgress(int n) {
            this.progressBar.setValue(n);
        }

        public void setNote(String string) {
            this.note.setText(string);
        }

        public void showProgressDialog(boolean bl) {
            this.setVisible(bl);
        }

        public void setBarIndeterminate(boolean bl) {
            this.progressBar.setIndeterminate(bl);
        }

        public void setBarString(String string) {
            this.progressBar.setString(string);
        }
    }

    private class ReadPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(this.listModel);

        ReadPanel() {
            this.list.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.setLayout(new BorderLayout());
            this.add((Component)jScrollPane, "Center");
        }

        String chooseFragment(String string) {
            ServletMessenger servletMessenger = new ServletMessenger(EmersionConnection.this.eMersionURL);
            Request request = new Request(EmersionConnection.this.eMersionSessionID, "list", string, true);
            try {
                int n;
                servletMessenger.send(request);
                Message message = (Message)servletMessenger.getFeedback();
                HashTableMessage hashTableMessage = (HashTableMessage)message;
                Hashtable hashtable = hashTableMessage.getContent();
                this.listModel.removeAllElements();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    this.listModel.addElement(enumeration.nextElement());
                }
                if (hashtable.size() > 0) {
                    this.list.setSelectedIndex(0);
                }
                if ((n = JOptionPane.showConfirmDialog(EmersionConnection.this.getParentComponent(), this, "eMersion", 2)) == 0) {
                    return (String)hashtable.get(this.list.getSelectedValue());
                }
            }
            catch (Exception exception) {
                EmersionConnection.this.showException(exception);
            }
            return null;
        }
    }

    private class SavePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel nameLabel = new JLabel("Name");
        JLabel annotationLabel;
        JTextField nameField;
        JTextField annotationField;

        SavePanel() {
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.nameField = new JTextField();
            this.nameField.setColumns(10);
            this.annotationLabel = new JLabel("Annotation");
            this.annotationLabel.setHorizontalAlignment(0);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.annotationField = new JTextField();
            this.annotationField.setColumns(10);
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.add(this.nameLabel);
            jPanel.add(this.annotationLabel);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            jPanel2.add(this.nameField);
            jPanel2.add(this.annotationField);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "West");
            this.add((Component)jPanel2, "Center");
        }

        boolean showSaveOptions(String string, String string2) {
            int n;
            if (string != null) {
                this.nameField.setText(string);
            }
            if (string2 != null) {
                this.annotationField.setText(string2);
            }
            return (n = JOptionPane.showConfirmDialog(EmersionConnection.this.getParentComponent(), this, "eMersion", 2)) == 0;
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EmersionConnection.this.task.done()) {
                if (EmersionConnection.this.task.getStatus()) {
                    EmersionConnection.this.progressMonitor.setProgress(100);
                    EmersionConnection.this.progressMonitor.setNote("Completed 100% out of 100%.");
                    EmersionConnection.this.progressMonitor.setBarString("Successful Delivery... Close this window and refresh eJournal");
                } else {
                    EmersionConnection.this.progressMonitor.setBarString("Sending with problems. Try it again!!!");
                    EmersionConnection.this.progressMonitor.setNote(EmersionConnection.this.task.getMessage());
                }
                EmersionConnection.this.task.stop();
                Toolkit.getDefaultToolkit().beep();
                EmersionConnection.this.timer.stop();
            } else {
                int n = EmersionConnection.this.task.getCurrent();
                if (n == EmersionConnection.this.previous) {
                    EmersionConnection.this.progressMonitor.setBarIndeterminate(true);
                    EmersionConnection.this.progressMonitor.setBarString("Sending Fragment... Please wait");
                } else {
                    EmersionConnection.this.progressMonitor.setBarIndeterminate(false);
                    EmersionConnection.this.progressMonitor.setBarString("Progress");
                }
                EmersionConnection.this.previous = n;
                EmersionConnection.this.progressMonitor.setNote(EmersionConnection.this.task.getMessage());
                EmersionConnection.this.progressMonitor.setProgress(n);
            }
        }
    }
}

