/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.cockpit.communication;

import ch.epfl.cockpit.communication.Compression;
import java.io.Serializable;
import java.util.Date;

public class Message
implements Serializable {
    private String sessionID;
    private int cockpitID;
    private String username;
    private char[] password;
    private byte[] encryptedPassword;
    private boolean encryptedPasswordAvailable = false;
    private String encryptingType;
    public static final String ENCRYTINGTYPE_BASE64 = "BASE64";
    public static final String ENCRYTINGTYPE_TEAV = "TEAV";
    public static final String ENCRYTINGTYPE_MD5 = "MD5";
    private String status = "no status";
    private Date creationDate = new Date();
    private String comment = "";
    public static final String CONNECTION_ERROR_STATUS = "Connection error";
    public static final String WRONG_PASSWORD_STATUS = "Password incorrect";
    public static final String USERNAME_UNKNOWN_STATUS = "User name unknown";
    public static final String OPERATION_FAILED_STATUS = "operation failed";
    public static final String OK_STATUS = "It's OK";
    public static final String ERROR_STATUS = "Error";

    public Message() {
    }

    public Message(String string, char[] cArray) {
        this.username = string;
        this.password = cArray;
        this.encryptedPasswordAvailable = false;
    }

    public Message(String string, byte[] byArray, boolean bl, String string2) {
        this.encryptedPassword = byArray;
        this.encryptedPasswordAvailable = bl;
        this.encryptingType = string2;
        this.username = string;
    }

    public Message(String string) {
        this.sessionID = string;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public void setEncryptedPassword(byte[] byArray, String string) {
        this.encryptedPasswordAvailable = true;
        this.encryptingType = string;
        this.encryptedPassword = byArray;
    }

    public boolean isPasswordEncrypted() {
        return this.encryptedPasswordAvailable;
    }

    public byte[] getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public String getEncryptingType() {
        return this.encryptingType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public int getCockpitID() {
        return this.cockpitID;
    }

    public void setCockpitID(int n) {
        this.cockpitID = n;
    }

    public Date getDate() {
        return this.creationDate;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "ID:" + super.toString() + " Status:" + this.status + " Comment:" + this.comment + " (created:" + this.creationDate + ")";
    }

    public static Message createOKMessage() {
        Message message = new Message();
        message.setStatus(OK_STATUS);
        return message;
    }

    public byte[] compressString(String string) {
        return Compression.compressFullArray(string.getBytes(), 9);
    }

    public String decompressString(byte[] byArray) {
        return new String(Compression.decompressFullArray(byArray));
    }
}

