/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.LocaleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleSelector {
    private LocaleListener listener;
    private JComboBox localeCB;
    private JComponent localePanel;
    private JLabel localeLabel;
    private Set<LocaleSelector> slaveSelectors = new HashSet<LocaleSelector>();
    private LocaleSelector masterSelector = null;
    private boolean isActive = true;

    public LocaleSelector(LocaleListener localeListener) {
        this.listener = localeListener;
        this.localeCB = new JComboBox();
        this.localeCB.addItem(LocaleItem.getDefaultItem());
        this.localeCB.setSelectedItem(LocaleItem.getDefaultItem());
        this.localeCB.setEditable(true);
        this.localeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!LocaleSelector.this.isActive) {
                    LocaleSelector.this.isActive = true;
                    return;
                }
                Object object = LocaleSelector.this.localeCB.getSelectedItem();
                if (object == null) {
                    return;
                }
                if (object instanceof LocaleItem) {
                    LocaleSelector.this.listener.setLocaleItem((LocaleItem)object);
                    return;
                }
                if (LocaleSelector.this.masterSelector != null) {
                    return;
                }
                LocaleItem localeItem = LocaleItem.getLocaleItem(object.toString());
                if (localeItem == null) {
                    JOptionPane.showMessageDialog(LocaleSelector.this.localeCB, String.valueOf(Simulation.getEjsString("LocaleSelector.InvalidLocale")) + " <" + object.toString() + ">", Simulation.getEjsString("Error"), 0);
                    LocaleSelector.this.localeCB.setSelectedItem(LocaleItem.getDefaultItem());
                    return;
                }
                int n = 0;
                while (n < LocaleSelector.this.localeCB.getItemCount()) {
                    LocaleItem localeItem2 = (LocaleItem)LocaleSelector.this.localeCB.getItemAt(n);
                    if (localeItem2.equals(localeItem)) {
                        LocaleSelector.this.localeCB.setSelectedIndex(n);
                        return;
                    }
                    ++n;
                }
                LocaleSelector.this.addLocaleItem(localeItem);
                LocaleSelector.this.localeCB.setSelectedItem(localeItem);
            }
        });
        this.localeLabel = new JLabel(Simulation.getEjsString("LocaleSelector.Language"), 4);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.localeLabel, "West");
        jPanel.add((Component)this.localeCB, "Center");
        jPanel.validate();
        this.localePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        this.localePanel.add((Component)jPanel, gridBagConstraints);
    }

    public void refreshGUI(LocaleItem localeItem) {
        this.localeLabel.setText(Simulation.getEjsString("LocaleSelector.Language"));
        int n = this.localeCB.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            LocaleItem localeItem2 = (LocaleItem)this.localeCB.getItemAt(n2);
            if (localeItem.equals(localeItem2)) {
                this.isActive = false;
                this.localeCB.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
    }

    public void setMasterSelector(LocaleSelector localeSelector) {
        if (this.masterSelector != null) {
            this.masterSelector.slaveSelectors.remove(this);
        }
        this.masterSelector = localeSelector;
        if (this.masterSelector != null) {
            this.masterSelector.slaveSelectors.add(this);
            this.localeCB.setEditable(false);
        } else {
            this.localeCB.setEditable(true);
        }
    }

    public void setEditable(boolean bl) {
        this.localeCB.setEditable(bl);
    }

    public JComponent getComponent() {
        return this.localePanel;
    }

    public void setEnabled(boolean bl) {
        this.localeCB.setEnabled(bl);
    }

    public void setColor(Color color) {
        this.localeLabel.setForeground(color);
    }

    public void clear() {
        this.localeCB.removeAllItems();
        this.localeCB.addItem(LocaleItem.getDefaultItem());
        this.localeCB.setSelectedItem(LocaleItem.getDefaultItem());
        for (LocaleSelector localeSelector : this.slaveSelectors) {
            localeSelector.clear();
        }
    }

    public Set<LocaleItem> getAvailableLocaleItems() {
        HashSet<LocaleItem> hashSet = new HashSet<LocaleItem>();
        int n = 0;
        int n2 = this.localeCB.getItemCount();
        while (n < n2) {
            hashSet.add((LocaleItem)this.localeCB.getItemAt(n));
            ++n;
        }
        return hashSet;
    }

    public LocaleItem addLocaleItem(LocaleItem localeItem) {
        if (localeItem.isDefaultItem()) {
            return LocaleItem.getDefaultItem();
        }
        boolean bl = false;
        int n = 1;
        int n2 = this.localeCB.getItemCount();
        while (n < n2) {
            LocaleItem localeItem2 = (LocaleItem)this.localeCB.getItemAt(n);
            if (localeItem.equals(localeItem2)) {
                bl = true;
                break;
            }
            if (localeItem.compareTo(localeItem2) < 0) {
                this.localeCB.insertItemAt(localeItem, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.localeCB.addItem(localeItem);
        }
        for (LocaleSelector localeSelector : this.slaveSelectors) {
            localeSelector.addLocaleItem(localeItem);
        }
        return localeItem;
    }

    public void removeLocaleItem(LocaleItem localeItem) {
        if (localeItem.isDefaultItem()) {
            return;
        }
        boolean bl = localeItem.equals(this.localeCB.getSelectedItem());
        int n = 1;
        int n2 = this.localeCB.getItemCount();
        while (n < n2) {
            LocaleItem localeItem2 = (LocaleItem)this.localeCB.getItemAt(n);
            if (localeItem.equals(localeItem2)) {
                this.localeCB.removeItemAt(n);
                for (LocaleSelector localeSelector : this.slaveSelectors) {
                    localeSelector.removeLocaleItem(localeItem);
                }
                if (bl) {
                    this.setLocaleItem(LocaleItem.getDefaultItem());
                }
                return;
            }
            ++n;
        }
    }

    public void setLocaleItem(LocaleItem localeItem) {
        int n = this.localeCB.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            LocaleItem localeItem2 = (LocaleItem)this.localeCB.getItemAt(n2);
            if (localeItem.equals(localeItem2)) {
                this.localeCB.setSelectedIndex(n2);
                this.listener.setLocaleItem(localeItem);
                return;
            }
            ++n2;
        }
        System.out.println("Warning! : Locale " + localeItem + " NOT found");
    }
}

