/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleItem
implements Comparable<LocaleItem> {
    private static final String LABEL_FOR_DEFAULT = "_default_";
    private static final Charset UTF16_CHARSET = Charset.forName("UTF-16");
    private static final LocaleItem DEFAULT_ITEM = new LocaleItem("_default_", null);
    private static final Map<String, LocaleItem> LOCALE_MAP = new HashMap<String, LocaleItem>();
    private String keyword;
    private String displayName;
    private Locale locale;

    public static Charset getCharset() {
        return UTF16_CHARSET;
    }

    public static LocaleItem getDefaultItem() {
        return DEFAULT_ITEM;
    }

    public static LocaleItem getLocaleItem(String string) {
        String string2;
        String string3;
        if (string.equals(LABEL_FOR_DEFAULT)) {
            return DEFAULT_ITEM;
        }
        int n = string.length();
        if (n >= 4) {
            string3 = string.substring(0, 2).toLowerCase();
            string2 = " " + string.substring(n - 2).toUpperCase();
        } else if (n >= 2) {
            string3 = string.substring(0, 2);
            string2 = "";
        } else {
            return null;
        }
        string = String.valueOf(string3) + string2;
        LocaleItem localeItem = LOCALE_MAP.get(string);
        if (localeItem != null) {
            return localeItem;
        }
        localeItem = string2.length() > 0 ? new LocaleItem(string, new Locale(string3, string2)) : new LocaleItem(string, new Locale(string3));
        LOCALE_MAP.put(string, localeItem);
        return localeItem;
    }

    public static LocaleItem getDefaultLocaleItem() {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = string2.length() > 0 ? string : String.valueOf(string) + " " + string2;
        LocaleItem localeItem = LOCALE_MAP.get(string3);
        if (localeItem != null) {
            return localeItem;
        }
        localeItem = LOCALE_MAP.get(string);
        if (localeItem != null) {
            return localeItem;
        }
        localeItem = new LocaleItem(string3, locale);
        LOCALE_MAP.put(string, localeItem);
        return localeItem;
    }

    private LocaleItem(String string, Locale locale) {
        this.keyword = string;
        this.locale = locale;
        this.displayName = this.locale == null ? ToolsRes.getString("TranslatorTool.Language.Default") : this.locale.getDisplayName(this.locale);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean isDefaultItem() {
        return this.equals(DEFAULT_ITEM);
    }

    @Override
    public int compareTo(LocaleItem localeItem) {
        if (this.locale == null) {
            return -1;
        }
        if (localeItem.locale == null) {
            return 1;
        }
        return this.displayName.compareTo(localeItem.displayName);
    }
}

