/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifVideo;
import org.opensourcephysics.media.gif.GifVideoRecorder;

public class GifVideoType
implements VideoType {
    protected FileFilter gifFilter;

    public Video getVideo(String string) {
        try {
            return new GifVideo(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public VideoRecorder getRecorder() {
        return new GifVideoRecorder();
    }

    public boolean canRecord() {
        return true;
    }

    public String getDescription() {
        return MediaRes.getString("GifVideoType.Description");
    }

    public String getDefaultExtension() {
        return "gif";
    }

    public FileFilter[] getFileFilters() {
        if (this.gifFilter == null) {
            this.gifFilter = new GIFFileFilter();
        }
        return new FileFilter[]{this.gifFilter};
    }

    public boolean isType(Video video2) {
        return video2.getClass().equals(GifVideo.class);
    }

    public class GIFFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = VideoIO.getExtension(file);
            return string != null && string.equals("gif");
        }

        public String getDescription() {
            return MediaRes.getString("GIFVideoType.GIFFileFilter.Description");
        }
    }
}

