/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.rk.AbstractExplicitRKSolverInterpolator;

public abstract class AbstractAdaptiveRKSolverInterpolator
extends AbstractExplicitRKSolverInterpolator {
    private boolean estimate = false;
    private double actualStepSize;
    private double absoluteTolerance = Double.NaN;
    private double relativeTolerance = Double.NaN;
    protected double[] relTol;
    protected double[] absTol;
    private static final double fac1 = 0.33;
    private static final double fac2 = 6.0;
    private static final double beta = 0.0;
    private static final double safe = 0.9;
    private final double expO1 = 1.0 / this.getMethodOrder() - 0.0;
    private double errOld = 1.0E-4;
    private double fac = 0.0;

    protected abstract double computeApproximations(double var1);

    protected abstract void computeFinalRate();

    protected abstract double getMethodOrder();

    protected void allocateOtherArrays() {
        this.relTol = new double[this.dimension];
        this.absTol = new double[this.dimension];
        this.setTolerances(1.0E-6, 1.0E-6);
    }

    public void reinitialize(double[] dArray) {
        super.reinitialize(dArray);
        this.actualStepSize = this.estimate ? this.limitStepSize(this.estimateFirstStepSize(this.stepSize)) : this.limitStepSize(this.stepSize);
    }

    public final void setEstimateFirstStep(boolean bl) {
        this.estimate = bl;
    }

    public void setMaximumStepSize(double d) {
        super.setMaximumStepSize(d);
        this.actualStepSize = this.limitStepSize(this.actualStepSize);
    }

    public final void setTolerances(double d, double d2) {
        if (this.absoluteTolerance == d && this.relativeTolerance == d2) {
            return;
        }
        this.absoluteTolerance = d;
        this.relativeTolerance = d2;
        int n = 0;
        while (n < this.dimension) {
            this.absTol[n] = d;
            this.relTol[n] = d2;
            ++n;
        }
        this.finalTime = Double.NaN;
        this.error_code = 0;
        this.actualStepSize = this.estimate ? this.limitStepSize(this.estimateFirstStepSize(this.stepSize)) : this.limitStepSize(this.stepSize);
    }

    public final void setTolerances(double[] dArray, double[] dArray2) {
        this.relativeTolerance = Double.NaN;
        this.absoluteTolerance = Double.NaN;
        System.arraycopy(dArray, 0, this.absTol, 0, this.dimension);
        System.arraycopy(dArray2, 0, this.relTol, 0, this.dimension);
        this.finalTime = Double.NaN;
        this.error_code = 0;
        this.actualStepSize = this.estimate ? this.limitStepSize(this.estimateFirstStepSize(this.stepSize)) : this.limitStepSize(this.stepSize);
    }

    protected final void computeOneStep() {
        this.error_code = 0;
        int n = 0;
        while (n < 500) {
            double d = this.computeApproximations(this.actualStepSize);
            this.counter += this.evals;
            if (d <= 1.0) {
                this.computeFinalRate();
                this.finalTime = this.initialTime + this.actualStepSize;
                this.actualStepSize = n > 0 ? this.limitStepSize(Math.min(this.actualStepSize, this.estimatedStepSize(d))) : this.limitStepSize(this.estimatedStepSize(d));
                return;
            }
            this.actualStepSize = this.limitStepSize(Math.min(this.actualStepSize, this.estimatedStepSize(d)));
            ++n;
        }
        this.finalTime = Double.NaN;
        this.error_code = 1;
    }

    protected final double computeError(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.dimension) {
            double d2 = this.absTol[n] + this.relTol[n] * Math.max(Math.abs(this.finalState[n]), Math.abs(this.initialState[n]));
            double d3 = (this.finalState[n] - dArray[n]) / d2;
            d += d3 * d3;
            ++n;
        }
        return Math.sqrt(d / (double)this.dimension);
    }

    protected double estimatedStepSize(double d) {
        double d2 = 0.0;
        if (d != 0.0) {
            d2 = Math.pow(d, this.expO1);
            this.fac = d2 / Math.exp(0.0 * Math.log(this.errOld));
            this.fac = Math.max(0.16666666666666666, Math.min(3.0303030303030303, this.fac / 0.9));
        } else {
            d2 = 3.0303030303030303;
            this.fac = 0.16666666666666666;
        }
        if (d <= 1.0) {
            this.errOld = Math.max(d, 1.0E-4);
            return this.actualStepSize / this.fac;
        }
        return this.actualStepSize / Math.min(3.0303030303030303, d2 / 0.9);
    }

    private double limitStepSize(double d) {
        if (d >= 0.0) {
            return Math.min(d, this.maximumStepSize);
        }
        return Math.max(d, -this.maximumStepSize);
    }

    private final double estimateFirstStepSize(double d) {
        int n = d < 0.0 ? -1 : 1;
        d = Math.abs(d);
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < this.dimension) {
            double d4 = this.absTol[n2] + this.relTol[n2] * Math.abs(this.initialState[n2]);
            double d5 = this.initialRate[n2] / d4;
            d2 += d5 * d5;
            d5 = this.initialState[n2] / d4;
            d3 += d5 * d5;
            ++n2;
        }
        double d6 = d2 <= 1.0E-10 || d3 <= 1.0E-10 ? 1.0E-6 : Math.sqrt(d3 / d2) * 0.01;
        d6 = (double)n * Math.min(d6, d);
        int n3 = 0;
        while (n3 < this.dimension) {
            this.finalState[n3] = this.initialState[n3] + d6 * this.initialRate[n3];
            ++n3;
        }
        this.ode.getRate(this.finalState, this.finalRate);
        double d7 = 0.0;
        int n4 = 0;
        while (n4 < this.dimension) {
            double d8 = this.absTol[n4] + this.relTol[n4] * Math.abs(this.initialState[n4]);
            double d9 = (this.finalRate[n4] - this.initialRate[n4]) / d8;
            d7 += d9 * d9;
            ++n4;
        }
        double d10 = Math.max(Math.abs(d7 = Math.sqrt(d7) / d6), Math.sqrt(d2));
        double d11 = d10 <= 1.0E-15 ? Math.max(1.0E-6, Math.abs(d6) * 0.001) : Math.exp(1.0 / this.getMethodOrder() * Math.log(0.01 / d10));
        d6 = (double)n * Math.min(100.0 * d6, d11);
        if (d != 0.0) {
            d6 = (double)n * Math.min(Math.abs(d6), d);
        }
        return d6;
    }
}

