/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.Function;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.GroupVariable;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.ControlRootPane;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

public class EjsControl {
    private static String _RETURN_;
    private static Rectangle defaultScreenBounds;
    protected String replaceOwnerName = null;
    private Frame ownerFrame = null;
    protected Frame replaceOwnerFrame = null;
    private JTextArea messageArea = null;
    protected boolean mustUpdateSimulation = true;
    protected boolean justCollectingData = false;
    private Simulation mySimulation = null;
    private Hashtable targetTable = new Hashtable();
    private Hashtable elementTable = new Hashtable();
    Hashtable variableTable = new Hashtable();
    private Vector elementList = new Vector();
    private Vector updateList = new Vector();
    private URL usercodebase = null;
    private Point displacement = new Point(0, 0);
    private boolean reportingChange = false;
    GroupVariable methodTriggerVariable = null;
    private Hashtable<ControlDrawable, ControlParentOfDrawables> drawablesReparented = new Hashtable();
    private BooleanValue booleanValue = new BooleanValue(false);
    private IntegerValue integerValue = new IntegerValue(0);
    private DoubleValue doubleValue = new DoubleValue(0.0);
    private StringValue stringValue = new StringValue("");
    private ObjectValue objectValue = new ObjectValue(null);
    private static Color[] colorTable;

    static {
        defaultScreenBounds = EjsControl.getScreenBounds(0);
        ResourceLoader.setCacheEnabled(true);
        try {
            _RETURN_ = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            _RETURN_ = "\n";
        }
        colorTable = null;
    }

    public EjsControl() {
        this.setValue("_expr_", new BooleanValue(false));
        this.methodTriggerVariable = (GroupVariable)this.variableTable.get("_expr_");
    }

    public EjsControl(Object object) {
        this();
        this.addTarget("_default_", object);
        if (object instanceof Simulation) {
            this.setSimulation((Simulation)object);
        }
    }

    public EjsControl(Object object, String string, Frame frame) {
        this(object);
        this.replaceOwnerFrame(string, frame);
    }

    public static Rectangle getScreenBounds(int n) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (n >= graphicsDeviceArray.length || n < 0) {
            return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        }
        return graphicsDeviceArray[n].getDefaultConfiguration().getBounds();
    }

    public static void setDefaultScreen(int n) {
        defaultScreenBounds = EjsControl.getScreenBounds(n);
    }

    public static Rectangle getDefaultScreenBounds() {
        return defaultScreenBounds;
    }

    public void setOwnerFrame(Frame frame) {
        this.ownerFrame = frame;
    }

    public Frame getOwnerFrame() {
        return this.ownerFrame;
    }

    public void replaceOwnerFrame(String string, Frame frame) {
        this.replaceOwnerName = string;
        this.replaceOwnerFrame = frame;
    }

    public String getReplaceOwnerName() {
        return this.replaceOwnerName;
    }

    public Frame getReplaceOwnerFrame() {
        return this.replaceOwnerFrame;
    }

    public void setSimulation(Simulation simulation) {
        this.mySimulation = simulation;
    }

    public Simulation getSimulation() {
        return this.mySimulation;
    }

    public void setUpdateSimulation(boolean bl) {
        this.mustUpdateSimulation = bl;
    }

    public void updateSimulation() {
        if (this.mustUpdateSimulation && this.mySimulation != null) {
            this.mySimulation.update();
        }
    }

    public boolean isCollectingData() {
        return this.justCollectingData;
    }

    public void addElementsMenuEntries() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).addMenuEntries();
        }
    }

    public final boolean isReportingChange() {
        return this.reportingChange;
    }

    public final void setReportingChange(boolean bl) {
        this.reportingChange = bl;
    }

    public void setDisplacement(int n, int n2) {
        this.setDisplacement(n, n2, null);
    }

    public void setDisplacement(int n, int n2, EjsControl ejsControl) {
        if (ejsControl != null) {
            this.displacement.x = n + ejsControl.displacement.x;
            this.displacement.y = n2 + ejsControl.displacement.y;
        } else {
            this.displacement.x = n;
            this.displacement.y = n2;
        }
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)enumeration.nextElement();
            if (!(controlElement instanceof ControlWindow)) continue;
            ((ControlWindow)controlElement).updateLocation();
        }
    }

    public Point getDisplacement() {
        return this.displacement;
    }

    public boolean reparentDrawable(String string, ControlElement controlElement) {
        ControlElement controlElement2 = this.getElement(string);
        if (controlElement2 instanceof ControlDrawable && controlElement instanceof ControlParentOfDrawables) {
            ControlDrawable controlDrawable = (ControlDrawable)controlElement2;
            this.drawablesReparented.put(controlDrawable, controlDrawable.getParent());
            controlDrawable.setParent((ControlParentOfDrawables)((Object)controlElement));
            return true;
        }
        JOptionPane.showMessageDialog(null, "Can't reparent drawable.\nOne of the elements is not of the right type", "Error", 1);
        return false;
    }

    public void undoReparenting() {
        Enumeration<ControlDrawable> enumeration = this.drawablesReparented.keys();
        while (enumeration.hasMoreElements()) {
            ControlDrawable controlDrawable = enumeration.nextElement();
            controlDrawable.setParent(this.drawablesReparented.get(controlDrawable));
        }
        this.drawablesReparented.clear();
    }

    public void dispose() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)enumeration.nextElement();
            if (!(controlElement instanceof ControlWindow)) continue;
            ((ControlWindow)controlElement).dispose();
        }
    }

    public Object getTarget(String string) {
        return this.targetTable.get(string);
    }

    public void addTarget(String string, Object object) {
        this.targetTable.put(string, object);
    }

    public void removeTarget(String string) {
        this.targetTable.remove(string);
    }

    public void setValue(String string, Value value) {
        this.setValue(string, value, false);
    }

    public void setValue(String string, Value value, boolean bl) {
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, value);
            groupVariable.setValueObsolete(false);
            groupVariable.setDefinedInModel(bl);
            this.variableTable.put(string, groupVariable);
        } else {
            groupVariable.setValue(value);
            groupVariable.setValueObsolete(false);
            if (bl) {
                groupVariable.setDefinedInModel(true);
            }
            groupVariable.propagateValue(null, this.justCollectingData);
        }
    }

    public Value getValue(String string) {
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            return null;
        }
        return groupVariable.getValue();
    }

    public GroupVariable getVariable(String string) {
        return (GroupVariable)this.variableTable.get(string);
    }

    public GroupVariable registerVariable(String string, ControlElement controlElement, int n, Value value) {
        if (string == null) {
            return null;
        }
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, value);
            this.variableTable.put(string, groupVariable);
        }
        groupVariable.addElementListener(controlElement, n);
        groupVariable.propagateValue(null, this.justCollectingData);
        return groupVariable;
    }

    public boolean isVariableRegistered(String string) {
        if (string == null) {
            return false;
        }
        return this.variableTable.get(string) != null;
    }

    public void variableChanged(GroupVariable groupVariable, ControlElement controlElement, Value value) {
        if (groupVariable == null) {
            return;
        }
        groupVariable.setValue(value);
        groupVariable.propagateValue(controlElement, this.justCollectingData);
        groupVariable.invokeListeners(controlElement);
    }

    public void addListener(String string, String string2) {
        this.addListener(string, string2, null);
    }

    public void addListener(String string, String string2, Object object) {
        Object object2;
        if (string == null) {
            return;
        }
        String[] stringArray = MethodWithOneParameter.splitMethodName(string2);
        if (stringArray == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Listener <" + string2 + "> not assigned");
            return;
        }
        if (stringArray[0] == null) {
            stringArray[0] = "_default_";
        }
        if ((object2 = this.getTarget(stringArray[0])) == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + stringArray[0] + "> not assigned");
            return;
        }
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, this.doubleValue);
            this.variableTable.put(string, groupVariable);
        }
        if (stringArray[2] == null) {
            groupVariable.addListener(object2, String.valueOf(stringArray[1]) + "()", object);
        } else {
            groupVariable.addListener(object2, String.valueOf(stringArray[1]) + "(" + stringArray[2] + ")", object);
        }
    }

    public void rename(ControlElement controlElement, String string) {
        String string2 = controlElement.getProperty("name");
        if (string2 != null) {
            this.elementTable.remove(string2);
        }
        if (string != null) {
            this.elementTable.put(string, controlElement);
        }
    }

    public final ControlElement addElement(ControlElement controlElement, String string) {
        Object object;
        if (this.replaceOwnerName != null && this.replaceOwnerName.equals(string)) {
            if (controlElement.getObject() instanceof Frame) {
                this.setOwnerFrame(this.replaceOwnerFrame);
            }
            controlElement = new ControlRootPane();
        }
        if ((object = controlElement.getObject()) instanceof Frame) {
            this.setOwnerFrame((Frame)object);
        } else if (object instanceof Dialog && this.ownerFrame != null) {
            controlElement.replaceVisual(this.ownerFrame);
        } else if (object instanceof JTextArea) {
            this.messageArea = (JTextArea)object;
        }
        controlElement.setGroup(this);
        controlElement.setProperty("name", string);
        this.elementList.add(controlElement);
        if (controlElement instanceof NeedsUpdate) {
            this.updateList.add(controlElement);
        }
        if (this.usercodebase != null) {
            controlElement.setProperty("_ejs_codebase", this.usercodebase.toString());
        }
        if (object instanceof Window && controlElement.getProperty("visible") == null) {
            controlElement.setProperty("visible", "true");
        }
        return controlElement;
    }

    public ControlElement getElement(String string) {
        if (string == null) {
            return null;
        }
        return (ControlElement)this.elementTable.get(string);
    }

    public ControlElement getControl(String string) {
        return this.getElement(string);
    }

    public Component getVisual(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getVisual();
    }

    public Component getComponent(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getComponent();
    }

    public Container getContainer(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement instanceof ControlContainer) {
            return ((ControlContainer)controlElement).getContainer();
        }
        return null;
    }

    public Object getObject(String string, String string2) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getObject(string2);
    }

    public Function getFunction(String string, String string2) {
        Object object = this.getObject(string, string2);
        if (object instanceof Function) {
            return (Function)object;
        }
        return null;
    }

    public void destroy(String string) {
        this.destroy(this.getElement(string), true);
    }

    public void destroy(ControlElement controlElement) {
        this.destroy(controlElement, true);
    }

    public void reset() {
        this.clearMessages();
        this.undoReparenting();
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).reset();
        }
    }

    public void initialize() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).initialize();
        }
    }

    public void propagateValues() {
    }

    private void doTheUpdate() {
        this.methodTriggerVariable.propagateValue(null, this.justCollectingData);
        Enumeration enumeration = this.updateList.elements();
        while (enumeration.hasMoreElements()) {
            ((NeedsUpdate)enumeration.nextElement()).update();
        }
    }

    public void update() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.propagateValues();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public synchronized void run() {
                        EjsControl.this.propagateValues();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.doTheUpdate();
    }

    public void updateVariables() {
        this.propagateValues();
        this.methodTriggerVariable.propagateValue(null, this.justCollectingData);
    }

    public void collectData() {
        this.justCollectingData = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.propagateValues();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public synchronized void run() {
                        EjsControl.this.propagateValues();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.doTheUpdate();
        this.justCollectingData = false;
    }

    public void resetTraces() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)enumeration.nextElement();
            if (!(controlElement instanceof Resetable)) continue;
            controlElement.reset();
        }
    }

    public void setUserCodebase(URL uRL) {
        this.usercodebase = uRL;
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).setProperty("_ejs_codebase", uRL.toString());
        }
    }

    public URL getUserCodebase() {
        return this.usercodebase;
    }

    @Deprecated
    public void flush() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).flush();
        }
    }

    public void setActive(boolean bl) {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).setActive(bl);
        }
    }

    public void onExit() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).onExit();
        }
    }

    public void clearVariables() {
        this.variableTable.clear();
    }

    public void clearModelVariables() {
        Hashtable<String, GroupVariable> hashtable = new Hashtable<String, GroupVariable>();
        Enumeration enumeration = this.variableTable.elements();
        while (enumeration.hasMoreElements()) {
            GroupVariable groupVariable = (GroupVariable)enumeration.nextElement();
            if (!groupVariable.isDefinedInModel()) {
                hashtable.put(groupVariable.getName(), groupVariable);
                continue;
            }
            if (!groupVariable.hasElementsRegistered()) continue;
            groupVariable.setValueObsolete(true);
            hashtable.put(groupVariable.getName(), groupVariable);
        }
        this.variableTable = hashtable;
    }

    public Set getVariablesSet() {
        return this.variableTable.keySet();
    }

    public Hashtable getVariablesTable() {
        return this.variableTable;
    }

    public void clear() {
        this.variableTable.clear();
        ArrayList<ControlElement> arrayList = new ArrayList<ControlElement>();
        ArrayList<ControlElement> arrayList2 = new ArrayList<ControlElement>();
        Iterator iterator = this.elementList.elements();
        while (iterator.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)iterator.nextElement();
            String string = controlElement.getProperty("parent");
            if (string != null) continue;
            if (controlElement instanceof ControlDialog) {
                arrayList.add(controlElement);
                continue;
            }
            arrayList2.add(controlElement);
        }
        for (ControlElement controlElement : arrayList) {
            this.destroy(controlElement, false);
        }
        for (ControlElement controlElement : arrayList2) {
            this.destroy(controlElement, false);
        }
        this.setOwnerFrame(null);
    }

    private void destroy(ControlElement controlElement, boolean bl) {
        Object object;
        Object object2;
        if (controlElement == null) {
            return;
        }
        if (bl) {
            object2 = this.getElement(controlElement.getProperty("parent"));
            if (object2 != null) {
                if (object2 instanceof ControlContainer) {
                    ((ControlContainer)object2).remove(controlElement);
                }
            } else {
                object = controlElement.getComponent().getParent();
                if (object != null) {
                    ((Container)object).remove(controlElement.getComponent());
                    ((Container)object).validate();
                    ((Component)object).repaint();
                }
            }
        }
        controlElement.variablePropertiesClear();
        object2 = controlElement.getProperty("name");
        if (object2 != null) {
            this.elementTable.remove(object2);
        }
        this.elementList.remove(controlElement);
        if (controlElement instanceof NeedsUpdate) {
            this.updateList.remove(controlElement);
        }
        if (controlElement instanceof ControlContainer) {
            object = ((ControlContainer)controlElement).getChildren().elements();
            while (object.hasMoreElements()) {
                ControlElement controlElement2 = (ControlElement)object.nextElement();
                this.destroy(controlElement2, false);
            }
        }
        if (controlElement instanceof ControlWindow) {
            ((ControlWindow)controlElement).dispose();
        }
    }

    public Container getTopLevelAncestor(String string) {
        if (string != null) {
            ControlElement controlElement = this.getElement(string);
            Component component = controlElement.getComponent();
            if (component instanceof JComponent) {
                return ((JComponent)component).getTopLevelAncestor();
            }
        } else {
            Enumeration enumeration = this.elementList.elements();
            while (enumeration.hasMoreElements()) {
                ControlElement controlElement = (ControlElement)enumeration.nextElement();
                Component component = controlElement.getComponent();
                if (!(component instanceof Window)) continue;
                return (Window)component;
            }
        }
        return null;
    }

    public void setValue(String string, boolean bl) {
        this.booleanValue.value = bl;
        this.setValue(string, this.booleanValue);
    }

    public void setValue(String string, int n) {
        this.integerValue.value = n;
        this.setValue(string, this.integerValue);
    }

    public void setValue(String string, double d) {
        this.doubleValue.value = d;
        this.setValue(string, this.doubleValue);
    }

    public void setValue(String string, String string2) {
        this.stringValue.value = string2;
        this.setValue(string, this.stringValue);
    }

    public void setValue(String string, Object object) {
        if (object instanceof String) {
            this.setValue(string, (String)object);
        } else {
            this.objectValue.value = object;
            this.setValue(string, this.objectValue);
        }
    }

    public boolean getBoolean(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return false;
        }
        return value.getBoolean();
    }

    public int getInt(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return 0;
        }
        return value.getInteger();
    }

    public double getDouble(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return 0.0;
        }
        return value.getDouble();
    }

    public String getString(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return "";
        }
        return value.getString();
    }

    public Object getObject(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return null;
        }
        return value.getObject();
    }

    public static Color[] getPhaseColorTable() {
        if (colorTable == null) {
            colorTable = new Color[256];
            int n = 0;
            while (n < 256) {
                double d = Math.abs(Math.sin(Math.PI * (double)n / 255.0));
                int n2 = (int)(255.0 * d * d);
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 1.0471975511965976));
                int n3 = (int)(255.0 * d * d * Math.sqrt(d));
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 2.0943951023931953));
                int n4 = (int)(255.0 * d * d);
                EjsControl.colorTable[n] = new Color(n4, n3, n2);
                ++n;
            }
        }
        return colorTable;
    }

    public static Color phaseToColor(double d) {
        int n = (int)(127.5 * (1.0 + d / Math.PI));
        return EjsControl.getPhaseColorTable()[n %= 255];
    }

    public void clearMessages() {
        if (this.messageArea != null) {
            this.messageArea.setText("");
            this.messageArea.setCaretPosition(this.messageArea.getText().length());
        }
    }

    public void println(String string) {
        this.print(String.valueOf(string) + _RETURN_);
    }

    public void println() {
        this.println("");
    }

    public void print(String string) {
        if (this.messageArea != null) {
            this.messageArea.append(string);
            this.messageArea.setCaretPosition(this.messageArea.getText().length());
        } else {
            System.out.print(string);
        }
    }
}

