/*
 * Decompiled with CFR 0.152.
 */
package users.sgeducation.lookang.RotationalPendulum_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EJSODE;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import users.sgeducation.lookang.RotationalPendulum_pkg.RotationalPendulumSimulation;
import users.sgeducation.lookang.RotationalPendulum_pkg.RotationalPendulumView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotationalPendulum
extends Model {
    public RotationalPendulumSimulation _simulation = null;
    public RotationalPendulumView _view = null;
    public RotationalPendulum _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EJSODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double time = 0.0;
    public double theta = 0.0;
    public double vtheta = 0.0;
    public double sigma = 0.0;
    public double vsigma = 0.0;
    public double omega2 = 52.6;
    public double alpha = 1.3;
    public double beta = 6.4;
    public double gamma = 79.4;
    public double cp = 0.02;
    public double u = 0.0;
    public double inittheta = 0.1;
    public double initsigma = 0.0;
    public double h1 = 4.0;
    public double h2 = 2.0;
    public double h3 = 2.2;
    public double h4 = 3.0;
    public double h5 = 4.0;
    public double r1 = 1.3;
    public double r2 = 0.5;
    public double r3 = 0.5;
    public double r4 = 0.3;
    public double r5 = 0.2;
    public double p1;
    public double p2;
    public double p3 = this.h1 + this.h2;
    public double q1;
    public double q2;
    public double t1;
    public double t2;
    public double t3;
    public double[] axis2;
    public double[] axis3;
    public double[] axis4;
    public double[] axis5;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return RotationalPendulum._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/sgeducation/lookang/RotationalPendulum.xml";
    }

    public static String _getModelDirectory() {
        return "users/sgeducation/lookang/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(439, 427);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/sgeducation/lookang/images/RotationalPendulum.gif");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/sgeducation/lookang/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("D:/Ejs/EJS_4.3.2_110226/EJS_4.3.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/Ejs/EJS_4.3.2_110226/EJS_4.3.2/bin/config/");
        }
        RotationalPendulum._addHtmlPageInfo("Intro Page", "_default_", "Intro Page", "./RotationalPendulum_Intro 1.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!RotationalPendulum._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        RotationalPendulum rotationalPendulum = new RotationalPendulum(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!RotationalPendulum._common_initialization(stringArray)) {
            return null;
        }
        RotationalPendulum rotationalPendulum = new RotationalPendulum("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)rotationalPendulum._getView().getComponent("mainFrame");
    }

    public RotationalPendulum() {
        this(null, null, null, null, null, false);
    }

    public RotationalPendulum(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public RotationalPendulum(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new RotationalPendulumSimulation(this, string, frame, uRL, bl);
        this._view = (RotationalPendulumView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return RotationalPendulum._getEjsResources();
    }

    @Override
    public String _getClassEjsModel() {
        return RotationalPendulum._getEjsModel();
    }

    @Override
    public String _getClassModelDirectory() {
        return RotationalPendulum._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.time = 0.0;
        this.theta = 0.0;
        this.vtheta = 0.0;
        this.sigma = 0.0;
        this.vsigma = 0.0;
        this.omega2 = 52.6;
        this.alpha = 1.3;
        this.beta = 6.4;
        this.gamma = 79.4;
        this.cp = 0.02;
        this.u = 0.0;
        this.inittheta = 0.1;
        this.initsigma = 0.0;
        this.h1 = 4.0;
        this.h2 = 2.0;
        this.h3 = 2.2;
        this.h4 = 3.0;
        this.h5 = 4.0;
        this.r1 = 1.3;
        this.r2 = 0.5;
        this.r3 = 0.5;
        this.r4 = 0.3;
        this.r5 = 0.2;
        this.p3 = this.h1 + this.h2;
        this.axis2 = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axis2[n] = 0.0;
        }
        this.axis3 = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axis3[n] = 0.0;
        }
        this.axis4 = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axis4[n] = 0.0;
        }
        this.axis5 = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axis5[n] = 0.0;
        }
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EJSODE eJSODE : this._privateOdesList.values()) {
            eJSODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._initializeSolvers();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.step();
        }
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.axis2 = null;
        this.axis3 = null;
        this.axis4 = null;
        this.axis5 = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EJSODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Angles".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._resetSolvers();
        }
        if ("Move Cilinders".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.theta = this.inittheta;
        this.vtheta = 0.0;
        this.sigma = this.initsigma;
        this.vsigma = 0.0;
        this.time = 0.0;
    }

    public void _constraints1() {
        double d = Math.cos(this.sigma);
        double d2 = Math.sin(this.sigma);
        double d3 = Math.cos(this.theta);
        double d4 = Math.sin(this.theta);
        this.axis2[0] = d;
        this.axis2[1] = -d2;
        this.axis2[3] = -this.axis2[1];
        this.axis2[4] = this.axis2[0];
        this.axis2[8] = 1.0;
        this.axis3[2] = 1.0;
        this.axis3[3] = d;
        this.axis3[4] = -d2;
        this.axis3[6] = d2;
        this.axis3[7] = d;
        this.p1 = -this.h3 * 0.5 * d2;
        this.p2 = -this.h3 * 0.5 * d;
        this.axis4[0] = -d4;
        this.axis4[2] = d3;
        this.axis4[3] = -this.axis4[2];
        this.axis4[5] = this.axis4[0];
        this.axis4[1] = -this.axis4[0] * d2;
        this.axis4[0] = this.axis4[0] * d;
        this.axis4[4] = -this.axis4[3] * d2;
        this.axis4[3] = this.axis4[3] * d;
        this.axis4[6] = d2;
        this.axis4[7] = d;
        this.q1 = -this.p1;
        this.q2 = -this.p2;
        this.axis5[0] = d3;
        this.axis5[2] = d4;
        this.axis5[4] = 1.0;
        this.axis5[6] = -d4;
        this.axis5[7] = 0.0;
        this.axis5[8] = d3;
        this.axis5[1] = -this.axis5[0] * d2;
        this.axis5[0] = this.axis5[0] * d;
        this.axis5[3] = this.axis5[4] * d2;
        this.axis5[4] = this.axis5[4] * d;
        this.axis5[7] = -this.axis5[6] * d2;
        this.axis5[6] = this.axis5[6] * d;
        this.t2 = this.h3 * 0.5 + this.h4 - 2.0 * this.r5;
        this.t1 = this.t2 * d2;
        this.t2 *= d;
        this.t3 = this.p3;
    }

    public double f1(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d);
        double d6 = Math.cos(d);
        double d7 = this.beta + d5 * d5 - this.alpha * this.alpha * d6 * d6;
        double d8 = -this.alpha * this.alpha * d3 * d3 * d5 * d6 + (this.beta + d5 * d5) * d4 * d4 * d5 * d6 + 2.0 * this.alpha * d3 * d4 * d5 * d6 * d6 + this.beta * this.omega2 * d5 + this.omega2 * d5 * d5 * d5 - this.cp * (this.beta + d5 * d5) * d3 - this.alpha * this.gamma * this.omega2 * d6 * this.u;
        return d8 / d7;
    }

    public double f2(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d);
        double d6 = Math.cos(d);
        double d7 = this.beta + d5 * d5 - this.alpha * this.alpha * d6 * d6;
        double d8 = this.alpha * d3 * d3 * d5 - this.alpha * d4 * d4 * d5 * d6 * d6 - 2.0 * d3 * d4 * d5 * d6 - this.alpha * this.omega2 * d5 * d6 + this.alpha * this.cp * d6 * d3 + this.gamma * this.omega2 * this.u;
        return d8 / d7;
    }

    public void Freeze() {
        this.vtheta = 0.0;
        this.vsigma = 0.0;
    }

    public void _method_for_Play_action() {
        this._play();
    }

    public void _method_for_Pause_action() {
        this._pause();
    }

    public void _method_for_Init_action() {
        this._initialize();
    }

    public void _method_for_Reset_action() {
        this._reset();
    }

    public void _method_for_Freeze_action() {
        this.Freeze();
    }

    public double _method_for_cilinder_sizex() {
        return 2.0 * this.r1;
    }

    public double _method_for_cilinder_sizey() {
        return 2.0 * this.r1;
    }

    public double _method_for_cilinder2_sizex() {
        return 2.0 * this.r2;
    }

    public double _method_for_cilinder2_sizey() {
        return 2.0 * this.r2;
    }

    public double _method_for_cilinder3_sizex() {
        return 2.0 * this.r3;
    }

    public double _method_for_cilinder3_sizey() {
        return 2.0 * this.r3;
    }

    public double _method_for_cilinder4_sizex() {
        return 2.0 * this.r4;
    }

    public double _method_for_cilinder4_sizey() {
        return 2.0 * this.r4;
    }

    public double _method_for_cilinder5_sizex() {
        return 2.0 * this.r5;
    }

    public double _method_for_cilinder5_sizey() {
        return 2.0 * this.r5;
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements EJSODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = RK4.class;
        private double[] __state = null;
        private double __currentTime;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            RotationalPendulum.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public ODEInterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        private void __instantiateSolver() {
            this.__state = new double[5];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getSolver().getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            this.__pushState();
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.initialize(0.01);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != RotationalPendulum.this.theta) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = RotationalPendulum.this.theta;
            if (this.__state[n] != RotationalPendulum.this.vtheta) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = RotationalPendulum.this.vtheta;
            if (this.__state[n] != RotationalPendulum.this.sigma) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = RotationalPendulum.this.sigma;
            if (this.__state[n] != RotationalPendulum.this.vsigma) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = RotationalPendulum.this.vsigma;
            if (this.__state[n] != RotationalPendulum.this.time) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = RotationalPendulum.this.time;
        }

        public void resetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(RotationalPendulum.this._view.getComponent(RotationalPendulum.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                RotationalPendulum.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(0.01);
            this.__eventSolver.setInternalStepSize(0.01);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__pushState();
            if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            RotationalPendulum.this.theta = this.__state[n++];
            RotationalPendulum.this.vtheta = this.__state[n++];
            RotationalPendulum.this.sigma = this.__state[n++];
            RotationalPendulum.this.vsigma = this.__state[n++];
            RotationalPendulum.this.time = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != 0) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            double d;
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            double d5 = dArray[n2++];
            this.__currentTime = d = dArray[n2++];
            int n3 = 0;
            dArray2[n3++] = d3;
            dArray2[n3++] = RotationalPendulum.this.f1(d2, d4, d3, d5);
            dArray2[n3++] = d5;
            dArray2[n3++] = RotationalPendulum.this.f2(d2, d4, d3, d5);
            dArray2[n3++] = 1.0;
        }
    }
}

