/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;

public class InitialConditionData
extends IntervalData {
    private DelayDifferentialEquation mDDE;
    private double[] mState;

    public InitialConditionData(DelayDifferentialEquation dde) {
        super(Double.NaN, Double.NaN);
        double[] state = dde.getState();
        this.mDDE = dde;
        this.mState = new double[state.length];
    }

    @Override
    public double interpolate(double time, int index) {
        this.mDDE.getInitialCondition(time, this.mState);
        return this.mState[index];
    }

    @Override
    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        this.mDDE.getInitialCondition(time, this.mState);
        System.arraycopy(this.mState, beginIndex, state, 0, length);
        return state;
    }
}

