/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementCylinder;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementCylinder
extends SimpleAbstractTile {
    public SimpleElementCylinder(ElementCylinder _element) {
        super(_element);
    }

    @Override
    protected double[][][] computeTile() {
        Resolution res;
        ElementCylinder cylinder = (ElementCylinder)this.element;
        int nr = 1;
        int nu = 1;
        int nz = 1;
        double angle1 = cylinder.getMinimumAngle();
        double angle2 = cylinder.getMaximumAngle();
        if (Math.abs(angle2 - angle1) > 360.0) {
            angle2 = angle1 + 360.0;
        }
        if ((res = this.style.getResolution()) != null) {
            switch (res.getType()) {
                case 0: {
                    nr = Math.max(res.getN1(), 1);
                    nu = Math.max(res.getN2(), 1);
                    nz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    double dx = Math.abs(this.element.getSizeX()) / 2.0;
                    double dy = Math.abs(this.element.getSizeY()) / 2.0;
                    nr = Math.max((int)Math.round(0.49 + Math.max(dx, dy) / res.getMaxLength()), 1);
                    nu = Math.max((int)Math.round(0.49 + Math.abs(angle2 - angle1) * (Math.PI / 180) * (dx + dy) / res.getMaxLength()), 1);
                    nz = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeZ()) / res.getMaxLength()), 1);
                }
            }
        }
        return ElementCylinder.createStandardCylinder(nr, nu, nz, angle1, angle2, cylinder.isClosedTop(), cylinder.isClosedBottom(), cylinder.isClosedLeft(), cylinder.isClosedRight());
    }
}

