/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import org.opensourcephysics.drawing3d.ElementEllipsoid;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementEllipsoid
extends Java3dElement {
    private Sphere sphere;
    private TransformGroup tg;
    private BranchGroup bg;
    double[][][] standardSphere;
    private int nr = 0;
    private int nu = 0;
    private int nv = 0;

    public Java3dElementEllipsoid(ElementEllipsoid _element) {
        super(_element);
        Transform3D t1 = new Transform3D();
        t1.rotX(1.5707963267948966);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(t1);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 0x10) != 0) {
            if (this.element.getStyle().getResolution().getType() == 1) {
                double maxRadius = Math.max(Math.max(Math.abs(this.element.getSizeX()), Math.abs(this.element.getSizeY())), Math.abs(this.element.getSizeZ())) / 2.0;
                this.nr = Math.max((int)Math.round(0.49 + maxRadius / this.element.getStyle().getResolution().getMaxLength()), 1);
                this.nu = Math.max((int)Math.round(0.49 + (double)Math.abs(((ElementEllipsoid)this.element).getMaximumAngleU() - ((ElementEllipsoid)this.element).getMinimumAngleU()) * (Math.PI / 180) * maxRadius / this.element.getStyle().getResolution().getMaxLength()), 1);
                this.nv = Math.max((int)Math.round(0.49 + (double)Math.abs(((ElementEllipsoid)this.element).getMaximumAngleV() - ((ElementEllipsoid)this.element).getMinimumAngleV()) * (Math.PI / 180) * maxRadius / this.element.getStyle().getResolution().getMaxLength()), 1);
            } else {
                this.nr = Math.max(this.element.getStyle().getResolution().getN1(), 1);
                this.nu = Math.max(this.element.getStyle().getResolution().getN2(), 1);
                this.nv = Math.max(this.element.getStyle().getResolution().getN3(), 1);
            }
            if (((ElementEllipsoid)this.element).checkStandarEllipsoid() && this.element.getStyle().isDrawingFill()) {
                this.primitive = true;
                this.createPrimitiveEllipsoid(2 * Math.max(this.nu, this.nv));
            } else {
                this.primitive = false;
                this.createTileEllipsoid();
            }
            this.styleChanged(10);
        }
        if ((_change & 8) != 0) {
            if (((ElementEllipsoid)this.element).checkStandarEllipsoid() && this.element.getStyle().isDrawingFill()) {
                if (this.primitive) {
                    return;
                }
                this.primitive = true;
                this.createPrimitiveEllipsoid(2 * Math.max(this.nu, this.nv));
            } else {
                this.primitive = false;
                this.createTileEllipsoid();
            }
            this.styleChanged(10);
        }
    }

    private void createPrimitiveEllipsoid(int _divisions) {
        if (this.sphere != null || this.standardSphere != null) {
            this.tg.removeChild((Node)this.bg);
        }
        this.sphere = new Sphere(0.5f, 35, _divisions);
        this.sphere.setAppearance(this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.sphere);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    private void createTileEllipsoid() {
        this.standardSphere = ElementEllipsoid.createStandardEllipsoid(this.nr, this.nu, this.nv, ((ElementEllipsoid)this.element).getMinimumAngleU(), ((ElementEllipsoid)this.element).getMaximumAngleU(), ((ElementEllipsoid)this.element).getMinimumAngleV(), ((ElementEllipsoid)this.element).getMaximumAngleV(), ((ElementEllipsoid)this.element).isClosedTop(), ((ElementEllipsoid)this.element).isClosedBottom(), ((ElementEllipsoid)this.element).isClosedLeft(), ((ElementEllipsoid)this.element).isClosedRight());
        int totalN = this.standardSphere.length;
        int tileSize = this.standardSphere[0].length;
        Point3d[] coords = new Point3d[totalN * tileSize * 2];
        int n = 0;
        while (n < totalN) {
            int j = 0;
            while (j < tileSize) {
                coords[n * tileSize + j + totalN * tileSize] = new Point3d(this.standardSphere[n][j][0], this.standardSphere[n][j][1], this.standardSphere[n][j][2]);
                if (j == 0) {
                    coords[n * tileSize + j + 3] = new Point3d(this.standardSphere[n][j][0], this.standardSphere[n][j][1], this.standardSphere[n][j][2]);
                } else if (j == 1) {
                    coords[n * tileSize + j + 1] = new Point3d(this.standardSphere[n][j][0], this.standardSphere[n][j][1], this.standardSphere[n][j][2]);
                } else if (j == 2) {
                    coords[n * tileSize + j - 1] = new Point3d(this.standardSphere[n][j][0], this.standardSphere[n][j][1], this.standardSphere[n][j][2]);
                } else {
                    coords[n * tileSize + j - 3] = new Point3d(this.standardSphere[n][j][0], this.standardSphere[n][j][1], this.standardSphere[n][j][2]);
                }
                ++j;
            }
            ++n;
        }
        GeometryInfo gi = new GeometryInfo(2);
        gi.setCoordinates(coords);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle((float)Math.toRadians(40.0));
        ng.generateNormals(gi);
        GeometryArray figure = gi.getGeometryArray();
        Shape3D shape = new Shape3D((Geometry)figure, this.getAppearance());
        this.addNode((Node)shape);
    }

    @Override
    public void styleChanged(int _change) {
        super.styleChanged(_change);
        if (_change == 4 || _change == 3) {
            if (this.element.getStyle().isDrawingLines() && !this.element.getStyle().isDrawingFill()) {
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = false;
                this.createTileEllipsoid();
            }
            if (this.element.getStyle().isDrawingFill() && ((ElementEllipsoid)this.element).checkStandarEllipsoid()) {
                if (this.primitive) {
                    return;
                }
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = true;
                this.createPrimitiveEllipsoid(2 * Math.max(this.nu, this.nv));
            }
        }
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }
}

