/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Cone;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.java3d.Java3dElementSegment;

public class Java3dElementArrow
extends Java3dElementSegment {
    private static final double HEAD_SCALE = 0.075;
    private double size = 1.25;
    private TransformGroup coneTg;
    private Transform3D coneTransform;

    public Java3dElementArrow(ElementArrow _element) {
        super(_element);
        this.element.getStyle().setDrawingFill(true);
        Cone cone = new Cone(0.5f, 1.0f, 3, 10, 10, this.getAppearance());
        this.size = ((ElementArrow)this.element).getHeadSize();
        this.coneTransform = new Transform3D();
        this.coneTg = new TransformGroup();
        this.coneTg.setCapability(18);
        this.coneTg.setCapability(13);
        this.coneTg.setCapability(14);
        this.coneTg.setTransform(this.coneTransform);
        this.coneTg.addChild((Node)cone);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)this.coneTg);
        this.getBranchGroup().addChild((Node)bg);
        this.resetConePosition();
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 0x66) != 0) {
            this.resetConePosition();
        }
    }

    @Override
    public void styleChanged(int _change) {
        super.styleChanged(_change);
        switch (_change) {
            case 1: {
                this.size = 1.25;
                if (this.element.getStyle().getLineWidth() > 1.0f) {
                    this.size += (double)(this.element.getStyle().getLineWidth() - 1.0f) * 0.5;
                }
                this.resetConePosition();
            }
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    private void resetConePosition() {
        Vector3d v = new Vector3d(0.0, 1.0, 0.0);
        Vector3d norm = new Vector3d(this.getSizeVector());
        norm.normalize();
        norm.x = Double.isNaN(norm.x) ? 0.0 : norm.x;
        norm.y = Double.isNaN(norm.y) ? 0.0 : norm.y;
        norm.z = Double.isNaN(norm.z) ? 0.0 : norm.z;
        AxisAngle4d axisAngle = new AxisAngle4d();
        axisAngle.angle = Math.acos(v.dot(norm));
        Vector3d sizeVector = this.getSizeVector();
        if (sizeVector.x == 0.0 && sizeVector.y < 0.0 && sizeVector.z == 0.0) {
            sizeVector.z = 1.0E-5;
        }
        v.cross(v, sizeVector);
        axisAngle.x = v.x;
        axisAngle.y = v.y;
        axisAngle.z = v.z;
        double coneLength = sizeVector.length() * 0.075 * this.size;
        norm.scale(sizeVector.length() * 0.075 * 0.5);
        Vector3d pos = new Vector3d();
        pos.x = this.getPositionVector().x;
        pos.y = this.getPositionVector().y;
        pos.z = this.getPositionVector().z;
        norm.sub(pos);
        norm.sub(sizeVector, norm);
        this.coneTransform.set(axisAngle);
        this.coneTransform.setTranslation(norm);
        this.coneTransform.setScale(coneLength);
        this.coneTg.setTransform(this.coneTransform);
    }
}

