/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.Set;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.interaction.InteractionSource;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Style;
import org.opensourcephysics.drawing3d.utils.TransformationWrapper;
import org.opensourcephysics.numerics.Transformation;

public abstract class Element
implements InteractionSource {
    public static final double[] STD_ORIGIN = new double[]{0.0, 0.0, 0.0};
    public static final double[] STD_END = new double[]{1.0, 1.0, 1.0};
    public static final double[] STD_CENTERED_ORIGIN = new double[]{-0.5, -0.5, -0.5};
    public static final double[] STD_CENTERED_END = new double[]{0.5, 0.5, 0.5};
    public static final double TO_RADIANS = Math.PI / 180;
    public static final double[] X_UNIT_VECTOR = new double[]{1.0, 0.0, 0.0};
    public static final double[] Y_UNIT_VECTOR = new double[]{0.0, 1.0, 0.0};
    public static final double[] Z_UNIT_VECTOR = new double[]{0.0, 0.0, 1.0};
    public static final int TARGET_POSITION = 0;
    public static final int TARGET_SIZE = 1;
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_VISIBILITY = 1;
    public static final int CHANGE_POSITION = 2;
    public static final int CHANGE_SIZE = 4;
    public static final int CHANGE_SHAPE = 8;
    public static final int CHANGE_RESOLUTION = 16;
    public static final int CHANGE_GROUP = 32;
    public static final int CHANGE_PROJECTION = 64;
    public static final int CHANGE_COLOR = 128;
    public static final int CHANGE_TRANSFORMATION = 256;
    public static final int CHANGE_POSITION_AND_SIZE = 38;
    public static final int CHANGE_INTERACTION_POINTS = 102;
    private String name = "unnamed";
    private boolean visible = true;
    private boolean canBeMeasured = true;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private double sizeZ = 1.0;
    private Transformation transformation = null;
    private Style style = new Style(this);
    private Group group = null;
    private Object dataObject = null;
    private boolean levelBelowWhenEqual = true;
    private double levelx = 0.0;
    private double levely = 0.0;
    private double levelz = 0.0;
    private double leveldx = 0.0;
    private double leveldy = 0.0;
    private double leveldz = 1.0;
    private double[] levelZ;
    private Color[] levelColors;
    protected int changeType = 0;
    private int implementation = -1;
    private DrawingPanel3D panel;
    private ImplementingObject implementingObject;
    private ImplementingObject previousImplementingObject;
    protected double[] center = new double[3];
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);
    private ArrayList<InteractionListener> listeners = new ArrayList();
    private ArrayList<TransformationWrapper> additionalTransformations = new ArrayList();

    protected abstract ImplementingObject createImplementingObject(int var1);

    public final ImplementingObject getImplementingObject() {
        return this.implementingObject;
    }

    public final ImplementingObject getPreviousImplementingObject() {
        return this.previousImplementingObject;
    }

    protected void setImplementation(int _implementation) {
        if (_implementation == this.implementation && this.implementingObject != null) {
            return;
        }
        this.implementation = _implementation;
        this.previousImplementingObject = this.implementingObject;
        this.implementingObject = this.createImplementingObject(this.implementation);
    }

    protected final int getImplementation() {
        return this.implementation;
    }

    public void setPanel(DrawingPanel3D _panel) {
        if (this.implementingObject != null) {
            this.implementingObject.removeFromScene();
        }
        this.panel = _panel;
        this.setImplementation(this.panel.getImplementation());
        this.implementingObject.addToScene();
    }

    public void removePanel() {
        if (this.implementingObject != null) {
            this.implementingObject.removeFromScene();
            this.panel = null;
            this.implementingObject = null;
        }
    }

    public final DrawingPanel3D getPanel() {
        Element el = this;
        while (el.group != null) {
            el = el.group;
        }
        return el.panel;
    }

    void setGroup(Group _group) {
        if (this.implementingObject != null) {
            this.implementingObject.removeFromScene();
        }
        this.group = _group;
        if (this.group != null) {
            this.panel = _group.getPanel();
            if (this instanceof Set || this instanceof Group) {
                for (Element element : ((Group)this).elementList) {
                    element.panel = _group.getPanel();
                }
            }
            this.setImplementation(_group.getImplementation());
            if (this.implementingObject != null) {
                this.implementingObject.addToScene();
            }
        }
        this.changeType |= 0x20;
    }

    public final Group getGroup() {
        return this.group;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setVisible(boolean _visible) {
        if (this.visible != _visible) {
            this.visible = _visible;
            this.changeType |= 1;
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setX(double _x) {
        this.x = _x;
        this.changeType |= 2;
    }

    public final double getX() {
        return this.x;
    }

    public void setY(double _y) {
        this.y = _y;
        this.changeType |= 2;
    }

    public final double getY() {
        return this.y;
    }

    public void setZ(double _z) {
        this.z = _z;
        this.changeType |= 2;
    }

    public final double getZ() {
        return this.z;
    }

    public void setXYZ(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.changeType |= 2;
    }

    public void setPosition(double[] _pos) {
        this.setXYZ(_pos[0], _pos[1], _pos[2]);
    }

    public final double[] getPosition() {
        return new double[]{this.x, this.y, this.z};
    }

    public final double[] getScaledPosition() {
        return this.panel.scalePosition(this.getPosition());
    }

    public void setSizeX(double _sizeX) {
        this.sizeX = _sizeX;
        this.changeType |= 4;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double _sizeY) {
        this.sizeY = _sizeY;
        this.changeType |= 4;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeZ(double _sizeZ) {
        this.sizeZ = _sizeZ;
        this.changeType |= 4;
    }

    public final double getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeXYZ(double _sizeX, double _sizeY, double _sizeZ) {
        this.sizeX = _sizeX;
        this.sizeY = _sizeY;
        this.sizeZ = _sizeZ;
        this.changeType |= 4;
    }

    public void setSize(double[] _size) {
        this.setSizeXYZ(_size[0], _size[1], _size[2]);
    }

    public final double[] getSize() {
        return new double[]{this.sizeX, this.sizeY, this.sizeZ};
    }

    public final double[] getScaledSize() {
        return this.panel.scaleSize(this.getSize());
    }

    public void setTransformation(Transformation _transformation) {
        this.transformation = _transformation == null ? null : (Transformation)_transformation.clone();
        this.changeType |= 0x100;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return null;
        }
        return (Transformation)this.transformation.clone();
    }

    public void addSecondaryTransformation(TransformationWrapper _transform) {
        this.addSecondaryTransformation(_transform, -1);
    }

    public void addSecondaryTransformation(TransformationWrapper _transform, int _index) {
        if (_index < 0 || _index > this.additionalTransformations.size()) {
            this.additionalTransformations.add(_transform);
        } else {
            this.additionalTransformations.add(_index, _transform);
        }
        this.changeType |= 0x100;
    }

    public void addSecondaryTransformations(List<TransformationWrapper> _transformList) {
        if (this.additionalTransformations.addAll(_transformList)) {
            this.changeType |= 0x100;
        }
    }

    public List<TransformationWrapper> getSecondaryTransformations() {
        ArrayList<TransformationWrapper> list = new ArrayList<TransformationWrapper>();
        for (TransformationWrapper tr : this.additionalTransformations) {
            TransformationWrapper cloned = (TransformationWrapper)tr.clone();
            cloned.setEnabled(tr.isEnabled());
            list.add(cloned);
        }
        return list;
    }

    public void removeSecondaryTransformation(TransformationWrapper _transform) {
        if (this.additionalTransformations.remove(_transform)) {
            this.changeType |= 0x100;
        }
    }

    public void removeAllSecondaryTransformations() {
        if (!this.additionalTransformations.isEmpty()) {
            this.additionalTransformations.clear();
            this.changeType |= 0x100;
        }
    }

    public double[] toSpaceFrame(double[] vector) {
        if (this.transformation != null) {
            this.transformation.direct(vector);
        }
        for (TransformationWrapper trWrapper : this.additionalTransformations) {
            if (!trWrapper.isEnabled()) continue;
            trWrapper.getTransformation().direct(vector);
        }
        vector[0] = vector[0] + this.x;
        vector[1] = vector[1] + this.y;
        vector[2] = vector[2] + this.z;
        Group el = this.group;
        while (el != null) {
            vector[0] = vector[0] * el.sizeX;
            vector[1] = vector[1] * el.sizeY;
            vector[2] = vector[2] * el.sizeZ;
            if (el.transformation != null) {
                el.transformation.direct(vector);
            }
            for (TransformationWrapper trWrapper : el.additionalTransformations) {
                if (!trWrapper.isEnabled()) continue;
                trWrapper.getTransformation().direct(vector);
            }
            vector[0] = vector[0] + el.x;
            vector[1] = vector[1] + el.y;
            vector[2] = vector[2] + el.z;
            el = el.group;
        }
        return vector;
    }

    public double[] toBodyFrame(double[] vector) throws UnsupportedOperationException {
        ArrayList<Element> elList = new ArrayList<Element>();
        Element el = this;
        do {
            elList.add(el);
        } while ((el = el.group) != null);
        int i = elList.size() - 1;
        while (i >= 0) {
            el = (Element)elList.get(i);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            vector[2] = vector[2] - el.z;
            int j = el.additionalTransformations.size() - 1;
            while (j >= 0) {
                el.additionalTransformations.get(j).getTransformation().inverse(vector);
                --j;
            }
            if (el.transformation != null) {
                el.transformation.inverse(vector);
            }
            if (el != this) {
                if (el.sizeX != 0.0) {
                    vector[0] = vector[0] / el.sizeX;
                }
                if (el.sizeY != 0.0) {
                    vector[1] = vector[1] / el.sizeY;
                }
                if (el.sizeZ != 0.0) {
                    vector[2] = vector[2] / el.sizeZ;
                }
            }
            --i;
        }
        return vector;
    }

    public final double[] sizeAndToSpaceFrame(double[] vector) {
        vector[0] = vector[0] * this.sizeX;
        vector[1] = vector[1] * this.sizeY;
        vector[2] = vector[2] * this.sizeZ;
        return this.toSpaceFrame(vector);
    }

    public Style getStyle() {
        return this.style;
    }

    public void styleChanged(int _change) {
        if (this.implementingObject != null) {
            this.implementingObject.styleChanged(_change);
        }
    }

    public void setCanBeMeasured(boolean measured) {
        this.canBeMeasured = measured;
    }

    public boolean getCanBeMeasured() {
        return this.canBeMeasured;
    }

    public double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY + this.sizeZ * this.sizeZ);
    }

    protected void getExtrema(double[] min, double[] max) {
        switch (this.getStyle().getRelativePosition()) {
            case 5: {
                System.arraycopy(STD_ORIGIN, 0, min, 0, 3);
                System.arraycopy(STD_END, 0, max, 0, 3);
                break;
            }
            default: {
                System.arraycopy(STD_CENTERED_ORIGIN, 0, min, 0, 3);
                System.arraycopy(STD_CENTERED_END, 0, max, 0, 3);
                break;
            }
            case 8: {
                System.arraycopy(STD_END, 0, min, 0, 3);
                System.arraycopy(STD_ORIGIN, 0, max, 0, 3);
            }
        }
        this.sizeAndToSpaceFrame(min);
        this.sizeAndToSpaceFrame(max);
    }

    public final void setDataObject(Object _object) {
        this.dataObject = _object;
    }

    public final Object getDataObject() {
        return this.dataObject;
    }

    public void setEnabled(boolean _enabled) {
        this.targetPosition.setEnabled(_enabled);
        this.targetSize.setEnabled(_enabled);
    }

    public boolean isEnabled() {
        return this.targetPosition.isEnabled() || this.targetSize.isEnabled();
    }

    @Override
    public InteractionTarget getInteractionTarget(int target) {
        switch (target) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    @Override
    public void addInteractionListener(InteractionListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeInteractionListener(InteractionListener listener) {
        this.listeners.remove(listener);
    }

    final void invokeActions(InteractionEvent event) {
        for (InteractionListener listener : this.listeners) {
            listener.interactionPerformed(event);
        }
    }

    public final void addChange(int _change) {
        this.changeType |= _change;
    }

    public boolean hasChanged() {
        return this.changeType != 0;
    }

    protected int getChange() {
        return this.changeType;
    }

    public void processChanges(int _cumulativeChange) {
        if (((_cumulativeChange |= this.changeType) & 1) == 0 && !this.visible) {
            this.changeType |= _cumulativeChange;
            return;
        }
        if (this.implementingObject != null) {
            this.implementingObject.processChanges(this.changeType, _cumulativeChange);
        }
        if ((_cumulativeChange & 0x66) != 0) {
            this.projectInteractionPoints();
        }
        this.changeType = 0;
    }

    protected void projectInteractionPoints() {
        System.arraycopy(STD_ORIGIN, 0, this.center, 0, 3);
        this.sizeAndToSpaceFrame(this.center);
        this.getPanel().projectPosition(this.center);
    }

    protected InteractionTarget getTargetHit(int _xpix, int _ypix) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        int sensitivity = this.getStyle().getSensitivity();
        if (Math.abs(this.center[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.center[1] - (double)_ypix) < (double)sensitivity) {
            return this.targetPosition;
        }
        return null;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget target) {
        switch (this.getStyle().getRelativePosition()) {
            default: {
                if (target == this.targetPosition) {
                    return new double[]{0.0, 0.0, 0.0};
                }
                if (target != this.targetSize) break;
                return new double[]{this.getSizeX() != 0.0 ? 1 : 0, this.getSizeY() != 0.0 ? 1 : 0, this.getSizeZ() != 0.0 ? 1 : 0};
            }
            case 0: {
                if (target == this.targetPosition) {
                    return new double[]{0.0, 0.0, 0.0};
                }
                if (target != this.targetSize) break;
                return new double[]{this.getSizeX() == 0.0 ? 0.0 : 0.5, this.getSizeY() == 0.0 ? 0.0 : 0.5, this.getSizeZ() == 0.0 ? 0.0 : 0.5};
            }
        }
        return null;
    }

    public final double[] getHotSpot(InteractionTarget target) {
        double[] coordinates = this.getHotSpotBodyCoordinates(target);
        if (coordinates != null) {
            this.sizeAndToSpaceFrame(coordinates);
        }
        return coordinates;
    }

    final void updateHotSpot(InteractionTarget target, double[] point) {
        if (target.getEnabled() == 8) {
            return;
        }
        Group gr = this.group;
        block2 : switch (target.getType()) {
            case 0: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] origin = this.getHotSpot(target);
                    switch (target.getEnabled()) {
                        case 2: {
                            gr.setX(gr.x + point[0] - origin[0]);
                            break block2;
                        }
                        case 3: {
                            gr.setY(gr.y + point[1] - origin[1]);
                            break block2;
                        }
                        case 4: {
                            gr.setZ(gr.z + point[2] - origin[2]);
                            break block2;
                        }
                        case 5: {
                            gr.setX(gr.x + point[0] - origin[0]);
                            gr.setY(gr.y + point[1] - origin[1]);
                            break block2;
                        }
                        case 6: {
                            gr.setX(gr.x + point[0] - origin[0]);
                            gr.setZ(gr.z + point[2] - origin[2]);
                            break block2;
                        }
                        case 7: {
                            gr.setY(gr.y + point[1] - origin[1]);
                            gr.setZ(gr.z + point[2] - origin[2]);
                            break block2;
                        }
                    }
                    gr.setXYZ(gr.x + point[0] - origin[0], gr.y + point[1] - origin[1], gr.z + point[2] - origin[2]);
                    break;
                }
                double[] coordinates = (double[])point.clone();
                this.groupInverseTransformations(coordinates);
                double[] origin = this.getHotSpotBodyCoordinates(target);
                origin[0] = origin[0] * this.sizeX;
                origin[1] = origin[1] * this.sizeY;
                origin[2] = origin[2] * this.sizeZ;
                if (this.transformation != null) {
                    this.transformation.direct(origin);
                }
                for (TransformationWrapper trWrapper : this.additionalTransformations) {
                    if (!trWrapper.isEnabled()) continue;
                    trWrapper.getTransformation().direct(origin);
                }
                switch (target.getEnabled()) {
                    case 2: {
                        this.setX(coordinates[0] - origin[0]);
                        break block2;
                    }
                    case 3: {
                        this.setY(coordinates[1] - origin[1]);
                        break block2;
                    }
                    case 4: {
                        this.setZ(coordinates[2] - origin[2]);
                        break block2;
                    }
                    case 5: {
                        this.setX(coordinates[0] - origin[0]);
                        this.setY(coordinates[1] - origin[1]);
                        break block2;
                    }
                    case 6: {
                        this.setX(coordinates[0] - origin[0]);
                        this.setZ(coordinates[2] - origin[2]);
                        break block2;
                    }
                    case 7: {
                        this.setY(coordinates[1] - origin[1]);
                        this.setZ(coordinates[2] - origin[2]);
                        break block2;
                    }
                }
                this.setXYZ(coordinates[0] - origin[0], coordinates[1] - origin[1], coordinates[2] - origin[2]);
                break;
            }
            case 1: {
                double[] origin;
                if (gr != null && target.getAffectsGroup()) {
                    double[] coordinates = (double[])point.clone();
                    coordinates[0] = coordinates[0] - gr.x;
                    coordinates[1] = coordinates[1] - gr.y;
                    coordinates[2] = coordinates[2] - gr.z;
                    try {
                        int j = gr.additionalTransformations.size() - 1;
                        while (j >= 0) {
                            gr.additionalTransformations.get(j).getTransformation().inverse(coordinates);
                            --j;
                        }
                        if (gr.transformation != null) {
                            gr.transformation.inverse(coordinates);
                        }
                    }
                    catch (Exception j) {
                        // empty catch block
                    }
                    double[] origin2 = this.getHotSpotBodyCoordinates(target);
                    this.elementDirectTransformations(origin2);
                    coordinates[0] = origin2[0] != 0.0 ? coordinates[0] / origin2[0] : gr.sizeX;
                    coordinates[1] = origin2[1] != 0.0 ? coordinates[1] / origin2[1] : gr.sizeY;
                    coordinates[2] = origin2[2] != 0.0 ? coordinates[2] / origin2[2] : gr.sizeZ;
                    switch (target.getEnabled()) {
                        case 2: {
                            gr.setSizeX(coordinates[0]);
                            break block2;
                        }
                        case 3: {
                            gr.setSizeY(coordinates[1]);
                            break block2;
                        }
                        case 4: {
                            gr.setSizeZ(coordinates[2]);
                            break block2;
                        }
                        case 5: {
                            gr.setSizeX(coordinates[0]);
                            gr.setSizeY(coordinates[1]);
                            break block2;
                        }
                        case 6: {
                            gr.setSizeX(coordinates[0]);
                            gr.setSizeZ(coordinates[2]);
                            break block2;
                        }
                        case 7: {
                            gr.setSizeY(coordinates[1]);
                            gr.setSizeZ(coordinates[2]);
                            break block2;
                        }
                    }
                    gr.setSize(coordinates);
                    break;
                }
                double[] coordinates = (double[])point.clone();
                this.groupInverseTransformations(coordinates);
                coordinates[0] = coordinates[0] - this.x;
                coordinates[1] = coordinates[1] - this.y;
                coordinates[2] = coordinates[2] - this.z;
                try {
                    int j = this.additionalTransformations.size() - 1;
                    while (j >= 0) {
                        this.additionalTransformations.get(j).getTransformation().inverse(coordinates);
                        --j;
                    }
                    if (this.transformation != null) {
                        this.transformation.inverse(coordinates);
                    }
                }
                catch (Exception j) {
                    // empty catch block
                }
                if ((origin = this.getHotSpotBodyCoordinates(target))[0] != 0.0) {
                    coordinates[0] = coordinates[0] / origin[0];
                }
                if (origin[1] != 0.0) {
                    coordinates[1] = coordinates[1] / origin[1];
                }
                if (origin[2] != 0.0) {
                    coordinates[2] = coordinates[2] / origin[2];
                }
                switch (target.getEnabled()) {
                    case 2: {
                        this.setSizeX(coordinates[0]);
                        break block2;
                    }
                    case 3: {
                        this.setSizeY(coordinates[1]);
                        break block2;
                    }
                    case 4: {
                        this.setSizeZ(coordinates[2]);
                        break block2;
                    }
                    case 5: {
                        this.setSizeX(coordinates[0]);
                        this.setSizeY(coordinates[1]);
                        break block2;
                    }
                    case 6: {
                        this.setSizeX(coordinates[0]);
                        this.setSizeZ(coordinates[2]);
                        break block2;
                    }
                    case 7: {
                        this.setSizeY(coordinates[1]);
                        this.setSizeZ(coordinates[2]);
                        break block2;
                    }
                }
                this.setSize(coordinates);
            }
        }
    }

    private final void groupInverseTransformations(double[] vector) throws UnsupportedOperationException {
        ArrayList<Group> elList = new ArrayList<Group>();
        Element el = this.group;
        while (el != null) {
            elList.add((Group)el);
            el = el.group;
        }
        int i = elList.size() - 1;
        while (i >= 0) {
            el = (Element)elList.get(i);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            vector[2] = vector[2] - el.z;
            try {
                int j = el.additionalTransformations.size() - 1;
                while (j >= 0) {
                    el.additionalTransformations.get(j).getTransformation().inverse(vector);
                    --j;
                }
                if (el.transformation != null) {
                    el.transformation.inverse(vector);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] / el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] / el.sizeY;
            }
            if (el.sizeZ != 0.0) {
                vector[2] = vector[2] / el.sizeZ;
            }
            --i;
        }
    }

    private final void elementDirectTransformations(double[] vector) {
        Element el = this;
        do {
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] * el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] * el.sizeY;
            }
            if (el.sizeZ != 0.0) {
                vector[2] = vector[2] * el.sizeZ;
            }
            if (el.transformation != null) {
                el.transformation.direct(vector);
            }
            for (TransformationWrapper trWrapper : el.additionalTransformations) {
                if (!trWrapper.isEnabled()) continue;
                trWrapper.getTransformation().direct(vector);
            }
            vector[0] = vector[0] + el.x;
            vector[1] = vector[1] + el.y;
            vector[2] = vector[2] + el.z;
        } while ((el = el.group) != null && el.group != null);
    }

    public void setColorBelowWhenEqual(boolean belowWhenEqual) {
        this.levelBelowWhenEqual = belowWhenEqual;
    }

    public boolean getColorBelowWhenEqual() {
        return this.levelBelowWhenEqual;
    }

    public double[] getColorLevels() {
        return this.levelZ;
    }

    public Color[] getColorPalette() {
        return this.levelColors;
    }

    public void setColorOrigin(double[] origin) {
        this.levelx = origin[0];
        this.levely = origin[1];
        this.levelz = origin[2];
    }

    public void setColorDirection(double[] direction) {
        this.leveldx = direction[0];
        this.leveldy = direction[1];
        this.leveldz = direction[2];
    }

    public void setColorRegions(double[] thresholds) {
        this.levelZ = thresholds;
    }

    public void setColorPalette(Color[] colors) {
        this.levelColors = colors;
    }

    public void setColorPalette(int[] colors) {
        this.levelColors = new Color[colors.length];
        int i = 0;
        while (i < colors.length) {
            this.levelColors[i] = DisplayColors.getLineColor(colors[i]);
            ++i;
        }
    }

    public double levelScalarProduct(double[] point) {
        return (point[0] - this.levelx) * this.leveldx + (point[1] - this.levely) * this.leveldy + (point[2] - this.levelz) * this.leveldz;
    }
}

