/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.interaction.InteractionSource;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.java3d.Java3dDrawingPanel3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleDrawingPanel3D;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.Decoration;
import org.opensourcephysics.drawing3d.utils.ImplementationChangeListener;
import org.opensourcephysics.drawing3d.utils.ImplementingPanel;
import org.opensourcephysics.drawing3d.utils.VisualizationHints;
import org.opensourcephysics.ejs.EjsRes;
import org.opensourcephysics.tools.VideoTool;

public class DrawingPanel3D
implements InteractionSource,
Renderable {
    private static final boolean isJava3DInstalled = OSPRuntime.hasJava3D();
    private static boolean askedToInstallJava3D = false;
    public static final int IMPLEMENTATION_SIMPLE3D = 0;
    public static final int IMPLEMENTATION_JAVA3D = 1;
    public static final int TARGET_PANEL = 0;
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    public static final int DRAG_NONE = 0;
    public static final int DRAG_ANY = 1;
    public static final int DRAG_AZIMUTH = 2;
    public static final int DRAG_ALTITUDE = 3;
    private boolean squareAspect = true;
    private int implementation = -1;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;
    private double axisXSize = Double.NaN;
    private double axisYSize = Double.NaN;
    private double axisZSize = Double.NaN;
    private VisualizationHints visHints;
    private Camera camera;
    private Decoration decoration;
    private VideoTool vidCap;
    private boolean resetCameraOnChanges = true;
    private ImplementingPanel implementingPanel;
    private ImplementingPanel previousImplementingPanel;
    private double axisXScale;
    private double axisYScale;
    private double axisZScale;
    private double maximumSize;
    private double[] center = new double[3];
    private double aconstant;
    private double bconstant;
    private int acenter;
    private int bcenter;
    private List<Element> elementList = new ArrayList<Element>();
    private ArrayList<ElementText> textList = new ArrayList();
    private int draggable = 1;
    private final InteractionTarget myTarget = new InteractionTarget(null, 0);
    private int keyPressed = -1;
    private int lastX = 0;
    private int lastY = 0;
    private InteractionTarget targetHit = null;
    private InteractionTarget targetEntered = null;
    private double[] trackerPoint = null;
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    private List<ImplementationChangeListener> implementationListeners = new ArrayList<ImplementationChangeListener>();
    private Thread firstTimeThread = null;
    private boolean canRender = true;
    private boolean mImmediateImplementation = false;
    private double mEyeDistance = Double.NaN;
    private AxisInfo xAxisInfo = new AxisInfo();
    private AxisInfo yAxisInfo = new AxisInfo();
    private AxisInfo zAxisInfo = new AxisInfo();

    public DrawingPanel3D(int implementation) {
        if (implementation == 1) {
            this.mImmediateImplementation = true;
        }
        this.visHints = new VisualizationHints(this);
        this.camera = new Camera(this);
        this.decoration = new Decoration(this);
        this.setImplementation(implementation);
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        this.camera.reset();
    }

    public DrawingPanel3D() {
        int impl = 0;
        this.visHints = new VisualizationHints(this);
        this.camera = new Camera(this);
        this.decoration = new Decoration(this);
        this.setImplementation(impl);
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        this.camera.reset();
    }

    public void setEyeDistance(double distance) {
        this.mEyeDistance = distance;
        if (this.implementingPanel != null) {
            this.implementingPanel.setEyeDistance(this.mEyeDistance);
            this.implementingPanel.forceRefresh();
        }
    }

    public boolean setImplementation(final int _implementation) {
        if (this.implementation == _implementation) {
            return true;
        }
        if (_implementation == 1 && !isJava3DInstalled) {
            if (!askedToInstallJava3D) {
                Object[] options = new Object[]{EjsRes.getString("DrawingPanel3D.VisitJava3DSite"), EjsRes.getString("Ok")};
                String message = EjsRes.getString("DrawingPanel3D.InstallJava3D");
                int option = JOptionPane.showOptionDialog(null, message, "Easy Java Simulations", -1, 1, null, options, options[0]);
                if (option == 0) {
                    OSPDesktop.displayURL("http://java3d.java.net/binary-builds.html");
                }
                askedToInstallJava3D = true;
            }
            return false;
        }
        if (this.mImmediateImplementation) {
            return this.doSetImplementation(_implementation);
        }
        if (_implementation == 1 && !this.implementingPanel.getComponent().isShowing()) {
            if (this.firstTimeThread != null && this.firstTimeThread.isAlive()) {
                return false;
            }
            this.canRender = false;
            this.firstTimeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!DrawingPanel3D.this.implementingPanel.getComponent().isShowing()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    DrawingPanel3D.this.doSetImplementation(_implementation);
                    DrawingPanel3D.this.update();
                }
            });
            this.firstTimeThread.start();
            return true;
        }
        return this.doSetImplementation(_implementation);
    }

    private boolean doSetImplementation(int _implementation) {
        this.firstTimeThread = null;
        this.implementation = _implementation;
        this.previousImplementingPanel = this.implementingPanel;
        for (Element el : this.elementList) {
            el.removePanel();
        }
        for (Element el : this.decoration.getElementList()) {
            el.removePanel();
        }
        switch (this.implementation) {
            default: {
                this.implementingPanel = new SimpleDrawingPanel3D(this);
                break;
            }
            case 1: {
                this.implementingPanel = new Java3dDrawingPanel3D(this);
            }
        }
        if (!Double.isNaN(this.mEyeDistance)) {
            this.implementingPanel.setEyeDistance(this.mEyeDistance);
        }
        this.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DrawingPanel3D.this.computeConstants(DrawingPanel3D.this.getComponent().getWidth(), DrawingPanel3D.this.getComponent().getHeight());
                for (Element el : DrawingPanel3D.this.elementList) {
                    el.addChange(64);
                }
                for (Element el : DrawingPanel3D.this.decoration.getElementList()) {
                    el.addChange(64);
                }
                DrawingPanel3D.this.implementingPanel.forceRefresh();
                DrawingPanel3D.this.getComponent().repaint();
            }
        });
        IADMouseController mouseController = new IADMouseController();
        this.getComponent().addMouseListener(mouseController);
        this.getComponent().addMouseMotionListener(mouseController);
        this.getComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                DrawingPanel3D.this.keyPressed = _e.getKeyCode();
            }

            @Override
            public void keyReleased(KeyEvent _e) {
                DrawingPanel3D.this.keyPressed = -1;
            }
        });
        this.getComponent().setFocusable(true);
        this.getComponent().setPreferredSize(new Dimension(300, 300));
        for (Element el : this.elementList) {
            el.setPanel(this);
        }
        for (Element el : this.decoration.getElementList()) {
            el.setPanel(this);
        }
        this.cameraChanged(0);
        if (this.visHints.getBackgroundImage() != null) {
            this.implementingPanel.visualizationChanged(7);
        }
        this.canRender = true;
        for (ImplementationChangeListener listener : this.implementationListeners) {
            listener.implementationChanged(this.implementation);
        }
        return true;
    }

    public final int getImplementation() {
        return this.implementation;
    }

    public Component getComponent() {
        return this.implementingPanel.getComponent();
    }

    public VisualizationHints getVisualizationHints() {
        return this.visHints;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public ImplementingPanel getImplementingPanel() {
        return this.implementingPanel;
    }

    public ImplementingPanel getPreviousImplementingPanel() {
        return this.previousImplementingPanel;
    }

    public void setResetCameraOnChanges(boolean _resetOnChanges) {
        this.resetCameraOnChanges = _resetOnChanges;
    }

    public boolean getResetCameraOnChanges() {
        return this.resetCameraOnChanges;
    }

    public void setAxesSize(double sizeX, double sizeY, double sizeZ) {
        if (this.axisXSize == sizeX && this.axisYSize == sizeY && this.axisZSize == sizeZ) {
            return;
        }
        this.axisXSize = sizeX;
        this.axisYSize = sizeY;
        this.axisZSize = sizeZ;
        this.adjustScales();
        this.maximumSize = this.getMaximum3DSize();
        this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
        if (this.resetCameraOnChanges) {
            this.camera.adjust();
        }
        for (Element el : this.elementList) {
            el.addChange(64);
        }
        for (Element el : this.decoration.getElementList()) {
            el.addChange(64);
        }
        this.implementingPanel.forceRefresh();
    }

    public final double getAxisXSize() {
        return this.axisXSize;
    }

    public final double getAxisYSize() {
        return this.axisYSize;
    }

    public final double getAxisZSize() {
        return this.axisZSize;
    }

    public void setPreferredMinMax(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        if (this.xmin == minX && this.xmax == maxX && this.ymin == minY && this.ymax == maxY && this.zmin == minZ && this.zmax == maxZ) {
            return;
        }
        this.xmin = minX;
        this.xmax = maxX;
        this.ymin = minY;
        this.ymax = maxY;
        this.zmin = minZ;
        this.zmax = maxZ;
        this.adjustScales();
        double newSize = this.getMaximum3DSize();
        if (newSize != this.maximumSize) {
            this.maximumSize = newSize;
            this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
            if (this.resetCameraOnChanges) {
                this.camera.adjust();
            }
        }
        this.decoration.reset();
        for (Element el : this.elementList) {
            el.addChange(64);
        }
        for (Element el : this.decoration.getElementList()) {
            el.addChange(64);
        }
        this.visHints.setScaleBackground(this.getMaximum3DSize());
        this.implementingPanel.forceRefresh();
    }

    public void zoomToFit() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] firstPoint = new double[3];
        double[] secondPoint = new double[3];
        for (Element el : this.elementList) {
            el.getExtrema(firstPoint, secondPoint);
            minX = Math.min(Math.min(minX, firstPoint[0]), secondPoint[0]);
            maxX = Math.max(Math.max(maxX, firstPoint[0]), secondPoint[0]);
            minY = Math.min(Math.min(minY, firstPoint[1]), secondPoint[1]);
            maxY = Math.max(Math.max(maxY, firstPoint[1]), secondPoint[1]);
            minZ = Math.min(Math.min(minZ, firstPoint[2]), secondPoint[2]);
            maxZ = Math.max(Math.max(maxZ, firstPoint[2]), secondPoint[2]);
        }
        double max = Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
        if (max == 0.0) {
            max = 2.0;
        }
        if (minX >= maxX) {
            minX = maxX - max / 2.0;
            maxX = minX + max;
        }
        if (minY >= maxY) {
            minY = maxY - max / 2.0;
            maxY = minY + max;
        }
        if (minZ >= maxZ) {
            minZ = maxZ - max / 2.0;
            maxZ = minZ + max;
        }
        this.setPreferredMinMax(minX, maxX, minY, maxY, minZ, maxZ);
    }

    public final double getPreferredMinX() {
        return this.xmin;
    }

    public final double getPreferredMaxX() {
        return this.xmax;
    }

    public final double getPreferredMinY() {
        return this.ymin;
    }

    public final double getPreferredMaxY() {
        return this.ymax;
    }

    public final double getPreferredMinZ() {
        return this.zmin;
    }

    public final double getPreferredMaxZ() {
        return this.zmax;
    }

    public void addElement(Element element) {
        if (!this.elementList.contains(element)) {
            element.setPanel(this);
            this.elementList.add(element);
            if (element instanceof ElementText) {
                this.textList.add((ElementText)element);
            }
            this.implementingPanel.forceRefresh();
        }
    }

    public void removeElement(Element element) {
        if (this.elementList.remove(element)) {
            if (this.textList.contains(element)) {
                this.textList.remove(element);
            }
            element.removePanel();
            this.implementingPanel.forceRefresh();
        }
    }

    public void removeAllElements() {
        this.elementList.clear();
        this.implementingPanel.forceRefresh();
    }

    public synchronized List<Element> getElements() {
        return new ArrayList<Element>(this.elementList);
    }

    public synchronized List<ElementText> getTextElements() {
        return new ArrayList<ElementText>(this.textList);
    }

    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
    }

    public boolean canRender() {
        return this.canRender;
    }

    @Override
    public BufferedImage render(BufferedImage image) {
        return this.implementingPanel.render(image);
    }

    @Override
    public BufferedImage render() {
        return this.implementingPanel.render();
    }

    public void update() {
        if (this.canRender) {
            this.implementingPanel.update();
        }
    }

    @Override
    public InteractionTarget getInteractionTarget(int target) {
        return this.myTarget;
    }

    @Override
    public void addInteractionListener(InteractionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeInteractionListener(InteractionListener listener) {
        this.listeners.remove(listener);
    }

    public void addImplementationChangeListener(ImplementationChangeListener listener) {
        this.implementationListeners.add(listener);
    }

    private void invokeActions(InteractionEvent event) {
        for (InteractionListener listener : this.listeners) {
            listener.interactionPerformed(event);
        }
    }

    public void hintChanged(int hintThatChanged) {
        switch (hintThatChanged) {
            case -1: {
                this.decoration.updateAxesLabels();
                this.decoration.setCursorMode();
                this.decoration.updateType();
                break;
            }
            case 0: {
                this.decoration.updateType();
                this.decoration.reset();
                break;
            }
            case 6: {
                this.decoration.updateAxesLabels();
                break;
            }
            case 4: {
                this.decoration.setCursorMode();
                break;
            }
            case 10: {
                this.decoration.adjustColors();
                this.implementingPanel.visualizationChanged(hintThatChanged);
                break;
            }
            case 11: {
                this.decoration.adjustFont();
                break;
            }
            case 7: {
                this.implementingPanel.visualizationChanged(hintThatChanged);
                break;
            }
            case 8: {
                this.implementingPanel.visualizationChanged(hintThatChanged);
                break;
            }
            case 9: {
                this.implementingPanel.visualizationChanged(hintThatChanged);
                break;
            }
            case 12: {
                this.implementingPanel.visualizationChanged(hintThatChanged);
            }
        }
        if (this.implementingPanel != null) {
            this.implementingPanel.forceRefresh();
        }
    }

    public void cameraChanged(int howItChanged) {
        switch (howItChanged) {
            case 1: {
                this.maximumSize = this.getMaximum3DSize();
                this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
                if (this.resetCameraOnChanges) {
                    this.camera.adjust();
                }
                this.implementingPanel.update();
            }
        }
        this.implementingPanel.cameraChanged(howItChanged);
        for (Element el : this.elementList) {
            el.addChange(64);
        }
        for (Element el : this.decoration.getElementList()) {
            el.addChange(64);
        }
        this.implementingPanel.forceRefresh();
    }

    public final double[] getCenter() {
        return (double[])this.center.clone();
    }

    public final double getDiagonal() {
        double dx = Double.isNaN(this.axisXSize) ? this.xmax - this.xmin : this.axisXSize;
        double dy = Double.isNaN(this.axisYSize) ? this.ymax - this.ymin : this.axisYSize;
        double dz = Double.isNaN(this.axisZSize) ? this.zmax - this.zmin : this.axisZSize;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final double getMaximum3DSize() {
        double dx = Double.isNaN(this.axisXSize) ? this.xmax - this.xmin : this.axisXSize;
        double dy = Double.isNaN(this.axisYSize) ? this.ymax - this.ymin : this.axisYSize;
        double dz = Double.isNaN(this.axisZSize) ? this.zmax - this.zmin : this.axisZSize;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return Math.max(dx, dy);
            }
            case 1: {
                return Math.max(dx, dz);
            }
            case 2: {
                return Math.max(dy, dz);
            }
        }
        return Math.max(Math.max(dx, dy), dz);
    }

    public void setSquareAspect(boolean square) {
        if (this.squareAspect == square) {
            return;
        }
        this.squareAspect = square;
        this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
        for (Element el : this.elementList) {
            el.addChange(64);
        }
        for (Element el : this.decoration.getElementList()) {
            el.addChange(64);
        }
        this.implementingPanel.forceRefresh();
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    private void adjustScales() {
        this.center[0] = Double.isNaN(this.axisXSize) ? (this.xmax + this.xmin) / 2.0 : this.axisXSize / 2.0;
        this.center[1] = Double.isNaN(this.axisYSize) ? (this.ymax + this.ymin) / 2.0 : this.axisYSize / 2.0;
        this.center[2] = Double.isNaN(this.axisZSize) ? (this.zmax + this.zmin) / 2.0 : this.axisZSize / 2.0;
        this.axisXScale = this.axisXSize / (this.xmax - this.xmin);
        this.axisYScale = this.axisYSize / (this.ymax - this.ymin);
        this.axisZScale = this.axisZSize / (this.zmax - this.zmin);
    }

    public void computeConstants(int width, int height) {
        this.acenter = width / 2;
        this.bcenter = height / 2;
        if (this.squareAspect) {
            width = height = Math.min(width, height);
        }
        this.aconstant = 0.5 * (double)width / this.maximumSize;
        this.bconstant = 0.5 * (double)height / this.maximumSize;
    }

    private double[] worldPoint(int a, int b) {
        double z;
        double y;
        double x;
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                x = this.center[0] + (double)(a - this.acenter) / (factor * this.aconstant);
                if (!Double.isNaN(this.axisXSize)) {
                    x = this.xmin + x / this.axisXScale;
                }
                y = this.center[1] + (double)(this.bcenter - b) / (factor * this.bconstant);
                if (!Double.isNaN(this.axisYSize)) {
                    y = this.ymin + y / this.axisYScale;
                }
                z = Double.NaN;
                break;
            }
            case 1: {
                x = this.center[0] + (double)(a - this.acenter) / (factor * this.aconstant);
                if (!Double.isNaN(this.axisXSize)) {
                    x = this.xmin + x / this.axisXScale;
                }
                y = Double.NaN;
                z = this.center[2] + (double)(this.bcenter - b) / (factor * this.bconstant);
                if (Double.isNaN(this.axisZSize)) break;
                z = this.zmin + z / this.axisZScale;
                break;
            }
            case 2: {
                x = Double.NaN;
                y = this.center[1] + (double)(a - this.acenter) / (factor * this.aconstant);
                if (!Double.isNaN(this.axisYSize)) {
                    y = this.ymin + y / this.axisYScale;
                }
                z = this.center[2] + (double)(this.bcenter - b) / (factor * this.bconstant);
                if (Double.isNaN(this.axisZSize)) break;
                z = this.zmin + z / this.axisZScale;
                break;
            }
            default: {
                return this.camera.inverseMapping((double[])this.center.clone());
            }
        }
        return new double[]{x, y, z};
    }

    public double[] scalePosition(double[] point) {
        if (!Double.isNaN(this.axisXSize)) {
            point[0] = (point[0] - this.xmin) * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            point[1] = (point[1] - this.ymin) * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            point[2] = (point[2] - this.zmin) * this.axisZScale;
        }
        return this.camera.map(point);
    }

    public double[] scaleSize(double[] point) {
        if (!Double.isNaN(this.axisXSize)) {
            point[0] = point[0] * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            point[1] = point[1] * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            point[2] = point[2] * this.axisZScale;
        }
        return this.camera.map(point);
    }

    public double[] projectPosition(double[] point) {
        if (!Double.isNaN(this.axisXSize)) {
            point[0] = (point[0] - this.xmin) * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            point[1] = (point[1] - this.ymin) * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            point[2] = (point[2] - this.zmin) * this.axisZScale;
        }
        this.camera.projectPosition(point);
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 3: 
            case 10: {
                factor = 1.3;
                break;
            }
            case 4: 
            case 11: {
                factor = 1.0;
            }
        }
        point[0] = (double)this.acenter + point[0] * factor * this.aconstant;
        point[1] = (double)this.bcenter - point[1] * factor * this.bconstant;
        return point;
    }

    public double[] projectSize(double[] point, double[] size) {
        if (!Double.isNaN(this.axisXSize)) {
            point[0] = (point[0] - this.xmin) * this.axisXScale;
            size[0] = size[0] * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            point[1] = (point[1] - this.ymin) * this.axisYScale;
            size[1] = size[1] * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            point[2] = (point[2] - this.zmin) * this.axisZScale;
            size[2] = size[2] * this.axisZScale;
        }
        this.camera.projectSize(point, size);
        double factor = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 3: 
            case 10: {
                factor = 1.3;
                break;
            }
            case 4: 
            case 11: {
                factor = 1.0;
            }
        }
        size[0] = size[0] * (factor * this.aconstant);
        size[1] = size[1] * (factor * this.bconstant);
        return size;
    }

    public Paint projectPaint(Paint _fillPaint, double _depth) {
        if (_fillPaint instanceof Color) {
            return this.projectColor((Color)_fillPaint, _depth);
        }
        return _fillPaint;
    }

    public Color projectColor(Color _aColor, double _depth) {
        if (!this.visHints.isUseColorDepth()) {
            return _aColor;
        }
        float[] crc = new float[4];
        try {
            _aColor.getRGBComponents(crc);
            int i = 0;
            while (i < 3) {
                int n = i;
                crc[n] = (float)((double)crc[n] / _depth);
                crc[i] = (float)Math.max(Math.min((double)crc[i], 1.0), 0.0);
                ++i;
            }
            return new Color(crc[0], crc[1], crc[2], crc[3]);
        }
        catch (Exception _exc) {
            return _aColor;
        }
    }

    public void setDraggable(boolean _canDrag) {
        this.draggable = _canDrag ? 1 : 0;
    }

    public boolean isDraggable() {
        return this.draggable == 1;
    }

    public void setDraggable(int _dragType) {
        this.draggable = _dragType;
    }

    public int getDraggable() {
        return this.draggable;
    }

    private InteractionTarget getTargetHit(int x, int y) {
        for (Element el : this.elementList) {
            if (!el.isVisible() || !el.isEnabled()) continue;
            el.processChanges(0);
            InteractionTarget target = el.getTargetHit(x, y);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private void setMouseCursor(Cursor cursor) {
        this.implementingPanel.getComponent().setCursor(cursor);
    }

    private void displayPosition(double[] _point) {
        this.visHints.displayPosition(this.camera.getProjectionMode(), _point);
        this.decoration.positionTrackers(_point);
    }

    private boolean mouseDraggedComputations(MouseEvent e) {
        block51: {
            double zeroCase;
            block50: {
                if (e.isControlDown()) {
                    if (!this.isDraggable()) {
                        return false;
                    }
                    if (this.camera.is3dMode()) {
                        double fx = this.camera.getFocusX();
                        double fy = this.camera.getFocusY();
                        double fz = this.camera.getFocusZ();
                        double dx = (double)(e.getX() - this.lastX) * this.maximumSize * 0.01;
                        double dy = (double)(e.getY() - this.lastY) * this.maximumSize * 0.01;
                        switch (this.keyPressed) {
                            case 88: {
                                if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(fx + dy, fy, fz);
                                    break;
                                }
                                if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                                    this.camera.setFocusXYZ(fx + dx, fy, fz);
                                    break;
                                }
                                if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(fx - dy, fy, fz);
                                    break;
                                }
                                this.camera.setFocusXYZ(fx - dx, fy, fz);
                                break;
                            }
                            case 89: {
                                if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(fx, fy - dx, fz);
                                    break;
                                }
                                if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                                    this.camera.setFocusXYZ(fx, fy + dy, fz);
                                    break;
                                }
                                if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(fx, fy + dx, fz);
                                    break;
                                }
                                this.camera.setFocusXYZ(fx, fy - dy, fz);
                                break;
                            }
                            case 90: {
                                if (this.camera.getCosBeta() >= 0.0) {
                                    this.camera.setFocusXYZ(fx, fy, fz + dy);
                                    break;
                                }
                                this.camera.setFocusXYZ(fx, fy, fz - dy);
                                break;
                            }
                            default: {
                                if (this.camera.getCosBeta() < 0.0) {
                                    dy = -dy;
                                }
                                if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(fx, fy - dx, fz + dy);
                                    break;
                                }
                                if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                                    this.camera.setFocusXYZ(fx + dx, fy, fz + dy);
                                    break;
                                }
                                if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(fx, fy + dx, fz - dy);
                                    break;
                                }
                                this.camera.setFocusXYZ(fx - dx, fy, fz - dy);
                                break;
                            }
                        }
                    } else {
                        double fx = this.camera.getFocusX();
                        double fy = this.camera.getFocusY();
                        double fz = this.camera.getFocusZ();
                        double dx = (double)(e.getX() - this.lastX) * this.maximumSize * 0.01;
                        double dy = (double)(e.getY() - this.lastY) * this.maximumSize * 0.01;
                        switch (this.camera.getProjectionMode()) {
                            case 0: {
                                this.camera.setFocusXYZ(fx - dx, fy + dy, fz);
                                break;
                            }
                            case 2: {
                                this.camera.setFocusXYZ(fx, fy - dx, fz + dy);
                                break;
                            }
                            case 1: {
                                this.camera.setFocusXYZ(fx - dx, fy, fz + dy);
                            }
                        }
                    }
                    return false;
                }
                if (e.isShiftDown()) {
                    this.camera.setDistanceToScreen(this.camera.getDistanceToScreen() - (double)(e.getY() - this.lastY) * this.maximumSize * 0.01);
                    return false;
                }
                if (this.camera.is3dMode() && this.targetHit == null && !e.isAltDown()) {
                    this.mouseDraggedComputationsForDraggingTheScene(e, this.draggable);
                    return false;
                }
                if (this.trackerPoint == null) {
                    return true;
                }
                if (this.camera.is3dMode()) break block50;
                double[] point = this.worldPoint(e.getX(), e.getY());
                switch (this.keyPressed) {
                    case 88: {
                        if (!Double.isNaN(point[0])) {
                            this.trackerPoint[0] = point[0];
                            break;
                        }
                        break block51;
                    }
                    case 89: {
                        if (!Double.isNaN(point[1])) {
                            this.trackerPoint[1] = point[1];
                            break;
                        }
                        break block51;
                    }
                    case 90: {
                        if (!Double.isNaN(point[2])) {
                            this.trackerPoint[2] = point[2];
                            break;
                        }
                        break block51;
                    }
                    default: {
                        if (!Double.isNaN(point[0])) {
                            this.trackerPoint[0] = point[0];
                        }
                        if (!Double.isNaN(point[1])) {
                            this.trackerPoint[1] = point[1];
                        }
                        if (!Double.isNaN(point[2])) {
                            this.trackerPoint[2] = point[2];
                            break;
                        }
                        break block51;
                    }
                }
                break block51;
            }
            double dH = (double)(e.getX() - this.lastX) / (1.3 * this.aconstant);
            double dV = (double)(e.getY() - this.lastY) / (1.3 * this.bconstant);
            double[] point = new double[3];
            point[2] = this.camera.getCosBeta() >= 0.0 ? -dV : dV;
            if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                point[0] = 0.0;
                point[1] = dH;
                zeroCase = -dH;
            } else if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                point[0] = -dH;
                point[1] = 0.0;
                zeroCase = dH;
            } else if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                point[0] = 0.0;
                point[1] = -dH;
                zeroCase = dH;
            } else {
                point[0] = dH;
                point[1] = 0.0;
                zeroCase = -dH;
            }
            this.camera.inverseMapping(point);
            double sx = Double.isNaN(this.axisXSize) ? 1.0 : this.axisXScale;
            double sy = Double.isNaN(this.axisYSize) ? 1.0 : this.axisYScale;
            double sz = Double.isNaN(this.axisZSize) ? 1.0 : this.axisZScale;
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint[0] = this.trackerPoint[0] + (point[0] == 0.0 ? zeroCase / sx : point[0] / sx);
                    break;
                }
                case 89: {
                    this.trackerPoint[1] = this.trackerPoint[1] + (point[1] == 0.0 ? zeroCase / sy : point[1] / sy);
                    break;
                }
                case 90: {
                    this.trackerPoint[2] = this.trackerPoint[2] + (point[2] == 0.0 ? zeroCase / sz : point[2] / sz);
                    break;
                }
                default: {
                    this.trackerPoint[0] = this.trackerPoint[0] + point[0] / sx;
                    this.trackerPoint[1] = this.trackerPoint[1] + point[1] / sy;
                    this.trackerPoint[2] = this.trackerPoint[2] + point[2] / sz;
                }
            }
        }
        return true;
    }

    private AxisInfo getAxisInfo(int _axisNumber, AxisInfo _info) {
        ElementArrow axis;
        switch (_axisNumber) {
            default: {
                axis = this.decoration.getXAxis();
                _info.scale = Double.isNaN(this.axisXSize) ? 1.0 : this.axisXScale;
                break;
            }
            case 1: {
                axis = this.decoration.getYAxis();
                _info.scale = Double.isNaN(this.axisYSize) ? 1.0 : this.axisYScale;
                break;
            }
            case 2: {
                axis = this.decoration.getZAxis();
                _info.scale = Double.isNaN(this.axisZSize) ? 1.0 : this.axisZScale;
            }
        }
        axis.projectInteractionPoints();
        double[] origin = axis.getProjectedOrigin();
        double[] end = axis.getProjectedEnd();
        _info.deltaH = end[0] - origin[0];
        _info.deltaV = end[1] - origin[1];
        return _info;
    }

    private boolean mouseDraggedComputationsForDraggingTheScene(MouseEvent e, int _targetRestrictions) {
        if (_targetRestrictions == 0) {
            return false;
        }
        double dAzi = (double)(e.getX() - this.lastX) * 0.01;
        double dAlt = (double)(e.getY() - this.lastY) * 0.005;
        if (_targetRestrictions == 2) {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - dAzi, this.camera.getAltitude());
        } else if (_targetRestrictions == 3) {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth(), this.camera.getAltitude() + dAlt);
        } else {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - dAzi, this.camera.getAltitude() + dAlt);
        }
        return false;
    }

    private boolean mouseDraggedComputationsOnTarget(MouseEvent e, int _targetRestrictions) {
        if (!this.camera.is3dMode()) {
            double[] point = this.worldPoint(e.getX(), e.getY());
            if (this.keyPressed == 88 || _targetRestrictions == 2) {
                if (!Double.isNaN(point[0])) {
                    this.trackerPoint[0] = point[0];
                }
            } else if (this.keyPressed == 89 || _targetRestrictions == 3) {
                if (!Double.isNaN(point[1])) {
                    this.trackerPoint[1] = point[1];
                }
            } else if (this.keyPressed == 90 || _targetRestrictions == 4) {
                if (!Double.isNaN(point[2])) {
                    this.trackerPoint[2] = point[2];
                }
            } else if (_targetRestrictions == 5) {
                if (!Double.isNaN(point[0])) {
                    this.trackerPoint[0] = point[0];
                }
                if (!Double.isNaN(point[1])) {
                    this.trackerPoint[1] = point[1];
                }
            } else if (_targetRestrictions == 6) {
                if (!Double.isNaN(point[0])) {
                    this.trackerPoint[0] = point[0];
                }
                if (!Double.isNaN(point[2])) {
                    this.trackerPoint[2] = point[2];
                }
            } else if (_targetRestrictions == 7) {
                if (!Double.isNaN(point[1])) {
                    this.trackerPoint[1] = point[1];
                }
                if (!Double.isNaN(point[2])) {
                    this.trackerPoint[2] = point[2];
                }
            } else {
                if (!Double.isNaN(point[0])) {
                    this.trackerPoint[0] = point[0];
                }
                if (!Double.isNaN(point[1])) {
                    this.trackerPoint[1] = point[1];
                }
                if (!Double.isNaN(point[2])) {
                    this.trackerPoint[2] = point[2];
                }
            }
        } else {
            double dH = (double)(e.getX() - this.lastX) / (1.3 * this.aconstant);
            double dV = (double)(e.getY() - this.lastY) / (1.3 * this.bconstant);
            if (this.keyPressed == 88 || _targetRestrictions == 2) {
                AxisInfo info = this.getAxisInfo(0, this.xAxisInfo);
                this.trackerPoint[0] = Math.abs(info.deltaH) >= Math.abs(info.deltaV) ? this.trackerPoint[0] + Math.signum(info.deltaH) * dH / info.scale : this.trackerPoint[0] + Math.signum(info.deltaV) * dV / info.scale;
            } else if (this.keyPressed == 89 || _targetRestrictions == 3) {
                AxisInfo info = this.getAxisInfo(1, this.yAxisInfo);
                this.trackerPoint[1] = Math.abs(info.deltaH) >= Math.abs(info.deltaV) ? this.trackerPoint[1] + Math.signum(info.deltaH) * dH / info.scale : this.trackerPoint[1] + Math.signum(info.deltaV) * dV / info.scale;
            } else if (this.keyPressed == 90 || _targetRestrictions == 4) {
                AxisInfo info = this.getAxisInfo(2, this.zAxisInfo);
                this.trackerPoint[2] = Math.abs(info.deltaH) >= Math.abs(info.deltaV) ? this.trackerPoint[2] + Math.signum(info.deltaH) * dH / info.scale : this.trackerPoint[2] + Math.signum(info.deltaV) * dV / info.scale;
            } else if (_targetRestrictions == 5) {
                AxisInfo xInfo = this.getAxisInfo(0, this.xAxisInfo);
                AxisInfo yInfo = this.getAxisInfo(1, this.yAxisInfo);
                if (Math.abs(xInfo.deltaH) >= Math.abs(yInfo.deltaH)) {
                    this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaH) * dH / xInfo.scale;
                    this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaV) * dV / yInfo.scale;
                } else {
                    this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaV) * dV / xInfo.scale;
                    this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaH) * dH / yInfo.scale;
                }
            } else if (_targetRestrictions == 6) {
                AxisInfo xInfo = this.getAxisInfo(0, this.xAxisInfo);
                AxisInfo zInfo = this.getAxisInfo(2, this.zAxisInfo);
                if (Math.abs(xInfo.deltaH) >= Math.abs(zInfo.deltaH)) {
                    this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaH) * dH / xInfo.scale;
                    this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaV) * dV / zInfo.scale;
                } else {
                    this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaV) * dV / xInfo.scale;
                    this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaH) * dH / zInfo.scale;
                }
            } else if (_targetRestrictions == 7) {
                AxisInfo yInfo = this.getAxisInfo(1, this.yAxisInfo);
                AxisInfo zInfo = this.getAxisInfo(2, this.zAxisInfo);
                if (Math.abs(yInfo.deltaH) >= Math.abs(zInfo.deltaH)) {
                    this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaH) * dH / yInfo.scale;
                    this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaV) * dV / zInfo.scale;
                } else {
                    this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaV) * dV / yInfo.scale;
                    this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaH) * dH / zInfo.scale;
                }
            } else {
                int horMove;
                AxisInfo xInfo = this.getAxisInfo(0, this.xAxisInfo);
                AxisInfo yInfo = this.getAxisInfo(1, this.yAxisInfo);
                AxisInfo zInfo = this.getAxisInfo(2, this.zAxisInfo);
                if (Math.abs(xInfo.deltaH) >= Math.abs(yInfo.deltaH)) {
                    if (Math.abs(xInfo.deltaH) >= Math.abs(zInfo.deltaH)) {
                        horMove = 0;
                        this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaH) * dH / xInfo.scale;
                    } else {
                        horMove = 2;
                        this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaH) * dH / zInfo.scale;
                    }
                } else if (Math.abs(yInfo.deltaH) >= Math.abs(zInfo.deltaH)) {
                    horMove = 1;
                    this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaH) * dH / yInfo.scale;
                } else {
                    horMove = 2;
                    this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaH) * dH / zInfo.scale;
                }
                if (horMove == 0) {
                    if (Math.abs(yInfo.deltaV) >= Math.abs(zInfo.deltaV)) {
                        this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaV) * dV / yInfo.scale;
                    } else {
                        this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaV) * dV / zInfo.scale;
                    }
                } else if (horMove == 1) {
                    if (Math.abs(xInfo.deltaV) >= Math.abs(zInfo.deltaV)) {
                        this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaV) * dV / xInfo.scale;
                    } else {
                        this.trackerPoint[2] = this.trackerPoint[2] + Math.signum(zInfo.deltaV) * dV / zInfo.scale;
                    }
                } else if (Math.abs(xInfo.deltaV) >= Math.abs(yInfo.deltaV)) {
                    this.trackerPoint[0] = this.trackerPoint[0] + Math.signum(xInfo.deltaV) * dV / xInfo.scale;
                } else {
                    this.trackerPoint[1] = this.trackerPoint[1] + Math.signum(yInfo.deltaV) * dV / yInfo.scale;
                }
            }
        }
        return true;
    }

    private void resetInteraction() {
        this.targetHit = null;
        this.displayPosition(null);
        this.implementingPanel.update();
    }

    private static class AxisInfo {
        double deltaH;
        double deltaV;
        double scale;

        private AxisInfo() {
        }
    }

    private class IADMouseController
    extends MouseInputAdapter {
        private IADMouseController() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void mousePressed(MouseEvent _evt) {
            DrawingPanel3D.this.implementingPanel.getComponent().requestFocus();
            if (_evt.isPopupTrigger() || _evt.getModifiers() == 4) {
                return;
            }
            DrawingPanel3D.this.lastX = _evt.getX();
            DrawingPanel3D.this.lastY = _evt.getY();
            DrawingPanel3D.this.targetHit = DrawingPanel3D.this.getTargetHit(DrawingPanel3D.this.lastX, DrawingPanel3D.this.lastY);
            if (DrawingPanel3D.this.targetHit != null) {
                Element el = DrawingPanel3D.this.targetHit.getElement();
                DrawingPanel3D.this.trackerPoint = el.getHotSpot(DrawingPanel3D.this.targetHit);
                el.invokeActions(new InteractionEvent((Object)el, 2000, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, _evt));
                DrawingPanel3D.this.trackerPoint = el.getHotSpot(DrawingPanel3D.this.targetHit);
                if (DrawingPanel3D.this.targetHit.getEnabled() != 8) {
                    DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                }
            } else {
                if (!DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                if (DrawingPanel3D.this.camera.is3dMode() && !_evt.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                DrawingPanel3D.this.trackerPoint = DrawingPanel3D.this.worldPoint(_evt.getX(), _evt.getY());
                if (Double.isNaN(DrawingPanel3D.this.trackerPoint[0])) {
                    ((DrawingPanel3D)DrawingPanel3D.this).trackerPoint[0] = DrawingPanel3D.this.xmax;
                }
                if (Double.isNaN(DrawingPanel3D.this.trackerPoint[1])) {
                    ((DrawingPanel3D)DrawingPanel3D.this).trackerPoint[1] = DrawingPanel3D.this.ymax;
                }
                if (Double.isNaN(DrawingPanel3D.this.trackerPoint[2])) {
                    ((DrawingPanel3D)DrawingPanel3D.this).trackerPoint[2] = DrawingPanel3D.this.zmax;
                }
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, _evt));
                if (DrawingPanel3D.this.targetHit.getEnabled() != 8) {
                    DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                }
            }
            DrawingPanel3D.this.implementingPanel.update();
        }

        @Override
        public void mouseReleased(MouseEvent _evt) {
            if (_evt.isPopupTrigger() || _evt.getModifiers() == 4) {
                return;
            }
            if (DrawingPanel3D.this.targetHit != null) {
                Element el = DrawingPanel3D.this.targetHit.getElement();
                el.invokeActions(new InteractionEvent((Object)el, 2002, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, _evt));
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                if (!DrawingPanel3D.this.camera.is3dMode() || _evt.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, _evt));
                } else {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                }
            }
            DrawingPanel3D.this.implementingPanel.setFastRedraw(false);
            DrawingPanel3D.this.resetInteraction();
        }

        @Override
        public void mouseDragged(MouseEvent _evt) {
            if (_evt.isPopupTrigger() || _evt.getModifiers() == 4) {
                return;
            }
            DrawingPanel3D.this.implementingPanel.setFastRedraw(DrawingPanel3D.this.visHints.isAllowQuickRedraw() && DrawingPanel3D.this.keyPressed != 83);
            if (DrawingPanel3D.this.targetHit != null) {
                DrawingPanel3D.this.mouseDraggedComputationsOnTarget(_evt, DrawingPanel3D.this.targetHit.getEnabled());
                DrawingPanel3D.this.lastX = _evt.getX();
                DrawingPanel3D.this.lastY = _evt.getY();
                Element el = DrawingPanel3D.this.targetHit.getElement();
                el.updateHotSpot(DrawingPanel3D.this.targetHit, DrawingPanel3D.this.trackerPoint);
                el.invokeActions(new InteractionEvent((Object)el, 2001, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, _evt));
                DrawingPanel3D.this.trackerPoint = el.getHotSpot(DrawingPanel3D.this.targetHit);
                if (DrawingPanel3D.this.targetHit.getEnabled() != 8) {
                    DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                }
            } else {
                boolean trackerMoved = DrawingPanel3D.this.mouseDraggedComputations(_evt);
                DrawingPanel3D.this.lastX = _evt.getX();
                DrawingPanel3D.this.lastY = _evt.getY();
                if (!trackerMoved) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                if (DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, _evt));
                    DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                }
            }
            DrawingPanel3D.this.implementingPanel.update();
        }

        @Override
        public void mouseEntered(MouseEvent _evt) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2003, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
            }
            DrawingPanel3D.this.targetEntered = null;
            DrawingPanel3D.this.targetHit = null;
        }

        @Override
        public void mouseExited(MouseEvent _evt) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2004, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
            }
            DrawingPanel3D.this.targetEntered = null;
            DrawingPanel3D.this.targetHit = null;
        }

        @Override
        public void mouseClicked(MouseEvent _evt) {
            _evt.isMetaDown();
        }

        @Override
        public void mouseMoved(MouseEvent _evt) {
            InteractionTarget target = DrawingPanel3D.this.getTargetHit(_evt.getX(), _evt.getY());
            if (target != null) {
                if (DrawingPanel3D.this.targetEntered == null) {
                    target.getElement().invokeActions(new InteractionEvent((Object)target.getElement(), 2003, target.getActionCommand(), target, _evt));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(12));
            } else {
                if (DrawingPanel3D.this.targetEntered != null) {
                    DrawingPanel3D.this.targetEntered.getElement().invokeActions(new InteractionEvent((Object)DrawingPanel3D.this.targetEntered.getElement(), 2004, DrawingPanel3D.this.targetEntered.getActionCommand(), DrawingPanel3D.this.targetEntered, _evt));
                } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2005, DrawingPanel3D.this.myTarget.getActionCommand(), null, _evt));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            DrawingPanel3D.this.targetEntered = target;
        }
    }
}

