/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opensourcephysics.tools.ToolsRes;

public class LocaleItem
implements Comparable<LocaleItem> {
    private static final String LABEL_FOR_DEFAULT = "_default_";
    private static final Charset UTF16_CHARSET = Charset.forName("UTF-16");
    private static final LocaleItem DEFAULT_ITEM = new LocaleItem("_default_", null);
    private static final Map<String, LocaleItem> LOCALE_MAP = new HashMap<String, LocaleItem>();
    private String keyword;
    private String displayName;
    private Locale locale;

    public static Charset getCharset() {
        return UTF16_CHARSET;
    }

    public static LocaleItem getDefaultItem() {
        return DEFAULT_ITEM;
    }

    public static LocaleItem getLocaleItem(String _keyword) {
        String country;
        String lang;
        if (_keyword.equals(LABEL_FOR_DEFAULT)) {
            return DEFAULT_ITEM;
        }
        int l = _keyword.length();
        if (l >= 4) {
            lang = _keyword.substring(0, 2).toLowerCase();
            country = " " + _keyword.substring(l - 2).toUpperCase();
        } else if (l >= 2) {
            lang = _keyword.substring(0, 2);
            country = "";
        } else {
            return null;
        }
        _keyword = String.valueOf(lang) + country;
        LocaleItem localeItem = LOCALE_MAP.get(_keyword);
        if (localeItem != null) {
            return localeItem;
        }
        localeItem = country.length() > 0 ? new LocaleItem(_keyword, new Locale(lang, country)) : new LocaleItem(_keyword, new Locale(lang));
        LOCALE_MAP.put(_keyword, localeItem);
        return localeItem;
    }

    public static LocaleItem getDefaultLocaleItem() {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String keyword = country.length() > 0 ? lang : String.valueOf(lang) + " " + country;
        LocaleItem localeItem = LOCALE_MAP.get(keyword);
        if (localeItem != null) {
            return localeItem;
        }
        localeItem = LOCALE_MAP.get(lang);
        if (localeItem != null) {
            return localeItem;
        }
        localeItem = new LocaleItem(keyword, locale);
        LOCALE_MAP.put(lang, localeItem);
        return localeItem;
    }

    private LocaleItem(String _keyword, Locale _locale) {
        this.keyword = _keyword;
        this.locale = _locale;
        this.displayName = this.locale == null ? ToolsRes.getString("TranslatorTool.Language.Default") : this.locale.getDisplayName(this.locale);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean isDefaultItem() {
        return this.equals(DEFAULT_ITEM);
    }

    @Override
    public int compareTo(LocaleItem arg0) {
        if (this.locale == null) {
            return -1;
        }
        if (arg0.locale == null) {
            return 1;
        }
        return this.displayName.compareTo(arg0.displayName);
    }
}

