/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FourierToolTab;
import org.opensourcephysics.tools.ToolsRes;

public class FourierTool
extends DataTool {
    static final FourierTool FOURIER_TOOL = new FourierTool();

    public static DataTool getTool() {
        return FOURIER_TOOL;
    }

    public static void main(String[] stringArray) {
        FourierTool.FOURIER_TOOL.exitOnClose = true;
        FourierTool.FOURIER_TOOL.saveChangesOnClose = true;
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            FOURIER_TOOL.open(stringArray[0]);
        }
        FOURIER_TOOL.setVisible(true);
    }

    public FourierTool() {
        super(ToolsRes.getString("FourierTool.Frame.Title"), "FourierTool");
    }

    public FourierTool(String string) {
        super(string);
    }

    public FourierTool(XMLControl xMLControl) {
        super(xMLControl);
    }

    public FourierTool(Data data) {
        super(data);
    }

    public DataToolTab addTab(Data data, String string) {
        FourierToolTab fourierToolTab = null;
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList != null) {
            for (Dataset dataset : arrayList) {
                fourierToolTab = new FourierToolTab(dataset, this);
                fourierToolTab.setName(dataset.getName());
                this.addTab(fourierToolTab);
            }
        }
        return fourierToolTab;
    }

    public DataToolTab addTab(XMLControl xMLControl) {
        if (FourierToolTab.class.isAssignableFrom(xMLControl.getObjectClass())) {
            FourierToolTab fourierToolTab = (FourierToolTab)xMLControl.loadObject(null);
            this.addTab(fourierToolTab);
            return fourierToolTab;
        }
        DataToolTab dataToolTab = FourierTool.loadData(null, xMLControl, this.useChooser);
        if (dataToolTab != null) {
            this.addTab(dataToolTab);
            dataToolTab.userEditable = true;
            dataToolTab.refreshGUI();
        }
        return dataToolTab;
    }

    public void setUserEditable(boolean bl) {
    }

    protected DatasetManager importData(String string, String string2) {
        DatasetManager datasetManager = DataTool.parseData(string, string2);
        if (datasetManager == null || datasetManager.getDatasets().size() < 2) {
            return datasetManager;
        }
        double[] dArray = datasetManager.getYPoints(0);
        String string3 = datasetManager.getDataset(0).getYColumnName();
        int n = 1;
        while (n < datasetManager.getDatasets().size()) {
            Dataset dataset = datasetManager.getDataset(n);
            double[] dArray2 = dataset.getYPoints();
            dataset.clear();
            dataset.append(dArray, dArray2);
            dataset.setXYColumnNames(string3, dataset.getYColumnName());
            ++n;
        }
        datasetManager.removeDataset(0);
        return datasetManager;
    }

    protected void createGUI() {
        super.createGUI();
        this.fileMenu.remove(this.newTabItem);
        this.emptyFileMenu.remove(this.emptyNewTabItem);
        helpName = "fourier_tool_help.html";
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.setTitle(ToolsRes.getString("FourierTool.Frame.Title"));
        this.helpItem.setText(ToolsRes.getString("FourierTool.MenuItem.Help"));
    }
}

