/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.FFT;

public class FFTReal {
    static final double PI2 = Math.PI * 2;
    int n;
    FFT fft = new FFT();

    public FFTReal() {
        this.setN(2);
    }

    public FFTReal(int n) {
        this.setN(n);
    }

    public void setN(int n) {
        if (n % 2 != 0) {
            throw new IllegalArgumentException(String.valueOf(n) + " is not even");
        }
        this.n = n;
        this.fft.setN(n / 2);
    }

    public int getN() {
        return this.n;
    }

    public double[] transform(double[] dArray) {
        if (dArray.length != this.n) {
            this.setN(dArray.length);
        }
        this.fft.transform(dArray);
        this.shuffle(dArray, 1);
        return dArray;
    }

    public double[] backtransform(double[] dArray) {
        if (dArray.length != this.n) {
            this.setN(dArray.length);
        }
        this.shuffle(dArray, -1);
        this.fft.backtransform(dArray);
        return dArray;
    }

    public double[] inverse(double[] dArray) {
        this.backtransform(dArray);
        double d = 2.0 / (double)this.n;
        int n = 0;
        while (n < this.n) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return dArray;
    }

    public double[] getNaturalFreq(double d) {
        int n = this.n / 2;
        double[] dArray = new double[n];
        double d2 = 0.0;
        double d3 = 0.5 / (double)n / d;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = d2;
            d2 += d3;
            ++n2;
        }
        return dArray;
    }

    public double[] getNaturalFreq(double d, double d2) {
        return this.getNaturalFreq((d2 - d) / (double)(this.n - this.n % 2));
    }

    public double[] getNaturalOmega(double d) {
        return this.getNaturalFreq(d / (Math.PI * 2));
    }

    public double[] getNaturalOmega(double d, double d2) {
        return this.getNaturalFreq((d2 - d) / (double)(this.n - this.n % 2) / (Math.PI * 2));
    }

    private void shuffle(double[] dArray, int n) {
        int n2 = this.n / 2;
        int n3 = this.n / 4;
        if (this.n == 6) {
            n3 = 2;
        }
        double d = 0.5;
        double d2 = -0.5 * (double)n;
        double d3 = (double)n * Math.PI / (double)n2;
        double d4 = Math.sin(0.5 * d3);
        double d5 = -2.0 * d4 * d4;
        double d6 = -Math.sin(d3);
        double d7 = 1.0 + d5;
        double d8 = d6;
        int n4 = 1;
        while (n4 < n3) {
            int n5 = 2 * n4;
            int n6 = this.n - n5;
            double d9 = d * (dArray[n5] + dArray[n6]);
            double d10 = d * (dArray[n5 + 1] - dArray[n6 + 1]);
            double d11 = -d2 * (dArray[n5 + 1] + dArray[n6 + 1]);
            double d12 = d2 * (dArray[n5] - dArray[n6]);
            dArray[n5] = d9 + d7 * d11 - d8 * d12;
            dArray[n5 + 1] = d10 + d7 * d12 + d8 * d11;
            dArray[n6] = d9 - d7 * d11 + d8 * d12;
            dArray[n6 + 1] = -d10 + d7 * d12 + d8 * d11;
            d4 = d7;
            d7 += d4 * d5 - d8 * d6;
            d8 += d4 * d6 + d8 * d5;
            ++n4;
        }
        double d13 = dArray[0];
        if (n == 1) {
            dArray[0] = d13 + dArray[1];
            dArray[1] = d13 - dArray[1];
        } else {
            dArray[0] = d * (d13 + dArray[1]);
            dArray[1] = d * (d13 - dArray[1]);
        }
        if (this.n % 4 == 0) {
            int n7 = n2 + 1;
            dArray[n7] = dArray[n7] * -1.0;
        }
    }
}

