/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementTrail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Element
implements Data {
    private ArrayList<Element> elementList = new ArrayList();
    private int elementInteracted = -1;

    public void clear() {
        for (Element element : this.getElements()) {
            if (!(element instanceof ElementTrail)) continue;
            ((ElementTrail)element).clear();
        }
    }

    public void initialize() {
        for (Element element : this.getElements()) {
            if (!(element instanceof ElementTrail)) continue;
            ((ElementTrail)element).initialize();
        }
    }

    public void addElement(Element element) {
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        element.setGroup(this);
    }

    public void addElementAtIndex(int n, Element element) {
        if (!this.elementList.contains(element)) {
            n = Math.max(n, this.elementList.size() - 1);
            this.elementList.add(n, element);
        }
        element.setGroup(this);
    }

    public void addElements(Collection<Element> collection) {
        if (collection != null) {
            for (Element element : collection) {
                this.addElement(element);
            }
        }
    }

    public void removeElement(Element element) {
        this.elementList.remove(element);
        element.setGroup(null);
    }

    public void removeAllElements() {
        for (Element element : this.elementList) {
            element.setGroup(null);
        }
        this.elementList.clear();
    }

    public synchronized List<Element> getElements() {
        return (List)this.elementList.clone();
    }

    public Element getElement(int n) {
        try {
            return this.elementList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        for (Element element : this.getElements()) {
            if (!(element instanceof Data)) continue;
            return ((Data)((Object)element)).getColumnNames();
        }
        return null;
    }

    @Override
    public Color getLineColor() {
        return this.getStyle().getLineColor();
    }

    @Override
    public Color getFillColor() {
        return this.getStyle().getFillColor();
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        for (Element element : this.getElements()) {
            if (!(element instanceof Data)) continue;
            arrayList.add((Data)((Object)element));
        }
        return arrayList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        for (Element element : this.getElements()) {
            if (!element.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        for (Element element : this.getElements()) {
            element.draw(drawingPanel, graphics);
        }
    }

    @Override
    public void setNeedToProject(boolean bl) {
        for (Element element : this.getElements()) {
            element.setNeedToProject(bl);
        }
    }

    @Override
    public boolean isMeasured() {
        if (!super.isMeasured()) {
            return false;
        }
        for (Element element : this.getElements()) {
            if (!element.isMeasured()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        for (Element element : this.getElements()) {
            if (!element.isMeasured()) continue;
            double d = element.getXMin();
            double d2 = element.getXMax();
            double d3 = element.getYMin();
            double d4 = element.getYMax();
            this.compareToExtrema(d, d3);
            this.compareToExtrema(d2, d3);
            this.compareToExtrema(d2, d4);
            this.compareToExtrema(d, d4);
            double d5 = element.getXMinLogscale();
            double d6 = element.getXMaxLogscale();
            double d7 = element.getYMinLogscale();
            double d8 = element.getYMaxLogscale();
            this.compareToLogExtrema(d5, d7);
            this.compareToLogExtrema(d6, d7);
            this.compareToLogExtrema(d6, d8);
            this.compareToLogExtrema(d5, d8);
        }
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        List<Element> list = this.getElements();
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            Interactive interactive = list.get(n3).findInteractive(drawingPanel, n, n2);
            if (interactive != null) {
                this.elementInteracted = n3;
                return interactive;
            }
            --n3;
        }
        this.elementInteracted = -1;
        return null;
    }
}

