/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementSegment;
import org.opensourcephysics.drawing2d.utils.VectorAlgebra;

public class ElementSpring
extends ElementSegment {
    public static final double DEF_RADIUS = 0.05;
    public static final int DEF_LOOPS = 8;
    public static final int DEF_PPL = 15;
    private double radius = 0.05;
    private double solenoid = 0.0;
    private boolean thinExtremes = true;
    private int loops;
    private int pointsPerLoop;
    private boolean needsToComputePath = true;
    private double[] pixelRadius = new double[2];
    private GeneralPath path;

    public ElementSpring() {
        this.setSize(new double[]{0.1, 0.1});
        this.setResolution(8, 15);
    }

    public void setRadius(double d) {
        this.radius = d;
        this.setNeedToProject(true);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setSolenoid(double d) {
        this.solenoid = d;
        this.needsToComputePath = true;
    }

    public double getSolenoid() {
        return this.solenoid;
    }

    public void setThinExtremes(boolean bl) {
        this.thinExtremes = bl;
        this.needsToComputePath = true;
    }

    public boolean isThinExtremes() {
        return this.thinExtremes;
    }

    public void setResolution(int n, int n2) {
        if (n == this.loops && n2 == this.pointsPerLoop) {
            return;
        }
        this.loops = n;
        this.pointsPerLoop = n2;
        this.needsToComputePath = true;
    }

    public int getLoops() {
        return this.loops;
    }

    public int getPointsPerLoop() {
        return this.pointsPerLoop;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if (this.needsToComputePath) {
            this.computePath();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.getStyle().getLineStroke());
        graphics2D.setColor(this.getStyle().getLineColor());
        graphics2D.draw(this.path);
    }

    protected void projectPoints() {
        super.projectPoints();
        this.getPanel().projectSize(this.getPosition(), new double[]{this.radius, 0.0}, this.pixelRadius);
        this.needsToComputePath = true;
    }

    private void computePath() {
        int n = this.loops * this.pointsPerLoop;
        double d = Math.PI * 2 / (double)this.pointsPerLoop;
        double d2 = this.pixelRadius[0];
        if (this.radius < 0.0) {
            d *= -1.0;
        }
        int n2 = this.pointsPerLoop / 2;
        GeneralPath generalPath = new GeneralPath();
        double d3 = this.pixelEnd[0] - this.pixelOrigin[0];
        double d4 = this.pixelEnd[1] - this.pixelOrigin[1];
        double[] dArray = new double[]{d3, d4, 0.0};
        double[] dArray2 = VectorAlgebra.normalTo(dArray);
        double[] dArray3 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(dArray, dArray2));
        int n3 = 0;
        while (n3 <= n) {
            int n4 = this.thinExtremes ? (n3 < n2 ? 0 : (n3 < this.pointsPerLoop ? n3 - n2 : (n3 > n - n2 ? 0 : (n3 > n - this.pointsPerLoop ? n - n3 - n2 : n2)))) : n2;
            double d5 = 1.5707963267948966 + (double)n3 * d;
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            double d8 = this.pixelOrigin[0] + (double)n3 * d3 / (double)n + (double)n4 * d2 * (d6 * dArray2[0] + d7 * dArray3[0]) / (double)n2;
            double d9 = this.pixelOrigin[1] + (double)n3 * d4 / (double)n + (double)n4 * d2 * (d6 * dArray2[1] + d7 * dArray3[1]) / (double)n2;
            if (this.solenoid != 0.0) {
                double d10 = (double)n4 * Math.cos((double)(n3 * 2) * Math.PI / (double)this.pointsPerLoop) / (double)n2;
                d8 += this.solenoid * d10 * d3;
                d9 += this.solenoid * d10 * d4;
            }
            if (n3 == 0) {
                generalPath.moveTo((float)d8, (float)d9);
            } else {
                generalPath.lineTo((float)d8, (float)d9);
            }
            ++n3;
        }
        this.path = generalPath;
        this.needsToComputePath = false;
    }
}

