/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;

public class ElementSegment
extends Element {
    protected static final Line2D.Double NORMAL_LINE = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
    protected static final Line2D.Double CENTERED_LINE = new Line2D.Double(-0.5, -0.5, 0.5, 0.5);
    protected static final double[] STD_CENTERED_ORIGIN = new double[]{-0.5, -0.5};
    protected static final double[] STD_CENTERED_END = new double[]{0.5, 0.5};
    protected double[] origin = new double[2];
    protected double[] end = new double[2];
    protected double[] pixelOrigin = new double[2];
    protected double[] pixelEnd = new double[2];
    protected double[] center = new double[2];
    protected double[] pixelCenter = new double[2];
    protected Line2D.Double line = NORMAL_LINE;

    public ElementSegment() {
        this.setSize(new double[]{0.1, 0.1});
        this.getStyle().setRelativePosition(5);
    }

    protected void styleChanged(int n) {
        if (n == 5) {
            switch (this.getStyle().getRelativePosition()) {
                default: {
                    this.line = NORMAL_LINE;
                    break;
                }
                case 0: {
                    this.line = CENTERED_LINE;
                }
            }
            this.setNeedToProject(true);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.getStyle().getLineStroke());
        graphics2D.setColor(this.getStyle().getLineColor());
        graphics2D.draw(this.getPixelTransform(drawingPanel).createTransformedShape(this.line));
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        switch (this.getStyle().getRelativePosition()) {
            default: {
                if (interactionTarget == this.targetPosition) {
                    return new double[]{0.0, 0.0};
                }
                if (interactionTarget != this.targetSize) break;
                return new double[]{this.getSizeX() != 0.0 ? 1 : 0, this.getSizeY() != 0.0 ? 1 : 0};
            }
            case 0: {
                if (interactionTarget == this.targetPosition) {
                    return new double[]{0.0, 0.0};
                }
                if (interactionTarget != this.targetSize) break;
                return new double[]{this.getSizeX() == 0.0 ? 0.0 : 0.5, this.getSizeY() == 0.0 ? 0.0 : 0.5};
            }
        }
        return null;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.targetPosition.isEnabled() && !this.targetSize.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.needsToProject()) {
            this.projectPoints();
        }
        int n3 = this.getStyle().getSensitivity();
        switch (this.getStyle().getRelativePosition()) {
            default: {
                if (this.targetPosition.isEnabled() && Math.abs(this.pixelOrigin[0] - (double)n) < (double)n3 && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)n3) {
                    return this.targetPosition;
                }
                if (!this.targetSize.isEnabled() || !(Math.abs(this.pixelEnd[0] - (double)n) < (double)n3) || !(Math.abs(this.pixelEnd[1] - (double)n2) < (double)n3)) break;
                return this.targetSize;
            }
            case 0: {
                if (this.targetPosition.isEnabled() && Math.abs(this.pixelCenter[0] - (double)n) < (double)n3 && Math.abs(this.pixelCenter[1] - (double)n2) < (double)n3) {
                    return this.targetPosition;
                }
                if (!this.targetSize.isEnabled() || !(Math.abs(this.pixelEnd[0] - (double)n) < (double)n3) || !(Math.abs(this.pixelEnd[1] - (double)n2) < (double)n3)) break;
                return this.targetSize;
            }
            case 8: {
                if (this.targetPosition.isEnabled() && Math.abs(this.pixelEnd[0] - (double)n) < (double)n3 && Math.abs(this.pixelEnd[1] - (double)n2) < (double)n3) {
                    return this.targetPosition;
                }
                if (!this.targetSize.isEnabled() || !(Math.abs(this.pixelOrigin[0] - (double)n) < (double)n3) || !(Math.abs(this.pixelOrigin[1] - (double)n2) < (double)n3)) break;
                return this.targetSize;
            }
        }
        return null;
    }

    protected void projectPoints() {
        switch (this.getStyle().getRelativePosition()) {
            default: {
                this.getTotalTransform().transform(STD_ORIGIN, 0, this.origin, 0, 1);
                this.getTotalTransform().transform(STD_END, 0, this.end, 0, 1);
                break;
            }
            case 0: {
                this.getTotalTransform().transform(STD_CENTERED_ORIGIN, 0, this.origin, 0, 1);
                this.getTotalTransform().transform(STD_CENTERED_END, 0, this.end, 0, 1);
                this.getTotalTransform().transform(STD_ORIGIN, 0, this.center, 0, 1);
                this.getPanel().projectPosition(this.center, this.pixelCenter);
                break;
            }
            case 8: {
                this.getTotalTransform().transform(STD_ORIGIN, 0, this.end, 0, 1);
                this.getTotalTransform().transform(STD_END, 0, this.origin, 0, 1);
            }
        }
        this.getPanel().projectPosition(this.origin, this.pixelOrigin);
        this.getPanel().projectPosition(this.end, this.pixelEnd);
        this.setNeedToProject(false);
    }
}

