/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetManager
extends AbstractTableModel
implements Measurable,
LogMeasurable,
Data {
    ArrayList<Dataset> datasets = new ArrayList();
    boolean connected;
    boolean sorted;
    int markerShape;
    int stride = 1;
    boolean linked = false;
    String xColumnName = "x";
    String yColumnName = "y";
    Map<String, Double> properties = new TreeMap<String, Double>();
    String name = "";

    public DatasetManager() {
        this(false, false, false, 2);
    }

    public DatasetManager(boolean bl) {
        this(false, false, bl, 2);
    }

    public DatasetManager(boolean bl, boolean bl2) {
        this(bl, bl2, false, 2);
    }

    public DatasetManager(boolean bl, boolean bl2, boolean bl3, int n) {
        this.connected = bl;
        this.sorted = bl2;
        this.markerShape = n;
        this.linked = bl3;
    }

    public void setXPointsLinked(boolean bl) {
        this.linked = bl;
        int n = 1;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            dataset.setXColumnVisible(!this.linked);
            ++n;
        }
    }

    public boolean isXPointsLinked() {
        return this.linked;
    }

    public void setSorted(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setSorted(bl);
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
        int n = 0;
        while (n < this.datasets.size()) {
            this.datasets.get(n).setSorted(bl);
            ++n;
        }
    }

    public void setConnected(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setConnected(bl);
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
        int n = 0;
        while (n < this.datasets.size()) {
            this.datasets.get(n).setConnected(bl);
            ++n;
        }
    }

    public void setStride(int n, int n2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setStride(n2);
    }

    public void setStride(int n) {
        this.stride = n;
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            this.datasets.get(n2).setStride(this.stride);
            ++n2;
        }
    }

    public void setMarkerColor(int n, Color color) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setMarkerColor(color);
    }

    public void setMarkerColor(int n, Color color, Color color2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setMarkerColor(color, color2);
    }

    public void setMarkerShape(int n, int n2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setMarkerShape(n2);
    }

    public void setCustomMarker(int n, Shape shape) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setCustomMarker(shape);
    }

    public void setXColumnVisible(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setXColumnVisible(bl);
    }

    public void setYColumnVisible(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setYColumnVisible(bl);
    }

    public void setMarkerSize(int n, int n2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setMarkerSize(n2);
    }

    public void setLineColor(int n, Color color) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setLineColor(color);
    }

    @Override
    public Color getLineColor() {
        return null;
    }

    @Override
    public Color getFillColor() {
        return null;
    }

    public void setXYColumnNames(int n, String string, String string2, String string3) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setXYColumnNames(string, string2, string3);
    }

    public void setXYColumnNames(int n, String string, String string2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.setXYColumnNames(string, string2);
    }

    @Override
    public boolean isMeasured() {
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public double getXMin() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.min(d, dataset.getXMin());
            }
            ++n;
        }
        return d;
    }

    @Override
    public double getXMinLogscale() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.min(d, dataset.getXMinLogscale());
            }
            ++n;
        }
        return Math.max((double)1.4E-45f, d);
    }

    @Override
    public double getXMax() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.max(d, dataset.getXMax());
            }
            ++n;
        }
        return d;
    }

    @Override
    public double getXMaxLogscale() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.max(d, dataset.getXMaxLogscale());
            }
            ++n;
        }
        return Math.max((double)1.4E-45f, d);
    }

    @Override
    public double getYMin() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.min(d, dataset.getYMin());
            }
            ++n;
        }
        return d;
    }

    @Override
    public double getYMinLogscale() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.min(d, dataset.getYMinLogscale());
            }
            ++n;
        }
        return Math.max((double)1.4E-45f, d);
    }

    @Override
    public double getYMax() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.max(d, dataset.getYMax());
            }
            ++n;
        }
        return d;
    }

    @Override
    public double getYMaxLogscale() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n);
            if (dataset.isMeasured()) {
                d = Math.max(d, dataset.getYMaxLogscale());
            }
            ++n;
        }
        return Math.max((double)1.4E-45f, d);
    }

    public double[] getXPoints(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        return dataset.getXPoints();
    }

    public double[] getYPoints(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        return dataset.getYPoints();
    }

    public boolean isSorted(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        return dataset.isSorted();
    }

    public boolean isConnected(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        return dataset.isConnected();
    }

    @Override
    public int getColumnCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n2);
            n += dataset.getColumnCount();
            ++n2;
        }
        return n;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n2);
            n = Math.max(n, dataset.getRowCount());
            ++n2;
        }
        return n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null) {
            this.name = TeXParser.parseTeX(string);
        }
    }

    @Override
    public String getColumnName(int n) {
        if (this.datasets.size() == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n3);
            int n4 = dataset.getColumnCount();
            if ((n2 += n4) > n) {
                int n5 = Math.abs(n2 - n4 - n);
                return dataset.getColumnName(n5);
            }
            ++n3;
        }
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.datasets.size() == 0) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.datasets.size()) {
            Dataset dataset = this.datasets.get(n4);
            int n5 = dataset.getColumnCount();
            if ((n3 += n5) > n2) {
                if (n >= dataset.getRowCount()) {
                    return null;
                }
                int n6 = Math.abs(n3 - n5 - n2);
                return dataset.getValueAt(n, n6);
            }
            ++n4;
        }
        return null;
    }

    public Class<Double> getColumnClass(int n) {
        return Double.class;
    }

    public void append(int n, double d, double d2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.append(d, d2);
    }

    public void append(int n, double d, double d2, double d3, double d4) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.append(d, d2, d3, d4);
    }

    public void append(int n, double[] dArray, double[] dArray2) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.append(dArray, dArray2);
    }

    public void append(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.append(dArray, dArray2, dArray3, dArray4);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = 0;
        while (n < this.datasets.size()) {
            this.datasets.get(n).draw(drawingPanel, graphics);
            ++n;
        }
    }

    public void clear(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = this.datasets.get(n);
        dataset.clear();
    }

    public void clear() {
        int n = 0;
        while (n < this.datasets.size()) {
            this.datasets.get(n).clear();
            ++n;
        }
    }

    public void removeDatasets() {
        this.clear();
        this.datasets.clear();
    }

    public Dataset getDataset(int n) {
        this.checkDatasetIndex(n);
        return this.datasets.get(n);
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return new ArrayList<Dataset>(this.datasets);
    }

    @Override
    public List<Data> getDataList() {
        return new ArrayList<Data>(this.datasets);
    }

    @Override
    public String[] getColumnNames() {
        int n = this.datasets.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            if (this.datasets.get(n2) != null) {
                stringArray[n2] = this.datasets.get(n2).getName();
            }
            ++n2;
        }
        return stringArray;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    public int addDataset(Dataset dataset) {
        if (this.linked) {
            dataset.setXColumnVisible(false);
        }
        this.datasets.add(dataset);
        return this.datasets.size() - 1;
    }

    public Dataset removeDataset(int n) {
        if (n < 0 || n > this.datasets.size() - 1) {
            return null;
        }
        return this.datasets.remove(n);
    }

    public int getDatasetIndex(String string) {
        int n = 0;
        while (n < this.datasets.size()) {
            String string2 = this.datasets.get(n).getYColumnName();
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Map<String, Double> getProperties() {
        return this.properties;
    }

    public String toString() {
        if (this.datasets.size() == 0) {
            return "No data in datasets.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.datasets.size()) {
            stringBuffer.append("Dataset ");
            stringBuffer.append(n);
            stringBuffer.append('\n');
            stringBuffer.append(this.datasets.get(n).toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setXYColumnNames(String string, String string2) {
        this.xColumnName = string;
        this.yColumnName = string2;
        int n = 0;
        int n2 = this.datasets.size();
        while (n < n2) {
            this.datasets.get(n).setXYColumnNames(string, string2);
            ++n;
        }
    }

    protected void checkDatasetIndex(int n) {
        while (n >= this.datasets.size()) {
            Dataset dataset = new Dataset(DisplayColors.getMarkerColor(n), DisplayColors.getLineColor(n), this.connected);
            if (this.linked && this.datasets.size() > 0) {
                dataset.setXColumnVisible(false);
            }
            dataset.setSorted(this.sorted);
            dataset.setXYColumnNames(this.xColumnName, this.yColumnName);
            dataset.setMarkerShape(this.markerShape);
            this.datasets.add(dataset);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DatasetManager datasetManager = (DatasetManager)object;
            xMLControl.setValue("connected", datasetManager.connected);
            xMLControl.setValue("sorted", datasetManager.sorted);
            xMLControl.setValue("maker_shape", datasetManager.markerShape);
            xMLControl.setValue("stride", datasetManager.stride);
            xMLControl.setValue("linked", datasetManager.linked);
            xMLControl.setValue("x_column_name", datasetManager.xColumnName);
            xMLControl.setValue("y_column_name", datasetManager.yColumnName);
            xMLControl.setValue("data_name", datasetManager.name);
            xMLControl.setValue("datasets", datasetManager.datasets);
        }

        public Object createObject(XMLControl xMLControl) {
            return new DatasetManager();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DatasetManager datasetManager = (DatasetManager)object;
            datasetManager.connected = xMLControl.getBoolean("connected");
            datasetManager.sorted = xMLControl.getBoolean("sorted");
            datasetManager.markerShape = xMLControl.getInt("maker_shape");
            datasetManager.stride = xMLControl.getInt("stride");
            datasetManager.linked = xMLControl.getBoolean("linked");
            datasetManager.xColumnName = xMLControl.getString("x_column_name");
            datasetManager.yColumnName = xMLControl.getString("y_column_name");
            datasetManager.setName(xMLControl.getString("data_name"));
            datasetManager.removeDatasets();
            Collection collection = (Collection)Collection.class.cast(xMLControl.getObject("datasets"));
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    datasetManager.datasets.add((Dataset)iterator.next());
                }
            }
            return object;
        }
    }
}

