/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.DataTableModel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.SortDecorator;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    public static String rowName = DisplayRes.getString("DataTable.Header.Row");
    protected final SortDecorator decorator;
    protected HashMap<String, PrecisionRenderer> renderersByColumnName = new HashMap();
    DataTableModel dataTableModel;
    protected RowNumberRenderer rowNumberRenderer;
    int maximumFractionDigits = 3;
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    protected int labelColumnWidth = 40;
    protected NumberFormatDialog formatDialog;

    public DataTable() {
        this(new DefaultDataTableModel());
    }

    public DataTable(DataTableModel dataTableModel) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(dataTableModel);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setForeground(Color.blue);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.decorator = new SortDecorator(this.getModel());
        this.setModel(this.decorator);
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!(OSPRuntime.isPopupTrigger(mouseEvent) || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
                    TableColumnModel tableColumnModel = DataTable.this.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = DataTable.this.convertColumnIndexToModel(n);
                    DataTable.this.decorator.sort(n2);
                }
            }
        });
    }

    public void setMaximumFractionDigits(String string, int n) {
        this.renderersByColumnName.put(string, new PrecisionRenderer(n));
    }

    public void setFormatPattern(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            this.renderersByColumnName.remove(string);
        } else {
            this.renderersByColumnName.put(string, new PrecisionRenderer(string2));
        }
    }

    public String getFormatPattern(String string) {
        PrecisionRenderer precisionRenderer = this.renderersByColumnName.get(string);
        return precisionRenderer == null ? null : precisionRenderer.pattern;
    }

    public NumberFormatDialog getFormatDialog(ArrayList<String> arrayList, String string) {
        if (this.formatDialog == null) {
            this.formatDialog = new NumberFormatDialog();
        }
        this.formatDialog.setColumns(arrayList, string);
        return this.formatDialog;
    }

    public void sort(int n) {
        this.decorator.sort(n);
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = n;
        this.setDefaultRenderer(Double.class, new PrecisionRenderer(n));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setRowNumberVisible(boolean bl) {
        if (this.dataTableModel.isRowNumberVisible() != bl) {
            if (bl && this.rowNumberRenderer == null) {
                this.rowNumberRenderer = new RowNumberRenderer(this);
            }
            this.dataTableModel.setRowNumberVisible(bl);
        }
    }

    public void setModel(DataTableModel dataTableModel) {
        super.setModel(dataTableModel);
        this.dataTableModel = dataTableModel;
    }

    public void setStride(TableModel tableModel, int n) {
        this.dataTableModel.setStride(tableModel, n);
    }

    public void setColumnVisible(TableModel tableModel, int n, boolean bl) {
        this.dataTableModel.setColumnVisible(tableModel, n, bl);
    }

    public boolean isRowNumberVisible() {
        return this.dataTableModel.isRowNumberVisible();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0 && this.dataTableModel.isRowNumberVisible()) {
            return this.rowNumberRenderer;
        }
        try {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer != null) {
                return tableCellRenderer;
            }
            for (String string : this.renderersByColumnName.keySet()) {
                if (!tableColumn.getHeaderValue().equals(string)) continue;
                return this.renderersByColumnName.get(string);
            }
        }
        catch (Exception exception) {}
        return this.getDefaultRenderer(this.getColumnClass(n2));
    }

    public void setRefreshDelay(int n) {
        if (n > 0) {
            this.refreshTimer.setDelay(n);
            this.refreshTimer.setInitialDelay(n);
        } else if (n <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = n;
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    DataTable.this.tableChanged(new TableModelEvent(DataTable.this.dataTableModel, -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.tableChanged(new TableModelEvent(this.dataTableModel, -1));
    }

    public void add(TableModel tableModel) {
        this.dataTableModel.add(tableModel);
    }

    public void remove(TableModel tableModel) {
        this.dataTableModel.remove(tableModel);
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        public TableColumn getColumn(int n) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(n);
            }
            catch (Exception exception) {
                return new TableColumn();
            }
            String string = (String)tableColumn.getHeaderValue();
            if (string == null) {
                return tableColumn;
            }
            if (string.equals(rowName)) {
                tableColumn.setMaxWidth(DataTable.this.labelColumnWidth);
                tableColumn.setMinWidth(DataTable.this.labelColumnWidth);
                tableColumn.setResizable(false);
            }
            return tableColumn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataTableElement {
        TableModel tableModel;
        boolean[] columnVisibilities;
        int stride = 1;

        public DataTableElement(TableModel tableModel) {
            this.tableModel = tableModel;
        }

        public void setStride(int n) {
            this.stride = n;
        }

        public void setColumnVisible(int n, boolean bl) {
            this.ensureCapacity(n + 1);
            this.columnVisibilities[n] = bl;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean[] getColumnVisibilities() {
            return this.columnVisibilities;
        }

        public int getColumnCount() {
            int n = 0;
            int n2 = this.tableModel.getColumnCount();
            this.ensureCapacity(n2);
            int n3 = 0;
            while (n3 < n2) {
                boolean bl = this.columnVisibilities[n3];
                if (bl) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            return this.tableModel.getValueAt(n, n2);
        }

        public String getColumnName(int n) {
            return this.tableModel.getColumnName(n);
        }

        public Class<?> getColumnClass(int n) {
            return this.tableModel.getColumnClass(n);
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        private void ensureCapacity(int n) {
            if (this.columnVisibilities == null) {
                this.columnVisibilities = new boolean[n * 3 / 2 + 1];
                Arrays.fill(this.columnVisibilities, true);
            } else if (this.columnVisibilities.length < n) {
                boolean[] blArray = this.columnVisibilities;
                this.columnVisibilities = new boolean[n * 3 / 2 + 1];
                System.arraycopy(blArray, 0, this.columnVisibilities, 0, blArray.length);
                Arrays.fill(this.columnVisibilities, blArray.length, this.columnVisibilities.length, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultDataTableModel
    implements DataTableModel {
        ArrayList<DataTableElement> dataTableElements = new ArrayList();
        boolean rowNumberVisible = false;

        protected DefaultDataTableModel() {
        }

        @Override
        public void setColumnVisible(TableModel tableModel, int n, boolean bl) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            dataTableElement.setColumnVisible(n, bl);
        }

        @Override
        public void setStride(TableModel tableModel, int n) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            dataTableElement.setStride(n);
        }

        @Override
        public void setRowNumberVisible(boolean bl) {
            this.rowNumberVisible = bl;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        @Override
        public boolean isRowNumberVisible() {
            return this.rowNumberVisible;
        }

        @Override
        public String getColumnName(int n) {
            if (this.dataTableElements.size() == 0 && !this.rowNumberVisible) {
                return null;
            }
            if (this.rowNumberVisible && n == 0) {
                return rowName;
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            String string = dataTableElement.getColumnName(modelFilterResult.column);
            return TeXParser.removeSubscripting(string);
        }

        @Override
        public int getRowCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.dataTableElements.size()) {
                DataTableElement dataTableElement = this.dataTableElements.get(n2);
                int n3 = dataTableElement.getStride();
                n = Math.max(n, (dataTableElement.getRowCount() + n3 - 1) / n3);
                ++n2;
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.dataTableElements.size()) {
                DataTableElement dataTableElement = this.dataTableElements.get(n2);
                n += dataTableElement.getColumnCount();
                ++n2;
            }
            if (this.rowNumberVisible) {
                ++n;
            }
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.dataTableElements.size() == 0) {
                return null;
            }
            if (this.rowNumberVisible && n2 == 0) {
                return new Integer(n);
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n2);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            int n3 = dataTableElement.getStride();
            if ((n *= n3) >= dataTableElement.getRowCount()) {
                return null;
            }
            return dataTableElement.getValueAt(n, modelFilterResult.column);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.rowNumberVisible && n == 0) {
                return Integer.class;
            }
            if (n == 0 && this.rowNumberVisible) {
                --n;
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            return dataTableElement.getColumnClass(modelFilterResult.column);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void remove(TableModel tableModel) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            this.dataTableElements.remove(dataTableElement);
        }

        @Override
        public void clear() {
            this.dataTableElements.clear();
        }

        @Override
        public void add(TableModel tableModel) {
            this.dataTableElements.add(new DataTableElement(tableModel));
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        private DataTableElement findElementContaining(TableModel tableModel) {
            int n = 0;
            while (n < this.dataTableElements.size()) {
                DataTableElement dataTableElement = this.dataTableElements.get(n);
                if (dataTableElement.tableModel == tableModel) {
                    return dataTableElement;
                }
                ++n;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelFilterResult {
        DataTableElement tableElement;
        int column;

        public ModelFilterResult(DataTableElement dataTableElement, int n) {
            this.tableElement = dataTableElement;
            this.column = n;
        }

        public static ModelFilterResult find(boolean bl, ArrayList<DataTableElement> arrayList, int n) {
            if (bl) {
                --n;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < arrayList.size()) {
                DataTableElement dataTableElement = arrayList.get(n3);
                int n4 = dataTableElement.getColumnCount();
                if ((n2 += n4) > n) {
                    int n5 = n4 + n - n2;
                    boolean[] blArray = dataTableElement.getColumnVisibilities();
                    int n6 = 0;
                    while (n6 < n) {
                        if (!blArray[n6]) {
                            ++n5;
                        }
                        ++n6;
                    }
                    return new ModelFilterResult(dataTableElement, n5);
                }
                ++n3;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NumberFormatDialog
    extends JDialog {
        JButton okButton;
        JButton cancelButton;
        JButton helpButton;
        JLabel patternLabel;
        JLabel sampleLabel;
        JTextField patternField;
        JTextField sampleField;
        DecimalFormat sampleFormat;
        ArrayList<String> columnNames;
        Map<String, String> prevPatterns;

        NumberFormatDialog() {
            super(JOptionPane.getFrameForComponent(DataTable.this), true);
            this.prevPatterns = new HashMap<String, String>();
            this.setLayout(new BorderLayout());
            this.setTitle(DisplayRes.getString("DataTable.NumberFormat.Dialog.Title"));
            this.sampleFormat = (DecimalFormat)NumberFormat.getNumberInstance();
            this.okButton = new JButton(DisplayRes.getString("GUIUtils.Ok"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (String string : NumberFormatDialog.this.columnNames) {
                        DataTable.this.setFormatPattern(string, NumberFormatDialog.this.prevPatterns.get(string));
                    }
                    DataTable.this.refreshTable();
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.helpButton = new JButton(DisplayRes.getString("GUIUtils.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "      ";
                    String string2 = System.getProperty("line.separator", "/n");
                    JOptionPane.showMessageDialog(((NumberFormatDialog)NumberFormatDialog.this).DataTable.this.formatDialog, String.valueOf(DisplayRes.getString("DataTable.NumberFormat.Help.Message1")) + string2 + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message2") + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message3") + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message4") + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message5") + string2 + string2 + DisplayRes.getString("DataTable.NumberFormat.Help.Message6") + " \"12.34567\"", DisplayRes.getString("DataTable.NumberFormat.Help.Title"), 1);
                }
            });
            this.patternLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Format"));
            this.sampleLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Sample"));
            this.patternField = new JTextField(6);
            this.patternField.setAction(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = NumberFormatDialog.this.patternField.getText();
                    int n = string.indexOf("0e0");
                    if (n > -1) {
                        string = String.valueOf(string.substring(0, n)) + "0E0" + string.substring(n + 3);
                    }
                    try {
                        NumberFormatDialog.this.showNumberFormatAndSample(string);
                        for (String string2 : NumberFormatDialog.this.columnNames) {
                            DataTable.this.setFormatPattern(string2, string);
                        }
                        DataTable.this.refreshTable();
                    }
                    catch (RuntimeException runtimeException) {
                        NumberFormatDialog.this.patternField.setBackground(new Color(255, 153, 153));
                    }
                }
            });
            this.patternField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        NumberFormatDialog.this.patternField.setBackground(Color.white);
                    } else {
                        NumberFormatDialog.this.patternField.setBackground(Color.yellow);
                    }
                }
            });
            this.patternField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    NumberFormatDialog.this.patternField.setBackground(Color.white);
                    NumberFormatDialog.this.patternField.getAction().actionPerformed(null);
                }
            });
            this.sampleField = new JTextField(6);
            this.sampleField.setEditable(false);
            JPanel jPanel = new JPanel(new GridLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.patternLabel);
            jPanel2.add(this.patternField);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.sampleLabel);
            jPanel3.add(this.sampleField);
            jPanel.add(jPanel3);
            this.add((Component)jPanel, "Center");
            JPanel jPanel4 = new JPanel();
            jPanel4.add(this.helpButton);
            jPanel4.add(this.okButton);
            jPanel4.add(this.cancelButton);
            this.add((Component)jPanel4, "South");
            this.pack();
        }

        private void showNumberFormatAndSample(String string) {
            if (string == null || string.equals("")) {
                TableCellRenderer tableCellRenderer = DataTable.this.getDefaultRenderer(Double.class);
                Component component = tableCellRenderer.getTableCellRendererComponent(DataTable.this, 12.34567, false, false, 0, 0);
                if (component instanceof JLabel) {
                    String string2 = ((JLabel)component).getText();
                    this.sampleField.setText(string2);
                }
            } else {
                this.sampleFormat.applyPattern(string);
                this.sampleField.setText(this.sampleFormat.format(12.34567));
            }
            this.patternField.setText(string);
        }

        void setColumns(ArrayList<String> arrayList, String string) {
            this.columnNames = arrayList;
            this.prevPatterns.clear();
            for (String string2 : this.columnNames) {
                this.prevPatterns.put(string2, DataTable.this.getFormatPattern(string2));
            }
            this.showNumberFormatAndSample(this.prevPatterns.get(string));
        }
    }

    private static class PrecisionRenderer
    extends DefaultTableCellRenderer {
        NumberFormat numberFormat = NumberFormat.getInstance();
        String pattern;

        public PrecisionRenderer(int n) {
            this.numberFormat.setMaximumFractionDigits(n);
            this.setHorizontalAlignment(4);
        }

        public PrecisionRenderer(String string) {
            if (this.numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)this.numberFormat).applyPattern(string);
                this.pattern = string;
            }
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object object) {
            this.setText(object == null ? "" : this.numberFormat.format(object));
        }

        public void setPrecision(int n) {
            this.numberFormat.setMaximumFractionDigits(n);
        }
    }

    protected static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        public RowNumberRenderer(JTable jTable) {
            this.table = jTable;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(PANEL_BACKGROUND);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.isRowSelected(n)) {
                int[] nArray = jTable.getSelectedColumns();
                if (nArray.length == 1 && jTable.convertColumnIndexToModel(nArray[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(object.toString());
            return this;
        }
    }
}

