/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.external;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalAppsHandler {
    private ExternalClient client;
    private Hashtable<String, ExternalApp> appList = new Hashtable();

    public ExternalAppsHandler(ExternalClient externalClient) {
        this.client = externalClient;
    }

    public ExternalAppsHandler(String string, ExternalClient externalClient) {
        this(externalClient);
    }

    public void requires(String string) {
        String string2 = string.replace('\\', '/');
        if (!new File(string2).exists() && Simulation.extractResource(string2, String.valueOf(Simulation.getTemporaryDir()) + string) == null) {
            System.out.println("Warning : the required file " + string + " could not be extracted!");
        }
    }

    public ExternalApp add(Class<?> clazz, String string) {
        try {
            string = string.trim();
            ExternalApp externalApp = this.appList.get(string);
            if (externalApp != null) {
                return externalApp;
            }
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            externalApp = (ExternalApp)constructor.newInstance(objectArray);
            externalApp.setInitCommand(this.client._externalInitCommand(string));
            this.appList.put(string, externalApp);
            externalApp.setClient(this.client);
            return externalApp;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("ExternalAppsHandler: error when trying to add class " + clazz + "!");
            return null;
        }
    }

    public void remove(String string) {
        this.appList.remove(string);
    }

    public ExternalApp getApplication(String string) {
        return this.appList.get(string);
    }

    public ExternalClient getClient() {
        return this.client;
    }

    public void eval(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.eval(string2);
            }
            catch (Exception exception) {
                System.err.println("Error evaluating <" + string2 + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void eval(String string, String string2, boolean bl) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.eval(string2, bl);
            }
            catch (Exception exception) {
                System.err.println("Error evaluating <" + string2 + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void eval(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.eval(string);
            }
            catch (Exception exception) {
                System.err.println("Error evaluating <" + string + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void eval(String string, boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.eval(string, bl);
            }
            catch (Exception exception) {
                System.err.println("Error evaluating <" + string + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void resetIC(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            externalApp.resetIC();
        }
    }

    public void resetIC() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().resetIC();
        }
    }

    public void resetParam() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().resetParam();
        }
    }

    public void step(String string, double d) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            this.client._externalSetValues(false, externalApp);
            try {
                externalApp.step(d);
            }
            catch (Exception exception) {
                System.err.println("Error stepping application : " + externalApp);
                exception.printStackTrace();
            }
            this.client._externalGetValues(false, externalApp);
        }
    }

    public void step(double d) {
        this.client._externalSetValues(true, null);
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.step(d);
            }
            catch (Exception exception) {
                System.err.println("Error stepping application : " + externalApp);
                exception.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public void update(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            this.client._externalSetValues(false, externalApp);
            this.client._externalGetValues(false, externalApp);
        }
    }

    public void update() {
        this.client._externalSetValues(true, null);
        this.client._externalGetValues(true, null);
    }

    public void reset(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            externalApp.reset();
        }
    }

    public void reset() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().reset();
        }
    }

    public void quit(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            externalApp.quit();
        }
    }

    public void quit() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().quit();
        }
    }

    public void setValues() {
        this.client._externalSetValues(true, null);
    }

    public void getValues() {
        this.client._externalGetValues(true, null);
    }

    public void setValue(String string, String string2) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, string2);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + string2 + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, string2, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + string2 + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, String string3) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, string3);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + string3 + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, String string3, boolean bl) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, string3, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + string3 + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, double d) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, d);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + d + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, double d, boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, d, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + d + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, double d) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, d);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + d + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, double d, boolean bl) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, d, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + d + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, double[] dArray) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, dArray);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + dArray + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, double[] dArray, boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, dArray, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + dArray + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, double[] dArray) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, dArray);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + dArray + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, double[] dArray, boolean bl) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, dArray, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + dArray + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, double[][] dArray) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, dArray);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + dArray + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, double[][] dArray, boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string, dArray, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string + "> to <" + dArray + "> for application : " + externalApp);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, double[][] dArray) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, dArray);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + dArray + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public void setValue(String string, String string2, double[][] dArray, boolean bl) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp == null) {
            System.err.println("Error: application " + string + " not found!");
        } else {
            try {
                externalApp.synchronize(true);
                externalApp.setValue(string2, dArray, bl);
            }
            catch (Exception exception) {
                System.err.println("Error setting <" + string2 + "> to <" + dArray + "> for application : " + string);
                exception.printStackTrace();
            }
        }
    }

    public String getString(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                return externalApp.getString(string);
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable <" + string + "> doesn't exists in any external application.");
        return "";
    }

    public String getStringAS() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                return externalApp.getStringAS();
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable doesn't exists in any external application.");
        return "";
    }

    public String getString(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.synchronize(true);
                return externalApp.getString(string2);
            }
            catch (Exception exception) {
                System.err.println("Error getting <" + string2 + "> from application : " + string);
                exception.printStackTrace();
            }
        }
        return "";
    }

    public String getStringAS(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                return externalApp.getStringAS();
            }
            catch (Exception exception) {
                System.err.println("Error getting buffer from application : " + string);
                exception.printStackTrace();
            }
        }
        return "";
    }

    public double getDouble(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                return externalApp.getDouble(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.err.println("Error: variable <" + string + "> doesn't exists in any external application.");
        return 0.0;
    }

    public double getDoubleAS() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                return externalApp.getDoubleAS();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.err.println("Error: variable can't get from Buffer in any external application.");
        return 0.0;
    }

    public double getDouble(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.synchronize(true);
                return externalApp.getDouble(string2);
            }
            catch (Exception exception) {
                System.err.println("Error getting <" + string2 + "> from application : " + string);
                exception.printStackTrace();
            }
        }
        return 0.0;
    }

    public double getDoubleAS(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                return externalApp.getDoubleAS();
            }
            catch (Exception exception) {
                System.err.println("Error getting buffer from application : " + string);
                exception.printStackTrace();
            }
        }
        return 0.0;
    }

    public double[] getDoubleArray(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                return externalApp.getDoubleArray(string);
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable <" + string + "> doesn't exists in any external application.");
        return null;
    }

    public double[] getDoubleArrayAS() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                return externalApp.getDoubleArrayAS();
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable doesn't exists in any external application.");
        return null;
    }

    public double[] getDoubleArray(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.synchronize(true);
                return externalApp.getDoubleArray(string2);
            }
            catch (Exception exception) {
                System.err.println("Error getting <" + string2 + "> from application : " + string);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public double[] getDoubleArrayAS(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                return externalApp.getDoubleArrayAS();
            }
            catch (Exception exception) {
                System.err.println("Error getting buffer from application : " + string);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public double[][] getDoubleArray2D(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(true);
                return externalApp.getDoubleArray2D(string);
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable <" + string + "> doesn't exists in any external application.");
        return null;
    }

    public double[][] getDoubleArray2DAS() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                return externalApp.getDoubleArray2DAS();
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable doesn't exists in any external application.");
        return null;
    }

    public double[][] getDoubleArray2D(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.synchronize(true);
                return externalApp.getDoubleArray2D(string2);
            }
            catch (Exception exception) {
                System.err.println("Error getting <" + string2 + "> from application : " + string);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public double[][] getDoubleArray2DAS(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                return externalApp.getDoubleArray2DAS();
            }
            catch (Exception exception) {
                System.err.println("Error getting buffer from application : " + string);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public synchronized void externalVars(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.externalVars(string2);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set external variables in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void externalVars(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.externalVars(string);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set external variables in any external application.");
            }
        }
    }

    public synchronized void synchronize(String string, boolean bl) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.synchronize(bl);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void synchronize(String string) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.synchronize();
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void synchronize(boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize(bl);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
            }
        }
    }

    public synchronized void synchronize() {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.synchronize();
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
            }
        }
    }

    public synchronized void setCommand(String string) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.setCommand(string);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set Command in any external application.");
            }
        }
    }

    public synchronized void setCommand(String string, String string2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.setCommand(string2);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void packageSize(String string, double d) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.packageSize(d);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set package size in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void packageSize(double d) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.packageSize(d);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set package size in any external application.");
            }
        }
    }

    public synchronized void update(String string, String string2, int n) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.update(string, string2, n);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to update in any external application.");
            }
        }
    }

    public synchronized void update(String string, String string2, String string3, int n) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.update(string2, string3, n);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to update in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void update(String string, String string2, int n, int n2) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.update(string, string2, n, n2);
            }
            catch (Exception exception) {
                System.err.println("Error: can't update in any external application.");
            }
        }
    }

    public synchronized void update(String string, String string2, String string3, int n, int n2) {
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.update(string2, string3, n, n2);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to update in any external application.");
                exception.printStackTrace();
            }
        }
    }

    public synchronized void stepAS(double d) {
        this.client._externalSetValues(true, null);
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.stepAS(d);
            }
            catch (Exception exception) {
                System.err.println("Error stepping application : " + externalApp);
                exception.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void stepAS(String string, double d) {
        this.client._externalSetValues(true, null);
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.stepAS(d);
            }
            catch (Exception exception) {
                System.err.println("Error stepping application : " + externalApp);
                exception.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void stepAS(double d, int n) {
        this.client._externalSetValues(true, null);
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.stepAS(d, n);
            }
            catch (Exception exception) {
                System.err.println("Error stepping application : " + externalApp);
                exception.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void stepAS(String string, double d, int n) {
        this.client._externalSetValues(true, null);
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.stepAS(d, n);
            }
            catch (Exception exception) {
                System.err.println("Error stepping application : " + externalApp);
                exception.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void haltStepAS(boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.haltStepAS(bl);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }

    public synchronized void haltStepAS(String string, boolean bl) {
        this.client._externalSetValues(true, null);
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.haltStepAS(bl);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }

    public synchronized void haltUpdate(boolean bl) {
        Enumeration<ExternalApp> enumeration = this.appList.elements();
        while (enumeration.hasMoreElements()) {
            ExternalApp externalApp = enumeration.nextElement();
            try {
                externalApp.haltUpdate(bl);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }

    public synchronized void haltUpdate(String string, boolean bl) {
        this.client._externalSetValues(true, null);
        ExternalApp externalApp = this.getApplication(string);
        if (externalApp != null) {
            try {
                externalApp.haltUpdate(bl);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }
}

