/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlRootPane
extends ControlContainer {
    protected JRootPane panel;
    private LayoutManager myLayout = null;
    protected JMenuBar menubar = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.panel = new JRootPane();
        this.panel.getContentPane().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlRootPane.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlRootPane.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlRootPane.this.printScreen();
                    }
                }
            }
        });
        this.panel.getContentPane().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ControlRootPane.this.getSimulation() != null && OSPRuntime.isPopupTrigger(mouseEvent)) {
                    ControlRootPane.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return this.panel;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public Container getContainer() {
        return this.panel.getContentPane();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("layout");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                LayoutManager layoutManager;
                if (!(value.getObject() instanceof LayoutManager) || (layoutManager = (LayoutManager)value.getObject()) == this.myLayout) break;
                this.myLayout = layoutManager;
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "BORDER";
            }
        }
        return super.getDefaultValueString(n - 1);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }

    @Override
    public void add(ControlElement controlElement) {
        if (!(controlElement.getVisual() instanceof JMenuBar)) {
            super.add(controlElement);
            return;
        }
        this.children.add(controlElement);
        this.menubar = (JMenuBar)controlElement.getVisual();
        this.panel.setJMenuBar(this.menubar);
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement controlElement) {
        if (!(controlElement.getVisual() instanceof JMenuBar)) {
            super.remove(controlElement);
            return;
        }
        this.children.remove(controlElement);
        this.menubar = null;
        this.panel.setJMenuBar(null);
        this.panel.validate();
        this.panel.repaint();
    }
}

