/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementSpring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSpringSet2D
extends ControlSet2D {
    private static final int PROPERTIES_ADDED = 5;
    private static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 5;
    }

    @Override
    protected Element createAnElement() {
        ElementSpring elementSpring = new ElementSpring();
        return elementSpring;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementSpring)element2).setRadius(((ElementSpring)element).getRadius());
        ((ElementSpring)element2).setSolenoid(((ElementSpring)element).getSolenoid());
        ((ElementSpring)element2).setThinExtremes(((ElementSpring)element).isThinExtremes());
        ((ElementSpring)element2).setResolution(((ElementSpring)element).getLoops(), ((ElementSpring)element).getPointsPerLoop());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("radius");
            infoList.add("solenoid");
            infoList.add("thinExtremes");
            infoList.add("loops");
            infoList.add("pointsPerLoop");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("radius")) {
            return "int|double|double[]";
        }
        if (string.equals("solenoid")) {
            return "int|double|double[]";
        }
        if (string.equals("thinExtremes")) {
            return "boolean|boolean[]";
        }
        if (string.equals("loops")) {
            return "int|int[]";
        }
        if (string.equals("pointsPerLoop")) {
            return "int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.elements.length, dArray.length);
                    while (n2 < n3) {
                        ((ElementSpring)this.elements[n2]).setRadius(dArray[n2]);
                        ++n2;
                    }
                } else {
                    double d = value.getDouble();
                    int n4 = 0;
                    while (n4 < this.elements.length) {
                        ((ElementSpring)this.elements[n4]).setRadius(d);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n5 = 0;
                    int n6 = Math.min(this.elements.length, dArray.length);
                    while (n5 < n6) {
                        ((ElementSpring)this.elements[n5]).setSolenoid(dArray[n5]);
                        ++n5;
                    }
                } else {
                    double d = value.getDouble();
                    int n7 = 0;
                    while (n7 < this.elements.length) {
                        ((ElementSpring)this.elements[n7]).setSolenoid(d);
                        ++n7;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n8 = 0;
                    int n9 = Math.min(this.elements.length, blArray.length);
                    while (n8 < n9) {
                        ((ElementSpring)this.elements[n8]).setThinExtremes(blArray[n8]);
                        ++n8;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n10 = 0;
                    while (n10 < this.elements.length) {
                        ((ElementSpring)this.elements[n10]).setThinExtremes(bl);
                        ++n10;
                    }
                }
                break;
            }
            case 3: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n11 = 0;
                    int n12 = Math.min(this.elements.length, nArray.length);
                    while (n11 < n12) {
                        ElementSpring elementSpring = (ElementSpring)this.elements[n11];
                        elementSpring.setResolution(nArray[n11], elementSpring.getPointsPerLoop());
                        ++n11;
                    }
                } else {
                    int n13 = value.getInteger();
                    int n14 = 0;
                    while (n14 < this.elements.length) {
                        ElementSpring elementSpring = (ElementSpring)this.elements[n14];
                        elementSpring.setResolution(n13, elementSpring.getPointsPerLoop());
                        ++n14;
                    }
                }
                break;
            }
            case 4: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n15 = 0;
                    int n16 = Math.min(this.elements.length, nArray.length);
                    while (n15 < n16) {
                        ElementSpring elementSpring = (ElementSpring)this.elements[n15];
                        elementSpring.setResolution(elementSpring.getLoops(), nArray[n15]);
                        ++n15;
                    }
                } else {
                    int n17 = value.getInteger();
                    int n18 = 0;
                    while (n18 < this.elements.length) {
                        ElementSpring elementSpring = (ElementSpring)this.elements[n18];
                        elementSpring.setResolution(elementSpring.getLoops(), n17);
                        ++n18;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.elements.length) {
                    ((ElementSpring)this.elements[n2]).setRadius(0.05);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.elements.length) {
                    ((ElementSpring)this.elements[n3]).setSolenoid(0.0);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.elements.length) {
                    ((ElementSpring)this.elements[n4]).setThinExtremes(true);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < this.elements.length) {
                    ElementSpring elementSpring = (ElementSpring)this.elements[n5];
                    elementSpring.setResolution(8, elementSpring.getPointsPerLoop());
                    ++n5;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                while (n6 < this.elements.length) {
                    ElementSpring elementSpring = (ElementSpring)this.elements[n6];
                    elementSpring.setResolution(elementSpring.getLoops(), 15);
                    ++n6;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return Double.toString(0.05);
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return Integer.toString(8);
            }
            case 4: {
                return Integer.toString(15);
            }
        }
        return super.getDefaultValueString(n - 5);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }
}

