/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementArrow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlArrowSet2D
extends ControlSet2D {
    private static final int ARROWSET_PROPERTIES_ADDED = 2;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 2;
    }

    @Override
    protected Element createAnElement() {
        ElementArrow elementArrow = new ElementArrow();
        return elementArrow;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementArrow)element2).setArrowType(((ElementArrow)element).getArrowType());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("elementposition");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "ArrowStyle|int|int[]";
        }
        if (string.equals("elementposition")) {
            return "ArrowPosition|int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.elements.length, nArray.length);
                    while (n2 < n3) {
                        ((ElementArrow)this.elements[n2]).setArrowType(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n4 = value.getInteger();
                    int n5 = 0;
                    while (n5 < this.elements.length) {
                        ((ElementArrow)this.elements[n5]).setArrowType(n4);
                        ++n5;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n6 = 0;
                    int n7 = Math.min(this.elements.length, nArray.length);
                    while (n6 < n7) {
                        this.elements[n6].getStyle().setRelativePosition(nArray[n6]);
                        ++n6;
                    }
                } else {
                    int n8 = value.getInteger();
                    int n9 = 0;
                    while (n9 < this.elements.length) {
                        this.elements[n9].getStyle().setRelativePosition(n8);
                        ++n9;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.elements.length) {
                    ((ElementArrow)this.elements[n2]).setArrowType(0);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.elements.length) {
                    this.elements[n3].getStyle().setRelativePosition(5);
                    ++n3;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "ARROW";
            }
            case 1: {
                return "NORTH_EAST";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }
}

