/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d.utils;

public class VectorAlgebra {
    public static double norm(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    public static double[] crossProduct(double[] dArray, double[] dArray2) {
        return new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
    }

    public static double[] normalize(double[] dArray) {
        double d = VectorAlgebra.norm(dArray);
        return new double[]{dArray[0] / d, dArray[1] / d, dArray[2] / d};
    }

    public static double[] normalTo(double[] dArray) {
        if (dArray[0] == 0.0) {
            return new double[]{1.0, 0.0, 0.0};
        }
        if (dArray[1] == 0.0) {
            return new double[]{0.0, 1.0, 0.0};
        }
        if (dArray[2] == 0.0) {
            return new double[]{0.0, 0.0, 1.0};
        }
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        return new double[]{-dArray[1] / d, dArray[0] / d, 0.0};
    }
}

