/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTextSet2D
extends ControlSet2D {
    private static final int PROPERTIES_ADDED = 4;
    private Font defaultElementFont;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 4;
    }

    @Override
    protected Element createAnElement() {
        ElementText elementText = new ElementText();
        return elementText;
    }

    public ControlTextSet2D() {
        this.defaultElementFont = ((ElementText)this.elements[0]).getFont();
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementText)element2).setText(((ElementText)element).getText());
        ((ElementText)element2).setFont(((ElementText)element).getFont());
        ((ElementText)element2).setTrueSize(((ElementText)element).isTrueSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("font");
            infoList.add("pixelSize");
            infoList.add("elementposition");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("font")) {
            return "Font|Object|Object[]";
        }
        if (string.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof String[]) {
                    String[] stringArray = (String[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.numElements, stringArray.length);
                    while (n2 < n3) {
                        ((ElementText)this.elements[n2]).setText(stringArray[n2]);
                        ++n2;
                    }
                } else {
                    String string = value.getString();
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        ((ElementText)this.elements[n4]).setText(string);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n5 = 0;
                    int n6 = Math.min(this.numElements, objectArray.length);
                    while (n5 < n6) {
                        ((ElementText)this.elements[n5]).setFont((Font)objectArray[n5]);
                        ++n5;
                    }
                } else {
                    Font font = (Font)value.getObject();
                    int n7 = 0;
                    while (n7 < this.numElements) {
                        ((ElementText)this.elements[n7]).setFont(font);
                        ++n7;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n8 = 0;
                    int n9 = Math.min(this.numElements, blArray.length);
                    while (n8 < n9) {
                        ((ElementText)this.elements[n8]).setTrueSize(blArray[n8]);
                        ++n8;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n10 = 0;
                    while (n10 < this.numElements) {
                        ((ElementText)this.elements[n10]).setTrueSize(bl);
                        ++n10;
                    }
                }
                break;
            }
            case 3: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n11 = 0;
                    int n12 = Math.min(this.numElements, nArray.length);
                    while (n11 < n12) {
                        this.elements[n11].getStyle().setRelativePosition(nArray[n11]);
                        ++n11;
                    }
                } else {
                    int n13 = value.getInteger();
                    int n14 = 0;
                    while (n14 < this.numElements) {
                        this.elements[n14].getStyle().setRelativePosition(n13);
                        ++n14;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementText)this.elements[n2]).setText("");
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.numElements) {
                    ((ElementText)this.elements[n3]).setFont(this.defaultElementFont);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numElements) {
                    ((ElementText)this.elements[n4]).setTrueSize(false);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < this.numElements) {
                    this.elements[n5].getStyle().setRelativePosition(0);
                    ++n5;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "false";
            }
            case 3: {
                return "CENTERED";
            }
        }
        return super.getDefaultValueString(n - 4);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

