/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.display3d.core.ElementText;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementText
extends Element
implements org.opensourcephysics.display3d.core.ElementText {
    private int justify = 0;
    private double angle = 0.0;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    private AffineTransform transform = new AffineTransform();
    private TextLine textLine = new TextLine();

    public ElementText() {
    }

    public ElementText(String string) {
        this();
        this.setText(string);
    }

    public void setText(String string) {
        this.textLine.setText(string);
    }

    public String getText() {
        return this.textLine.getText();
    }

    public void setFont(Font font) {
        this.textLine.setFont(font);
    }

    public Font getFont() {
        return this.textLine.getFont();
    }

    public void setJustification(int n) {
        this.justify = n;
        switch (n) {
            default: {
                this.textLine.setJustification(0);
                break;
            }
            case 1: {
                this.textLine.setJustification(1);
                break;
            }
            case 2: {
                this.textLine.setJustification(2);
            }
        }
    }

    public int getJustification() {
        return this.justify;
    }

    public void setRotationAngle(double d) {
        this.angle = d;
    }

    public double getRotationAngle() {
        return this.angle;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        Color color = this.getDrawingPanel3D().projectColor(this.getRealStyle().getLineColor(), this.objects[0].getDistance());
        this.drawIt(graphics2D, color);
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawIt(graphics2D, this.getRealStyle().getLineColor());
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = 0.0;
        dArray2[0] = 0.0;
        dArray[1] = 0.0;
        dArray2[1] = 0.0;
        dArray[2] = 0.0;
        dArray2[2] = 0.0;
        this.sizeAndToSpaceFrame(dArray);
        this.sizeAndToSpaceFrame(dArray2);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixel[0] - (double)n) < 5.0 && Math.abs(this.pixel[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        this.coordinates[2] = 0.0;
        this.coordinates[1] = 0.0;
        this.coordinates[0] = 0.0;
        this.sizeAndToSpaceFrame(this.coordinates);
        this.getDrawingPanel3D().project(this.coordinates, this.pixel);
        this.objects[0].setDistance(this.pixel[2]);
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    private void drawIt(Graphics2D graphics2D, Color color) {
        this.textLine.setColor(color);
        if (this.angle != 0.0) {
            AffineTransform affineTransform = graphics2D.getTransform();
            this.transform.setTransform(affineTransform);
            this.transform.rotate(this.angle, this.pixel[0], this.pixel[1]);
            graphics2D.setTransform(this.transform);
            this.textLine.drawText(graphics2D, (int)this.pixel[0], (int)this.pixel[1]);
            graphics2D.setTransform(affineTransform);
        } else {
            this.textLine.drawText(graphics2D, (int)this.pixel[0], (int)this.pixel[1]);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementText.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementText();
        }
    }
}

